/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.parallel;

import java.util.HashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.hbase.index.IndexTableName;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestThreadPoolManager {
    @Rule
    public IndexTableName name = new IndexTableName();

    @Test
    public void testShutdownGetsNewThreadPool() throws Exception {
        HashMap cache = new HashMap();
        ThreadPoolBuilder builder = new ThreadPoolBuilder(this.name.getTableNameString(), new Configuration(false));
        ThreadPoolExecutor exec = ThreadPoolManager.getExecutor((ThreadPoolBuilder)builder, cache);
        Assert.assertNotNull((String)"Got a null exector from the pool!", (Object)exec);
        exec.shutdown();
        ThreadPoolExecutor exec2 = ThreadPoolManager.getExecutor((ThreadPoolBuilder)builder, cache);
        Assert.assertFalse((String)"Got the same exectuor, even though the original shutdown", (exec2 == exec ? 1 : 0) != 0);
    }

    @Test
    public void testShutdownWithReferencesDoesNotStopExecutor() throws Exception {
        HashMap cache = new HashMap();
        ThreadPoolBuilder builder = new ThreadPoolBuilder(this.name.getTableNameString(), new Configuration(false));
        ThreadPoolExecutor exec = ThreadPoolManager.getExecutor((ThreadPoolBuilder)builder, cache);
        Assert.assertNotNull((String)"Got a null exector from the pool!", (Object)exec);
        ThreadPoolExecutor exec2 = ThreadPoolManager.getExecutor((ThreadPoolBuilder)builder, cache);
        Assert.assertTrue((String)"Should have gotten the same executor", (exec2 == exec ? 1 : 0) != 0);
        exec.shutdown();
        Assert.assertFalse((String)"Executor is shutting down, even though we have a live reference!", (exec.isShutdown() || exec.isTerminating() ? 1 : 0) != 0);
        exec2.shutdown();
        Assert.assertTrue((String)"Executor is NOT shutting down, after releasing live reference!", (boolean)exec.awaitTermination(300L, TimeUnit.SECONDS));
    }

    @Test
    public void testGetExpectedExecutorForName() throws Exception {
        HashMap cache = new HashMap();
        ThreadPoolBuilder builder = new ThreadPoolBuilder(this.name.getTableNameString(), new Configuration(false));
        ThreadPoolExecutor exec = ThreadPoolManager.getExecutor((ThreadPoolBuilder)builder, cache);
        Assert.assertNotNull((String)"Got a null exector from the pool!", (Object)exec);
        ThreadPoolExecutor exec2 = ThreadPoolManager.getExecutor((ThreadPoolBuilder)builder, cache);
        Assert.assertTrue((String)"Got a different exectuor, even though they have the same name", (exec2 == exec ? 1 : 0) != 0);
        builder = new ThreadPoolBuilder(this.name.getTableNameString(), new Configuration(false));
        exec2 = ThreadPoolManager.getExecutor((ThreadPoolBuilder)builder, cache);
        Assert.assertTrue((String)"Got a different exectuor, even though they have the same name, but different confs", (exec2 == exec ? 1 : 0) != 0);
        builder = new ThreadPoolBuilder(this.name.getTableNameString() + "-some-other-pool", new Configuration(false));
        exec2 = ThreadPoolManager.getExecutor((ThreadPoolBuilder)builder, cache);
        Assert.assertFalse((String)"Got a different exectuor, even though they have the same name, but different confs", (exec2 == exec ? 1 : 0) != 0);
    }
}

