/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.filter;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.filter.NewerTimestampFilter;
import org.junit.Assert;
import org.junit.Test;

public class TestNewerTimestampFilter {
    byte[] row = new byte[]{97};
    byte[] fam = Bytes.toBytes((String)"family");
    byte[] qual = new byte[]{98};
    byte[] val = Bytes.toBytes((String)"val");

    @Test
    public void testOnlyAllowsOlderTimestamps() {
        long ts = 100L;
        NewerTimestampFilter filter = new NewerTimestampFilter(ts);
        KeyValue kv = new KeyValue(this.row, this.fam, this.qual, ts, this.val);
        Assert.assertEquals((String)"Didn't accept kv with matching ts", (Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell((Cell)kv));
        kv = new KeyValue(this.row, this.fam, this.qual, ts + 1L, this.val);
        Assert.assertEquals((String)"Didn't skip kv with greater ts", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)kv));
        kv = new KeyValue(this.row, this.fam, this.qual, ts - 1L, this.val);
        Assert.assertEquals((String)"Didn't accept kv with lower ts", (Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell((Cell)kv));
    }
}

