/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.filter.ApplyAndFilterDeletesFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.junit.Assert;
import org.junit.Test;

public class TestApplyAndFilterDeletesFilter {
    private static final Set<ImmutableBytesPtr> EMPTY_SET = Collections.emptySet();
    private byte[] row = Bytes.toBytes((String)"row");
    private byte[] family = Bytes.toBytes((String)"family");
    private byte[] qualifier = Bytes.toBytes((String)"qualifier");
    private byte[] value = Bytes.toBytes((String)"value");
    private long ts = 10L;

    @Test
    public void testDeletesAreNotReturned() {
        KeyValue kv = this.createKvForType(KeyValue.Type.Delete);
        ApplyAndFilterDeletesFilter filter = new ApplyAndFilterDeletesFilter(EMPTY_SET);
        Assert.assertEquals((String)"Didn't skip point delete!", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)kv));
        filter.reset();
        kv = this.createKvForType(KeyValue.Type.DeleteColumn);
        Assert.assertEquals((String)"Didn't skip from column delete!", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)kv));
        filter.reset();
        kv = this.createKvForType(KeyValue.Type.DeleteFamily);
        Assert.assertEquals((String)"Didn't skip from family delete!", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)kv));
    }

    @Test
    public void testHintCorrectlyToNextFamily() {
        KeyValue kv = this.createKvForType(KeyValue.Type.DeleteFamily);
        ApplyAndFilterDeletesFilter filter = new ApplyAndFilterDeletesFilter(EMPTY_SET);
        Assert.assertEquals((Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)kv));
        KeyValue next = this.createKvForType(KeyValue.Type.Put);
        Assert.assertEquals((String)"Didn't get a hint from a family delete", (Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)next));
        Assert.assertEquals((String)"Didn't get END_KEY with no families to match", (Object)KeyValue.LOWESTKEY, (Object)filter.getNextCellHint((Cell)next));
        filter = new ApplyAndFilterDeletesFilter(TestApplyAndFilterDeletesFilter.asSet(new byte[][]{Bytes.toBytes((String)"afamily")}));
        Assert.assertEquals((Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)kv));
        Assert.assertEquals((String)"Didn't get a hint from a family delete", (Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)next));
        Assert.assertEquals((String)"Didn't get END_KEY with no families to match", (Object)KeyValue.LOWESTKEY, (Object)filter.getNextCellHint((Cell)next));
        byte[] laterFamily = Bytes.toBytes((String)"zfamily");
        filter = new ApplyAndFilterDeletesFilter(TestApplyAndFilterDeletesFilter.asSet(new byte[][]{laterFamily}));
        Assert.assertEquals((Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)kv));
        KeyValue expected = KeyValueUtil.createFirstOnRow((byte[])CellUtil.cloneRow((Cell)kv), (byte[])laterFamily, (byte[])new byte[0]);
        Assert.assertEquals((String)"Didn't get a hint from a family delete", (Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)next));
        Assert.assertEquals((String)"Didn't get correct next key with a next family", (Object)expected, (Object)filter.getNextCellHint((Cell)next));
    }

    @Test
    public void testCoveringPointDelete() {
        KeyValue kv = this.createKvForType(KeyValue.Type.Delete);
        ApplyAndFilterDeletesFilter filter = new ApplyAndFilterDeletesFilter(EMPTY_SET);
        filter.filterCell((Cell)kv);
        KeyValue put = this.createKvForType(KeyValue.Type.Put);
        Assert.assertEquals((String)"Didn't filter out put with same timestamp!", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)put));
        Assert.assertEquals((String)"Didn't filter out put with same timestamp on second call!", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)put));
        put = this.createKvForType(KeyValue.Type.Put, this.ts - 1L);
        Assert.assertEquals((String)"Didn't accept put that has an earlier ts than the covering delete!", (Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell((Cell)put));
    }

    private KeyValue createKvForType(KeyValue.Type t) {
        return this.createKvForType(t, this.ts);
    }

    private KeyValue createKvForType(KeyValue.Type t, long timestamp) {
        return new KeyValue(this.row, this.family, this.qualifier, timestamp, t, this.value);
    }

    @Test
    public void testCoverForDeleteColumn() throws Exception {
        ApplyAndFilterDeletesFilter filter = new ApplyAndFilterDeletesFilter(EMPTY_SET);
        KeyValue dc = this.createKvForType(KeyValue.Type.DeleteColumn, 11L);
        KeyValue put = this.createKvForType(KeyValue.Type.Put, 10L);
        Assert.assertEquals((String)"Didn't filter out delete column.", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)dc));
        Assert.assertEquals((String)"Didn't get a seek hint for the deleted column", (Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)put));
        Cell seek = filter.getNextCellHint((Cell)put);
        Assert.assertTrue((String)"Seeked key wasn't past the expected put - didn't skip the column", (CellComparator.getInstance().compare(seek, (Cell)put) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteFamilyCorrectlyCoversColumns() {
        ApplyAndFilterDeletesFilter filter = new ApplyAndFilterDeletesFilter(EMPTY_SET);
        KeyValue df = this.createKvForType(KeyValue.Type.DeleteFamily, 11L);
        KeyValue put = this.createKvForType(KeyValue.Type.Put, 12L);
        Assert.assertEquals((String)"Didn't filter out delete family", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)df));
        Assert.assertEquals((String)"Filtered out put with newer TS than delete family", (Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell((Cell)put));
        put = this.createKvForType(KeyValue.Type.Put, 10L);
        Assert.assertEquals((String)"Didn't filter out older put, covered by DeleteFamily marker", (Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)put));
        Assert.assertEquals((Object)KeyValue.LOWESTKEY, (Object)filter.getNextCellHint((Cell)put));
    }

    @Test
    public void testDeleteColumnCorrectlyCoversColumns() {
        ApplyAndFilterDeletesFilter filter = new ApplyAndFilterDeletesFilter(EMPTY_SET);
        KeyValue d = this.createKvForType(KeyValue.Type.DeleteColumn, 12L);
        byte[] qual2 = Bytes.add((byte[])this.qualifier, (byte[])Bytes.toBytes((String)"-other"));
        KeyValue put = new KeyValue(this.row, this.family, qual2, 11L, KeyValue.Type.Put, this.value);
        Assert.assertEquals((String)"Didn't filter out delete column", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)d));
        Assert.assertEquals((String)"Filtered out put with different column than the delete", (Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell((Cell)put));
        d = this.createKvForType(KeyValue.Type.DeleteFamily, 10L);
        Assert.assertEquals((String)"Didn't filter out delete column", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)d));
        d = this.createKvForType(KeyValue.Type.DeleteColumn, 11L);
        Assert.assertEquals((String)"Didn't filter out delete column", (Object)Filter.ReturnCode.SKIP, (Object)filter.filterCell((Cell)d));
        Assert.assertEquals((String)"Filtered out put with different column than the delete", (Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell((Cell)put));
    }

    private static Set<ImmutableBytesPtr> asSet(byte[] ... strings) {
        HashSet<ImmutableBytesPtr> set = new HashSet<ImmutableBytesPtr>();
        for (byte[] s : strings) {
            set.add(new ImmutableBytesPtr(s));
        }
        return set;
    }
}

