/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.ColumnGroup;
import org.apache.phoenix.hbase.index.covered.CoveredColumn;
import org.apache.phoenix.hbase.index.covered.CoveredColumnIndexSpecifierBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestCoveredIndexSpecifierBuilder {
    private static final String FAMILY = "FAMILY";
    private static final String FAMILY2 = "FAMILY2";
    private static final String INDEX_TABLE = "INDEX_TABLE";
    private static final String INDEX_TABLE2 = "INDEX_TABLE2";

    @Test
    public void testSimpleSerialziationDeserialization() throws Exception {
        byte[] indexed_qualifer = Bytes.toBytes((String)"indexed_qual");
        CoveredColumnIndexSpecifierBuilder builder = new CoveredColumnIndexSpecifierBuilder();
        ColumnGroup fam1 = new ColumnGroup(INDEX_TABLE);
        CoveredColumn col1 = new CoveredColumn(FAMILY, indexed_qualifer);
        fam1.add(col1);
        CoveredColumn col2 = new CoveredColumn(FAMILY2, null);
        fam1.add(col2);
        builder.addIndexGroup(fam1);
        ColumnGroup fam2 = new ColumnGroup(INDEX_TABLE2);
        CoveredColumn col3 = new CoveredColumn(FAMILY2, indexed_qualifer);
        fam2.add(col3);
        builder.addIndexGroup(fam2);
        Configuration conf = new Configuration(false);
        Map<String, String> map = builder.convertToMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
        List<ColumnGroup> columns = CoveredColumnIndexSpecifierBuilder.getColumns(conf);
        Assert.assertEquals((String)"Didn't deserialize the expected number of column groups", (long)2L, (long)columns.size());
        ColumnGroup group = columns.get(0);
        Assert.assertEquals((String)"Didn't deserialize expected column in first group", (Object)((Object)col1), (Object)((Object)group.getColumnForTesting(0)));
        Assert.assertEquals((String)"Didn't deserialize expected column in first group", (Object)((Object)col2), (Object)((Object)group.getColumnForTesting(1)));
        group = columns.get(1);
        Assert.assertEquals((String)"Didn't deserialize expected column in second group", (Object)((Object)col3), (Object)((Object)group.getColumnForTesting(0)));
    }
}

