/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.util.ArrayList;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnTracker {
    @Test
    public void testEnsureGuarranteedMinValid() {
        Assert.assertFalse((String)"Guarranted min wasn't recognized as having newer timestamps!", (boolean)ColumnTracker.isNewestTime((long)Long.MIN_VALUE));
    }

    @Test
    public void testOnlyKeepsOlderTimestamps() {
        ArrayList columns = new ArrayList();
        ColumnTracker tracker = new ColumnTracker(columns);
        tracker.setTs(10L);
        Assert.assertEquals((String)"Column tracker didn't set original TS", (long)10L, (long)tracker.getTS());
        tracker.setTs(12L);
        Assert.assertEquals((String)"Column tracker allowed newer timestamp to be set.", (long)10L, (long)tracker.getTS());
        tracker.setTs(9L);
        Assert.assertEquals((String)"Column tracker didn't decrease set timestamp for smaller value", (long)9L, (long)tracker.getTS());
    }

    @Test
    public void testHasNewerTimestamps() throws Exception {
        ArrayList columns = new ArrayList();
        ColumnTracker tracker = new ColumnTracker(columns);
        Assert.assertFalse((String)"Tracker has newer timestamps when no ts set", (boolean)tracker.hasNewerTimestamps());
        tracker.setTs(10L);
        Assert.assertTrue((String)"Tracker doesn't have newer timetamps with set ts", (boolean)tracker.hasNewerTimestamps());
    }
}

