/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessorclient.BaseScannerRegionObserverConstants;
import org.apache.phoenix.hbase.index.MultiMutation;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.NonTxIndexBuilder;
import org.apache.phoenix.hbase.index.covered.data.CachedLocalTable;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.base.Predicate;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class NonTxIndexBuilderTest
extends BaseConnectionlessQueryTest {
    private static final String TEST_TABLE_STRING = "TEST_TABLE";
    private static final String TEST_TABLE_DDL = "CREATE TABLE IF NOT EXISTS TEST_TABLE (\n    ORGANIZATION_ID CHAR(4) NOT NULL,\n    ENTITY_ID CHAR(7) NOT NULL,\n    SCORE INTEGER,\n    LAST_UPDATE_TIME TIMESTAMP\n    CONSTRAINT TEST_TABLE_PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        ENTITY_ID\n    )\n) VERSIONS=1, MULTI_TENANT=TRUE";
    private static final String TEST_TABLE_INDEX_STRING = "TEST_TABLE_SCORE";
    private static final String TEST_TABLE_INDEX_DDL = "CREATE INDEX IF NOT EXISTS TEST_TABLE_SCORE ON TEST_TABLE (SCORE DESC, ENTITY_ID DESC)";
    private static final byte[] ROW = Bytes.toBytes((String)"org1entity1");
    private static final String FAM_STRING = "0";
    private static final byte[] FAM = Bytes.toBytes((String)"0");
    private static final byte[] INDEXED_QUALIFIER = Bytes.toBytes((String)"SCORE");
    private static final byte[] VALUE_1 = Bytes.toBytes((int)111);
    private static final byte[] VALUE_2 = Bytes.toBytes((int)222);
    private static final byte[] VALUE_3 = Bytes.toBytes((int)333);
    private static final byte[] VALUE_4 = Bytes.toBytes((int)444);
    private NonTxIndexBuilder indexBuilder;
    private PhoenixIndexMetaData mockIndexMetaData;
    private List<Cell> currentRowCells;

    @Before
    public void setup() throws Exception {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Configuration conf = new Configuration(false);
        conf.set("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
        Mockito.when((Object)env.getConfiguration()).thenReturn((Object)conf);
        Region mockRegion = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)env.getRegion()).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getScanner((Scan)Mockito.any(Scan.class))).thenAnswer((Answer)new Answer<RegionScanner>(){

            public RegionScanner answer(InvocationOnMock invocation) throws Throwable {
                Scan sArg = (Scan)invocation.getArguments()[0];
                TimeRange timeRange = sArg.getTimeRange();
                return NonTxIndexBuilderTest.this.getMockTimeRangeRegionScanner(timeRange);
            }
        });
        RegionInfo mockRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)env.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.getStartKey()).thenReturn((Object)Bytes.toBytes((String)"a"));
        Mockito.when((Object)mockRegionInfo.getEndKey()).thenReturn((Object)Bytes.toBytes((String)"z"));
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)TEST_TABLE_STRING));
        this.mockIndexMetaData = (PhoenixIndexMetaData)Mockito.mock(PhoenixIndexMetaData.class);
        Mockito.when((Object)this.mockIndexMetaData.requiresPriorRowState((Mutation)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.mockIndexMetaData.getReplayWrite()).thenReturn(null);
        Mockito.when((Object)this.mockIndexMetaData.getIndexMaintainers()).thenReturn(Collections.singletonList(this.getTestIndexMaintainer()));
        this.indexBuilder = new NonTxIndexBuilder();
        this.indexBuilder.setup(env);
    }

    private RegionScanner getMockTimeRangeRegionScanner(final TimeRange timeRange) {
        return new BaseRegionScanner((RegionScanner)Mockito.mock(RegionScanner.class)){

            public boolean next(List<Cell> results) throws IOException {
                for (Cell cell : NonTxIndexBuilderTest.this.currentRowCells) {
                    if (cell.getTimestamp() < timeRange.getMin() || cell.getTimestamp() >= timeRange.getMax()) continue;
                    results.add(cell);
                }
                return false;
            }

            public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                return this.next(result);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexMaintainer getTestIndexMaintainer() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.default.column.encoded.bytes.attrib", FAM_STRING);
        try (Connection conn = DriverManager.getConnection(NonTxIndexBuilderTest.getUrl(), props);){
            IndexMaintainer indexMaintainer;
            conn.setAutoCommit(true);
            conn.createStatement().execute(TEST_TABLE_DDL);
            conn.createStatement().execute(TEST_TABLE_INDEX_DDL);
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable table = pconn.getTable(new PTableKey(pconn.getTenantId(), TEST_TABLE_STRING));
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            table.getIndexMaintainers(ptr, pconn);
            List indexMaintainerList = IndexMaintainer.deserialize((ImmutableBytesWritable)ptr, (KeyValueBuilder)GenericKeyValueBuilder.INSTANCE, (boolean)true);
            Assert.assertEquals((long)1L, (long)indexMaintainerList.size());
            IndexMaintainer indexMaintainer2 = indexMaintainer = (IndexMaintainer)indexMaintainerList.get(0);
            return indexMaintainer2;
        }
    }

    @Test
    public void testGetMutableIndexUpdate() throws IOException {
        this.setCurrentRowState(FAM, INDEXED_QUALIFIER, 1, VALUE_1);
        Put put = new Put(ROW);
        put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(FAM).setType(Cell.Type.Put).setQualifier(INDEXED_QUALIFIER).setTimestamp(2L).setValue(VALUE_2).build());
        MultiMutation mutation = new MultiMutation(new ImmutableBytesPtr(ROW));
        mutation.addAll((Mutation)put);
        CachedLocalTable cachedLocalTable = CachedLocalTable.build(Collections.singletonList(mutation), (PhoenixIndexMetaData)this.mockIndexMetaData, (Region)this.indexBuilder.getEnv().getRegion());
        Collection indexUpdates = this.indexBuilder.getIndexUpdate((Mutation)mutation, (IndexMetaData)this.mockIndexMetaData, (LocalHBaseState)cachedLocalTable);
        Assert.assertEquals((long)2L, (long)indexUpdates.size());
        this.assertContains(indexUpdates, 2L, ROW, Cell.Type.DeleteFamily, FAM, new byte[0], 2L);
        this.assertContains(indexUpdates, Long.MAX_VALUE, ROW, Cell.Type.Put, FAM, QueryConstants.EMPTY_COLUMN_BYTES, 2L);
    }

    @Test
    public void testRebuildMultipleVersionRow() throws IOException {
        Mockito.when((Object)this.mockIndexMetaData.getReplayWrite()).thenReturn((Object)BaseScannerRegionObserverConstants.ReplayWrite.INDEX_ONLY);
        Cell currentCell1 = PhoenixKeyValueUtil.newKeyValue((byte[])ROW, (byte[])FAM, (byte[])INDEXED_QUALIFIER, (long)1L, (byte[])VALUE_1);
        Cell currentCell2 = PhoenixKeyValueUtil.newKeyValue((byte[])ROW, (byte[])FAM, (byte[])INDEXED_QUALIFIER, (long)2L, (byte[])VALUE_2);
        Cell currentCell3 = PhoenixKeyValueUtil.newKeyValue((byte[])ROW, (byte[])FAM, (byte[])INDEXED_QUALIFIER, (long)3L, (byte[])VALUE_3);
        Cell currentCell4 = PhoenixKeyValueUtil.newKeyValue((byte[])ROW, (byte[])FAM, (byte[])INDEXED_QUALIFIER, (long)4L, (byte[])VALUE_4);
        this.setCurrentRowState(Arrays.asList(currentCell4, currentCell3, currentCell2, currentCell1));
        MultiMutation mutation = new MultiMutation(new ImmutableBytesPtr(ROW));
        Put put = new Put(ROW);
        put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(FAM).setType(Cell.Type.Put).setQualifier(INDEXED_QUALIFIER).setTimestamp(4L).setValue(VALUE_4).build());
        mutation.addAll((Mutation)put);
        put = new Put(ROW);
        put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(FAM).setType(Cell.Type.Put).setQualifier(INDEXED_QUALIFIER).setTimestamp(3L).setValue(VALUE_3).build());
        mutation.addAll((Mutation)put);
        put = new Put(ROW);
        put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(FAM).setType(Cell.Type.Put).setQualifier(INDEXED_QUALIFIER).setTimestamp(2L).setValue(VALUE_2).build());
        mutation.addAll((Mutation)put);
        ArrayList indexUpdates = Lists.newArrayList();
        Collection mutations = IndexManagementUtil.flattenMutationsByTimestamp(Collections.singletonList(mutation));
        CachedLocalTable cachedLocalTable = CachedLocalTable.build((Collection)mutations, (PhoenixIndexMetaData)this.mockIndexMetaData, (Region)this.indexBuilder.getEnv().getRegion());
        for (Mutation m : mutations) {
            indexUpdates.addAll(this.indexBuilder.getIndexUpdate(m, (IndexMetaData)this.mockIndexMetaData, (LocalHBaseState)cachedLocalTable));
        }
        Assert.assertEquals((long)6L, (long)indexUpdates.size());
        this.assertContains(indexUpdates, 2L, ROW, Cell.Type.DeleteFamily, FAM, new byte[0], 2L);
        this.assertContains(indexUpdates, Long.MAX_VALUE, ROW, Cell.Type.Put, FAM, QueryConstants.EMPTY_COLUMN_BYTES, 2L);
        this.assertContains(indexUpdates, 3L, ROW, Cell.Type.DeleteFamily, FAM, new byte[0], 3L);
        this.assertContains(indexUpdates, Long.MAX_VALUE, ROW, Cell.Type.Put, FAM, QueryConstants.EMPTY_COLUMN_BYTES, 3L);
        this.assertContains(indexUpdates, 4L, ROW, Cell.Type.DeleteFamily, FAM, new byte[0], 4L);
        this.assertContains(indexUpdates, Long.MAX_VALUE, ROW, Cell.Type.Put, FAM, QueryConstants.EMPTY_COLUMN_BYTES, 4L);
    }

    @Test(timeout=10000L)
    public void testManyVersions() throws IOException {
        Mockito.when((Object)this.mockIndexMetaData.getReplayWrite()).thenReturn((Object)BaseScannerRegionObserverConstants.ReplayWrite.INDEX_ONLY);
        MultiMutation mutation = this.getMultipleVersionMutation(200);
        this.currentRowCells = (List)mutation.getFamilyCellMap().get(FAM);
        Collection mutations = IndexManagementUtil.flattenMutationsByTimestamp(Collections.singletonList(mutation));
        CachedLocalTable cachedLocalTable = CachedLocalTable.build((Collection)mutations, (PhoenixIndexMetaData)this.mockIndexMetaData, (Region)this.indexBuilder.getEnv().getRegion());
        ArrayList indexUpdates = Lists.newArrayList();
        for (Mutation m : IndexManagementUtil.flattenMutationsByTimestamp(Collections.singletonList(mutation))) {
            indexUpdates.addAll(this.indexBuilder.getIndexUpdate(m, (IndexMetaData)this.mockIndexMetaData, (LocalHBaseState)cachedLocalTable));
        }
        Assert.assertNotEquals((long)0L, (long)indexUpdates.size());
    }

    private void assertContains(Collection<Pair<Mutation, byte[]>> indexUpdates, final long mutationTs, byte[] row, final Cell.Type cellType, final byte[] fam, final byte[] qual, final long cellTs) {
        Predicate<Pair<Mutation, byte[]>> hasCellPredicate = new Predicate<Pair<Mutation, byte[]>>(){

            public boolean apply(Pair<Mutation, byte[]> input) {
                NavigableMap familyCellMap;
                Cell updateCell;
                Assert.assertEquals((Object)NonTxIndexBuilderTest.TEST_TABLE_INDEX_STRING, (Object)Bytes.toString((byte[])((byte[])input.getSecond())));
                Mutation mutation = (Mutation)input.getFirst();
                return mutationTs == mutation.getTimestamp() && cellType == (updateCell = (Cell)((List)(familyCellMap = mutation.getFamilyCellMap()).get(fam)).get(0)).getType() && Bytes.compareTo((byte[])fam, (byte[])CellUtil.cloneFamily((Cell)updateCell)) == 0 && Bytes.compareTo((byte[])qual, (byte[])CellUtil.cloneQualifier((Cell)updateCell)) == 0 && cellTs == updateCell.getTimestamp();
            }
        };
        Optional tryFind = Iterables.tryFind(indexUpdates, (Predicate)hasCellPredicate);
        Assert.assertTrue((boolean)tryFind.isPresent());
    }

    private void setCurrentRowState(byte[] fam2, byte[] indexedQualifier, int i, byte[] value1) {
        Cell cell = PhoenixKeyValueUtil.newKeyValue((byte[])ROW, (byte[])FAM, (byte[])INDEXED_QUALIFIER, (long)1L, (byte[])VALUE_1);
        this.currentRowCells = Collections.singletonList(cell);
    }

    private void setCurrentRowState(List<Cell> cells) {
        this.currentRowCells = cells;
    }

    private MultiMutation getMultipleVersionMutation(int versions) {
        MultiMutation mutation = new MultiMutation(new ImmutableBytesPtr(ROW));
        for (int i = versions - 1; i >= 0; --i) {
            Put put = new Put(ROW);
            try {
                put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(FAM).setType(Cell.Type.Put).setQualifier(INDEXED_QUALIFIER).setTimestamp((long)i).setValue(Bytes.toBytes((int)i)).build());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            mutation.addAll((Mutation)put);
        }
        return mutation;
    }
}

