/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexTestingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexTestingUtils.class);
    private static final String MASTER_INFO_PORT_KEY = "hbase.master.info.port";
    private static final String RS_INFO_PORT_KEY = "hbase.regionserver.info.port";

    private IndexTestingUtils() {
    }

    public static void setupConfig(Configuration conf) {
        conf.setInt(MASTER_INFO_PORT_KEY, -1);
        conf.setInt(RS_INFO_PORT_KEY, -1);
        conf.set("hbase.regionserver.wal.codec", IndexedWALEditCodec.class.getName());
    }

    public static void verifyIndexTableAtTimestamp(Table index1, List<KeyValue> expected, long start, long end, byte[] startKey, byte[] endKey) throws IOException {
        LOGGER.debug("Scanning " + index1.getName().getNameAsString() + " between times (" + start + ", " + end + "] and keys: [" + Bytes.toString((byte[])startKey) + ", " + Bytes.toString((byte[])endKey) + "].");
        Scan s = new Scan().withStartRow(startKey).withStopRow(endKey);
        s.readAllVersions();
        s.setTimeRange(start, end);
        ArrayList received = new ArrayList();
        ResultScanner scanner = index1.getScanner(s);
        for (Result r : scanner) {
            received.addAll(r.listCells());
            LOGGER.debug("Received: " + r.listCells());
        }
        scanner.close();
        Assert.assertEquals((String)"Didn't get the expected kvs from the index table!", expected, received);
    }

    public static void verifyIndexTableAtTimestamp(Table index1, List<KeyValue> expected, long ts, byte[] startKey) throws IOException {
        IndexTestingUtils.verifyIndexTableAtTimestamp(index1, expected, ts, startKey, HConstants.EMPTY_END_ROW);
    }

    public static void verifyIndexTableAtTimestamp(Table index1, List<KeyValue> expected, long start, byte[] startKey, byte[] endKey) throws IOException {
        IndexTestingUtils.verifyIndexTableAtTimestamp(index1, expected, start, start + 1L, startKey, endKey);
    }
}

