/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.util.BitSet;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.phoenix.filter.EncodedQualifiersColumnProjectionFilter;
import org.apache.phoenix.schema.PTable;

public class EncodedQualifiersColumnProjectionFilterTest
extends TestCase {
    private final String someEmptyCFName = "cfName1";
    private final String someConditionalCFName1 = "conditionalCfName1";
    private final String someConditionalCFName2 = "conditionalCfName2";
    private final PTable.QualifierEncodingScheme someQualifiedEncodingScheme = PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS;
    private final BitSet someBitSet;
    private EncodedQualifiersColumnProjectionFilter filter;

    public EncodedQualifiersColumnProjectionFilterTest() {
        HashSet<byte[]> conditionalCFNames = new HashSet<byte[]>(2);
        conditionalCFNames.add("conditionalCfName1".getBytes());
        conditionalCFNames.add("conditionalCfName2".getBytes());
        this.someBitSet = new BitSet();
        this.someBitSet.xor(new BitSet(0));
        this.filter = new EncodedQualifiersColumnProjectionFilter(this.someEmptyCFName.getBytes(), this.someBitSet, conditionalCFNames, this.someQualifiedEncodingScheme);
    }

    public void testToString() {
        String outputString = this.filter.toString();
        EncodedQualifiersColumnProjectionFilterTest.assertTrue((boolean)outputString.contains("EmptyCFName"));
        EncodedQualifiersColumnProjectionFilterTest.assertTrue((boolean)outputString.contains("EncodingScheme"));
        EncodedQualifiersColumnProjectionFilterTest.assertTrue((boolean)outputString.contains("TrackedColumns"));
        EncodedQualifiersColumnProjectionFilterTest.assertTrue((boolean)outputString.contains("ConditionOnlyCfs"));
        EncodedQualifiersColumnProjectionFilterTest.assertTrue((boolean)outputString.contains(this.someEmptyCFName));
        EncodedQualifiersColumnProjectionFilterTest.assertTrue((boolean)outputString.contains(this.someConditionalCFName1));
        EncodedQualifiersColumnProjectionFilterTest.assertTrue((boolean)outputString.contains(this.someConditionalCFName2));
        EncodedQualifiersColumnProjectionFilterTest.assertTrue((boolean)outputString.contains(this.someBitSet.toString()));
    }
}

