/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.util.regex;

import java.sql.SQLException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.util.regex.AbstractBasePattern;
import org.apache.phoenix.expression.util.regex.AbstractBaseSplitter;
import org.apache.phoenix.expression.util.regex.GuavaSplitter;
import org.apache.phoenix.expression.util.regex.JONIPattern;
import org.apache.phoenix.expression.util.regex.JavaPattern;
import org.apache.phoenix.schema.types.PVarchar;
import org.junit.Test;

public class PatternPerformanceTest {
    private String[] data = new String[]{"ONE:TWO:THREE", "ABC:DEF", "PKU:THU:FDU"};
    private ImmutableBytesWritable[] dataPtr = new ImmutableBytesWritable[]{PatternPerformanceTest.getPtr(this.data[0]), PatternPerformanceTest.getPtr(this.data[1]), PatternPerformanceTest.getPtr(this.data[2])};
    private String patternString;
    private ImmutableBytesWritable resultPtr = new ImmutableBytesWritable();
    private int maxTimes = 10000000;
    private Timer timer = new Timer();
    private final boolean ENABLE_ASSERT = false;

    private static ImmutableBytesWritable getPtr(String str) {
        return new ImmutableBytesWritable(PVarchar.INSTANCE.toBytes((Object)str));
    }

    private void testReplaceAll(ImmutableBytesWritable replacePtr, AbstractBasePattern pattern, String name) {
        this.timer.reset();
        for (int i = 0; i < this.maxTimes; ++i) {
            ImmutableBytesWritable ptr = this.dataPtr[i % 3];
            this.resultPtr.set(ptr.get(), ptr.getOffset(), ptr.getLength());
            pattern.replaceAll(this.resultPtr, replacePtr.get(), replacePtr.getOffset(), replacePtr.getLength());
        }
        this.timer.printTime(name);
    }

    public void testReplaceAll() {
        this.patternString = "[A-Z]+";
        ImmutableBytesWritable replacePtr = PatternPerformanceTest.getPtr("");
        this.testReplaceAll(replacePtr, (AbstractBasePattern)new JavaPattern(this.patternString), "Java replaceAll");
        this.testReplaceAll(replacePtr, (AbstractBasePattern)new JONIPattern(this.patternString), "JONI replaceAll");
    }

    private void testLike(AbstractBasePattern pattern, String name) {
        this.timer.reset();
        for (int i = 0; i < this.maxTimes; ++i) {
            ImmutableBytesWritable ptr = this.dataPtr[i % 3];
            this.resultPtr.set(ptr.get(), ptr.getOffset(), ptr.getLength());
            pattern.matches(this.resultPtr);
        }
        this.timer.printTime(name);
    }

    public void testLike() {
        this.patternString = "\\Q\\E.*\\QU\\E.*\\QU\\E.*\\QU\\E.*\\Q\\E";
        this.testLike((AbstractBasePattern)new JavaPattern(this.patternString), "Java Like");
        this.testLike((AbstractBasePattern)new JONIPattern(this.patternString), "JONI Like");
    }

    private void testSubstr(AbstractBasePattern pattern, String name) {
        this.timer.reset();
        for (int i = 0; i < this.maxTimes; ++i) {
            ImmutableBytesWritable ptr = this.dataPtr[i % 3];
            this.resultPtr.set(ptr.get(), ptr.getOffset(), ptr.getLength());
            pattern.substr(this.resultPtr, 0);
        }
        this.timer.printTime(name);
    }

    public void testSubstr() {
        this.patternString = "\\:[A-Z]+";
        this.testSubstr((AbstractBasePattern)new JavaPattern(this.patternString), "Java Substr");
        this.testSubstr((AbstractBasePattern)new JONIPattern(this.patternString), "JONI Substr");
    }

    private void testSplit(AbstractBaseSplitter pattern, String name) throws SQLException {
        this.timer.reset();
        for (int i = 0; i < this.maxTimes; ++i) {
            ImmutableBytesWritable ptr = this.dataPtr[i % 3];
            this.resultPtr.set(ptr.get(), ptr.getOffset(), ptr.getLength());
            boolean bl = pattern.split(this.resultPtr);
        }
        this.timer.printTime(name);
    }

    public void testSplit() throws SQLException {
        this.patternString = "\\:";
        this.testSplit((AbstractBaseSplitter)new GuavaSplitter(this.patternString), "GuavaSplit");
        this.testSplit((AbstractBaseSplitter)new JONIPattern(this.patternString), "JONI Split");
    }

    @Test
    public void test() throws Exception {
    }

    private static class Timer {
        private long startTimeStamp;

        private Timer() {
        }

        public void reset() {
            this.startTimeStamp = System.currentTimeMillis();
        }

        public double currentTime() {
            return (double)(System.currentTimeMillis() - this.startTimeStamp) / 1000.0;
        }

        public void printTime(String hint) {
            System.out.println(hint + " Time=" + this.currentTime());
        }
    }
}

