/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.UpperFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class UpperFunctionTest {
    private static ImmutableMap<String, String> turkishLowerToUpperCaseMap = ImmutableMap.of((Object)"i", (Object)"\u0130", (Object)"\u0131", (Object)"I");
    private static ImmutableMap<String, String> anyLocaleLowerToUpperCaseMap = ImmutableMap.of((Object)"\u00df", (Object)"SS", (Object)"Fahrvergn\u00fcgen", (Object)"FAHRVERGN\u00dcGEN");

    @Test
    public void testTurkishUpperCase() throws Exception {
        this.testLowerToUpperCaseMap((Map<String, String>)turkishLowerToUpperCaseMap, "tr");
    }

    @Test
    public void testUniversalUpperCaseNoLocale() throws Exception {
        this.testLowerToUpperCaseMap((Map<String, String>)anyLocaleLowerToUpperCaseMap, null);
    }

    @Test
    public void testUniversalUpperCaseTurkish() throws Exception {
        this.testLowerToUpperCaseMap((Map<String, String>)anyLocaleLowerToUpperCaseMap, "tr");
    }

    private void testLowerToUpperCaseMap(Map<String, String> lowerToUpperMap, String locale) throws Exception {
        for (Map.Entry<String, String> lowerUpperPair : lowerToUpperMap.entrySet()) {
            String upperCaseResultAsc = UpperFunctionTest.callFunction(lowerUpperPair.getKey(), locale, SortOrder.ASC);
            String upperCaseResultDesc = UpperFunctionTest.callFunction(lowerUpperPair.getKey(), locale, SortOrder.DESC);
            Assert.assertEquals((String)("Result of calling UpperFunction[ASC] on [" + lowerUpperPair.getKey() + "][" + locale + "] not as expected."), (Object)lowerUpperPair.getValue(), (Object)upperCaseResultAsc);
            Assert.assertEquals((String)("Result of calling UpperFunction[DESC] on [" + lowerUpperPair.getKey() + "][" + locale + "] not as expected."), (Object)lowerUpperPair.getValue(), (Object)upperCaseResultDesc);
        }
    }

    private static String callFunction(String inputStr, String localeIsoCode, SortOrder sortOrder) throws Exception {
        ImmutableBytesWritable ptr;
        LiteralExpression inputStrLiteral = LiteralExpression.newConstant((Object)inputStr, (PDataType)PVarchar.INSTANCE, (SortOrder)sortOrder);
        LiteralExpression localeIsoCodeLiteral = LiteralExpression.newConstant((Object)localeIsoCode, (PDataType)PVarchar.INSTANCE, (SortOrder)sortOrder);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{inputStrLiteral, localeIsoCodeLiteral});
        UpperFunction upperFunction = new UpperFunction((List)expressions);
        boolean ret = upperFunction.evaluate(null, ptr = new ImmutableBytesWritable());
        String result = ret ? (String)upperFunction.getDataType().toObject(ptr, upperFunction.getSortOrder()) : null;
        return result;
    }
}

