/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.InstrFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.junit.Assert;
import org.junit.Test;

public class InstrFunctionTest {
    private static Object evaluateExpression(String value, PDataType<?> dataType, String strToSearch, SortOrder order) throws SQLException {
        LiteralExpression inputArg = LiteralExpression.newConstant((Object)value, dataType, (SortOrder)order);
        LiteralExpression strToSearchExp = LiteralExpression.newConstant((Object)strToSearch, dataType);
        List<Expression> expressions = Arrays.asList(inputArg, strToSearchExp);
        InstrFunction instrFunction = new InstrFunction(expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        instrFunction.evaluate(null, ptr);
        return instrFunction.getDataType().toObject(ptr);
    }

    public static void inputExpression(String value, PDataType<?> dataType, String strToSearch, Integer expected, SortOrder order) throws SQLException {
        Object obj = InstrFunctionTest.evaluateExpression(value, dataType, strToSearch, order);
        Assert.assertNotNull((String)"Result was unexpectedly null", (Object)obj);
        Assert.assertTrue((((Integer)obj).compareTo(expected) == 0 ? 1 : 0) != 0);
    }

    public static void inputNullExpression(String value, PDataType<?> dataType, String strToSearch, SortOrder order) throws SQLException {
        Object obj = InstrFunctionTest.evaluateExpression(value, dataType, strToSearch, order);
        Assert.assertNull((String)"Result was unexpectedly non-null", (Object)obj);
    }

    @Test
    public void testInstrFunction() throws SQLException {
        InstrFunctionTest.inputExpression("abcdefghijkl", PVarchar.INSTANCE, "fgh", 6, SortOrder.ASC);
        InstrFunctionTest.inputExpression("abcdefghijkl", PVarchar.INSTANCE, "fgh", 6, SortOrder.DESC);
        InstrFunctionTest.inputExpression("abcde fghijkl", PVarchar.INSTANCE, " fgh", 6, SortOrder.ASC);
        InstrFunctionTest.inputExpression("abcde fghijkl", PVarchar.INSTANCE, " fgh", 6, SortOrder.DESC);
        InstrFunctionTest.inputExpression("abcde fghijkl", PVarchar.INSTANCE, "lmn", 0, SortOrder.DESC);
        InstrFunctionTest.inputExpression("abcde fghijkl", PVarchar.INSTANCE, "lmn", 0, SortOrder.ASC);
        InstrFunctionTest.inputExpression("ABCDEFGHIJKL", PVarchar.INSTANCE, "FGH", 6, SortOrder.ASC);
        InstrFunctionTest.inputExpression("ABCDEFGHIJKL", PVarchar.INSTANCE, "FGH", 6, SortOrder.DESC);
        InstrFunctionTest.inputExpression("ABCDEFGHiJKL", PVarchar.INSTANCE, "iJKL", 9, SortOrder.ASC);
        InstrFunctionTest.inputExpression("ABCDEFGHiJKL", PVarchar.INSTANCE, "iJKL", 9, SortOrder.DESC);
        InstrFunctionTest.inputExpression("ABCDE FGHiJKL", PVarchar.INSTANCE, " ", 6, SortOrder.ASC);
        InstrFunctionTest.inputExpression("ABCDE FGHiJKL", PVarchar.INSTANCE, " ", 6, SortOrder.DESC);
        InstrFunctionTest.inputNullExpression("ABCDE FGHiJKL", PVarchar.INSTANCE, "", SortOrder.ASC);
        InstrFunctionTest.inputNullExpression("ABCDE FGHiJKL", PVarchar.INSTANCE, "", SortOrder.DESC);
        InstrFunctionTest.inputNullExpression("ABCDE FGHiJKL", PVarchar.INSTANCE, null, SortOrder.ASC);
        InstrFunctionTest.inputNullExpression("ABCDE FGHiJKL", PVarchar.INSTANCE, null, SortOrder.DESC);
        InstrFunctionTest.inputExpression("ABCDEABC", PVarchar.INSTANCE, "ABC", 1, SortOrder.ASC);
        InstrFunctionTest.inputExpression("ABCDEABC", PVarchar.INSTANCE, "ABC", 1, SortOrder.DESC);
        InstrFunctionTest.inputExpression("AB01CDEABC", PVarchar.INSTANCE, "01C", 3, SortOrder.ASC);
        InstrFunctionTest.inputExpression("AB01CDEABC", PVarchar.INSTANCE, "01C", 3, SortOrder.DESC);
        InstrFunctionTest.inputExpression("ABCD%EFGH", PVarchar.INSTANCE, "%", 5, SortOrder.ASC);
        InstrFunctionTest.inputExpression("ABCD%EFGH", PVarchar.INSTANCE, "%", 5, SortOrder.DESC);
        InstrFunctionTest.inputExpression("A\u025a\u0266FGH", PVarchar.INSTANCE, "\u025a\u0266", 2, SortOrder.ASC);
        InstrFunctionTest.inputExpression("A\u025a\u0266FGH", PVarchar.INSTANCE, "\u025a\u0266", 2, SortOrder.DESC);
        InstrFunctionTest.inputExpression("A\u025a\u0266FGH", PVarchar.INSTANCE, "\u0266FGH", 3, SortOrder.ASC);
        InstrFunctionTest.inputExpression("A\u025a\u0266FGH", PVarchar.INSTANCE, "\u0266FGH", 3, SortOrder.DESC);
        InstrFunctionTest.inputExpression("A\u025a\u0266F/GH", PVarchar.INSTANCE, "\u0266F/GH", 3, SortOrder.ASC);
        InstrFunctionTest.inputExpression("A\u025a\u0266F/GH", PVarchar.INSTANCE, "\u0266F/GH", 3, SortOrder.DESC);
    }
}

