/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ExternalSqlTypeIdFunction;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PIntegerArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class ExternalSqlTypeIdFunctionTest {
    @Test
    public void testEvaluate() throws SQLException {
        LiteralExpression inputArg = LiteralExpression.newConstant((Object)PInteger.INSTANCE.getSqlType(), (PDataType)PInteger.INSTANCE);
        Object returnValue = this.executeFunction((Expression)inputArg);
        Assert.assertEquals((Object)4, (Object)returnValue);
    }

    @Test
    public void testEvaluateArrayType() throws SQLException {
        LiteralExpression inputArg = LiteralExpression.newConstant((Object)PIntegerArray.INSTANCE.getSqlType(), (PDataType)PInteger.INSTANCE);
        Object returnValue = this.executeFunction((Expression)inputArg);
        Assert.assertEquals((Object)2003, (Object)returnValue);
    }

    @Test
    public void testClone() throws SQLException {
        LiteralExpression inputArg = LiteralExpression.newConstant((Object)PIntegerArray.INSTANCE.getSqlType(), (PDataType)PInteger.INSTANCE);
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{inputArg});
        ExternalSqlTypeIdFunction externalIdFunction = new ExternalSqlTypeIdFunction((List)args);
        ScalarFunction clone = externalIdFunction.clone((List)args);
        Assert.assertEquals((Object)externalIdFunction, (Object)clone);
    }

    private Object executeFunction(Expression inputArg) throws SQLException {
        ExternalSqlTypeIdFunction externalIdFunction = new ExternalSqlTypeIdFunction((List)Lists.newArrayList((Object[])new Expression[]{inputArg}));
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        Assert.assertTrue((boolean)externalIdFunction.evaluate(null, ptr));
        return PInteger.INSTANCE.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), (PDataType)PInteger.INSTANCE, inputArg.getSortOrder());
    }
}

