/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.SqrtFunction;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PNumericType;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class SqrtFunctionTest {
    private static boolean testExpression(LiteralExpression literal, double expected) throws SQLException {
        ImmutableBytesWritable ptr;
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{literal});
        SqrtFunction sqrtFunction = new SqrtFunction((List)expressions);
        boolean ret = sqrtFunction.evaluate(null, ptr = new ImmutableBytesWritable());
        if (ret) {
            Double result = (Double)sqrtFunction.getDataType().toObject(ptr, sqrtFunction.getSortOrder());
            Assert.assertTrue((boolean)BaseTest.twoDoubleEquals(result, expected));
        }
        return ret;
    }

    private static void test(Number value, PNumericType dataType, double expected) throws SQLException {
        LiteralExpression literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        boolean ret1 = SqrtFunctionTest.testExpression(literal, expected);
        literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        boolean ret2 = SqrtFunctionTest.testExpression(literal, expected);
        Assert.assertEquals((Object)ret1, (Object)ret2);
    }

    private static void testBatch(Number[] value, PNumericType dataType) throws SQLException {
        int i;
        double[] expected = new double[value.length];
        for (i = 0; i < expected.length; ++i) {
            expected[i] = Math.sqrt(value[i].doubleValue());
        }
        Assert.assertEquals((long)value.length, (long)expected.length);
        for (i = 0; i < value.length; ++i) {
            SqrtFunctionTest.test(value[i], dataType, expected[i]);
        }
    }

    @Test
    public void testSqrtFunction() throws Exception {
        Random random = new Random();
        SqrtFunctionTest.testBatch(new BigDecimal[]{BigDecimal.valueOf(1.0), BigDecimal.valueOf(0.0), BigDecimal.valueOf(-1.0), BigDecimal.valueOf(123.1234), BigDecimal.valueOf(-123.1234), BigDecimal.valueOf(random.nextDouble()), BigDecimal.valueOf(random.nextDouble())}, (PNumericType)PDecimal.INSTANCE);
        SqrtFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(123.1234f), Float.valueOf(-123.1234f), Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat())}, (PNumericType)PFloat.INSTANCE);
        SqrtFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(123.1234f), Float.valueOf(-123.1234f), Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat())}, (PNumericType)PFloat.INSTANCE);
        SqrtFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(123.1234f)}, (PNumericType)PUnsignedFloat.INSTANCE);
        SqrtFunctionTest.testBatch(new Double[]{1.0, 0.0, -1.0, 123.1234, -123.1234, random.nextDouble(), random.nextDouble()}, (PNumericType)PDouble.INSTANCE);
        SqrtFunctionTest.testBatch(new Double[]{1.0, 0.0, 123.1234}, (PNumericType)PUnsignedDouble.INSTANCE);
        SqrtFunctionTest.testBatch(new Long[]{1L, 0L, -1L, Long.MAX_VALUE, Long.MIN_VALUE, 123L, -123L, random.nextLong(), random.nextLong()}, (PNumericType)PLong.INSTANCE);
        SqrtFunctionTest.testBatch(new Long[]{1L, 0L, Long.MAX_VALUE, 123L}, (PNumericType)PUnsignedLong.INSTANCE);
        SqrtFunctionTest.testBatch(new Integer[]{1, 0, -1, Integer.MAX_VALUE, Integer.MIN_VALUE, 123, -123, random.nextInt(), random.nextInt()}, (PNumericType)PInteger.INSTANCE);
        SqrtFunctionTest.testBatch(new Integer[]{1, 0, Integer.MAX_VALUE, 123}, (PNumericType)PUnsignedInt.INSTANCE);
        SqrtFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)-1, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, (short)123, (short)-123}, (PNumericType)PSmallint.INSTANCE);
        SqrtFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)Short.MAX_VALUE, (short)123}, (PNumericType)PSmallint.INSTANCE);
        SqrtFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)-1, (byte)127, (byte)-128, (byte)123, (byte)-123}, (PNumericType)PTinyint.INSTANCE);
        SqrtFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)127, (byte)123}, (PNumericType)PTinyint.INSTANCE);
    }
}

