/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.DecimalAddExpression;
import org.apache.phoenix.expression.DecimalDivideExpression;
import org.apache.phoenix.expression.DecimalMultiplyExpression;
import org.apache.phoenix.expression.DecimalSubtractExpression;
import org.apache.phoenix.expression.DoubleAddExpression;
import org.apache.phoenix.expression.DoubleDivideExpression;
import org.apache.phoenix.expression.DoubleMultiplyExpression;
import org.apache.phoenix.expression.DoubleSubtractExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.LongAddExpression;
import org.apache.phoenix.expression.LongDivideExpression;
import org.apache.phoenix.expression.LongMultiplyExpression;
import org.apache.phoenix.expression.LongSubtractExpression;
import org.apache.phoenix.expression.StringConcatExpression;
import org.apache.phoenix.expression.function.ByteBasedRegexpReplaceFunction;
import org.apache.phoenix.expression.function.ByteBasedRegexpSubstrFunction;
import org.apache.phoenix.expression.function.FunctionArgumentType;
import org.apache.phoenix.expression.function.LTrimFunction;
import org.apache.phoenix.expression.function.LengthFunction;
import org.apache.phoenix.expression.function.LowerFunction;
import org.apache.phoenix.expression.function.LpadFunction;
import org.apache.phoenix.expression.function.RTrimFunction;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.expression.function.SqlTypeNameFunction;
import org.apache.phoenix.expression.function.StringBasedRegexpReplaceFunction;
import org.apache.phoenix.expression.function.StringBasedRegexpSubstrFunction;
import org.apache.phoenix.expression.function.SubstrFunction;
import org.apache.phoenix.expression.function.ToCharFunction;
import org.apache.phoenix.expression.function.ToDateFunction;
import org.apache.phoenix.expression.function.ToNumberFunction;
import org.apache.phoenix.expression.function.TrimFunction;
import org.apache.phoenix.expression.function.UpperFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.DateUtil;
import org.junit.Assert;
import org.junit.Test;

public class SortOrderExpressionTest {
    @Test
    public void substr() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("blah", (PDataType)PChar.INSTANCE), this.getLiteral(3), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new SubstrFunction((List)args), "ah");
    }

    @Test
    public void regexpSubstr() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("blah", (PDataType)PChar.INSTANCE), this.getLiteral("l.h"), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new StringBasedRegexpSubstrFunction((List)args), "lah");
        this.evaluateAndAssertResult((Expression)new ByteBasedRegexpSubstrFunction((List)args), "lah");
    }

    @Test
    public void regexpReplace() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("blah", (PDataType)PChar.INSTANCE), this.getLiteral("l.h"), this.getLiteral("foo")});
        this.evaluateAndAssertResult((Expression)new ByteBasedRegexpReplaceFunction((List)args), "bfoo");
        this.evaluateAndAssertResult((Expression)new StringBasedRegexpReplaceFunction((List)args), "bfoo");
    }

    @Test
    public void ltrim() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("   blah", (PDataType)PChar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new LTrimFunction((List)args), "blah");
    }

    @Test
    public void substrLtrim() throws Exception {
        ArrayList ltrimArgs = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("   blah", (PDataType)PChar.INSTANCE)});
        LTrimFunction ltrim = new LTrimFunction((List)ltrimArgs);
        ArrayList substrArgs = Lists.newArrayList((Object[])new Expression[]{ltrim, this.getLiteral(3), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new SubstrFunction((List)substrArgs), "ah");
    }

    @Test
    public void rtrim() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("blah    ", (PDataType)PChar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new RTrimFunction((List)args), "blah");
    }

    @Test
    public void lower() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("BLAH", (PDataType)PChar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new LowerFunction((List)args), "blah");
    }

    @Test
    public void upper() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("blah", (PDataType)PChar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new UpperFunction((List)args), "BLAH");
    }

    @Test
    public void length() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("blah", (PDataType)PChar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new LengthFunction((List)args), 4);
    }

    @Test
    public void round() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(SortOrderExpressionTest.date(12, 11, 2001), (PDataType)PDate.INSTANCE), this.getLiteral("hour"), this.getLiteral(1)});
        this.evaluateAndAssertResult(RoundDateExpression.create((List)args), SortOrderExpressionTest.date(12, 11, 2001));
    }

    @Test
    public void sqlTypeName() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(12, (PDataType)PInteger.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new SqlTypeNameFunction((List)args), "VARCHAR");
    }

    @Test
    public void toChar() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(SortOrderExpressionTest.date(12, 11, 2001), (PDataType)PDate.INSTANCE)});
        Object caseInsensitiveExpected = new Object(){

            public boolean equals(Object other) {
                return other instanceof String && "12/11/01 12:00 AM".equalsIgnoreCase((String)other);
            }
        };
        this.evaluateAndAssertResult((Expression)new ToCharFunction((List)args, FunctionArgumentType.TEMPORAL, "", DateUtil.getDateFormatter((String)"MM/dd/yy hh:mm a")), caseInsensitiveExpected);
    }

    @Test
    public void toDate() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("2001-11-30 00:00:00:0", (PDataType)PVarchar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new ToDateFunction((List)args, "yyyy-MM-dd HH:mm:ss:S", "GMT"), SortOrderExpressionTest.date(11, 30, 2001));
    }

    @Test
    public void toNumber() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("10", (PDataType)PVarchar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new ToNumberFunction((List)args, FunctionArgumentType.CHAR, "", null), new BigDecimal(BigInteger.valueOf(1L), -1));
    }

    @Test
    public void trim() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("   blah    ", (PDataType)PChar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new TrimFunction((List)args), "blah");
    }

    @Test
    public void lpad() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("ABCD", (PDataType)PChar.INSTANCE), this.getLiteral(7), this.getLiteral("12")});
        this.evaluateAndAssertResult((Expression)new LpadFunction((List)args), "121ABCD");
    }

    @Test
    public void add() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DecimalAddExpression((List)args), BigDecimal.valueOf(12L));
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new LongAddExpression((List)args), 12L);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PFloat.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleAddExpression((List)args), 12.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PUnsignedFloat.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleAddExpression((List)args), 12.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PUnsignedDouble.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleAddExpression((List)args), 12.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PDouble.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleAddExpression((List)args), 12.0);
    }

    @Test
    public void subtract() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DecimalSubtractExpression((List)args), BigDecimal.valueOf(8L));
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new LongSubtractExpression((List)args), 8L);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PFloat.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleSubtractExpression((List)args), 8.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PUnsignedFloat.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleSubtractExpression((List)args), 8.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PUnsignedDouble.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleSubtractExpression((List)args), 8.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PDouble.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleSubtractExpression((List)args), 8.0);
    }

    @Test
    public void divide() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DecimalDivideExpression((List)args), BigDecimal.valueOf(5L));
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new LongDivideExpression((List)args), 5L);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PFloat.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleDivideExpression((List)args), 5.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PUnsignedFloat.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleDivideExpression((List)args), 5.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PUnsignedDouble.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleDivideExpression((List)args), 5.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PDouble.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleDivideExpression((List)args), 5.0);
    }

    @Test
    public void multiply() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DecimalMultiplyExpression((List)args), new BigDecimal(BigInteger.valueOf(2L), -1));
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new LongMultiplyExpression((List)args), 20L);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PFloat.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleMultiplyExpression((List)args), 20.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PUnsignedFloat.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleMultiplyExpression((List)args), 20.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PUnsignedDouble.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleMultiplyExpression((List)args), 20.0);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(10.0, (PDataType)PDouble.INSTANCE), this.getLiteral(2)});
        this.evaluateAndAssertResult((Expression)new DoubleMultiplyExpression((List)args), 20.0);
    }

    @Test
    public void compareNumbers() throws Exception {
        PDataType[] numberDataTypes;
        for (PDataType lhsDataType : numberDataTypes = new PDataType[]{PInteger.INSTANCE, PLong.INSTANCE, PDecimal.INSTANCE, PUnsignedInt.INSTANCE, PUnsignedLong.INSTANCE}) {
            for (PDataType rhsDataType : numberDataTypes) {
                this.runCompareTest(CompareOperator.GREATER, true, 10, lhsDataType, 2, rhsDataType);
            }
        }
    }

    @Test
    public void compareCharacters() throws Exception {
        PDataType[] textDataTypes;
        for (PDataType lhsDataType : textDataTypes = new PDataType[]{PChar.INSTANCE, PVarchar.INSTANCE}) {
            for (PDataType rhsDataType : textDataTypes) {
                this.runCompareTest(CompareOperator.GREATER, true, "xxx", lhsDataType, "bbb", rhsDataType);
            }
        }
    }

    @Test
    public void compareBooleans() throws Exception {
        this.runCompareTest(CompareOperator.GREATER, true, true, (PDataType)PBoolean.INSTANCE, false, (PDataType)PBoolean.INSTANCE);
    }

    @Test
    public void stringConcat() throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("blah", (PDataType)PVarchar.INSTANCE), this.getInvertedLiteral("foo", (PDataType)PVarchar.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new StringConcatExpression((List)args), "blahfoo");
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral("blah", (PDataType)PVarchar.INSTANCE), this.getInvertedLiteral(10, (PDataType)PInteger.INSTANCE)});
        this.evaluateAndAssertResult((Expression)new StringConcatExpression((List)args), "blah10");
    }

    private void runCompareTest(CompareOperator op, boolean expectedResult, Object lhsValue, PDataType lhsDataType, Object rhsValue, PDataType rhsDataType) throws Exception {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ArrayList args = Lists.newArrayList((Object[])new Expression[]{this.getLiteral(lhsValue, lhsDataType), this.getLiteral(rhsValue, rhsDataType)});
        this.evaluateAndAssertResult(ComparisonExpression.create((CompareOperator)op, (List)args, (ImmutableBytesWritable)ptr, (boolean)true), expectedResult, "lhsDataType: " + lhsDataType + " rhsDataType: " + rhsDataType);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(lhsValue, lhsDataType), this.getLiteral(rhsValue, rhsDataType)});
        this.evaluateAndAssertResult(ComparisonExpression.create((CompareOperator)op, (List)args, (ImmutableBytesWritable)ptr, (boolean)true), expectedResult, "lhs (inverted) dataType: " + lhsDataType + " rhsDataType: " + rhsDataType);
        args = Lists.newArrayList((Object[])new Expression[]{this.getLiteral(lhsValue, lhsDataType), this.getInvertedLiteral(rhsValue, rhsDataType)});
        this.evaluateAndAssertResult(ComparisonExpression.create((CompareOperator)op, (List)args, (ImmutableBytesWritable)ptr, (boolean)true), expectedResult, "lhsDataType: " + lhsDataType + " rhs (inverted) dataType: " + rhsDataType);
        args = Lists.newArrayList((Object[])new Expression[]{this.getInvertedLiteral(lhsValue, lhsDataType), this.getInvertedLiteral(rhsValue, rhsDataType)});
        this.evaluateAndAssertResult(ComparisonExpression.create((CompareOperator)op, (List)args, (ImmutableBytesWritable)ptr, (boolean)true), expectedResult, "lhs (inverted) dataType: " + lhsDataType + " rhs (inverted) dataType: " + rhsDataType);
    }

    private void evaluateAndAssertResult(Expression expression, Object expectedResult) {
        this.evaluateAndAssertResult(expression, expectedResult, null);
    }

    private void evaluateAndAssertResult(Expression expression, Object expectedResult, String context) {
        context = context == null ? "" : context;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        Assert.assertTrue((boolean)expression.evaluate(null, ptr));
        PDataType dataType = expression.getDataType();
        SortOrder sortOrder = expression.getSortOrder();
        Object result = dataType.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), dataType, sortOrder);
        Assert.assertEquals((String)context, (Object)expectedResult, (Object)result);
    }

    private Expression getLiteral(Object value) throws Exception {
        return LiteralExpression.newConstant((Object)value);
    }

    private Expression getLiteral(Object value, PDataType dataType) throws Exception {
        return LiteralExpression.newConstant((Object)value, (PDataType)dataType);
    }

    private Expression getInvertedLiteral(Object literal, PDataType dataType) throws Exception {
        return LiteralExpression.newConstant((Object)literal, (PDataType)dataType, (SortOrder)SortOrder.DESC);
    }

    private static Date date(int month, int day, int year) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(1, year);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = new Date(cal.getTimeInMillis());
        return d;
    }
}

