/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ByteBasedRegexpSplitFunction;
import org.apache.phoenix.expression.function.StringBasedRegexpSplitFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class RegexpSplitFunctionTest {
    private static final PVarchar TYPE = PVarchar.INSTANCE;

    private String[] evalExp(Expression exp) throws SQLException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean eval = exp.evaluate(null, ptr);
        Assert.assertTrue((boolean)eval);
        PhoenixArray evalRes = (PhoenixArray)exp.getDataType().toObject(ptr);
        String[] res = (String[])evalRes.getArray();
        return res;
    }

    private String[] testExpression(String srcStr, String patternStr, SortOrder sortOrder) throws SQLException {
        LiteralExpression srcExp = LiteralExpression.newConstant((Object)srcStr, (PDataType)TYPE, (SortOrder)sortOrder);
        LiteralExpression patternExp = LiteralExpression.newConstant((Object)patternStr, (PDataType)TYPE, (SortOrder)sortOrder);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{srcExp, patternExp});
        String[] res1 = this.evalExp((Expression)new ByteBasedRegexpSplitFunction((List)expressions));
        String[] res2 = this.evalExp((Expression)new StringBasedRegexpSplitFunction((List)expressions));
        this.testEqual(res2, res1);
        return res1;
    }

    private String[] testExpression(String srcStr, String patternStr) throws SQLException {
        String[] result1 = this.testExpression(srcStr, patternStr, SortOrder.ASC);
        String[] result2 = this.testExpression(srcStr, patternStr, SortOrder.DESC);
        this.testEqual(result1, result2);
        return result1;
    }

    private void testEqual(String[] expectedStr, String[] result) {
        if (result == null ^ expectedStr == null) {
            return;
        }
        if (expectedStr == null) {
            return;
        }
        Assert.assertEquals((long)expectedStr.length, (long)result.length);
        for (int i = 0; i < expectedStr.length; ++i) {
            Assert.assertEquals((Object)expectedStr[i], (Object)result[i]);
        }
    }

    private void testExpression(String srcStr, String patternStr, String[] expectedStr) throws SQLException {
        String[] result = this.testExpression(srcStr, patternStr);
        this.testEqual(expectedStr, result);
    }

    @Test
    public void test() throws Exception {
        String[] res = new String[]{"ONE", "TWO", "THREE"};
        this.testExpression("ONE:TWO:THREE", ":", res);
        this.testExpression("ONE,TWO,THREE", ",", res);
        this.testExpression("12ONE34TWO56THREE78", "[0-9]+", new String[]{null, "ONE", "TWO", "THREE", null});
        this.testExpression("ONE34TWO56THREE78", "[0-9]+", new String[]{"ONE", "TWO", "THREE", null});
        this.testExpression("123ONE34TWO56THREE", "[0-9]+", new String[]{null, "ONE", "TWO", "THREE"});
        this.testExpression("123", "[0-9]+", new String[]{null, null});
        this.testExpression("ONE", "[0-9]+", new String[]{"ONE"});
    }
}

