/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ByteBasedRegexpReplaceFunction;
import org.apache.phoenix.expression.function.StringBasedRegexpReplaceFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class RegexpReplaceFunctionTest {
    private static final PVarchar TYPE = PVarchar.INSTANCE;

    private String evalExp(Expression exp) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean eval = exp.evaluate(null, ptr);
        Assert.assertTrue((boolean)eval);
        String res = (String)exp.getDataType().toObject(ptr);
        return res;
    }

    private String testExpression(String srcStr, String patternStr, String replaceStr, SortOrder sortOrder) throws SQLException {
        LiteralExpression srcExp = LiteralExpression.newConstant((Object)srcStr, (PDataType)TYPE, (SortOrder)sortOrder);
        LiteralExpression patternExp = LiteralExpression.newConstant((Object)patternStr, (PDataType)TYPE, (SortOrder)sortOrder);
        LiteralExpression replaceExp = LiteralExpression.newConstant((Object)replaceStr, (PDataType)TYPE, (SortOrder)sortOrder);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{srcExp, patternExp, replaceExp});
        String res1 = this.evalExp((Expression)new ByteBasedRegexpReplaceFunction((List)expressions));
        String res2 = this.evalExp((Expression)new StringBasedRegexpReplaceFunction((List)expressions));
        Assert.assertEquals((Object)res1, (Object)res2);
        return res1;
    }

    private String testExpression(String srcStr, String patternStr, String replaceStr) throws SQLException {
        String result1 = this.testExpression(srcStr, patternStr, replaceStr, SortOrder.ASC);
        String result2 = this.testExpression(srcStr, patternStr, replaceStr, SortOrder.DESC);
        Assert.assertEquals((Object)result1, (Object)result2);
        return result1;
    }

    private void testExpression(String srcStr, String patternStr, String replaceStr, String expectedStr) throws SQLException {
        String result = this.testExpression(srcStr, patternStr, replaceStr);
        Assert.assertEquals((Object)expectedStr, (Object)result);
    }

    @Test
    public void test() throws Exception {
        this.testExpression("aa11bb22cc33dd44ee", "[0-9]+", "*", "aa*bb*cc*dd*ee");
        this.testExpression("aa11bb22cc33dd44ee", "[0-9]+", "", "aabbccddee");
        this.testExpression("aa11bb22cc33dd44ee", "[a-z][0-9]", "", "a1b2c3d4ee");
        this.testExpression("aa11bb22cc33dd44ee", "[a-z0-9]+", "", (String)null);
    }
}

