/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.PowerFunction;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PNumericType;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class PowerFunctionTest {
    private static final Expression ONE_POINT_FIVE = LiteralExpression.newConstant((Object)1.5);
    private static final Expression TWO = LiteralExpression.newConstant((Object)2);
    private static final Expression THREE = LiteralExpression.newConstant((Object)3);

    private static boolean testExpression(LiteralExpression literal, LiteralExpression literal2, LiteralExpression literal3, double exptFor15, double exptFor2, double exptFor3) throws SQLException {
        PowerFunction powerFunction2;
        boolean ret2;
        ArrayList expressions15 = Lists.newArrayList((Object[])new Expression[]{literal, ONE_POINT_FIVE});
        ArrayList expressions2 = Lists.newArrayList((Object[])new Expression[]{literal2, TWO});
        ArrayList expressions3 = Lists.newArrayList((Object[])new Expression[]{literal3, THREE});
        PowerFunction powerFunction15 = new PowerFunction((List)expressions15);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean ret15 = powerFunction15.evaluate(null, ptr);
        if (ret15) {
            Double result = (Double)powerFunction15.getDataType().toObject(ptr, powerFunction15.getSortOrder());
            Assert.assertTrue((boolean)BaseTest.twoDoubleEquals(result, exptFor15));
        }
        if (ret2 = (powerFunction2 = new PowerFunction((List)expressions2)).evaluate(null, ptr)) {
            Double result = (Double)powerFunction2.getDataType().toObject(ptr, powerFunction2.getSortOrder());
            Assert.assertTrue((boolean)BaseTest.twoDoubleEquals(result, exptFor2));
        }
        Assert.assertEquals((Object)ret15, (Object)ret2);
        PowerFunction powerFunction3 = new PowerFunction((List)expressions3);
        boolean ret3 = powerFunction3.evaluate(null, ptr);
        if (ret3) {
            Double result = (Double)powerFunction3.getDataType().toObject(ptr, powerFunction3.getSortOrder());
            Assert.assertTrue((boolean)BaseTest.twoDoubleEquals(result, exptFor3));
        }
        Assert.assertEquals((Object)ret15, (Object)ret3);
        return ret15;
    }

    private static void test(Number value, PNumericType dataType, double exptFor15, double exptFor2, double exptFor3) throws SQLException {
        LiteralExpression literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        LiteralExpression literal2 = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        LiteralExpression literal3 = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        boolean ret1 = PowerFunctionTest.testExpression(literal, literal2, literal3, exptFor15, exptFor2, exptFor3);
        literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        literal2 = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        literal3 = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        boolean ret2 = PowerFunctionTest.testExpression(literal, literal2, literal3, exptFor15, exptFor2, exptFor3);
        Assert.assertEquals((Object)ret1, (Object)ret2);
    }

    private static void testBatch(Number[] value, PNumericType dataType) throws SQLException {
        int i;
        double[][] expected = new double[value.length][3];
        for (i = 0; i < expected.length; ++i) {
            expected[i][0] = Math.pow(value[i].doubleValue(), 1.5);
            expected[i][1] = Math.pow(value[i].doubleValue(), 2.0);
            expected[i][2] = Math.pow(value[i].doubleValue(), 3.0);
        }
        Assert.assertEquals((long)value.length, (long)expected.length);
        for (i = 0; i < value.length; ++i) {
            PowerFunctionTest.test(value[i], dataType, expected[i][0], expected[i][1], expected[i][2]);
        }
    }

    @Test
    public void testLnLogFunction() throws Exception {
        Random random = new Random();
        PowerFunctionTest.testBatch(new BigDecimal[]{BigDecimal.valueOf(1.0), BigDecimal.valueOf(0.0), BigDecimal.valueOf(-1.0), BigDecimal.valueOf(123.1234), BigDecimal.valueOf(-123.1234), BigDecimal.valueOf(random.nextDouble()), BigDecimal.valueOf(random.nextDouble())}, (PNumericType)PDecimal.INSTANCE);
        PowerFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(123.1234f), Float.valueOf(-123.1234f), Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat())}, (PNumericType)PFloat.INSTANCE);
        PowerFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(123.1234f)}, (PNumericType)PUnsignedFloat.INSTANCE);
        PowerFunctionTest.testBatch(new Double[]{1.0, 0.0, -1.0, 123.1234, -123.1234, random.nextDouble(), random.nextDouble()}, (PNumericType)PDouble.INSTANCE);
        PowerFunctionTest.testBatch(new Double[]{1.0, 0.0, 123.1234}, (PNumericType)PUnsignedDouble.INSTANCE);
        PowerFunctionTest.testBatch(new Long[]{1L, 0L, -1L, Long.MAX_VALUE, Long.MIN_VALUE, 123L, -123L, random.nextLong(), random.nextLong()}, (PNumericType)PLong.INSTANCE);
        PowerFunctionTest.testBatch(new Long[]{1L, 0L, Long.MAX_VALUE, 123L}, (PNumericType)PUnsignedLong.INSTANCE);
        PowerFunctionTest.testBatch(new Integer[]{1, 0, -1, Integer.MAX_VALUE, Integer.MIN_VALUE, 123, -123, random.nextInt(), random.nextInt()}, (PNumericType)PInteger.INSTANCE);
        PowerFunctionTest.testBatch(new Integer[]{1, 0, Integer.MAX_VALUE, 123}, (PNumericType)PUnsignedInt.INSTANCE);
        PowerFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)-1, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, (short)123, (short)-123}, (PNumericType)PSmallint.INSTANCE);
        PowerFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)Short.MAX_VALUE, (short)123}, (PNumericType)PSmallint.INSTANCE);
        PowerFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)-1, (byte)127, (byte)-128, (byte)123, (byte)-123}, (PNumericType)PTinyint.INSTANCE);
        PowerFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)127, (byte)123}, (PNumericType)PTinyint.INSTANCE);
    }
}

