/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.OctetLengthFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBinaryBase;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class OctetLengthFunctionTest {
    private void testOctetLengthExpression(Expression data, int expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{data});
        OctetLengthFunction octetLengthFunction = new OctetLengthFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        octetLengthFunction.evaluate(null, ptr);
        Integer result = (Integer)octetLengthFunction.getDataType().toObject(ptr, octetLengthFunction.getSortOrder());
        if (expected == 0) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((long)expected, (long)result.intValue());
        }
    }

    private void testOctetLength(byte[] bytes, PBinaryBase dataType, int expected) throws SQLException {
        LiteralExpression dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        this.testOctetLengthExpression((Expression)dataExpr, expected);
        dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        this.testOctetLengthExpression((Expression)dataExpr, expected);
    }

    @Test
    public void testByteBatch() throws SQLException {
        for (int len = 0; len < 300; ++len) {
            byte[] bytes = new byte[len];
            this.testOctetLength(bytes, (PBinaryBase)PBinary.INSTANCE, bytes.length);
            this.testOctetLength(bytes, (PBinaryBase)PVarbinary.INSTANCE, bytes.length);
        }
    }
}

