/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CosFunction;
import org.apache.phoenix.expression.function.SinFunction;
import org.apache.phoenix.expression.function.TanFunction;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PNumericType;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MathTrigFunctionTest {
    private Number[] value;
    private PNumericType dataType;

    public MathTrigFunctionTest(Number[] value, PNumericType dataType) {
        this.value = value;
        this.dataType = dataType;
    }

    @Parameterized.Parameters(name="{0} {1}")
    public static synchronized Collection<Object> data() {
        return Arrays.asList((Object[])new Object[][]{{new BigDecimal[]{BigDecimal.valueOf(1.0), BigDecimal.valueOf(0.0), BigDecimal.valueOf(-1.0), BigDecimal.valueOf(123.1234), BigDecimal.valueOf(-123.1234)}, PDecimal.INSTANCE}, {new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(-3.4028235E38f), Float.valueOf(-1.4E-45f), Float.valueOf(123.1234f), Float.valueOf(-123.1234f)}, PFloat.INSTANCE}, {new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(123.1234f)}, PUnsignedFloat.INSTANCE}, {new Double[]{1.0, 0.0, -1.0, Double.MAX_VALUE, Double.MIN_VALUE, -1.7976931348623157E308, -4.9E-324, 123.1234, -123.1234}, PDouble.INSTANCE}, {new Double[]{1.0, 0.0, Double.MAX_VALUE, Double.MIN_VALUE, 123.1234}, PUnsignedDouble.INSTANCE}, {new Long[]{1L, 0L, -1L, Long.MAX_VALUE, Long.MIN_VALUE, 123L, -123L}, PLong.INSTANCE}, {new Long[]{1L, 0L, Long.MAX_VALUE, 123L}, PUnsignedLong.INSTANCE}, {new Integer[]{1, 0, -1, Integer.MAX_VALUE, Integer.MIN_VALUE, 123, -123}, PInteger.INSTANCE}, {new Integer[]{1, 0, Integer.MAX_VALUE, 123}, PUnsignedInt.INSTANCE}, {new Short[]{(short)1, (short)0, (short)-1, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, (short)123, (short)-123}, PSmallint.INSTANCE}, {new Short[]{(short)1, (short)0, (short)Short.MAX_VALUE, (short)123}, PSmallint.INSTANCE}, {new Byte[]{(byte)1, (byte)0, (byte)-1, (byte)127, (byte)-128, (byte)123, (byte)-123}, PTinyint.INSTANCE}, {new Byte[]{(byte)1, (byte)0, (byte)127, (byte)123}, PTinyint.INSTANCE}});
    }

    private boolean testExpression(LiteralExpression literal, double expectedResult, String testedFunction) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{literal});
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        SinFunction mathFunction = null;
        if (testedFunction.equals("SIN")) {
            mathFunction = new SinFunction((List)expressions);
        } else if (testedFunction.equals("COS")) {
            mathFunction = new CosFunction((List)expressions);
        } else if (testedFunction.equals("TAN")) {
            mathFunction = new TanFunction((List)expressions);
        }
        boolean ret = mathFunction.evaluate(null, ptr);
        if (ret) {
            Double result = (Double)mathFunction.getDataType().toObject(ptr, mathFunction.getSortOrder());
            Assert.assertTrue((boolean)BaseTest.twoDoubleEquals(result, expectedResult));
        }
        return ret;
    }

    private void test(Number value, PNumericType dataType, double expectedResult, String testedFunction) throws SQLException {
        LiteralExpression literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        boolean ret1 = this.testExpression(literal, expectedResult, testedFunction);
        literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        boolean ret2 = this.testExpression(literal, expectedResult, testedFunction);
        Assert.assertEquals((Object)ret1, (Object)ret2);
    }

    @Test
    public void testBatch() throws SQLException {
        for (int i = 0; i < this.value.length; ++i) {
            this.test(this.value[i], this.dataType, Math.sin(this.value[i].doubleValue()), "SIN");
            this.test(this.value[i], this.dataType, Math.cos(this.value[i].doubleValue()), "COS");
            this.test(this.value[i], this.dataType, Math.tan(this.value[i].doubleValue()), "TAN");
        }
    }
}

