/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.LnFunction;
import org.apache.phoenix.expression.function.LogFunction;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PNumericType;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class LnLogFunctionTest {
    private static final Expression THREE = LiteralExpression.newConstant((Object)3);
    private static final Expression DEFAULT_VALUE = LiteralExpression.newConstant((Object)10.0);

    private static boolean testExpression(LiteralExpression literal, LiteralExpression literal2, LiteralExpression literal3, double exptForLn, double exptForLog10, double exptForLog3) throws SQLException {
        LogFunction log10Function;
        boolean retLog10;
        ArrayList expressionsLn = Lists.newArrayList((Object[])new Expression[]{literal});
        ArrayList expressionsLog10 = Lists.newArrayList((Object[])new Expression[]{literal2, DEFAULT_VALUE});
        ArrayList expressionsLog3 = Lists.newArrayList((Object[])new Expression[]{literal3, THREE});
        LnFunction lnFunction = new LnFunction((List)expressionsLn);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean retLn = lnFunction.evaluate(null, ptr);
        if (retLn) {
            Double result = (Double)lnFunction.getDataType().toObject(ptr, lnFunction.getSortOrder());
            Assert.assertTrue((boolean)BaseTest.twoDoubleEquals(result, exptForLn));
        }
        if (retLog10 = (log10Function = new LogFunction((List)expressionsLog10)).evaluate(null, ptr)) {
            Double result = (Double)log10Function.getDataType().toObject(ptr, log10Function.getSortOrder());
            Assert.assertTrue((boolean)BaseTest.twoDoubleEquals(result, exptForLog10));
        }
        Assert.assertEquals((Object)retLn, (Object)retLog10);
        LogFunction log3Function = new LogFunction((List)expressionsLog3);
        boolean retLog3 = log3Function.evaluate(null, ptr);
        if (retLog3) {
            Double result = (Double)log3Function.getDataType().toObject(ptr, log3Function.getSortOrder());
            Assert.assertTrue((boolean)BaseTest.twoDoubleEquals(result, exptForLog3));
        }
        Assert.assertEquals((Object)retLn, (Object)retLog3);
        return retLn;
    }

    private static void test(Number value, PNumericType dataType, double exptForLn, double exptForLog10, double exptForLog3) throws SQLException {
        LiteralExpression literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        LiteralExpression literal2 = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        LiteralExpression literal3 = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        boolean ret1 = LnLogFunctionTest.testExpression(literal, literal2, literal3, exptForLn, exptForLog10, exptForLog3);
        literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        literal2 = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        literal3 = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        boolean ret2 = LnLogFunctionTest.testExpression(literal, literal2, literal3, exptForLn, exptForLog10, exptForLog3);
        Assert.assertEquals((Object)ret1, (Object)ret2);
    }

    private static void testBatch(Number[] value, PNumericType dataType) throws SQLException {
        int i;
        double[][] expected = new double[value.length][3];
        for (i = 0; i < expected.length; ++i) {
            expected[i][0] = Math.log(value[i].doubleValue());
            expected[i][1] = Math.log10(value[i].doubleValue());
            expected[i][2] = Math.log10(value[i].doubleValue()) / Math.log10(3.0);
        }
        Assert.assertEquals((long)value.length, (long)expected.length);
        for (i = 0; i < value.length; ++i) {
            LnLogFunctionTest.test(value[i], dataType, expected[i][0], expected[i][1], expected[i][2]);
        }
    }

    @Test
    public void testLnLogFunction() throws Exception {
        Random random = new Random();
        LnLogFunctionTest.testBatch(new BigDecimal[]{BigDecimal.valueOf(1.0), BigDecimal.valueOf(0.0), BigDecimal.valueOf(-1.0), BigDecimal.valueOf(123.1234), BigDecimal.valueOf(-123.1234), BigDecimal.valueOf(random.nextDouble()), BigDecimal.valueOf(random.nextDouble())}, (PNumericType)PDecimal.INSTANCE);
        LnLogFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(123.1234f), Float.valueOf(-123.1234f), Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat())}, (PNumericType)PFloat.INSTANCE);
        LnLogFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(123.1234f)}, (PNumericType)PUnsignedFloat.INSTANCE);
        LnLogFunctionTest.testBatch(new Double[]{1.0, 0.0, -1.0, 123.1234, -123.1234, random.nextDouble(), random.nextDouble()}, (PNumericType)PDouble.INSTANCE);
        LnLogFunctionTest.testBatch(new Double[]{1.0, 0.0, 123.1234}, (PNumericType)PUnsignedDouble.INSTANCE);
        LnLogFunctionTest.testBatch(new Long[]{1L, 0L, -1L, Long.MAX_VALUE, Long.MIN_VALUE, 123L, -123L, random.nextLong(), random.nextLong()}, (PNumericType)PLong.INSTANCE);
        LnLogFunctionTest.testBatch(new Long[]{1L, 0L, Long.MAX_VALUE, 123L}, (PNumericType)PUnsignedLong.INSTANCE);
        LnLogFunctionTest.testBatch(new Integer[]{1, 0, -1, Integer.MAX_VALUE, Integer.MIN_VALUE, 123, -123, random.nextInt(), random.nextInt()}, (PNumericType)PInteger.INSTANCE);
        LnLogFunctionTest.testBatch(new Integer[]{1, 0, Integer.MAX_VALUE, 123}, (PNumericType)PUnsignedInt.INSTANCE);
        LnLogFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)-1, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, (short)123, (short)-123}, (PNumericType)PSmallint.INSTANCE);
        LnLogFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)Short.MAX_VALUE, (short)123}, (PNumericType)PSmallint.INSTANCE);
        LnLogFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)-1, (byte)127, (byte)-128, (byte)123, (byte)-123}, (PNumericType)PTinyint.INSTANCE);
        LnLogFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)127, (byte)123}, (PNumericType)PTinyint.INSTANCE);
    }
}

