/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ByteBasedLikeExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LikeExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.StringBasedLikeExpression;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.junit.Assert;
import org.junit.Test;

public class LikeExpressionTest {
    private boolean testExpression(String value, String expression, SortOrder sortorder) throws SQLException {
        LiteralExpression v = LiteralExpression.newConstant((Object)value, (PDataType)PVarchar.INSTANCE, (SortOrder)sortorder);
        LiteralExpression p = LiteralExpression.newConstant((Object)expression, (PDataType)PVarchar.INSTANCE, (SortOrder)sortorder);
        List<Expression> children = Arrays.asList(v, p);
        LikeExpression e1 = ByteBasedLikeExpression.create(children, (LikeParseNode.LikeType)LikeParseNode.LikeType.CASE_SENSITIVE);
        LikeExpression e2 = StringBasedLikeExpression.create(children, (LikeParseNode.LikeType)LikeParseNode.LikeType.CASE_SENSITIVE);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean evaluated1 = e1.evaluate(null, ptr);
        Boolean result1 = (Boolean)e1.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)evaluated1);
        boolean evaluated2 = e2.evaluate(null, ptr);
        Boolean result2 = (Boolean)e2.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)evaluated2);
        Assert.assertEquals((Object)result1, (Object)result2);
        return result1;
    }

    private boolean testExpression(String value, String expression) throws SQLException {
        boolean result1 = this.testExpression(value, expression, SortOrder.ASC);
        boolean result2 = this.testExpression(value, expression, SortOrder.DESC);
        Assert.assertEquals((Object)result1, (Object)result2);
        return result1;
    }

    @Test
    public void testStartWildcard() throws Exception {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.testExpression("149na7-app1-2-", "%-w"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("149na7-app1-2-", "%-2%"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("149na7-app1-2-", "%4%7%2%"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.testExpression("149na7-app1-2-", "%9%4%2%"));
    }

    @Test
    public void testCaseSensitive() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("test", "test"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.testExpression("test", "teSt"));
    }

    @Test
    public void testStartWildcardAndCaseInsensitive() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("test", "%s%"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.testExpression("test", "%S%"));
    }

    @Test
    public void testOneChar() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("A", "_"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.testExpression("AA", "_"));
    }

    @Test
    public void testEmptySourceStr() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("", "%"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.testExpression("", "_"));
    }

    @Test
    public void testNewline() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("AA\nA", "AA%"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("AA\nA", "AA_A"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.testExpression("AA\nA", "AA%A"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.testExpression("AA\nA", "AA_"));
    }
}

