/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.GetBitFunction;
import org.apache.phoenix.expression.function.GetByteFunction;
import org.apache.phoenix.expression.function.SetBitFunction;
import org.apache.phoenix.expression.function.SetByteFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBinaryBase;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class GetSetByteBitFunctionTest {
    private void testGetByteExpression(Expression data, Expression offset, int expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{data, offset});
        GetByteFunction getByteFunction = new GetByteFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        getByteFunction.evaluate(null, ptr);
        Integer result = (Integer)getByteFunction.getDataType().toObject(ptr, getByteFunction.getSortOrder());
        Assert.assertEquals((long)expected, (long)result.intValue());
    }

    private void testSetByteExpression(Expression data, Expression offset, Expression newValue, byte[] expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{data, offset, newValue});
        SetByteFunction setByteFunction = new SetByteFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        setByteFunction.evaluate(null, ptr);
        byte[] result = (byte[])setByteFunction.getDataType().toObject(ptr, setByteFunction.getSortOrder());
        Assert.assertArrayEquals((byte[])expected, (byte[])result);
    }

    private void testGetByte(byte[] bytes, int offset, PBinaryBase dataType, int expected) throws SQLException {
        LiteralExpression dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        LiteralExpression offsetExpr = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.ASC);
        this.testGetByteExpression((Expression)dataExpr, (Expression)offsetExpr, expected);
        dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        offsetExpr = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.DESC);
        this.testGetByteExpression((Expression)dataExpr, (Expression)offsetExpr, expected);
    }

    private void testSetByte(byte[] bytes, int offset, int newValue, PBinaryBase dataType, byte[] expected) throws SQLException {
        LiteralExpression dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        LiteralExpression offsetExpr = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.ASC);
        LiteralExpression newValueExpr = LiteralExpression.newConstant((Object)newValue, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.ASC);
        this.testSetByteExpression((Expression)dataExpr, (Expression)offsetExpr, (Expression)newValueExpr, expected);
        dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        offsetExpr = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.DESC);
        newValueExpr = LiteralExpression.newConstant((Object)newValue, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.DESC);
        this.testSetByteExpression((Expression)dataExpr, (Expression)offsetExpr, (Expression)newValueExpr, expected);
    }

    @Test
    public void testByteBatch() throws SQLException {
        int offset;
        byte[] bytes = new byte[256];
        int sum = 0;
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)(i & 0xFF);
            sum += bytes[i];
        }
        Assert.assertEquals((long)-128L, (long)sum);
        for (offset = 0; offset < 256; ++offset) {
            this.testGetByte(bytes, offset, (PBinaryBase)PBinary.INSTANCE, bytes[offset]);
            this.testGetByte(bytes, offset, (PBinaryBase)PVarbinary.INSTANCE, bytes[offset]);
        }
        for (offset = 0; offset < 256; ++offset) {
            for (int tmp = -128; tmp <= 127; ++tmp) {
                byte[] expected = new byte[bytes.length];
                System.arraycopy(bytes, 0, expected, 0, bytes.length);
                expected[offset] = (byte)(tmp & 0xFF);
                this.testSetByte(bytes, offset, tmp, (PBinaryBase)PBinary.INSTANCE, expected);
            }
        }
    }

    private void testGetBitExpression(Expression data, Expression offset, int expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{data, offset});
        GetBitFunction getBitFunction = new GetBitFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        getBitFunction.evaluate(null, ptr);
        Integer result = (Integer)getBitFunction.getDataType().toObject(ptr, getBitFunction.getSortOrder());
        Assert.assertEquals((long)expected, (long)result.intValue());
    }

    private void testSetBitExpression(Expression data, Expression offset, Expression newValue, byte[] expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{data, offset, newValue});
        SetBitFunction setBitFunction = new SetBitFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        setBitFunction.evaluate(null, ptr);
        byte[] result = (byte[])setBitFunction.getDataType().toObject(ptr, setBitFunction.getSortOrder());
        Assert.assertArrayEquals((byte[])expected, (byte[])result);
    }

    private void testGetBit(byte[] bytes, int offset, PBinaryBase dataType, int expected) throws SQLException {
        LiteralExpression dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        LiteralExpression offsetExpr = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.ASC);
        this.testGetBitExpression((Expression)dataExpr, (Expression)offsetExpr, expected);
        dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        offsetExpr = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.DESC);
        this.testGetBitExpression((Expression)dataExpr, (Expression)offsetExpr, expected);
    }

    private void testSetBit(byte[] bytes, int offset, int newValue, PBinaryBase dataType, byte[] expected) throws SQLException {
        LiteralExpression dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        LiteralExpression offsetExpr = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.ASC);
        LiteralExpression newValueExpr = LiteralExpression.newConstant((Object)newValue, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.ASC);
        this.testSetBitExpression((Expression)dataExpr, (Expression)offsetExpr, (Expression)newValueExpr, expected);
        dataExpr = LiteralExpression.newConstant((Object)bytes, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        offsetExpr = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.DESC);
        newValueExpr = LiteralExpression.newConstant((Object)newValue, (PDataType)PInteger.INSTANCE, (SortOrder)SortOrder.DESC);
        this.testSetBitExpression((Expression)dataExpr, (Expression)offsetExpr, (Expression)newValueExpr, expected);
    }

    @Test
    public void testGetBitBatch() throws SQLException {
        int offset;
        byte[] bytes = new byte[256];
        int sum = 0;
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)(i & 0xFF);
            sum += bytes[i];
        }
        Assert.assertEquals((long)-128L, (long)sum);
        for (offset = 0; offset < 2048; ++offset) {
            int expected = (bytes[offset / 8] & 1 << offset % 8) != 0 ? 1 : 0;
            this.testGetBit(bytes, offset, (PBinaryBase)PBinary.INSTANCE, expected);
            this.testGetBit(bytes, offset, (PBinaryBase)PVarbinary.INSTANCE, expected);
        }
        for (offset = 0; offset < 2048; ++offset) {
            for (int tmp = 0; tmp <= 1; ++tmp) {
                byte[] expected = new byte[bytes.length];
                System.arraycopy(bytes, 0, expected, 0, bytes.length);
                if (tmp != 0) {
                    int n = offset / 8;
                    expected[n] = (byte)(expected[n] | (byte)(1 << offset % 8));
                } else {
                    int n = offset / 8;
                    expected[n] = (byte)(expected[n] & (byte)(~(1 << offset % 8)));
                }
                this.testSetBit(bytes, offset, tmp, (PBinaryBase)PBinary.INSTANCE, expected);
            }
        }
    }
}

