/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CbrtFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PNumericType;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class CbrtFunctionTest {
    private static void testExpression(LiteralExpression literal, double expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{literal});
        CbrtFunction cbrtFunction = new CbrtFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        cbrtFunction.evaluate(null, ptr);
        Double result = (Double)cbrtFunction.getDataType().toObject(ptr, cbrtFunction.getSortOrder());
        Assert.assertTrue((Math.abs(result - expected) <= 1.0E-9 ? 1 : 0) != 0);
    }

    private static void test(Number value, PNumericType dataType, double expected) throws SQLException {
        LiteralExpression literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        CbrtFunctionTest.testExpression(literal, expected);
        literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        CbrtFunctionTest.testExpression(literal, expected);
    }

    private static void testBatch(Number[] value, PNumericType dataType) throws SQLException {
        int i;
        double[] expected = new double[value.length];
        for (i = 0; i < expected.length; ++i) {
            expected[i] = Math.cbrt(value[i].doubleValue());
        }
        Assert.assertEquals((long)value.length, (long)expected.length);
        for (i = 0; i < value.length; ++i) {
            CbrtFunctionTest.test(value[i], dataType, expected[i]);
        }
    }

    @Test
    public void testCbrtFunction() throws Exception {
        Random random = new Random();
        CbrtFunctionTest.testBatch(new BigDecimal[]{BigDecimal.valueOf(1.0), BigDecimal.valueOf(0.0), BigDecimal.valueOf(-1.0), BigDecimal.valueOf(123.1234), BigDecimal.valueOf(-123.1234), BigDecimal.valueOf(random.nextDouble()), BigDecimal.valueOf(random.nextDouble())}, (PNumericType)PDecimal.INSTANCE);
        CbrtFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(123.1234f), Float.valueOf(-123.1234f), Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat())}, (PNumericType)PFloat.INSTANCE);
        CbrtFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(123.1234f)}, (PNumericType)PUnsignedFloat.INSTANCE);
        CbrtFunctionTest.testBatch(new Double[]{1.0, 0.0, -1.0, 123.1234, -123.1234, random.nextDouble(), random.nextDouble()}, (PNumericType)PDouble.INSTANCE);
        CbrtFunctionTest.testBatch(new Double[]{1.0, 0.0, 123.1234}, (PNumericType)PUnsignedDouble.INSTANCE);
        CbrtFunctionTest.testBatch(new Long[]{1L, 0L, -1L, Long.MAX_VALUE, Long.MIN_VALUE, 123L, -123L, random.nextLong(), random.nextLong()}, (PNumericType)PLong.INSTANCE);
        CbrtFunctionTest.testBatch(new Long[]{1L, 0L, Long.MAX_VALUE, 123L}, (PNumericType)PUnsignedLong.INSTANCE);
        CbrtFunctionTest.testBatch(new Integer[]{1, 0, -1, Integer.MAX_VALUE, Integer.MIN_VALUE, 123, -123, random.nextInt(), random.nextInt()}, (PNumericType)PInteger.INSTANCE);
        CbrtFunctionTest.testBatch(new Integer[]{1, 0, Integer.MAX_VALUE, 123}, (PNumericType)PUnsignedInt.INSTANCE);
        CbrtFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)-1, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, (short)123, (short)-123}, (PNumericType)PSmallint.INSTANCE);
        CbrtFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)Short.MAX_VALUE, (short)123}, (PNumericType)PSmallint.INSTANCE);
        CbrtFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)-1, (byte)127, (byte)-128, (byte)123, (byte)-123}, (PNumericType)PTinyint.INSTANCE);
        CbrtFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)127, (byte)123}, (PNumericType)PTinyint.INSTANCE);
    }
}

