/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ArrayRemoveFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class ArrayRemoveFunctionTest {
    private static void testExpression(LiteralExpression array, LiteralExpression element, PhoenixArray expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{element});
        expressions.add(array);
        ArrayRemoveFunction arrayRemoveFunction = new ArrayRemoveFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayRemoveFunction.evaluate(null, ptr);
        PhoenixArray result = (PhoenixArray)arrayRemoveFunction.getDataType().toObject(ptr, ((Expression)expressions.get(1)).getSortOrder(), array.getMaxLength(), array.getScale());
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private static void test(PhoenixArray array, Object element, PDataType arrayDataType, Integer arrMaxLen, Integer arrScale, PDataType elementDataType, Integer elemMaxLen, Integer elemScale, PhoenixArray expected, SortOrder arraySortOrder, SortOrder elementSortOrder) throws SQLException {
        LiteralExpression arrayLiteral = LiteralExpression.newConstant((Object)array, (PDataType)arrayDataType, (Integer)arrMaxLen, (Integer)arrScale, (SortOrder)arraySortOrder, (Determinism)Determinism.ALWAYS);
        LiteralExpression elementLiteral = LiteralExpression.newConstant((Object)element, (PDataType)elementDataType, (Integer)elemMaxLen, (Integer)elemScale, (SortOrder)elementSortOrder, (Determinism)Determinism.ALWAYS);
        ArrayRemoveFunctionTest.testExpression(arrayLiteral, elementLiteral, expected);
    }

    @Test
    public void testArrayRemoveFunction1() throws Exception {
        Object[] o = new Object[]{1, 2, -3, 4};
        Object[] o2 = new Object[]{1, 2, -3};
        Integer element = 4;
        PInteger baseType = PInteger.INSTANCE;
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveIntPhoenixArray expected = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction2() throws Exception {
        Object[] o = new Object[]{"1", "2", "3", "4"};
        Object[] o2 = new Object[]{"1", "3", "4"};
        String element = "2";
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction3() throws Exception {
        Object[] o = new Object[]{"1", "2", "2", "4"};
        Object[] o2 = new Object[]{"1", "4"};
        String element = "2";
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction4() throws Exception {
        Object[] o = new Object[]{"1", "2", "2", "4"};
        Object[] o2 = new Object[]{"1", "2", "2", "4"};
        String element = "5";
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunctionBoolean() throws Exception {
        Object[] o = new Boolean[]{true, false, false, true};
        Object[] o2 = new Boolean[]{true, true};
        Boolean element = false;
        PBoolean baseType = PBoolean.INSTANCE;
        PhoenixArray.PrimitiveBooleanPhoenixArray arr = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveBooleanPhoenixArray expected = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction6() throws Exception {
        Object[] o = new Object[]{new Float(2.3), new Float(7.9), new Float(-9.6), new Float(2.3)};
        Object[] o2 = new Object[]{new Float(7.9), new Float(-9.6)};
        Double element = 2.3;
        PFloat baseType = PFloat.INSTANCE;
        PhoenixArray.PrimitiveFloatPhoenixArray arr = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveFloatPhoenixArray expected = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction7() throws Exception {
        Object[] o = new Object[]{4.78, 9.54, 2.34, -9.675, Double.MAX_VALUE};
        Object[] o2 = new Object[]{9.54, 2.34, -9.675, Double.MAX_VALUE};
        Double element = 4.78;
        PDouble baseType = PDouble.INSTANCE;
        PhoenixArray.PrimitiveDoublePhoenixArray arr = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveDoublePhoenixArray expected = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction8() throws Exception {
        Object[] o = new Object[]{123L, 677L, 98789L, -78989L, 66787L};
        Object[] o2 = new Object[]{123L, 677L, -78989L, 66787L};
        Long element = 98789L;
        PLong baseType = PLong.INSTANCE;
        PhoenixArray.PrimitiveLongPhoenixArray arr = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveLongPhoenixArray expected = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction9() throws Exception {
        Object[] o = new Object[]{(short)34, (short)-89, (short)999, (short)34};
        Object[] o2 = new Object[]{(short)34, (short)-89, (short)999, (short)34};
        Short element = -23;
        PSmallint baseType = PSmallint.INSTANCE;
        PhoenixArray.PrimitiveShortPhoenixArray arr = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveShortPhoenixArray expected = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction10() throws Exception {
        Object[] o = new Object[]{(byte)4, (byte)8, (byte)9};
        Object[] o2 = new Object[]{(byte)8, (byte)9};
        Byte element = 4;
        PTinyint baseType = PTinyint.INSTANCE;
        PhoenixArray.PrimitiveBytePhoenixArray arr = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveBytePhoenixArray expected = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction11() throws Exception {
        Object[] o = new Object[]{BigDecimal.valueOf(2345L), BigDecimal.valueOf(-23.45), BigDecimal.valueOf(785L)};
        Object[] o2 = new Object[]{BigDecimal.valueOf(-23.45), BigDecimal.valueOf(785L)};
        BigDecimal element = BigDecimal.valueOf(2345L);
        PDecimal baseType = PDecimal.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction12() throws Exception {
        Calendar calendar = Calendar.getInstance();
        java.util.Date currentDate = calendar.getTime();
        Date date = new Date(currentDate.getTime());
        Date date2 = new Date(new java.util.Date().getTime() + 1000L);
        Object[] o = new Object[]{date, date, date, date2};
        Object[] o2 = new Object[]{date2};
        PDate baseType = PDate.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test(arr, date, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction13() throws Exception {
        Calendar calendar = Calendar.getInstance();
        java.util.Date currentDate = calendar.getTime();
        Time time = new Time(currentDate.getTime());
        Time time2 = new Time(new java.util.Date().getTime() + 1000L);
        Object[] o = new Object[]{time, time, time, time2};
        Object[] o2 = new Object[]{time2};
        PTime baseType = PTime.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test(arr, time, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction14() throws Exception {
        Calendar calendar = Calendar.getInstance();
        java.util.Date currentDate = calendar.getTime();
        Timestamp timestamp = new Timestamp(currentDate.getTime());
        Timestamp timestamp2 = new Timestamp(new java.util.Date().getTime() + 1000L);
        Object[] o = new Object[]{timestamp, timestamp2, timestamp, timestamp};
        Object[] o2 = new Object[]{timestamp2};
        PTimestamp baseType = PTimestamp.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayRemoveFunctionTest.test(arr, timestamp, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayRemoveFunction15() throws Exception {
        byte[][] o = new byte[][]{{2, 0, 3}, {42, 3}, {5, 3}, {6, 3}, {2, 5}};
        byte[][] o2 = new byte[][]{{42, 3}, {5, 3}, {6, 3}, {2, 5}};
        byte[] element = new byte[]{2, 0, 3};
        PVarbinary baseType = PVarbinary.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, (Object[])o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, (Object[])o2);
        ArrayRemoveFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }
}

