/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ArrayPrependFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PVarcharArray;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class ArrayPrependFunctionTest {
    private static void testExpression(LiteralExpression array, LiteralExpression element, PhoenixArray expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{element});
        expressions.add(array);
        ArrayPrependFunction arrayPrependFunction = new ArrayPrependFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayPrependFunction.evaluate(null, ptr);
        PhoenixArray result = (PhoenixArray)arrayPrependFunction.getDataType().toObject(ptr, ((Expression)expressions.get(1)).getSortOrder(), array.getMaxLength(), array.getScale());
        Assert.assertEquals((Object)result, (Object)expected);
    }

    private static void test(PhoenixArray array, Object element, PDataType arrayDataType, Integer arrMaxLen, Integer arrScale, PDataType elementDataType, Integer elemMaxLen, Integer elemScale, PhoenixArray expected, SortOrder arraySortOrder, SortOrder elementSortOrder) throws SQLException {
        LiteralExpression arrayLiteral = LiteralExpression.newConstant((Object)array, (PDataType)arrayDataType, (Integer)arrMaxLen, (Integer)arrScale, (SortOrder)arraySortOrder, (Determinism)Determinism.ALWAYS);
        LiteralExpression elementLiteral = LiteralExpression.newConstant((Object)element, (PDataType)elementDataType, (Integer)elemMaxLen, (Integer)elemScale, (SortOrder)elementSortOrder, (Determinism)Determinism.ALWAYS);
        ArrayPrependFunctionTest.testExpression(arrayLiteral, elementLiteral, expected);
    }

    @Test
    public void testArrayPrependFunction1() throws Exception {
        Object[] o = new Object[]{1, 2, -3, 4};
        Object[] o2 = new Object[]{5, 1, 2, -3, 4};
        Integer element = 5;
        PInteger baseType = PInteger.INSTANCE;
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveIntPhoenixArray expected = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction2() throws Exception {
        Object[] o = new Object[]{"1", "2", "3", "4"};
        Object[] o2 = new Object[]{"56", "1", "2", "3", "4"};
        String element = "56";
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction3() throws Exception {
        Object[] o = new Object[32768];
        for (int i = 0; i < o.length; ++i) {
            o[i] = "a";
        }
        Object[] o2 = new Object[32769];
        for (int i = 1; i < o2.length; ++i) {
            o2[i] = "a";
        }
        String element = "b";
        o2[0] = element;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction4() throws Exception {
        Object[] o = new Object[32774];
        for (int i = 0; i < o.length; ++i) {
            o[i] = "a";
        }
        Object[] o2 = new Object[32775];
        for (int i = 1; i < o2.length; ++i) {
            o2[i] = "a";
        }
        String element = "b";
        o2[0] = element;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunctionBoolean() throws Exception {
        Object[] o = new Boolean[]{true, false, false, true};
        Object[] o2 = new Boolean[]{false, true, false, false, true};
        Boolean element = false;
        PBoolean baseType = PBoolean.INSTANCE;
        PhoenixArray.PrimitiveBooleanPhoenixArray arr = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveBooleanPhoenixArray expected = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction6() throws Exception {
        Object[] o = new Object[]{new Float(2.3), new Float(7.9), new Float(-9.6), new Float(2.3)};
        Object[] o2 = new Object[]{new Float(8.9), new Float(2.3), new Float(7.9), new Float(-9.6), new Float(2.3)};
        Double element = 8.9;
        PFloat baseType = PFloat.INSTANCE;
        PhoenixArray.PrimitiveFloatPhoenixArray arr = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveFloatPhoenixArray expected = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction7() throws Exception {
        Object[] o = new Object[]{4.78, 9.54, 2.34, -9.675, Double.MAX_VALUE};
        Object[] o2 = new Object[]{12.67, 4.78, 9.54, 2.34, -9.675, Double.MAX_VALUE};
        Double element = 12.67;
        PDouble baseType = PDouble.INSTANCE;
        PhoenixArray.PrimitiveDoublePhoenixArray arr = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveDoublePhoenixArray expected = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction8() throws Exception {
        Object[] o = new Object[]{123L, 677L, 98789L, -78989L, 66787L};
        Object[] o2 = new Object[]{543L, 123L, 677L, 98789L, -78989L, 66787L};
        Long element = 543L;
        PLong baseType = PLong.INSTANCE;
        PhoenixArray.PrimitiveLongPhoenixArray arr = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveLongPhoenixArray expected = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction9() throws Exception {
        Object[] o = new Object[]{(short)34, (short)-23, (short)-89, (short)999, (short)34};
        Object[] o2 = new Object[]{(short)7, (short)34, (short)-23, (short)-89, (short)999, (short)34};
        Short element = 7;
        PSmallint baseType = PSmallint.INSTANCE;
        PhoenixArray.PrimitiveShortPhoenixArray arr = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveShortPhoenixArray expected = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction10() throws Exception {
        Object[] o = new Object[]{(byte)4, (byte)8, (byte)9};
        Object[] o2 = new Object[]{(byte)6, (byte)4, (byte)8, (byte)9};
        Byte element = 6;
        PTinyint baseType = PTinyint.INSTANCE;
        PhoenixArray.PrimitiveBytePhoenixArray arr = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveBytePhoenixArray expected = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction11() throws Exception {
        Object[] o = new Object[]{BigDecimal.valueOf(2345L), BigDecimal.valueOf(-23.45), BigDecimal.valueOf(785L)};
        Object[] o2 = new Object[]{BigDecimal.valueOf(-19L), BigDecimal.valueOf(2345L), BigDecimal.valueOf(-23.45), BigDecimal.valueOf(785L)};
        BigDecimal element = BigDecimal.valueOf(-19L);
        PDecimal baseType = PDecimal.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction12() throws Exception {
        Calendar calendar = Calendar.getInstance();
        java.util.Date currentDate = calendar.getTime();
        Date date = new Date(currentDate.getTime());
        Object[] o = new Object[]{date, date, date};
        Object[] o2 = new Object[]{date, date, date, date};
        PDate baseType = PDate.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, date, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction13() throws Exception {
        Calendar calendar = Calendar.getInstance();
        java.util.Date currentDate = calendar.getTime();
        Time time = new Time(currentDate.getTime());
        Object[] o = new Object[]{time, time, time};
        Object[] o2 = new Object[]{time, time, time, time};
        PTime baseType = PTime.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, time, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction14() throws Exception {
        Calendar calendar = Calendar.getInstance();
        java.util.Date currentDate = calendar.getTime();
        Timestamp timestamp = new Timestamp(currentDate.getTime());
        Object[] o = new Object[]{timestamp, timestamp, timestamp};
        Object[] o2 = new Object[]{timestamp, timestamp, timestamp, timestamp};
        PTimestamp baseType = PTimestamp.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, timestamp, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction15() throws Exception {
        Object[] o = new Object[]{1, 2, -3, 4};
        Object[] o2 = new Object[]{5, 1, 2, -3, 4};
        Integer element = 5;
        PInteger baseType = PInteger.INSTANCE;
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveIntPhoenixArray expected = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction16() throws Exception {
        Object[] o = new Object[]{1, 2, -3, 4};
        Object[] o2 = new Object[]{5, 1, 2, -3, 4};
        Integer element = 5;
        PInteger baseType = PInteger.INSTANCE;
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveIntPhoenixArray expected = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.DESC);
    }

    @Test
    public void testArrayPrependFunction17() throws Exception {
        Object[] o = new Object[]{1, 2, -3, 4};
        Object[] o2 = new Object[]{5, 1, 2, -3, 4};
        Integer element = 5;
        PInteger baseType = PInteger.INSTANCE;
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveIntPhoenixArray expected = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testArrayPrependFunction18() throws Exception {
        Object[] o = new Object[]{"1   ", "2   ", "3   ", "4   "};
        Object[] o2 = new Object[]{"5", "1", "2", "3", "4"};
        String element = "5";
        PChar baseType = PChar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 4, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testArrayPrependFunction19() throws Exception {
        Object[] o = new Object[]{"1   ", "2   ", "3   ", "4   "};
        Object[] o2 = new Object[]{"5", "1", "2", "3", "4"};
        String element = "5";
        PChar baseType = PChar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 4, null, (PDataType)baseType, 1, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testArrayPrependFunction20() throws Exception {
        Object[] o = new Object[]{"1   ", "2   ", "3   ", "4   "};
        Object[] o2 = new Object[]{"5", "1", "2", "3", "4"};
        String element = "5";
        PChar baseType = PChar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 4, null, (PDataType)baseType, 1, null, expected, SortOrder.DESC, SortOrder.DESC);
    }

    @Test
    public void testArrayPrependFunction21() throws Exception {
        Object[] o = new Object[]{4.78, 9.54, 2.34, -9.675, Double.MAX_VALUE};
        Object[] o2 = new Object[]{12.67, 4.78, 9.54, 2.34, -9.675, Double.MAX_VALUE};
        Double element = 12.67;
        PDouble baseType = PDouble.INSTANCE;
        PhoenixArray.PrimitiveDoublePhoenixArray arr = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)baseType, o);
        PhoenixArray.PrimitiveDoublePhoenixArray expected = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test((PhoenixArray)arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testArrayPrependFunction22() throws Exception {
        byte[][] o = new byte[][]{{2, 0, 3}, {42, 3}, {5, 3}, {6, 3}, {2, 5}};
        byte[][] o2 = new byte[][]{{5, 6}, {2, 0, 3}, {42, 3}, {5, 3}, {6, 3}, {2, 5}};
        byte[] element = new byte[]{5, 6};
        PVarbinary baseType = PVarbinary.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, (Object[])o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, (Object[])o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testArrayPrependFunction23() throws Exception {
        byte[][] o = new byte[][]{{2, 3}, {42, 3}, {5, 3}, {6, 3}, {2, 5}};
        byte[][] o2 = new byte[][]{{5, 6}, {2, 3}, {42, 3}, {5, 3}, {6, 3}, {2, 5}};
        byte[] element = new byte[]{5, 6};
        PBinary baseType = PBinary.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, (Object[])o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, (Object[])o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 2, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testArrayPrependFunction24() throws Exception {
        byte[][] o = new byte[][]{{2, 0}, {13, 3}, {5, 3}, {6, 3}, {2, 5}};
        byte[][] o2 = new byte[][]{{5, 6}, {2, 0}, {13, 3}, {5, 3}, {6, 3}, {2, 5}};
        byte[] element = new byte[]{5, 6};
        PBinary baseType = PBinary.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, (Object[])o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, (Object[])o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 3, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWithNoNullsAtBeginning() throws Exception {
        Object[] o = new Object[]{"1   ", "2   ", "3   ", "4   "};
        Object[] o2 = new Object[]{"1", "2", "3", "4"};
        Object element = null;
        PChar baseType = PChar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 4, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsAllNulls() throws Exception {
        Object element = null;
        PChar baseType = PChar.INSTANCE;
        PhoenixArray arr = null;
        PhoenixArray expected = null;
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 4, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWith268NullsAtBeginning() throws Exception {
        Object[] o = new Object[270];
        for (int i = 0; i < o.length - 2; ++i) {
            o[i] = null;
        }
        o[o.length - 2] = "1";
        o[o.length - 1] = "2";
        Object[] o2 = new Object[271];
        for (int i = 0; i < o2.length - 2; ++i) {
            o2[i] = null;
        }
        o2[o2.length - 2] = "1";
        o2[o2.length - 1] = "2";
        Object element = null;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWith241NullsAtBeginning() throws Exception {
        Object[] o = new Object[243];
        for (int i = 0; i < o.length - 2; ++i) {
            o[i] = null;
        }
        o[o.length - 2] = "1";
        o[o.length - 1] = "2";
        Object[] o2 = new Object[244];
        for (int i = 0; i < o2.length - 2; ++i) {
            o2[i] = null;
        }
        o2[o2.length - 2] = "1";
        o2[o2.length - 1] = "2";
        Object element = null;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWith254NullsAtBeginning() throws Exception {
        Object[] o = new Object[256];
        for (int i = 0; i < o.length - 2; ++i) {
            o[i] = null;
        }
        o[o.length - 2] = "1";
        o[o.length - 1] = "2";
        Object[] o2 = new Object[257];
        for (int i = 0; i < o2.length - 2; ++i) {
            o2[i] = null;
        }
        o2[o2.length - 2] = "1";
        o2[o2.length - 1] = "2";
        Object element = null;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWith510NullsAtBeginning() throws Exception {
        Object[] o = new Object[512];
        for (int i = 0; i < o.length - 2; ++i) {
            o[i] = null;
        }
        o[o.length - 2] = "1";
        o[o.length - 1] = "2";
        Object[] o2 = new Object[513];
        for (int i = 0; i < o2.length - 2; ++i) {
            o2[i] = null;
        }
        o2[o2.length - 2] = "1";
        o2[o2.length - 1] = "2";
        Object element = null;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWith509NullsAtBeginning() throws Exception {
        Object[] o = new Object[511];
        for (int i = 0; i < o.length - 2; ++i) {
            o[i] = null;
        }
        o[o.length - 2] = "1";
        o[o.length - 1] = "2";
        Object[] o2 = new Object[512];
        for (int i = 0; i < o2.length - 2; ++i) {
            o2[i] = null;
        }
        o2[o2.length - 2] = "1";
        o2[o2.length - 1] = "2";
        Object element = null;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWith1NullAtBeginning() throws Exception {
        Object[] o = new Object[]{"1   ", "2   ", "3   ", "4   "};
        Object[] o2 = new Object[]{null, "1   ", "2   ", "3   ", "4   "};
        Object element = null;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 4, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWith2NullsAtBeginning() throws Exception {
        Object[] o = new Object[]{null, "1   ", "2   ", "3   ", "4   "};
        Object[] o2 = new Object[]{null, null, "1   ", "2   ", "3   ", "4   "};
        Object element = null;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), 4, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForNullsWithNullsInMiddle() throws Exception {
        Object[] o = new Object[]{"1   ", "2   ", null, "3   ", "4   "};
        Object[] o2 = new Object[]{null, "1   ", "2   ", null, "3   ", "4   "};
        Object element = null;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        PhoenixArray expected = new PhoenixArray((PDataType)baseType, o2);
        ArrayPrependFunctionTest.test(arr, element, PDataType.fromTypeId((int)(baseType.getSqlType() + 3000)), null, null, (PDataType)baseType, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForCorrectSeparatorBytes1() throws Exception {
        Object[] o = new Object[]{"a", "b", "c"};
        String element = "d";
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        LiteralExpression arrayLiteral = LiteralExpression.newConstant((Object)arr, (PDataType)PVarcharArray.INSTANCE, null, null, (SortOrder)SortOrder.ASC, (Determinism)Determinism.ALWAYS);
        LiteralExpression elementLiteral = LiteralExpression.newConstant((Object)element, (PDataType)baseType, null, null, (SortOrder)SortOrder.ASC, (Determinism)Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{elementLiteral});
        expressions.add(arrayLiteral);
        ArrayPrependFunction arrayPrependFunction = new ArrayPrependFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayPrependFunction.evaluate(null, ptr);
        byte[] expected = new byte[]{100, 0, 97, 0, 98, 0, 99, 0, 0, 0, -128, 1, -128, 3, -128, 5, -128, 7, 0, 0, 0, 10, 0, 0, 0, 4, 1};
        Assert.assertArrayEquals((byte[])expected, (byte[])ptr.get());
    }

    @Test
    public void testForCorrectSeparatorBytes2() throws Exception {
        Object[] o = new Object[]{"a", "b", "c"};
        String element = "d";
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        LiteralExpression arrayLiteral = LiteralExpression.newConstant((Object)arr, (PDataType)PVarcharArray.INSTANCE, null, null, (SortOrder)SortOrder.DESC, (Determinism)Determinism.ALWAYS);
        LiteralExpression elementLiteral = LiteralExpression.newConstant((Object)element, (PDataType)baseType, null, null, (SortOrder)SortOrder.ASC, (Determinism)Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{elementLiteral});
        expressions.add(arrayLiteral);
        ArrayPrependFunction arrayPrependFunction = new ArrayPrependFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayPrependFunction.evaluate(null, ptr);
        byte[] expected = new byte[]{-101, -1, -98, -1, -99, -1, -100, -1, -1, -1, -128, 1, -128, 3, -128, 5, -128, 7, 0, 0, 0, 10, 0, 0, 0, 4, 1};
        Assert.assertArrayEquals((byte[])expected, (byte[])ptr.get());
    }

    @Test
    public void testForCorrectSeparatorBytes3() throws Exception {
        Object[] o = new Object[]{"a", null, null, "c"};
        String element = "d";
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray arr = new PhoenixArray((PDataType)baseType, o);
        LiteralExpression arrayLiteral = LiteralExpression.newConstant((Object)arr, (PDataType)PVarcharArray.INSTANCE, null, null, (SortOrder)SortOrder.DESC, (Determinism)Determinism.ALWAYS);
        LiteralExpression elementLiteral = LiteralExpression.newConstant((Object)element, (PDataType)baseType, null, null, (SortOrder)SortOrder.ASC, (Determinism)Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{elementLiteral});
        expressions.add(arrayLiteral);
        ArrayPrependFunction arrayPrependFunction = new ArrayPrependFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayPrependFunction.evaluate(null, ptr);
        byte[] expected = new byte[]{-101, -1, -98, -1, 0, -2, -100, -1, -1, -1, -128, 1, -128, 3, -128, 5, -128, 5, -128, 7, 0, 0, 0, 10, 0, 0, 0, 5, 1};
        Assert.assertArrayEquals((byte[])expected, (byte[])ptr.get());
    }
}

