/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.expression.DecimalAddExpression;
import org.apache.phoenix.expression.DecimalDivideExpression;
import org.apache.phoenix.expression.DecimalMultiplyExpression;
import org.apache.phoenix.expression.DecimalSubtractExpression;
import org.apache.phoenix.expression.DoubleAddExpression;
import org.apache.phoenix.expression.DoubleSubtractExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.RandomFunction;
import org.apache.phoenix.expression.visitor.CloneExpressionVisitor;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.junit.Assert;
import org.junit.Test;

public class ArithmeticOperationTest {
    @Test
    public void testDecimalAddition() throws Exception {
        LiteralExpression op1 = LiteralExpression.newConstant((Object)new BigDecimal("1234567890123456789012345678901"), (PDataType)PDecimal.INSTANCE, (Integer)31, (Integer)0);
        LiteralExpression op2 = LiteralExpression.newConstant((Object)new BigDecimal("12345"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)0);
        List<Expression> children = Arrays.asList(op1, op2);
        DecimalAddExpression e = new DecimalAddExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("1234567890123456789012345691246"));
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("123.45"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)2);
        children = Arrays.asList(op1, op2);
        e = new DecimalAddExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("12468.45"));
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("99999999999999999999999999999999999999"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("123"), (PDataType)PDecimal.INSTANCE, (Integer)3, (Integer)0);
        children = Arrays.asList(op1, op2);
        e = new DecimalAddExpression(children);
        try {
            e.evaluate(null, new ImmutableBytesWritable());
            Assert.fail((String)"Evaluation should have failed");
        }
        catch (DataExceedsCapacityException dataExceedsCapacityException) {
            // empty catch block
        }
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("99999999999999999999999999999999999999"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("123"), (PDataType)PDecimal.INSTANCE, (Integer)3, (Integer)0);
        LiteralExpression op3 = LiteralExpression.newConstant((Object)new BigDecimal("-123"), (PDataType)PDecimal.INSTANCE, (Integer)3, (Integer)0);
        children = Arrays.asList(op1, op2, op3);
        e = new DecimalAddExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("99999999999999999999999999999999999999"));
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345678901234567890123456789012345678"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("123.45"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)2);
        children = Arrays.asList(op1, op2);
        e = new DecimalAddExpression(children);
        try {
            e.evaluate(null, new ImmutableBytesWritable());
            Assert.fail((String)"Evaluation should have failed");
        }
        catch (DataExceedsCapacityException dataExceedsCapacityException) {
            // empty catch block
        }
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("9999.1"), (PDataType)PDecimal.INSTANCE);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("1.1111"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)4);
        children = Arrays.asList(op1, op2);
        e = new DecimalAddExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("10000.2111"));
    }

    @Test
    public void testIntPlusDecimal() throws Exception {
        LiteralExpression op1 = LiteralExpression.newConstant((Object)new BigDecimal("1234.111"), (PDataType)PDecimal.INSTANCE);
        Assert.assertNull((Object)op1.getScale());
        LiteralExpression op2 = LiteralExpression.newConstant((Object)1, (PDataType)PInteger.INSTANCE);
        List<Expression> children = Arrays.asList(op1, op2);
        DecimalAddExpression e = new DecimalAddExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("1235.111"));
    }

    @Test
    public void testDecimalSubtraction() throws Exception {
        LiteralExpression op1 = LiteralExpression.newConstant((Object)new BigDecimal("1234567890123456789012345678901"), (PDataType)PDecimal.INSTANCE, (Integer)31, (Integer)0);
        LiteralExpression op2 = LiteralExpression.newConstant((Object)new BigDecimal("12345"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)0);
        List<Expression> children = Arrays.asList(op1, op2);
        DecimalSubtractExpression e = new DecimalSubtractExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("1234567890123456789012345666556"));
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("123.45"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)2);
        children = Arrays.asList(op1, op2);
        e = new DecimalSubtractExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("12221.55"));
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("99999999999999999999999999999999999999"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("-123"), (PDataType)PDecimal.INSTANCE, (Integer)3, (Integer)0);
        children = Arrays.asList(op1, op2);
        e = new DecimalSubtractExpression(children);
        try {
            e.evaluate(null, new ImmutableBytesWritable());
            Assert.fail((String)"Evaluation should have failed");
        }
        catch (DataExceedsCapacityException dataExceedsCapacityException) {
            // empty catch block
        }
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("99999999999999999999999999999999999999"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("-123"), (PDataType)PDecimal.INSTANCE, (Integer)3, (Integer)0);
        LiteralExpression op3 = LiteralExpression.newConstant((Object)new BigDecimal("123"), (PDataType)PDecimal.INSTANCE, (Integer)3, (Integer)0);
        children = Arrays.asList(op1, op2, op3);
        e = new DecimalSubtractExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("99999999999999999999999999999999999999"));
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345678901234567890123456789012345678"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("123.45"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)2);
        children = Arrays.asList(op1, op2);
        e = new DecimalSubtractExpression(children);
        try {
            e.evaluate(null, new ImmutableBytesWritable());
            Assert.fail((String)"Evaluation should have failed");
        }
        catch (DataExceedsCapacityException dataExceedsCapacityException) {
            // empty catch block
        }
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("1111.1"), (PDataType)PDecimal.INSTANCE);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("1.1111"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)4);
        children = Arrays.asList(op1, op2);
        e = new DecimalSubtractExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("1109.9889"));
    }

    @Test
    public void testDecimalMultiplication() throws Exception {
        LiteralExpression op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)0);
        LiteralExpression op2 = LiteralExpression.newConstant((Object)new BigDecimal("123.45"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)2);
        List<Expression> children = Arrays.asList(op1, op2);
        DecimalMultiplyExpression e = new DecimalMultiplyExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("1523990.25"));
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345678901234567890123456789012345678"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("12345"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)0);
        children = Arrays.asList(op1, op2);
        e = new DecimalMultiplyExpression(children);
        try {
            e.evaluate(null, new ImmutableBytesWritable());
            Assert.fail((String)"Evaluation should have failed");
        }
        catch (DataExceedsCapacityException dataExceedsCapacityException) {
            // empty catch block
        }
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345678901234567890123456789012345678"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("1.45"), (PDataType)PDecimal.INSTANCE, (Integer)3, (Integer)2);
        children = Arrays.asList(op1, op2);
        e = new DecimalMultiplyExpression(children);
        try {
            e.evaluate(null, new ImmutableBytesWritable());
            Assert.fail((String)"Evaluation should have failed");
        }
        catch (DataExceedsCapacityException dataExceedsCapacityException) {
            // empty catch block
        }
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("1111.1"), (PDataType)PDecimal.INSTANCE);
        Assert.assertNull((Object)op1.getScale());
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("1.1111"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)4);
        children = Arrays.asList(op1, op2);
        e = new DecimalMultiplyExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("1234.54321"));
    }

    @Test
    public void testDecimalDivision() throws Exception {
        LiteralExpression op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)0);
        LiteralExpression op2 = LiteralExpression.newConstant((Object)new BigDecimal("0.01"), (PDataType)PDecimal.INSTANCE, (Integer)2, (Integer)2);
        List<Expression> children = Arrays.asList(op1, op2);
        DecimalDivideExpression e = new DecimalDivideExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("1.2345E+6"));
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("12345678901234567890123456789012345678"), (PDataType)PDecimal.INSTANCE, (Integer)38, (Integer)0);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("0.01"), (PDataType)PDecimal.INSTANCE, (Integer)2, (Integer)2);
        children = Arrays.asList(op1, op2);
        e = new DecimalDivideExpression(children);
        try {
            e.evaluate(null, new ImmutableBytesWritable());
            Assert.fail((String)"Evaluation should have failed");
        }
        catch (DataExceedsCapacityException dataExceedsCapacityException) {
            // empty catch block
        }
        op1 = LiteralExpression.newConstant((Object)new BigDecimal("10"), (PDataType)PDecimal.INSTANCE);
        op2 = LiteralExpression.newConstant((Object)new BigDecimal("3"), (PDataType)PDecimal.INSTANCE, (Integer)5, (Integer)4);
        Assert.assertEquals((Object)4, (Object)op2.getScale());
        children = Arrays.asList(op1, op2);
        e = new DecimalDivideExpression(children);
        ArithmeticOperationTest.assertEqualValue((Expression)e, (PDataType)PDecimal.INSTANCE, new BigDecimal("3.3333333333333333333333333333333333333"));
    }

    @Test
    public void testPerInvocationClone() throws Exception {
        CloneExpressionVisitor visitor;
        ImmutableBytesWritable ptr1 = new ImmutableBytesWritable();
        ImmutableBytesWritable ptr2 = new ImmutableBytesWritable();
        LiteralExpression op1 = LiteralExpression.newConstant((Object)5.0);
        LiteralExpression op2 = LiteralExpression.newConstant((Object)3.0);
        LiteralExpression op3 = LiteralExpression.newConstant((Object)2.0);
        LiteralExpression op4 = LiteralExpression.newConstant((Object)1.0);
        List<Expression> children = Arrays.asList(op1, op2);
        DoubleAddExpression e1 = new DoubleAddExpression(children);
        children = Arrays.asList(op3, op4);
        DoubleSubtractExpression e2 = new DoubleSubtractExpression(children);
        DoubleAddExpression e3 = new DoubleAddExpression(Arrays.asList(e1, e2));
        DoubleAddExpression e4 = new DoubleAddExpression(Arrays.asList(new RandomFunction(Arrays.asList(LiteralExpression.newConstant(null))), e3));
        Expression clone = (Expression)e4.accept((ExpressionVisitor)(visitor = new CloneExpressionVisitor()));
        Assert.assertTrue((clone != e4 ? 1 : 0) != 0);
        e4.evaluate(null, ptr1);
        clone.evaluate(null, ptr2);
        Assert.assertNotEquals((Object)ptr1, (Object)ptr2);
        e4 = new DoubleAddExpression(Arrays.asList(new RandomFunction(Arrays.asList(LiteralExpression.newConstant((Object)1))), e3));
        visitor = new CloneExpressionVisitor();
        clone = (Expression)e4.accept((ExpressionVisitor)visitor);
        Assert.assertTrue((clone == e4 ? 1 : 0) != 0);
        e4.evaluate(null, ptr1);
        clone.evaluate(null, ptr2);
        Assert.assertEquals((Object)ptr1, (Object)ptr2);
    }

    private static void assertEqualValue(Expression e, PDataType type, Object value) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean evaluated = e.evaluate(null, ptr);
        Assert.assertTrue((boolean)evaluated);
        Assert.assertEquals((Object)value, (Object)type.toObject(ptr.get()));
        CloneExpressionVisitor visitor = new CloneExpressionVisitor();
        Expression clone = (Expression)e.accept((ExpressionVisitor)visitor);
        evaluated = clone.evaluate(null, ptr);
        Assert.assertTrue((boolean)evaluated);
        Assert.assertEquals((Object)value, (Object)type.toObject(ptr.get()));
    }
}

