/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PBaseColumn;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.junit.Assert;
import org.junit.Test;

public class AndExpressionTest {
    private AndExpression createAnd(Expression lhs, Expression rhs) {
        return new AndExpression(Arrays.asList(lhs, rhs));
    }

    private AndExpression createAnd(Boolean x, Boolean y) {
        return this.createAnd((Expression)LiteralExpression.newConstant((Object)x), (Expression)LiteralExpression.newConstant((Object)y));
    }

    private void testImmediateSingle(Boolean expected, Boolean lhs, Boolean rhs) {
        AndExpression and = this.createAnd(lhs, rhs);
        ImmutableBytesWritable out = new ImmutableBytesWritable();
        MultiKeyValueTuple tuple = new MultiKeyValueTuple();
        boolean success = and.evaluate((Tuple)tuple, out);
        Assert.assertTrue((boolean)success);
        Assert.assertEquals((Object)expected, (Object)PBoolean.INSTANCE.toObject(out));
    }

    private void testImmediate(Boolean expected, Boolean a, Boolean b) {
        this.testImmediateSingle(expected, a, b);
        this.testImmediateSingle(expected, b, a);
    }

    private PColumn pcolumn(final String name) {
        return new PBaseColumn(){

            public PName getName() {
                return PNameFactory.newName((String)name);
            }

            public PDataType getDataType() {
                return PBoolean.INSTANCE;
            }

            public PName getFamilyName() {
                return PNameFactory.newName((String)"0");
            }

            public int getPosition() {
                return 0;
            }

            public Integer getArraySize() {
                return null;
            }

            public byte[] getViewConstant() {
                return new byte[0];
            }

            public boolean isViewReferenced() {
                return false;
            }

            public String getExpressionStr() {
                return null;
            }

            public boolean isRowTimestamp() {
                return false;
            }

            public boolean isDynamic() {
                return false;
            }

            public byte[] getColumnQualifierBytes() {
                return null;
            }

            public long getTimestamp() {
                return 0L;
            }

            public boolean isDerived() {
                return false;
            }

            public boolean isExcluded() {
                return false;
            }

            public SortOrder getSortOrder() {
                return null;
            }
        };
    }

    private KeyValueColumnExpression kvExpr(String name) {
        return new KeyValueColumnExpression(this.pcolumn(name));
    }

    private Cell createCell(String name, Boolean value) {
        byte[] valueBytes = value == null ? null : (value != false ? PBoolean.TRUE_BYTES : PBoolean.FALSE_BYTES);
        return CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(Bytes.toBytes((String)"row")).setFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES).setQualifier(Bytes.toBytes((String)name)).setTimestamp(1L).setType(Cell.Type.Put).setValue(valueBytes).build();
    }

    private void testPartialOneSideFirst(Boolean expected, Boolean lhs, Boolean rhs, boolean leftFirst) {
        KeyValueColumnExpression lhsExpr = this.kvExpr("LHS");
        KeyValueColumnExpression rhsExpr = this.kvExpr("RHS");
        AndExpression and = this.createAnd((Expression)lhsExpr, (Expression)rhsExpr);
        MultiKeyValueTuple tuple = new MultiKeyValueTuple(Collections.emptyList());
        ImmutableBytesWritable out = new ImmutableBytesWritable();
        boolean success = and.evaluate((Tuple)tuple, out);
        Assert.assertFalse((boolean)success);
        if (leftFirst) {
            tuple.setKeyValues(Collections.singletonList(this.createCell("LHS", lhs)));
        } else {
            tuple.setKeyValues(Collections.singletonList(this.createCell("RHS", rhs)));
        }
        success = and.evaluate((Tuple)tuple, out);
        Assert.assertFalse((boolean)success);
        tuple.setKeyValues(Arrays.asList(this.createCell("LHS", lhs), this.createCell("RHS", rhs)));
        success = and.evaluate((Tuple)tuple, out);
        Assert.assertTrue((boolean)success);
        Assert.assertEquals((Object)expected, (Object)PBoolean.INSTANCE.toObject(out));
    }

    private void testPartialEvaluation(Boolean expected, Boolean x, Boolean y, boolean xFirst) {
        this.testPartialOneSideFirst(expected, x, y, xFirst);
        this.testPartialOneSideFirst(expected, y, x, !xFirst);
    }

    private void testShortCircuitOneSideFirst(Boolean expected, Boolean lhs, Boolean rhs, boolean leftFirst) {
        KeyValueColumnExpression lhsExpr = this.kvExpr("LHS");
        KeyValueColumnExpression rhsExpr = this.kvExpr("RHS");
        AndExpression and = this.createAnd((Expression)lhsExpr, (Expression)rhsExpr);
        MultiKeyValueTuple tuple = new MultiKeyValueTuple(Collections.emptyList());
        ImmutableBytesWritable out = new ImmutableBytesWritable();
        boolean success = and.evaluate((Tuple)tuple, out);
        Assert.assertFalse((boolean)success);
        if (leftFirst) {
            tuple.setKeyValues(Collections.singletonList(this.createCell("LHS", lhs)));
        } else {
            tuple.setKeyValues(Collections.singletonList(this.createCell("RHS", rhs)));
        }
        success = and.evaluate((Tuple)tuple, out);
        Assert.assertTrue((boolean)success);
        Assert.assertEquals((Object)expected, (Object)PBoolean.INSTANCE.toObject(out));
    }

    private void testShortCircuit(Boolean expected, Boolean x, Boolean y, boolean xFirst) {
        this.testShortCircuitOneSideFirst(expected, x, y, xFirst);
        this.testShortCircuitOneSideFirst(expected, y, x, !xFirst);
    }

    @Test
    public void testImmediateCertainty() {
        this.testImmediate(true, true, true);
        this.testImmediate(false, false, true);
        this.testImmediate(false, false, false);
    }

    @Test
    public void testImmediateUncertainty() {
        this.testImmediate(null, true, null);
        this.testImmediate(false, false, null);
        this.testImmediate(null, null, null);
    }

    @Test
    public void testPartialCertainty() {
        this.testPartialEvaluation(true, true, true, true);
        this.testPartialEvaluation(true, true, true, false);
        this.testPartialEvaluation(false, true, false, true);
        this.testPartialEvaluation(false, false, true, false);
    }

    @Test
    public void testPartialUncertainty() {
        this.testPartialEvaluation(null, true, null, true);
        this.testPartialEvaluation(null, true, null, false);
        this.testPartialEvaluation(null, null, true, true);
        this.testPartialEvaluation(null, null, true, false);
        this.testPartialEvaluation(false, null, false, true);
        this.testPartialEvaluation(false, false, null, false);
        this.testPartialEvaluation(null, null, null, true);
        this.testPartialEvaluation(null, null, null, false);
    }

    @Test
    public void testShortCircuitCertainty() {
        this.testShortCircuit(false, false, false, true);
        this.testShortCircuit(false, false, false, false);
        this.testShortCircuit(false, false, true, true);
        this.testShortCircuit(false, true, false, false);
    }

    @Test
    public void testShortCircuitUncertainty() {
        this.testShortCircuit(false, false, null, true);
        this.testShortCircuit(false, null, false, false);
    }

    @Test
    public void testTruthTable() {
        Boolean[][] testCases;
        for (Boolean[] testCase : testCases = new Boolean[][]{{true, true, false, false, true}, {true, false, false, true, false}, {false, false, true, true, false}, {true, null, false, false, null}, {false, null, true, false, false}, {null, null, false, false, null}}) {
            Boolean x = testCase[0];
            Boolean y = testCase[1];
            boolean shouldShortCircuitWhenXEvaluatedFirst = testCase[2];
            boolean shouldShortCircuitWhenYEvaluatedFirst = testCase[3];
            Boolean expected = testCase[4];
            this.testImmediate(expected, x, y);
            if (shouldShortCircuitWhenXEvaluatedFirst) {
                this.testShortCircuit(expected, x, y, true);
            } else {
                this.testPartialEvaluation(expected, x, y, true);
            }
            if (shouldShortCircuitWhenYEvaluatedFirst) {
                this.testShortCircuit(expected, x, y, false);
                continue;
            }
            this.testPartialEvaluation(expected, x, y, false);
        }
    }
}

