/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.AbsFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PNumericType;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class AbsFunctionTest {
    private static void testExpression(LiteralExpression literal, Number expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{literal});
        AbsFunction absFunction = new AbsFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        absFunction.evaluate(null, ptr);
        Number result = (Number)absFunction.getDataType().toObject(ptr, absFunction.getSortOrder());
        Assert.assertTrue((boolean)result.getClass().equals(expected.getClass()));
        if (result instanceof BigDecimal) {
            Assert.assertTrue((((BigDecimal)result).compareTo((BigDecimal)expected) == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((boolean)result.equals(expected));
        }
    }

    private static void test(Number value, PNumericType dataType, Number expected) throws SQLException {
        LiteralExpression literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        AbsFunctionTest.testExpression(literal, expected);
        literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        AbsFunctionTest.testExpression(literal, expected);
    }

    private static void testBatch(Number[] value, PNumericType dataType, ArrayList<Number> expected) throws SQLException {
        Assert.assertEquals((long)value.length, (long)expected.size());
        for (int i = 0; i < value.length; ++i) {
            AbsFunctionTest.test(value[i], dataType, expected.get(i));
        }
    }

    @Test
    public void testAbsFunction() throws Exception {
        int i;
        Random random = new Random();
        ArrayList<Number> expected = new ArrayList<Number>();
        Number[] value = new BigDecimal[]{BigDecimal.valueOf(1.0), BigDecimal.valueOf(0.0), BigDecimal.valueOf(-1.0), BigDecimal.valueOf(123.1234), BigDecimal.valueOf(-123.1234)};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(value[i].abs());
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PDecimal.INSTANCE, expected);
        value = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(123.1234f), Float.valueOf(-123.1234f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-1.4E-45f), Float.valueOf(-3.4028235E38f), Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat())};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(Float.valueOf(Math.abs(((Float)value[i]).floatValue())));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PFloat.INSTANCE, expected);
        value = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(123.1234f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(Float.valueOf(Math.abs(((Float)value[i]).floatValue())));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PUnsignedFloat.INSTANCE, expected);
        value = new Double[]{1.0, 0.0, -1.0, 123.1234, -123.1234, Double.MIN_VALUE, Double.MAX_VALUE, -4.9E-324, -1.7976931348623157E308, random.nextDouble(), random.nextDouble(), random.nextDouble()};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(Math.abs((Double)value[i]));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PDouble.INSTANCE, expected);
        value = new Double[]{1.0, 0.0, 123.1234, Double.MIN_VALUE, Double.MAX_VALUE};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(Math.abs((Double)value[i]));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PUnsignedDouble.INSTANCE, expected);
        value = new Long[]{1L, 0L, -1L, 123L, -123L, -9223372036854775807L, Long.MAX_VALUE, random.nextLong(), random.nextLong(), random.nextLong()};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(Math.abs((Long)value[i]));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PLong.INSTANCE, expected);
        value = new Long[]{1L, 0L, 123L, Long.MAX_VALUE};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(Math.abs((Long)value[i]));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PUnsignedLong.INSTANCE, expected);
        value = new Integer[]{1, 0, -1, 123, -123, -2147483647, Integer.MAX_VALUE, random.nextInt(), random.nextInt(), random.nextInt()};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(Math.abs((Integer)value[i]));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PInteger.INSTANCE, expected);
        value = new Integer[]{1, 0, 123, Integer.MAX_VALUE};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add(Math.abs((Integer)value[i]));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PUnsignedInt.INSTANCE, expected);
        value = new Short[]{(short)1, (short)0, (short)-1, (short)123, (short)-123, (short)-32767, (short)Short.MAX_VALUE};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add((short)Math.abs(((Short)value[i]).shortValue()));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PSmallint.INSTANCE, expected);
        value = new Short[]{(short)1, (short)0, (short)123, (short)Short.MAX_VALUE};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add((short)Math.abs(((Short)value[i]).shortValue()));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PUnsignedSmallint.INSTANCE, expected);
        value = new Byte[]{(byte)1, (byte)0, (byte)-1, (byte)123, (byte)-123, (byte)-127, (byte)127};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add((byte)Math.abs(((Byte)value[i]).byteValue()));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PTinyint.INSTANCE, expected);
        value = new Byte[]{(byte)1, (byte)0, (byte)123, (byte)127};
        expected.clear();
        for (i = 0; i < value.length; ++i) {
            expected.add((byte)Math.abs(((Byte)value[i]).byteValue()));
        }
        AbsFunctionTest.testBatch(value, (PNumericType)PUnsignedTinyint.INSTANCE, expected);
    }
}

