/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class UpsertSelectOverlappingBatchesIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertSelectOverlappingBatchesIT.class);
    private Properties props;
    private static volatile String dataTable;
    private String index;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)3);
        serverProps.put("hbase.coprocessor.region.classes", SlowBatchRegionObserver.class.getName());
        serverProps.put("hbase.rowlock.wait.duration", "5000");
        serverProps.put("phoenix.mutate.batchSize", "100");
        UpsertSelectOverlappingBatchesIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void tearDownClass() throws Exception {
        SlowBatchRegionObserver.SLOW_MUTATE = false;
        ServerMetadataCacheTestImpl.resetCache();
        UpsertSelectOverlappingBatchesIT.getUtility().shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        SlowBatchRegionObserver.SLOW_MUTATE = false;
        this.props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.props.put("hbase.client.retries.number", (Object)2);
        dataTable = UpsertSelectOverlappingBatchesIT.generateUniqueName();
        this.index = "IDX_" + dataTable;
        try (Connection conn = driver.connect(url, this.props);){
            conn.createStatement().execute("CREATE TABLE " + dataTable + " (k INTEGER NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)");
            conn.createStatement().execute("CREATE INDEX " + this.index + " ON " + dataTable + " (v1)");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTable + " VALUES(?,?,?)");
            conn.setAutoCommit(false);
            for (int i = 0; i < 100; ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, "v1" + i);
                stmt.setString(3, "v2" + i);
                stmt.execute();
            }
            conn.commit();
        }
    }

    @Test
    public void testUpsertSelectSameBatchConcurrently() throws Exception {
        try (Connection conn = driver.connect(url, this.props);){
            int numUpsertSelectRunners = 5;
            ExecutorService exec = Executors.newFixedThreadPool(numUpsertSelectRunners);
            ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(exec);
            ArrayList futures = Lists.newArrayListWithExpectedSize((int)numUpsertSelectRunners);
            futures.add(completionService.submit(new UpsertSelectRunner(dataTable, 0, 105, 1)));
            for (int i = 0; i < 100; i += 25) {
                futures.add(completionService.submit(new UpsertSelectRunner(dataTable, i, i + 25, 5)));
            }
            for (int received = 0; received < futures.size(); ++received) {
                Future resultFuture = completionService.take();
                Boolean result = (Boolean)resultFuture.get();
                Assert.assertTrue((boolean)result);
            }
            exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitDuringUpsertSelect() throws Exception {
        int numUpsertSelectRunners = 4;
        ExecutorService exec = Executors.newFixedThreadPool(numUpsertSelectRunners);
        try (Connection conn = driver.connect(url, this.props);){
            UpsertSelectRunner upsertSelectRunner = new UpsertSelectRunner(dataTable, 0, 105, 1);
            SlowBatchRegionObserver.SLOW_MUTATE = true;
            for (int i = 0; i < numUpsertSelectRunners; ++i) {
                exec.submit(new UpsertSelectLooper(upsertSelectRunner));
                Thread.sleep(300L);
            }
            HBaseTestingUtility utility = UpsertSelectOverlappingBatchesIT.getUtility();
            final Admin admin = utility.getAdmin();
            final TableName dataTN = TableName.valueOf((String)dataTable);
            Assert.assertEquals((long)1L, (long)utility.getHBaseCluster().getRegions(dataTN).size());
            utility.waitFor(60000L, 1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    try {
                        List regions = admin.getRegions(dataTN);
                        if (regions.size() > 1) {
                            LOGGER.info("Found region was split");
                            return true;
                        }
                        if (regions.size() == 0) {
                            LOGGER.info("No region returned");
                            return false;
                        }
                        RegionInfo hRegion = (RegionInfo)regions.get(0);
                        LOGGER.info("Attempting to split region");
                        admin.splitRegionAsync(hRegion.getRegionName(), Bytes.toBytes((int)2));
                        return false;
                    }
                    catch (NotServingRegionException | DoNotRetryRegionException re) {
                        return false;
                    }
                }
            });
        }
        finally {
            SlowBatchRegionObserver.SLOW_MUTATE = false;
            exec.shutdownNow();
            exec.awaitTermination(60L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionCloseDuringUpsertSelect() throws Exception {
        int numUpsertSelectRunners = 4;
        ExecutorService exec = Executors.newFixedThreadPool(numUpsertSelectRunners);
        try (Connection conn = driver.connect(url, this.props);){
            UpsertSelectRunner upsertSelectRunner = new UpsertSelectRunner(dataTable, 0, 105, 1);
            SlowBatchRegionObserver.SLOW_MUTATE = true;
            for (int i = 0; i < numUpsertSelectRunners; ++i) {
                exec.submit(new UpsertSelectLooper(upsertSelectRunner));
                Thread.sleep(300L);
            }
            HBaseTestingUtility utility = UpsertSelectOverlappingBatchesIT.getUtility();
            final HRegionServer dataRs = utility.getHBaseCluster().getRegionServer(0);
            final Admin admin = utility.getAdmin();
            final RegionInfo dataRegion = (RegionInfo)admin.getRegions(TableName.valueOf((String)dataTable)).get(0);
            LOGGER.info("Closing data table region");
            admin.unassign(dataRegion.getEncodedNameAsBytes(), true);
            utility.waitFor(60000L, 1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    List onlineRegions = admin.getRegions(dataRs.getServerName());
                    for (RegionInfo onlineRegion : onlineRegions) {
                        if (!onlineRegion.equals(dataRegion)) continue;
                        LOGGER.info("Data region still online");
                        return false;
                    }
                    LOGGER.info("Region is no longer online");
                    return true;
                }
            });
        }
        finally {
            SlowBatchRegionObserver.SLOW_MUTATE = false;
            exec.shutdownNow();
            exec.awaitTermination(60L, TimeUnit.SECONDS);
        }
    }

    public static class SlowBatchRegionObserver
    extends SimpleRegionObserver {
        public static volatile boolean SLOW_MUTATE = false;

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws HBaseIOException {
            if ((miniBatchOp.size() == 100 || SLOW_MUTATE) && ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().getTable().getNameAsString().equals(dataTable)) {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class UpsertSelectRunner
    implements Callable<Boolean> {
        private final String dataTable;
        private final int minIndex;
        private final int maxIndex;
        private final int numLoop;

        public UpsertSelectRunner(String dataTable, int minIndex, int maxIndex, int numLoop) {
            this.dataTable = dataTable;
            this.minIndex = minIndex;
            this.maxIndex = maxIndex;
            this.numLoop = numLoop;
        }

        @Override
        public Boolean call() throws Exception {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            try (Connection myConn = DriverManager.getConnection(UpsertSelectOverlappingBatchesIT.getUrl(), props);){
                myConn.setAutoCommit(true);
                String time = String.valueOf(System.currentTimeMillis());
                String dml = "UPSERT INTO " + this.dataTable + " SELECT k, v1 || '" + time + "', v2 || '" + time + "' FROM " + this.dataTable + " WHERE k >= " + this.minIndex + " AND k < " + this.maxIndex;
                myConn.setAutoCommit(true);
                for (int j = 0; j < this.numLoop; ++j) {
                    myConn.createStatement().execute(dml);
                }
                Boolean bl = true;
                return bl;
            }
        }
    }

    private static class UpsertSelectLooper
    implements Runnable {
        private UpsertSelectRunner runner;

        public UpsertSelectLooper(UpsertSelectRunner runner) {
            this.runner = runner;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.runner.call();
                    }
                }
                catch (Exception e) {
                    if (ExceptionUtils.indexOfThrowable((Throwable)e, InterruptedException.class) != -1) {
                        LOGGER.info("Interrupted, exiting", (Throwable)e);
                        Thread.currentThread().interrupt();
                        return;
                    }
                    LOGGER.error("Hit exception while writing", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

