/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.SortMergeJoinPlan;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SortMergeJoinTest {
    private final long INIT_LATENCY = 10000L;

    @Test
    public void testOptimizeSemiJoinForSortMergeJoinBug5956() throws SQLException, InterruptedException {
        StatementContext statementContext = (StatementContext)Mockito.mock(StatementContext.class);
        PhoenixConnection phoenixConnection = (PhoenixConnection)Mockito.mock(PhoenixConnection.class);
        Mockito.when((Object)statementContext.getConnection()).thenReturn((Object)phoenixConnection);
        ConnectionQueryServices connectionQueryServices = (ConnectionQueryServices)Mockito.mock(ConnectionQueryServices.class);
        Mockito.when((Object)connectionQueryServices.getProps()).thenReturn((Object)ReadOnlyProps.EMPTY_PROPS);
        Mockito.when((Object)phoenixConnection.getQueryServices()).thenReturn((Object)connectionQueryServices);
        ArrayList expressions = new ArrayList();
        Pair lhsAndRhsJoinExpressions = Pair.newPair(expressions, expressions);
        Pair lhsAndRhsOrderByNodes = Pair.newPair(new ArrayList(), new ArrayList());
        JoinTableNode.JoinType joinType = JoinTableNode.JoinType.Semi;
        ResultIterator lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Tuple tuple = (Tuple)Mockito.mock(Tuple.class);
        Mockito.when((Object)lhsResultIterator.next()).thenReturn((Object)tuple);
        QueryPlan lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        QueryPlan rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        ResultIterator rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)rhsResultIterator.next()).thenReturn(null);
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        SortMergeJoinPlan sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        SortMergeJoinPlan.SemiAntiJoinIterator semiAntiJoinIterator = (SortMergeJoinPlan.SemiAntiJoinIterator)sortMergeJoinPlan.iterator();
        Tuple resultTuple = semiAntiJoinIterator.next();
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semiAntiJoinIterator.isEnd());
        joinType = JoinTableNode.JoinType.Semi;
        lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenReturn(null);
        lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        tuple = (Tuple)Mockito.mock(Tuple.class);
        Mockito.when((Object)rhsResultIterator.next()).thenReturn((Object)tuple);
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        semiAntiJoinIterator = (SortMergeJoinPlan.SemiAntiJoinIterator)sortMergeJoinPlan.iterator();
        resultTuple = semiAntiJoinIterator.next();
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semiAntiJoinIterator.isEnd());
        joinType = JoinTableNode.JoinType.Anti;
        lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenReturn(null);
        lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        tuple = (Tuple)Mockito.mock(Tuple.class);
        Mockito.when((Object)rhsResultIterator.next()).thenReturn((Object)tuple);
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        semiAntiJoinIterator = (SortMergeJoinPlan.SemiAntiJoinIterator)sortMergeJoinPlan.iterator();
        resultTuple = semiAntiJoinIterator.next();
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semiAntiJoinIterator.isEnd());
    }

    @Test
    public void testSortMergeFastReturnNullBug5793() throws SQLException, InterruptedException {
        StatementContext statementContext = (StatementContext)Mockito.mock(StatementContext.class);
        PhoenixConnection phoenixConnection = (PhoenixConnection)Mockito.mock(PhoenixConnection.class);
        Mockito.when((Object)statementContext.getConnection()).thenReturn((Object)phoenixConnection);
        ConnectionQueryServices connectionQueryServices = (ConnectionQueryServices)Mockito.mock(ConnectionQueryServices.class);
        Mockito.when((Object)connectionQueryServices.getProps()).thenReturn((Object)ReadOnlyProps.EMPTY_PROPS);
        Mockito.when((Object)phoenixConnection.getQueryServices()).thenReturn((Object)connectionQueryServices);
        ArrayList expressions = new ArrayList();
        Pair lhsAndRhsJoinExpressions = Pair.newPair(expressions, expressions);
        Pair lhsAndRhsOrderByNodes = Pair.newPair(new ArrayList(), new ArrayList());
        JoinTableNode.JoinType joinType = JoinTableNode.JoinType.Inner;
        ResultIterator lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenAnswer(this.longLatencyInit());
        QueryPlan lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        QueryPlan rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        ResultIterator rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)rhsResultIterator.next()).thenReturn(null);
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        SortMergeJoinPlan sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        SortMergeJoinPlan.BasicJoinIterator sortMergeJoinResultIterator = (SortMergeJoinPlan.BasicJoinIterator)sortMergeJoinPlan.iterator();
        long startTime = System.currentTimeMillis();
        Tuple resultTuple = sortMergeJoinResultIterator.next();
        long elapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sortMergeJoinResultIterator.isJoinResultNullBecauseOneSideNull());
        Assert.assertTrue((boolean)sortMergeJoinResultIterator.isInitialized());
        Assert.assertTrue((elapsed < 10000L ? 1 : 0) != 0);
        joinType = JoinTableNode.JoinType.Inner;
        lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenReturn(null);
        lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)rhsResultIterator.next()).thenAnswer(this.longLatencyInit());
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        sortMergeJoinResultIterator = (SortMergeJoinPlan.BasicJoinIterator)sortMergeJoinPlan.iterator();
        startTime = System.currentTimeMillis();
        resultTuple = sortMergeJoinResultIterator.next();
        elapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sortMergeJoinResultIterator.isJoinResultNullBecauseOneSideNull());
        Assert.assertTrue((boolean)sortMergeJoinResultIterator.isInitialized());
        Assert.assertTrue((elapsed < 10000L ? 1 : 0) != 0);
        joinType = JoinTableNode.JoinType.Left;
        lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenReturn(null);
        lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)rhsResultIterator.next()).thenAnswer(this.longLatencyInit());
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        sortMergeJoinResultIterator = (SortMergeJoinPlan.BasicJoinIterator)sortMergeJoinPlan.iterator();
        startTime = System.currentTimeMillis();
        resultTuple = sortMergeJoinResultIterator.next();
        elapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sortMergeJoinResultIterator.isJoinResultNullBecauseOneSideNull());
        Assert.assertTrue((boolean)sortMergeJoinResultIterator.isInitialized());
        Assert.assertTrue((elapsed < 10000L ? 1 : 0) != 0);
        joinType = JoinTableNode.JoinType.Full;
        lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenReturn(null);
        lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)rhsResultIterator.next()).thenReturn(null);
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        sortMergeJoinResultIterator = (SortMergeJoinPlan.BasicJoinIterator)sortMergeJoinPlan.iterator();
        startTime = System.currentTimeMillis();
        resultTuple = sortMergeJoinResultIterator.next();
        elapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((!sortMergeJoinResultIterator.isJoinResultNullBecauseOneSideNull() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sortMergeJoinResultIterator.isInitialized());
        Assert.assertTrue((elapsed < 10000L ? 1 : 0) != 0);
        joinType = JoinTableNode.JoinType.Semi;
        lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenReturn(null);
        lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)rhsResultIterator.next()).thenAnswer(this.longLatencyInit());
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        SortMergeJoinPlan.SemiAntiJoinIterator sortMergeJoinSemiAntiResultIterator = (SortMergeJoinPlan.SemiAntiJoinIterator)sortMergeJoinPlan.iterator();
        startTime = System.currentTimeMillis();
        resultTuple = sortMergeJoinSemiAntiResultIterator.next();
        elapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sortMergeJoinSemiAntiResultIterator.isJoinResultNullBecauseOneSideNull());
        Assert.assertTrue((boolean)sortMergeJoinSemiAntiResultIterator.isInitialized());
        Assert.assertTrue((elapsed < 10000L ? 1 : 0) != 0);
        joinType = JoinTableNode.JoinType.Semi;
        lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenAnswer(this.longLatencyInit());
        lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)rhsResultIterator.next()).thenReturn(null);
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        sortMergeJoinSemiAntiResultIterator = (SortMergeJoinPlan.SemiAntiJoinIterator)sortMergeJoinPlan.iterator();
        startTime = System.currentTimeMillis();
        resultTuple = sortMergeJoinSemiAntiResultIterator.next();
        elapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sortMergeJoinSemiAntiResultIterator.isJoinResultNullBecauseOneSideNull());
        Assert.assertTrue((boolean)sortMergeJoinSemiAntiResultIterator.isInitialized());
        Assert.assertTrue((elapsed < 10000L ? 1 : 0) != 0);
        joinType = JoinTableNode.JoinType.Anti;
        lhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)lhsResultIterator.next()).thenReturn(null);
        lhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        Mockito.when((Object)lhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)lhsResultIterator);
        rhsQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        rhsResultIterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)rhsResultIterator.next()).thenAnswer(this.longLatencyInit());
        Mockito.when((Object)rhsQueryPlan.iterator((ParallelScanGrouper)DefaultParallelScanGrouper.getInstance())).thenReturn((Object)rhsResultIterator);
        sortMergeJoinPlan = new SortMergeJoinPlan(statementContext, null, null, joinType, lhsQueryPlan, rhsQueryPlan, lhsAndRhsJoinExpressions, expressions, null, null, null, 0, true, lhsAndRhsOrderByNodes);
        sortMergeJoinSemiAntiResultIterator = (SortMergeJoinPlan.SemiAntiJoinIterator)sortMergeJoinPlan.iterator();
        startTime = System.currentTimeMillis();
        resultTuple = sortMergeJoinSemiAntiResultIterator.next();
        elapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((resultTuple == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sortMergeJoinSemiAntiResultIterator.isJoinResultNullBecauseOneSideNull());
        Assert.assertTrue((boolean)sortMergeJoinSemiAntiResultIterator.isInitialized());
        Assert.assertTrue((elapsed < 10000L ? 1 : 0) != 0);
    }

    private Answer<Tuple> longLatencyInit() {
        return new Answer<Tuple>(){

            public Tuple answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(10000L);
                Tuple tuple = (Tuple)Mockito.mock(Tuple.class);
                return tuple;
            }
        };
    }
}

