/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.transform;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.tasks.TransformMonitorTask;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.index.ImmutableIndexExtendedIT;
import org.apache.phoenix.end2end.index.SingleCellIndexIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.mapreduce.transform.TransformTool;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.Transform;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TransformToolIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformToolIT.class);
    private final String tableDDLOptions;

    @Parameterized.Parameters(name="mutable={0}")
    public static synchronized Collection<Object[]> data() {
        boolean[] Booleans;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        for (boolean mutable : Booleans = new boolean[]{true, false}) {
            list.add(new Object[]{mutable});
        }
        return list;
    }

    public TransformToolIT(boolean mutable) {
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES=NONE ");
        if (!mutable) {
            optionBuilder.append(", IMMUTABLE_ROWS=true ");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @BeforeClass
    public static synchronized void setup() throws Exception {
        TransformMonitorTask.disableTransformMonitorTask((boolean)true);
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        serverProps.put("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.index.rebuild_page_size_in_rows", Long.toString(8L));
        serverProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        serverProps.put("phoenix.transform.monitor.enabled", Boolean.FALSE.toString());
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.transform.monitor.enabled", Boolean.FALSE.toString());
        TransformToolIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void cleanup() {
        TransformMonitorTask.disableTransformMonitorTask((boolean)false);
    }

    private void createTableAndUpsertRows(Connection conn, String dataTableFullName, int numOfRows) throws SQLException {
        TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
    }

    public static void createTableAndUpsertRows(Connection conn, String dataTableFullName, int numOfRows, String tableOptions) throws SQLException {
        TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, "", tableOptions);
    }

    public static void createTableAndUpsertRows(Connection conn, String dataTableFullName, int numOfRows, String constantVal, String tableOptions) throws SQLException {
        String stmString1 = "CREATE TABLE IF NOT EXISTS " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER, DATA VARCHAR) " + tableOptions;
        conn.createStatement().execute(stmString1);
        TransformToolIT.upsertRows(conn, dataTableFullName, 1, numOfRows, constantVal);
        conn.commit();
    }

    public static void upsertRows(Connection conn, String dataTableFullName, int startIdx, int numOfRows) throws SQLException {
        TransformToolIT.upsertRows(conn, dataTableFullName, startIdx, numOfRows, "");
    }

    public static void upsertRows(Connection conn, String dataTableFullName, int startIdx, int numOfRows, String constantVal) throws SQLException {
        String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?, ?)", dataTableFullName);
        PreparedStatement stmt = conn.prepareStatement(upsertQuery);
        for (int i = startIdx; i < startIdx + numOfRows; ++i) {
            stmt.setInt(1, i);
            stmt.setString(2, "uname" + String.valueOf(i));
            stmt.setInt(3, 95050 + i);
            stmt.setString(4, constantVal);
            stmt.executeUpdate();
        }
    }

    @Test
    public void testTransformTable() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String newTableFullName = dataTableFullName + "_1";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 2;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            TransformToolIT.assertTransformStatusOrPartial(PTable.TransformStatus.PENDING_CUTOVER, record);
            Assert.assertEquals((long)TestUtil.getRowCount(conn, dataTableFullName), (long)TestUtil.getRowCount(conn, newTableFullName));
            String sql = "SELECT ID, NAME, ZIP FROM %s ";
            ResultSet rs1 = conn.createStatement().executeQuery(String.format(sql, dataTableFullName));
            ResultSet rs2 = conn.createStatement().executeQuery(String.format(sql, newTableFullName));
            for (int i = 0; i < numOfRows; ++i) {
                Assert.assertTrue((boolean)rs1.next());
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)rs1.getString(1), (Object)rs2.getString(1));
                Assert.assertEquals((Object)rs1.getString(2), (Object)rs2.getString(2));
                Assert.assertEquals((long)rs1.getInt(3), (long)rs2.getInt(3));
            }
            Assert.assertFalse((boolean)rs1.next());
            Assert.assertFalse((boolean)rs2.next());
        }
    }

    @Test
    public void testAbortTransform() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, 2, this.tableDDLOptions);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, true, false, false, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNull((Object)record);
        }
    }

    public static void pauseTableTransform(String schemaName, String dataTableName, Connection conn, String tableDDLOptions) throws Exception {
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, 2, tableDDLOptions);
        conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
        SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
        Assert.assertNotNull((Object)record);
        List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, true, false, false, false);
        TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
        record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
        Assert.assertEquals((Object)PTable.TransformStatus.PAUSED.name(), (Object)record.getTransformStatus());
    }

    @Test
    public void testPauseTransform() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            TransformToolIT.pauseTableTransform(schemaName, dataTableName, conn, this.tableDDLOptions);
        }
    }

    @Test
    public void testResumeTransform() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            TransformToolIT.pauseTableTransform(schemaName, dataTableName, conn, this.tableDDLOptions);
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, true, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            TransformToolIT.assertTransformStatusOrPartial(PTable.TransformStatus.PENDING_CUTOVER, record);
        }
    }

    @Test
    public void testSplitTable() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        TableName dataTN = TableName.valueOf((String)dataTableFullName);
        TableName newDataTN = TableName.valueOf((String)(dataTableFullName + "_1"));
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
             Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            conn.setAutoCommit(true);
            String dataDDL = "CREATE TABLE " + dataTableFullName + "(\nID VARCHAR NOT NULL PRIMARY KEY,\n\"info\".CAR_NUM VARCHAR(18) NULL,\n\"test\".CAR_NUM VARCHAR(18) NULL,\n\"info\".CAP_DATE VARCHAR NULL,\n\"info\".ORG_ID BIGINT NULL,\n\"info\".ORG_NAME VARCHAR(255) NULL\n) IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES = 0";
            conn.createStatement().execute(dataDDL);
            String[] idPrefixes = new String[]{"1", "2", "3", "4"};
            int numSplits = idPrefixes.length;
            int targetNumRegions = numSplits + 1;
            byte[][] splitPoints = new byte[numSplits][];
            for (String prefix : idPrefixes) {
                splitPoints[--numSplits] = Bytes.toBytes((String)prefix);
            }
            TableDescriptor dataTD = admin.getDescriptor(dataTN);
            admin.disableTable(dataTN);
            admin.deleteTable(dataTN);
            admin.createTable(dataTD, (byte[][])splitPoints);
            Assert.assertEquals((long)targetNumRegions, (long)admin.getRegions(dataTN).size());
            int idCounter = 1;
            try (PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + dataTableFullName + "(ID,\"info\".CAR_NUM,\"test\".CAR_NUM,CAP_DATE,ORG_ID,ORG_NAME) VALUES(?,?,?,'2021-01-01 00:00:00',11,'orgname1')");){
                for (String carNum : idPrefixes) {
                    for (int i = 0; i < 100; ++i) {
                        ps.setString(1, "" + idCounter++);
                        ps.setString(2, carNum + "_" + i);
                        ps.setString(3, "test-" + carNum + "_ " + i);
                        ps.addBatch();
                    }
                }
                ps.executeBatch();
                conn.commit();
            }
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            args.add("--autosplit=3");
            args.add("-op");
            args.add("/tmp/" + UUID.randomUUID().toString());
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, newDataTN.getNameAsString());
            Assert.assertEquals((long)targetNumRegions, (long)admin.getRegions(newDataTN).size());
            Assert.assertEquals((long)TestUtil.getRowCount(conn, dataTableFullName), (long)TestUtil.getRowCount(conn, dataTableFullName + "_1"));
        }
    }

    @Test
    public void testDataAfterTransformingMultiColFamilyTable() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        TableName dataTN = TableName.valueOf((String)dataTableFullName);
        TableName newDataTN = TableName.valueOf((String)(dataTableFullName + "_1"));
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
             Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            conn.setAutoCommit(true);
            String dataDDL = "CREATE TABLE " + dataTableFullName + "(\nID CHAR(5) NOT NULL PRIMARY KEY,\n\"info\".CAR_NUM VARCHAR(18) NULL,\n\"test\".CAR_NUM VARCHAR(18) NULL,\n\"info\".CAP_DATE VARCHAR NULL,\n\"info\".ORG_ID BIGINT NULL,\n\"test\".ORG_NAME VARCHAR(255) NULL\n) IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES=NONE ";
            conn.createStatement().execute(dataDDL);
            int idCounter = 1;
            try (PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + dataTableFullName + "(ID,\"info\".CAR_NUM,\"test\".CAR_NUM,CAP_DATE,ORG_ID,ORG_NAME) VALUES(?,?,?,'2021-01-01 00:00:00',11,'orgname1')");){
                for (int i = 0; i < 5; ++i) {
                    ps.setString(1, "" + idCounter++);
                    ps.setString(2, "info-" + i);
                    ps.setString(3, "test-" + i);
                    ps.addBatch();
                }
                ps.executeBatch();
                conn.commit();
            }
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, newDataTN.getNameAsString());
            Assert.assertEquals((long)TestUtil.getRowCount(conn, dataTableFullName), (long)TestUtil.getRowCount(conn, dataTableFullName + "_1"));
            String select = "SELECT ID,\"info\".CAR_NUM,\"test\".CAR_NUM,CAP_DATE,ORG_ID,ORG_NAME FROM ";
            ResultSet resultSetNew = conn.createStatement().executeQuery(select + newDataTN.getNameAsString());
            ResultSet resultSetOld = conn.createStatement().executeQuery(select + dataTableFullName);
            for (int i = 0; i < idCounter - 1; ++i) {
                Assert.assertTrue((boolean)resultSetNew.next());
                Assert.assertTrue((boolean)resultSetOld.next());
                Assert.assertEquals((Object)resultSetOld.getString(1), (Object)resultSetNew.getString(1));
                Assert.assertEquals((Object)resultSetOld.getString(2), (Object)resultSetNew.getString(2));
                Assert.assertEquals((Object)resultSetOld.getString(3), (Object)resultSetNew.getString(3));
                Assert.assertEquals((Object)resultSetOld.getString(4), (Object)resultSetNew.getString(4));
                Assert.assertEquals((Object)resultSetOld.getString(5), (Object)resultSetNew.getString(5));
                Assert.assertEquals((Object)resultSetOld.getString(6), (Object)resultSetNew.getString(6));
            }
            Assert.assertFalse((boolean)resultSetNew.next());
            Assert.assertFalse((boolean)resultSetOld.next());
        }
    }

    @Test
    public void testTransformIndex() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = "I_" + TransformToolIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 2;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (NAME) INCLUDE (ZIP)");
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, indexTableFullName);
            conn.createStatement().execute("ALTER INDEX " + indexTableName + " ON " + dataTableFullName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)indexTableName, (String)dataTableFullName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, indexTableName, null, null, null, false, false, false, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            record = Transform.getTransformRecord((String)schemaName, (String)indexTableName, (String)dataTableFullName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            TransformToolIT.assertTransformStatusOrPartial(PTable.TransformStatus.PENDING_CUTOVER, record);
            Assert.assertEquals((long)TestUtil.getRowCount(conn, indexTableFullName), (long)TestUtil.getRowCount(conn, indexTableFullName + "_1"));
            String sql = "SELECT \":ID\", \"0:NAME\", \"0:ZIP\" FROM %s ORDER BY \":ID\"";
            ResultSet rs1 = conn.createStatement().executeQuery(String.format(sql, indexTableFullName));
            ResultSet rs2 = conn.createStatement().executeQuery(String.format(sql, indexTableFullName + "_1"));
            for (int i = 0; i < numOfRows; ++i) {
                Assert.assertTrue((boolean)rs1.next());
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)rs1.getString(1), (Object)rs2.getString(1));
                Assert.assertEquals((Object)rs1.getString(2), (Object)rs2.getString(2));
                Assert.assertEquals((long)rs1.getInt(3), (long)rs2.getInt(3));
            }
            Assert.assertFalse((boolean)rs1.next());
            Assert.assertFalse((boolean)rs2.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformMutationReadRepair() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 0;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            IndexToolIT.upsertRow(stmt1, 1);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            IndexToolIT.upsertRow(stmt1, 2);
            Assert.assertEquals((long)1L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.UNVERIFIED_BYTES));
            Assert.assertEquals((long)1L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.VERIFIED_BYTES));
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            Transform.doCutover((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (SystemTransformRecord)record);
            Transform.updateTransformRecord((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (SystemTransformRecord)record, (PTable.TransformStatus)PTable.TransformStatus.COMPLETED);
            Assert.assertEquals((long)1L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.UNVERIFIED_BYTES));
            Assert.assertEquals((long)1L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.VERIFIED_BYTES));
            String select = "SELECT * FROM " + dataTableFullName;
            ResultSet rs = conn.createStatement().executeQuery(select);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.UNVERIFIED_BYTES));
            Assert.assertEquals((long)2L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.VERIFIED_BYTES));
        }
        finally {
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformIndexReadRepair() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = "IDX_" + TransformToolIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 0;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (NAME) INCLUDE (ZIP)");
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, indexTableFullName);
            conn.createStatement().execute("ALTER INDEX " + indexTableName + " ON " + dataTableFullName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)indexTableName, (String)dataTableFullName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            IndexToolIT.upsertRow(stmt1, 1);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            IndexToolIT.upsertRow(stmt1, 2);
            Assert.assertEquals((long)1L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.UNVERIFIED_BYTES));
            Assert.assertEquals((long)1L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.VERIFIED_BYTES));
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            Transform.doCutover((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (SystemTransformRecord)record);
            Assert.assertEquals((long)1L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.UNVERIFIED_BYTES));
            Assert.assertEquals((long)1L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.VERIFIED_BYTES));
            String select = "SELECT NAME, ZIP FROM " + dataTableFullName;
            ResultSet rs = conn.createStatement().executeQuery(select);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.UNVERIFIED_BYTES));
            Assert.assertEquals((long)2L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.VERIFIED_BYTES));
        }
        finally {
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformMutationFailureRepair() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String parentViewName = "VWP_" + TransformToolIT.generateUniqueName();
        String viewName = "VW_" + TransformToolIT.generateUniqueName();
        String viewIdxName = "VWIDX_" + TransformToolIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 0;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            String createParentViewSql = "CREATE VIEW " + parentViewName + " ( PARENT_VIEW_COL1 VARCHAR ) AS SELECT * FROM " + dataTableFullName;
            conn.createStatement().execute(createParentViewSql);
            String createViewSql = "CREATE VIEW " + viewName + " ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + parentViewName;
            conn.createStatement().execute(createViewSql);
            String createViewIdxSql = "CREATE INDEX " + viewIdxName + " ON " + viewName + " (VIEW_COL1) include (VIEW_COL2) ";
            conn.createStatement().execute(createViewIdxSql);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)true);
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", viewName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            try {
                IndexToolIT.upsertRow(stmt1, 1);
                Assert.fail((String)"Transform table upsert should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            IndexToolIT.upsertRow(stmt1, 2);
            IndexToolIT.upsertRow(stmt1, 3);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            try {
                IndexToolIT.upsertRow(stmt1, 4);
                Assert.fail((String)"Data table upsert should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                IndexToolIT.upsertRow(stmt1, 5);
                Assert.fail((String)"Data table upsert should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)4L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, true);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)dataTableFullName)), false));
            Assert.assertEquals((long)0L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.UNVERIFIED_BYTES));
            Assert.assertEquals((long)2L, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, record.getNewPhysicalTableName(), QueryConstants.VERIFIED_BYTES));
        }
        finally {
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        }
    }

    @Test
    public void testTransformFailedForTransactionalTable() throws Exception {
        this.testTransactionalTableCannotTransform("OMID");
    }

    private void testTransactionalTableCannotTransform(String provider) throws Exception {
        String tableOptions = this.tableDDLOptions + " ,TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + provider + "'";
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, tableOptions);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            try {
                conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_TRANSFORM_TRANSACTIONAL_TABLE.getErrorCode(), (long)ex.getErrorCode());
            }
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformVerify() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 2;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)true);
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            try {
                IndexToolIT.upsertRow(stmt1, numOfRows + 1);
                Assert.fail((String)"New table upsert should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)numOfRows, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            IndexToolIT.upsertRow(stmt1, ++numOfRows);
            IndexToolIT.upsertRow(stmt1, ++numOfRows);
            Assert.assertEquals((long)(numOfRows - 2), (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)numOfRows, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            try {
                IndexToolIT.upsertRow(stmt1, numOfRows + 1);
                Assert.fail((String)"Data table upsert should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)(numOfRows - 1), (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)numOfRows, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            args.add("-v");
            args.add(IndexTool.IndexVerifyType.ONLY.getValue());
            TransformTool transformTool = TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Assert.assertEquals((long)numOfRows, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)numOfRows, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)(numOfRows - 2), (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)2L, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)2L, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).getValue());
            args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            args.add("-v");
            args.add(IndexTool.IndexVerifyType.AFTER.getValue());
            transformTool = TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Assert.assertEquals((long)numOfRows, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)numOfRows, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)numOfRows, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)numOfRows, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            int numOfRows2 = 2;
            String dataTableName2 = TransformToolIT.generateUniqueName();
            String dataTableFullName2 = SchemaUtil.getTableName((String)schemaName, (String)dataTableName2);
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName2, numOfRows2, this.tableDDLOptions);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName2 + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            record = Transform.getTransformRecord((String)schemaName, (String)dataTableName2, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)numOfRows2, (long)TestUtil.getRowCount(conn, dataTableFullName2));
            args = TransformToolIT.getArgList(schemaName, dataTableName2, null, null, null, null, false, false, false, false, false);
            args.add("-v");
            args.add(IndexTool.IndexVerifyType.BEFORE.getValue());
            transformTool = TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Assert.assertEquals((long)numOfRows2, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)numOfRows2, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)numOfRows2, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)(numOfRows2 - 2), (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)numOfRows2, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).getValue());
        }
        finally {
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformVerify_shouldFixUnverified() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            int numOfRowsInNewTbl = 0;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)numOfRows, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            IndexToolIT.upsertRow(stmt1, ++numOfRows);
            ++numOfRowsInNewTbl;
            IndexToolIT.upsertRow(stmt1, ++numOfRows);
            ++numOfRowsInNewTbl;
            Assert.assertEquals((long)(numOfRows - 1), (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)numOfRows, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            try {
                ++numOfRowsInNewTbl;
                IndexToolIT.upsertRow(stmt1, numOfRows + 1);
                Assert.fail((String)"Data table upsert should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ++numOfRowsInNewTbl;
                IndexToolIT.upsertRow(stmt1, numOfRows + 2);
                Assert.fail((String)"Data table upsert should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)numOfRowsInNewTbl, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)numOfRows, (long)TestUtil.getRowCount(conn, dataTableFullName));
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, true);
            args.add("-v");
            args.add(IndexTool.IndexVerifyType.BEFORE.getValue());
            TransformTool transformTool = TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Assert.assertEquals((long)numOfRowsInNewTbl, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)2L, (long)transformTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT).getValue());
        }
        finally {
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        }
    }

    @Test
    public void testTransformVerify_VerifyOnlyShouldNotChangeTransformState() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = "IDX_" + TransformToolIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (NAME) INCLUDE (ZIP)");
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, indexTableFullName);
            conn.createStatement().execute("ALTER INDEX " + indexTableName + " ON " + dataTableFullName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)indexTableName, (String)dataTableFullName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, indexTableName, null, null, null, false, false, false, false, false);
            args.add("-v");
            args.add(IndexTool.IndexVerifyType.ONLY.getValue());
            TransformTool transformTool = TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Assert.assertEquals((Object)PTable.TransformStatus.CREATED.toString(), (Object)record.getTransformStatus());
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            args.add("-v");
            args.add(IndexTool.IndexVerifyType.ONLY.getValue());
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Assert.assertEquals((Object)PTable.TransformStatus.CREATED.toString(), (Object)record.getTransformStatus());
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
        }
    }

    @Test
    public void testTransformVerify_ForceCutover() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = "IDX_" + TransformToolIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            TransformToolIT.createTableAndUpsertRows((Connection)conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            SingleCellIndexIT.assertMetadata((Connection)conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (NAME) INCLUDE (ZIP)");
            SingleCellIndexIT.assertMetadata((Connection)conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, indexTableFullName);
            conn.createStatement().execute("ALTER INDEX " + indexTableName + " ON " + dataTableFullName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, indexTableName, null, null, null, false, false, false, false, false);
            args.add("-fco");
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)indexTableName, (String)dataTableFullName, null, (PhoenixConnection)((PhoenixConnection)conn.unwrap(PhoenixConnection.class)));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertTransformStatusOrPartial(PTable.TransformStatus.COMPLETED, record);
            PTable pOldIndexTable = conn.getTableNoCache(indexTableFullName);
            Assert.assertEquals((Object)SchemaUtil.getTableNameFromFullName((String)record.getNewPhysicalTableName()), (Object)pOldIndexTable.getPhysicalName(true).getString());
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            args.add("-fco");
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)((PhoenixConnection)conn.unwrap(PhoenixConnection.class)));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertTransformStatusOrPartial(PTable.TransformStatus.COMPLETED, record);
            PTable pOldTable = conn.getTableNoCache(dataTableFullName);
            Assert.assertEquals((Object)SchemaUtil.getTableNameFromFullName((String)record.getNewPhysicalTableName()), (Object)pOldTable.getPhysicalName(true).getString());
        }
    }

    @Test
    public void testTransformForGlobalViews() throws Exception {
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String view1Name = "VW1_" + TransformToolIT.generateUniqueName();
        String view2Name = "VW2_" + TransformToolIT.generateUniqueName();
        String upsertQuery = "UPSERT INTO %s VALUES(?, ?, ?, ?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 0;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            String createViewSql = "CREATE VIEW " + view1Name + " ( VIEW_COL11 INTEGER, VIEW_COL12 VARCHAR ) AS SELECT * FROM " + dataTableFullName + " where ID=1";
            conn.createStatement().execute(createViewSql);
            createViewSql = "CREATE VIEW " + view2Name + " ( VIEW_COL21 INTEGER, VIEW_COL22 VARCHAR ) AS SELECT * FROM " + dataTableFullName + " where ID=11";
            conn.createStatement().execute(createViewSql);
            PreparedStatement stmt1 = conn.prepareStatement(String.format(upsertQuery, view1Name));
            stmt1.setInt(1, 1);
            stmt1.setString(2, "uname1");
            stmt1.setInt(3, 95051);
            stmt1.setString(4, "");
            stmt1.setInt(5, 101);
            stmt1.setString(6, "viewCol12");
            stmt1.executeUpdate();
            conn.commit();
            stmt1 = conn.prepareStatement(String.format(upsertQuery, view2Name));
            stmt1.setInt(1, 11);
            stmt1.setString(2, "uname11");
            stmt1.setInt(3, 950511);
            stmt1.setString(4, "");
            stmt1.setInt(5, 111);
            stmt1.setString(6, "viewCol22");
            stmt1.executeUpdate();
            conn.commit();
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Transform.doCutover((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (SystemTransformRecord)record);
            Transform.updateTransformRecord((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (SystemTransformRecord)record, (PTable.TransformStatus)PTable.TransformStatus.COMPLETED);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                admin.disableTable(TableName.valueOf((String)dataTableFullName));
                admin.truncateTable(TableName.valueOf((String)dataTableFullName), true);
            }
            String sql = "SELECT VIEW_COL11, VIEW_COL12 FROM %s ";
            ResultSet rs1 = conn.createStatement().executeQuery(String.format(sql, view1Name));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)101L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"viewCol12", (Object)rs1.getString(2));
            sql = "SELECT VIEW_COL21, VIEW_COL22 FROM %s ";
            rs1 = conn.createStatement().executeQuery(String.format(sql, view2Name));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)111L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"viewCol22", (Object)rs1.getString(2));
        }
    }

    @Test
    public void testTransformForTenantViews() throws Exception {
        ResultSet rs1;
        String sql;
        PreparedStatement stmt1;
        String createViewSql;
        String schemaName = TransformToolIT.generateUniqueName();
        String dataTableName = TransformToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String view1Name = "VW1_" + TransformToolIT.generateUniqueName();
        String view2Name = "VW2_" + TransformToolIT.generateUniqueName();
        String upsertQuery = "UPSERT INTO %s VALUES(?, ?, ?, ?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);){
            conn.setAutoCommit(true);
            int numOfRows = 0;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, this.tableDDLOptions);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
        }
        try (Connection tenantConn1 = TransformToolIT.getTenantConnection("tenant1");){
            createViewSql = "CREATE VIEW " + view1Name + " ( VIEW_COL11 INTEGER, VIEW_COL12 VARCHAR ) AS SELECT * FROM " + dataTableFullName + " where ID=1";
            tenantConn1.createStatement().execute(createViewSql);
        }
        try (Connection tenantConn2 = TransformToolIT.getTenantConnection("tenant2");){
            createViewSql = "CREATE VIEW " + view2Name + " ( VIEW_COL21 INTEGER, VIEW_COL22 VARCHAR ) AS SELECT * FROM " + dataTableFullName + " where ID=11";
            tenantConn2.createStatement().execute(createViewSql);
        }
        tenantConn1 = TransformToolIT.getTenantConnection("tenant1");
        try {
            stmt1 = tenantConn1.prepareStatement(String.format(upsertQuery, view1Name));
            stmt1.setInt(1, 1);
            stmt1.setString(2, "uname1");
            stmt1.setInt(3, 95051);
            stmt1.setString(4, "");
            stmt1.setInt(5, 101);
            stmt1.setString(6, "viewCol12");
            stmt1.executeUpdate();
            tenantConn1.commit();
        }
        finally {
            if (tenantConn1 != null) {
                tenantConn1.close();
            }
        }
        tenantConn2 = TransformToolIT.getTenantConnection("tenant2");
        try {
            stmt1 = tenantConn2.prepareStatement(String.format(upsertQuery, view2Name));
            stmt1.setInt(1, 11);
            stmt1.setString(2, "uname11");
            stmt1.setInt(3, 950511);
            stmt1.setString(4, "");
            stmt1.setInt(5, 111);
            stmt1.setString(6, "viewCol22");
            stmt1.executeUpdate();
            tenantConn2.commit();
        }
        finally {
            if (tenantConn2 != null) {
                tenantConn2.close();
            }
        }
        conn = DriverManager.getConnection(TransformToolIT.getUrl(), props);
        try {
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformToolIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, false, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            Transform.doCutover((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (SystemTransformRecord)record);
            Transform.updateTransformRecord((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (SystemTransformRecord)record, (PTable.TransformStatus)PTable.TransformStatus.COMPLETED);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                admin.disableTable(TableName.valueOf((String)dataTableFullName));
                admin.truncateTable(TableName.valueOf((String)dataTableFullName), true);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        tenantConn1 = TransformToolIT.getTenantConnection("tenant1");
        try {
            sql = "SELECT VIEW_COL11, VIEW_COL12 FROM %s ";
            rs1 = tenantConn1.createStatement().executeQuery(String.format(sql, view1Name));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)101L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"viewCol12", (Object)rs1.getString(2));
        }
        finally {
            if (tenantConn1 != null) {
                tenantConn1.close();
            }
        }
        tenantConn2 = TransformToolIT.getTenantConnection("tenant2");
        try {
            sql = "SELECT VIEW_COL21, VIEW_COL22 FROM %s ";
            rs1 = tenantConn2.createStatement().executeQuery(String.format(sql, view2Name));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)111L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"viewCol22", (Object)rs1.getString(2));
        }
        finally {
            if (tenantConn2 != null) {
                tenantConn2.close();
            }
        }
    }

    public static Connection getTenantConnection(String tenant) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenant);
        return DriverManager.getConnection(TransformToolIT.getUrl(), props);
    }

    public static void assertTransformStatusOrPartial(PTable.TransformStatus expectedStatus, SystemTransformRecord systemTransformRecord) {
        if (systemTransformRecord.getTransformStatus().equals(expectedStatus.name())) {
            return;
        }
        Assert.assertEquals((Object)true, (Object)systemTransformRecord.getTransformType().toString().contains("PARTIAL"));
    }

    public static List<String> getArgList(String schemaName, String dataTable, String indxTable, String tenantId, Long startTime, Long endTime, boolean shouldAbort, boolean shouldPause, boolean shouldResume, boolean isPartial, boolean shouldFixUnverified) {
        ArrayList args = Lists.newArrayList();
        if (schemaName != null) {
            args.add("--schema=" + schemaName);
        }
        args.add("--data-table=" + dataTable);
        if (indxTable != null) {
            args.add("--index-table=" + indxTable);
        }
        args.add("-op");
        args.add("/tmp/" + UUID.randomUUID().toString());
        args.add("-runfg");
        if (tenantId != null) {
            args.add("-tenant");
            args.add(tenantId);
        }
        if (startTime != null) {
            args.add("-st");
            args.add(String.valueOf(startTime));
        }
        if (endTime != null) {
            args.add("-et");
            args.add(String.valueOf(endTime));
        }
        if (shouldAbort) {
            args.add("-abort");
        }
        if (shouldPause) {
            args.add("-pause");
        }
        if (shouldResume) {
            args.add("-resume");
        }
        if (isPartial) {
            args.add("-pt");
        }
        if (shouldFixUnverified) {
            args.add("-fu");
        }
        return args;
    }

    public static String[] getArgValues(String schemaName, String dataTable, String indexTable, String tenantId, Long startTime, Long endTime) {
        List<String> args = TransformToolIT.getArgList(schemaName, dataTable, indexTable, tenantId, startTime, endTime, false, false, false, false, false);
        args.add("-op");
        args.add("/tmp/" + UUID.randomUUID().toString());
        return args.toArray(new String[0]);
    }

    public static TransformTool runTransformTool(int expectedStatus, String schemaName, String dataTableName, String indexTableName, String tenantId, String ... additionalArgs) throws Exception {
        String[] cmdArgs = TransformToolIT.getArgValues(schemaName, dataTableName, indexTableName, tenantId, 0L, 0L);
        ArrayList<String> cmdArgList = new ArrayList<String>(Arrays.asList(cmdArgs));
        cmdArgList.add("-op");
        cmdArgList.add("/tmp/" + UUID.randomUUID().toString());
        cmdArgList.addAll(Arrays.asList(additionalArgs));
        return TransformToolIT.runTransformTool(cmdArgList.toArray(new String[cmdArgList.size()]), expectedStatus);
    }

    public static TransformTool runTransformTool(String[] cmdArgs, int expectedStatus) throws Exception {
        TransformTool tt = new TransformTool();
        Configuration conf = new Configuration(TransformToolIT.getUtility().getConfiguration());
        tt.setConf(conf);
        LOGGER.info("Running TransformTool with {}", (Object)Arrays.toString(cmdArgs), (Object)new Exception("Stack Trace"));
        int status = tt.run(cmdArgs);
        Assert.assertEquals((long)expectedStatus, (long)status);
        return tt;
    }
}

