/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.salted;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.SaltingUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsEnabledIT.class})
@RunWith(value=Parameterized.class)
public class SaltedTableWithParallelStatsEnabledIT
extends ParallelStatsEnabledIT {
    private final boolean withStatsForParallelization;
    private final boolean withFullTableScan;
    private final boolean withPointLookups;

    public SaltedTableWithParallelStatsEnabledIT(boolean withStatsForParallelization, boolean withFullTableScan, boolean withPointLookups) {
        this.withStatsForParallelization = withStatsForParallelization;
        this.withFullTableScan = withFullTableScan;
        this.withPointLookups = withPointLookups;
    }

    @Parameterized.Parameters(name="SaltedTableWithParallelStatsEnabledIT_withStatsForParallelization={0}, withFullTableScan={1}, withPointLookups={2}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({true, false, false}, {false, false, false}, {true, true, false}, {false, true, false}, {true, false, true}, {false, false, true});
    }

    @Test
    public void testPhoenix7580() throws Exception {
        String tableName = SaltedTableWithParallelStatsEnabledIT.generateUniqueName();
        int saltBucketCount = 5;
        int rowsToInsert = saltBucketCount * 10;
        String primaryKeyPrefix = "pk1_1";
        int[] pk2ValuesForPointLookups = IntStream.range(0, 15).toArray();
        int pointLookupsPerSaltBkt = pk2ValuesForPointLookups.length / saltBucketCount;
        String connProfile = "testRangeScanForPhoenix7580" + this.withStatsForParallelization;
        Properties props = new Properties();
        props.setProperty("phoenix.use.stats.parallelization", this.withStatsForParallelization ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        try (Connection conn = DriverManager.getConnection(SaltedTableWithParallelStatsEnabledIT.getUrl(connProfile), props);){
            this.createTable(conn, tableName, saltBucketCount);
            this.addRows(conn, tableName, primaryKeyPrefix, IntStream.range(0, rowsToInsert).toArray(), false);
            if (this.withFullTableScan) {
                this.assertFullScanRowCntFromHBaseAndPhoenix(conn, rowsToInsert, tableName);
            } else if (this.withPointLookups) {
                this.assertPointLookupsRowCntFromHBaseAndPhoenix(conn, pk2ValuesForPointLookups.length, tableName, saltBucketCount, primaryKeyPrefix, pk2ValuesForPointLookups, pointLookupsPerSaltBkt);
            } else {
                this.assertRangeScanRowCntFromHBaseAndPhoenix(conn, rowsToInsert, tableName, saltBucketCount, primaryKeyPrefix);
            }
            String primaryKeyPrefixForNewRows = "pk1_2";
            int[] pk2ValuesForNewRows = new int[]{1, 6, 10};
            this.triggerPhoenix7580(conn, tableName, saltBucketCount, primaryKeyPrefixForNewRows, pk2ValuesForNewRows);
            if (this.withFullTableScan) {
                this.assertFullScanRowCntFromHBaseAndPhoenix(conn, rowsToInsert + pk2ValuesForNewRows.length, tableName);
            } else if (this.withPointLookups) {
                this.assertPointLookupsRowCntFromHBaseAndPhoenix(conn, pk2ValuesForPointLookups.length, tableName, saltBucketCount, primaryKeyPrefix, pk2ValuesForPointLookups, pointLookupsPerSaltBkt);
            } else {
                this.assertRangeScanRowCntFromHBaseAndPhoenix(conn, rowsToInsert, tableName, saltBucketCount, primaryKeyPrefix);
            }
        }
    }

    private void assertRangeScanRowCntFromHBaseAndPhoenix(Connection conn, int expectedRowCount, String tableName, int saltBucketCount, String primaryKeyPrefix) throws Exception {
        Table hTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(tableName.getBytes());
        int rowCountFromHBase = 0;
        byte[] rowKeyPrefix = new byte[primaryKeyPrefix.length() + 1];
        System.arraycopy(Bytes.toBytes((String)primaryKeyPrefix), 0, rowKeyPrefix, 1, rowKeyPrefix.length - 1);
        for (int i = 0; i < saltBucketCount; ++i) {
            rowKeyPrefix[0] = (byte)i;
            Scan scan = new Scan();
            scan.setRowPrefixFilter(rowKeyPrefix);
            try (ResultScanner scanner = hTable.getScanner(scan);){
                while (scanner.next() != null) {
                    ++rowCountFromHBase;
                }
                continue;
            }
        }
        Assert.assertEquals((long)expectedRowCount, (long)rowCountFromHBase);
        String rangeScanDql = "SELECT COUNT(*) FROM " + tableName + " WHERE PK1=?";
        try (PreparedStatement stmt = conn.prepareStatement(rangeScanDql);){
            stmt.setString(1, primaryKeyPrefix);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int rowsVisible = rs.getInt(1);
            rs.close();
            Assert.assertEquals((long)expectedRowCount, (long)rowsVisible);
        }
    }

    private void assertFullScanRowCntFromHBaseAndPhoenix(Connection conn, int expectedRowCount, String tableName) throws Exception {
        Table hTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(tableName.getBytes());
        int rowCountFromHBase = 0;
        Scan scan = new Scan();
        try (ResultScanner scanner = hTable.getScanner(scan);){
            while (scanner.next() != null) {
                ++rowCountFromHBase;
            }
        }
        Assert.assertEquals((long)expectedRowCount, (long)rowCountFromHBase);
        String fullScanDql = "SELECT COUNT(*) FROM " + tableName;
        try (PreparedStatement stmt = conn.prepareStatement(fullScanDql);){
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int rowsVisible = rs.getInt(1);
            rs.close();
            Assert.assertEquals((long)expectedRowCount, (long)rowsVisible);
        }
    }

    private void assertPointLookupsRowCntFromHBaseAndPhoenix(Connection conn, int expectedRowCount, String tableName, int saltBucketCount, String firstPrimaryKey, int[] pk2Values, int rowsPerSaltBkt) throws Exception {
        String secondPrimaryKeyPrefix = "pk2_";
        String primaryKeyPrefix = firstPrimaryKey + secondPrimaryKeyPrefix;
        Table hTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(tableName.getBytes());
        int rowCountFromHBase = 0;
        byte[] rowKey = new byte[primaryKeyPrefix.length() + 3];
        System.arraycopy(Bytes.toBytes((String)primaryKeyPrefix), 0, rowKey, 1, rowKey.length - 3);
        for (int pk2Value : pk2Values) {
            byte[] rowKeySuffix = Bytes.toBytes((String)String.format("%02d", pk2Value));
            rowKey[rowKey.length - 2] = rowKeySuffix[0];
            rowKey[rowKey.length - 1] = rowKeySuffix[1];
            rowKey[0] = SaltingUtil.getSaltingByte((byte[])rowKey, (int)1, (int)(rowKey.length - 1), (int)saltBucketCount);
            Get get = new Get(rowKey);
            if (hTable.get(get).isEmpty()) continue;
            ++rowCountFromHBase;
        }
        Assert.assertEquals((long)expectedRowCount, (long)rowCountFromHBase);
        StringBuilder pointLookupDql = new StringBuilder("SELECT COUNT(*) FROM ");
        pointLookupDql.append(tableName);
        pointLookupDql.append(" WHERE PK1=? AND PK2 IN (?");
        for (int i = 1; i < pk2Values.length; ++i) {
            pointLookupDql.append(",?");
        }
        pointLookupDql.append(")");
        try (PreparedStatement stmt = conn.prepareStatement(pointLookupDql.toString());){
            stmt.setString(1, firstPrimaryKey);
            for (int i = 0; i < pk2Values.length; ++i) {
                stmt.setString(i + 2, String.format(secondPrimaryKeyPrefix + "%02d", i));
            }
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int rowsVisible = rs.getInt(1);
            rs.close();
            Assert.assertEquals((long)expectedRowCount, (long)rowsVisible);
        }
    }

    private void triggerPhoenix7580(Connection conn, String tableName, int saltBucketCount, String primaryKeyPrefixForNewRows, int[] pk2ValuesForNewRows) throws Exception {
        byte[] endKey;
        byte[] startKey;
        this.addRows(conn, tableName, primaryKeyPrefixForNewRows, pk2ValuesForNewRows, true);
        byte[] splitKey = null;
        byte[] rowKeyPrefix = new byte[primaryKeyPrefixForNewRows.length() + 1];
        System.arraycopy(Bytes.toBytes((String)primaryKeyPrefixForNewRows), 0, rowKeyPrefix, 1, rowKeyPrefix.length - 1);
        rowKeyPrefix[0] = (byte)(saltBucketCount - 2);
        byte[] expectedEndKeyPrefixAfterSplit = Bytes.copy((byte[])rowKeyPrefix);
        Table hTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(tableName.getBytes());
        Scan scan = new Scan();
        scan.setRowPrefixFilter(rowKeyPrefix);
        boolean pastFirstRow = false;
        try (ResultScanner scanner = hTable.getScanner(scan);){
            Result r;
            while ((r = scanner.next()) != null) {
                if (pastFirstRow) {
                    splitKey = r.getRow();
                    break;
                }
                pastFirstRow = true;
            }
        }
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        List regions = admin.getRegions(TableName.valueOf((String)tableName));
        RegionInfo secondLastSaltBucketRegion = null;
        for (RegionInfo regionInfo : regions) {
            startKey = regionInfo.getStartKey();
            endKey = regionInfo.getEndKey();
            if (startKey.length <= 0 || startKey[0] != saltBucketCount - 2 || endKey.length <= 0 || endKey[0] != saltBucketCount - 1) continue;
            secondLastSaltBucketRegion = regionInfo;
            break;
        }
        Assert.assertNotNull((String)"Not able to determine region of second last salt bucket", secondLastSaltBucketRegion);
        admin.splitRegionAsync(secondLastSaltBucketRegion.getEncodedNameAsBytes(), splitKey).get();
        regions = admin.getRegions(TableName.valueOf((String)tableName));
        for (RegionInfo regionInfo : regions) {
            startKey = regionInfo.getStartKey();
            endKey = regionInfo.getEndKey();
            if (startKey.length <= 0 || startKey[0] != saltBucketCount - 2) continue;
            Assert.assertTrue((Bytes.compareTo((byte[])expectedEndKeyPrefixAfterSplit, (byte[])endKey) < 0 ? 1 : 0) != 0);
            break;
        }
    }

    private void createTable(Connection conn, String tableName, int saltBucketCount) throws Exception {
        String createTableDdl = "CREATE TABLE IF NOT EXISTS " + tableName + " (\n    PK1 CHAR(5) NOT NULL,\n    PK2 CHAR(6) NOT NULL,\n    COL1 VARCHAR,\n    CONSTRAINT PK PRIMARY KEY (\n        PK1,\n        PK2 \n    )\n) SALT_BUCKETS=" + saltBucketCount;
        try (Statement stmt = conn.createStatement();){
            stmt.execute(createTableDdl);
        }
    }

    private void addRows(Connection conn, String tableName, String primaryKeyPrefix, int[] pk2Values, boolean skipUpdateStats) throws Exception {
        String upsertDml = "UPSERT INTO " + tableName + " VALUES (?,?,?)";
        try (PreparedStatement upsertStmt = conn.prepareStatement(upsertDml);){
            for (int i = 0; i < pk2Values.length; ++i) {
                upsertStmt.setString(1, primaryKeyPrefix);
                upsertStmt.setString(2, String.format("pk2_%02d", pk2Values[i]));
                upsertStmt.setString(3, "col1_" + i);
                upsertStmt.executeUpdate();
            }
            conn.commit();
        }
        if (!skipUpdateStats) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("UPDATE STATISTICS " + tableName);
            }
        }
    }
}

