/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.salted;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SaltedTableVarLengthRowKeyIT
extends ParallelStatsDisabledIT {
    private static final String TEST_TABLE = SaltedTableVarLengthRowKeyIT.generateUniqueName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTableValues() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SaltedTableVarLengthRowKeyIT.getUrl(), props);){
            SaltedTableVarLengthRowKeyIT.createTestTable(SaltedTableVarLengthRowKeyIT.getUrl(), "create table " + TEST_TABLE + "  (key_string varchar not null primary key, kv integer) SALT_BUCKETS=4\n");
            String query = "UPSERT INTO " + TEST_TABLE + " VALUES(?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "a");
            stmt.setInt(2, 1);
            stmt.execute();
            stmt.setString(1, "ab");
            stmt.setInt(2, 2);
            stmt.execute();
            stmt.setString(1, "abc");
            stmt.setInt(2, 3);
            stmt.execute();
            conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectValueWithPointKeyQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SaltedTableVarLengthRowKeyIT.getUrl(), props);){
            SaltedTableVarLengthRowKeyIT.initTableValues();
            String query = "SELECT * FROM " + TEST_TABLE + " where key_string = 'abc'";
            PreparedStatement stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSaltedVarbinaryUpperBoundQuery() throws Exception {
        String tableName = SaltedTableVarLengthRowKeyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " ( k VARBINARY PRIMARY KEY, a INTEGER ) SALT_BUCKETS = 3";
        String dml = "UPSERT INTO " + tableName + " values (?, ?)";
        String sql2 = "SELECT * FROM " + tableName + " WHERE k = ?";
        try (Connection conn = DriverManager.getConnection(SaltedTableVarLengthRowKeyIT.getUrl());){
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setInt(2, 1);
            stmt.setBytes(1, new byte[]{5});
            stmt.executeUpdate();
            stmt.setBytes(1, new byte[]{5, 0});
            stmt.executeUpdate();
            stmt.setBytes(1, new byte[]{5, 1});
            stmt.executeUpdate();
            stmt.close();
            conn.commit();
            stmt = conn.prepareStatement(sql2);
            stmt.setBytes(1, new byte[]{5});
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{5}, (byte[])rs.getBytes(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            stmt.close();
        }
    }

    @Test
    public void testSaltedArrayTypeUpperBoundQuery() throws Exception {
        String tableName = SaltedTableVarLengthRowKeyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " ( k TINYINT ARRAY[10] PRIMARY KEY, a INTEGER ) SALT_BUCKETS = 3";
        String dml = "UPSERT INTO " + tableName + " values (?, ?)";
        String sql2 = "SELECT * FROM " + tableName + " WHERE k = ?";
        try (Connection conn = DriverManager.getConnection(SaltedTableVarLengthRowKeyIT.getUrl());){
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setInt(2, 1);
            Object[] byteArray1 = ArrayUtils.toObject((byte[])new byte[]{5});
            Object[] byteArray2 = ArrayUtils.toObject((byte[])new byte[]{5, -128});
            Object[] byteArray3 = ArrayUtils.toObject((byte[])new byte[]{5, -127});
            Array array1 = conn.createArrayOf("TINYINT", byteArray1);
            Array array2 = conn.createArrayOf("TINYINT", byteArray2);
            Array array3 = conn.createArrayOf("TINYINT", byteArray3);
            stmt.setArray(1, array1);
            stmt.executeUpdate();
            stmt.setArray(1, array2);
            stmt.executeUpdate();
            stmt.setArray(1, array3);
            stmt.executeUpdate();
            stmt.close();
            conn.commit();
            stmt = conn.prepareStatement(sql2);
            stmt.setArray(1, array1);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            byte[] resultByteArray = (byte[])rs.getArray(1).getArray();
            Assert.assertArrayEquals((byte[])new byte[]{5}, (byte[])resultByteArray);
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            stmt.close();
        }
    }
}

