/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.salted;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SaltedTableUpsertSelectIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertIntoSaltedTableFromNormalTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SaltedTableUpsertSelectIT.getUrl(), props);){
            String source = SaltedTableUpsertSelectIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + source + " (pk VARCHAR NOT NULL PRIMARY KEY, col INTEGER)";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            String target = SaltedTableUpsertSelectIT.generateUniqueName();
            ddl = "CREATE TABLE IF NOT EXISTS " + target + " (pk VARCHAR NOT NULL PRIMARY KEY, col INTEGER) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            String query = "UPSERT INTO " + source + "(pk, col) VALUES(?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "1");
            stmt.setInt(2, 1);
            stmt.execute();
            conn.commit();
            query = "UPSERT INTO " + target + "(pk, col) SELECT pk, col from " + source;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + target;
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertIntoNormalTableFromSaltedTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SaltedTableUpsertSelectIT.getUrl(), props);){
            String source = SaltedTableUpsertSelectIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + source + " (pk VARCHAR NOT NULL PRIMARY KEY, col INTEGER) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            String target = SaltedTableUpsertSelectIT.generateUniqueName();
            ddl = "CREATE TABLE IF NOT EXISTS " + target + " (pk VARCHAR NOT NULL PRIMARY KEY, col INTEGER)";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            String query = "UPSERT INTO " + source + "(pk, col) VALUES(?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "1");
            stmt.setInt(2, 1);
            stmt.execute();
            conn.commit();
            query = "UPSERT INTO " + target + "(pk, col) SELECT pk, col from " + source;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            this.analyzeTable(conn, source);
            this.analyzeTable(conn, target);
            query = "SELECT * FROM " + target;
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void analyzeTable(Connection conn, String tableName) throws IOException, SQLException {
        String query = "UPDATE STATISTICS " + tableName;
        conn.createStatement().execute(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSaltedTableIntoSaltedTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SaltedTableUpsertSelectIT.getUrl(), props);){
            String source = SaltedTableUpsertSelectIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + source + " (pk VARCHAR NOT NULL PRIMARY KEY, col INTEGER) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            String target = SaltedTableUpsertSelectIT.generateUniqueName();
            ddl = "CREATE TABLE IF NOT EXISTS " + target + " (pk VARCHAR NOT NULL PRIMARY KEY, col INTEGER) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            String query = "UPSERT INTO " + source + "(pk, col) VALUES(?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "1");
            stmt.setInt(2, 1);
            stmt.execute();
            conn.commit();
            query = "UPSERT INTO " + target + "(pk, col) SELECT pk, col from " + source;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + target;
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSelectOnSameSaltedTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SaltedTableUpsertSelectIT.getUrl(), props);){
            String source = SaltedTableUpsertSelectIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + source + " (pk VARCHAR NOT NULL PRIMARY KEY, col1 INTEGER, col2 INTEGER) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            String query = "UPSERT INTO " + source + "(pk, col1) VALUES(?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "1");
            stmt.setInt(2, 1);
            stmt.execute();
            conn.commit();
            query = "UPSERT INTO " + source + "(pk, col2) SELECT pk, col1 from " + source;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            query = "SELECT col2 FROM " + source;
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSelectOnSameSaltedTableWithEmptyPKColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SaltedTableUpsertSelectIT.getUrl(), props);){
            String source1 = SaltedTableUpsertSelectIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + source1 + " (pk1 varchar NULL, pk2 varchar NULL, pk3 integer NOT NULL, col1 INTEGER CONSTRAINT pk PRIMARY KEY (pk1, pk2, pk3)) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            String query = "UPSERT INTO " + source1 + "(pk1, pk2, pk3, col1) VALUES(?,?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "1");
            stmt.setString(2, "2");
            stmt.setInt(3, 1);
            stmt.setInt(4, 1);
            stmt.execute();
            conn.commit();
            conn.setAutoCommit(true);
            query = "UPSERT INTO " + source1 + "(pk3, col1, pk1) SELECT pk3+1, col1+1, pk2 from " + source1;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            this.analyzeTable(conn, source1);
            query = "SELECT col1 FROM " + source1;
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSelectWithJoinOnSaltedTables() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SaltedTableUpsertSelectIT.getUrl(), props);){
            String source1 = SaltedTableUpsertSelectIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + source1 + " (pk1 varchar NULL, pk2 varchar NULL, pk3 integer NOT NULL, col1 INTEGER CONSTRAINT pk PRIMARY KEY (pk1, pk2, pk3)) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl);
            for (int i = 0; i < 1000; ++i) {
                String upsert = "UPSERT INTO " + source1 + "(pk1, pk2, pk3, col1) VALUES (?,?,?,?)";
                PreparedStatement stmt = conn.prepareStatement(upsert);
                stmt.setString(1, Integer.toString(i));
                stmt.setString(2, Integer.toString(i));
                stmt.setInt(3, i);
                stmt.setInt(4, i);
                stmt.execute();
            }
            conn.commit();
            String source2 = SaltedTableUpsertSelectIT.generateUniqueName();
            String ddl2 = "CREATE TABLE IF NOT EXISTS " + source2 + " (pk1 varchar NULL, pk2 varchar NULL, pk3 integer NOT NULL, col1 INTEGER CONSTRAINT pk PRIMARY KEY (pk1, pk2, pk3)) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl2);
            for (int i = 0; i < 1000; ++i) {
                String upsert = "UPSERT INTO " + source2 + "(pk1, pk2, pk3, col1) VALUES (?,?,?,?)";
                PreparedStatement stmt = conn.prepareStatement(upsert);
                stmt.setString(1, Integer.toString(i));
                stmt.setString(2, Integer.toString(i));
                stmt.setInt(3, i);
                stmt.setInt(4, i);
                stmt.execute();
            }
            conn.commit();
            String dest = SaltedTableUpsertSelectIT.generateUniqueName();
            String ddl3 = "CREATE TABLE IF NOT EXISTS " + dest + " (pk1 varchar NULL, pk2 varchar NULL, pk3 integer NOT NULL, col1 INTEGER CONSTRAINT pk PRIMARY KEY (pk1, pk2, pk3)) SALT_BUCKETS=4";
            SaltedTableUpsertSelectIT.createTestTable(SaltedTableUpsertSelectIT.getUrl(), ddl3);
            String query = "UPSERT INTO " + dest + "(pk1, pk2, pk3, col1) SELECT S1.pk1, S1.pk2, S2.pk3, S2.col1 FROM " + source1 + " AS S1 JOIN " + source2 + " AS S2 ON S1.pk1 = S2.pk1 AND S1.pk2 = S2.pk2 AND S1.pk3 = S2.pk3";
            conn.createStatement().execute(query);
            conn.commit();
            query = "SELECT COUNT(*) FROM " + dest;
            PreparedStatement stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1000L, (long)rs.getInt(1));
        }
    }
}

