/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.join;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.phoenix.end2end.join.BaseJoinIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class SortMergeJoinIT
extends BaseJoinIT {
    public SortMergeJoinIT(String[] indexDDL, String[] plans) {
        super(indexDDL, plans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S6");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInnerJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name, next value for " + this.seqName + " FROM " + tableName1 + " item INNER JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertEquals((long)1L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertEquals((long)2L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertEquals((long)3L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertEquals((long)4L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertEquals((long)5L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S6");
            Assert.assertEquals((long)6L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeftJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String[] query = new String[]{"SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name, next value for " + this.seqName + " FROM " + tableName1 + " item LEFT JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" ORDER BY \"item_id\"", "SELECT /*+ USE_SORT_MERGE_JOIN*/ " + tableName1 + ".\"item_id\", " + tableName1 + ".name, " + tableName2 + ".\"supplier_id\", " + tableName2 + ".name, next value for " + this.seqName + " FROM " + tableName1 + " LEFT JOIN " + tableName2 + " ON " + tableName1 + ".\"supplier_id\" = " + tableName2 + ".\"supplier_id\" ORDER BY \"item_id\"", "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", " + tableName1 + ".name, supp.\"supplier_id\", " + tableName2 + ".name, next value for " + this.seqName + " FROM " + tableName1 + " item LEFT JOIN " + tableName2 + " supp ON " + tableName1 + ".\"supplier_id\" = supp.\"supplier_id\" ORDER BY \"item_id\""};
        try {
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
                Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
                Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
                Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
                Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
                Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
                Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
                Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
                Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
                Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
                Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
                Assert.assertEquals((Object)rs.getString(3), (Object)"0000000006");
                Assert.assertEquals((Object)rs.getString(4), (Object)"S6");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"invalid001");
                Assert.assertEquals((Object)rs.getString(2), (Object)"INVALID-1");
                Assert.assertNull((Object)rs.getString(3));
                Assert.assertNull((Object)rs.getString(4));
                Assert.assertFalse((boolean)rs.next());
                rs.close();
                statement.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRightJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName2 + " supp RIGHT JOIN " + tableName1 + " item ON item.\"supplier_id\" = supp.\"supplier_id\" ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S6");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"invalid001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"INVALID-1");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInnerJoinWithPreFilters() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item INNER JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" AND supp.\"supplier_id\" BETWEEN '0000000001' AND '0000000005' ORDER BY \"item_id\"";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item INNER JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" AND (supp.\"supplier_id\" = '0000000001' OR supp.\"supplier_id\" = '0000000005') ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeftJoinWithPreFilters() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item LEFT JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" AND (supp.\"supplier_id\" = '0000000001' OR supp.\"supplier_id\" = '0000000005') ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"invalid001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"INVALID-1");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithPostFilters() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName2 + " supp RIGHT JOIN " + tableName1 + " item ON item.\"supplier_id\" = supp.\"supplier_id\" WHERE supp.\"supplier_id\" BETWEEN '0000000001' AND '0000000005' ORDER BY \"item_id\"";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item LEFT JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" WHERE supp.\"supplier_id\" = '0000000001' OR supp.\"supplier_id\" = '0000000005' ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStarJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName3 = this.getTableName(conn, "\"Join\".\"CustomerTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String[] query = new String[]{"SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", c.name, i.name iname, quantity, o.\"DATE\" FROM " + tableName4 + " o JOIN " + tableName3 + " c ON o.\"customer_id\" = c.\"customer_id\" JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" ORDER BY \"order_id\"", "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", c.name, i.name iname, quantity, o.\"DATE\" FROM " + tableName4 + " o, " + tableName3 + " c, " + tableName1 + " i WHERE o.\"item_id\" = i.\"item_id\" AND o.\"customer_id\" = c.\"customer_id\" ORDER BY \"order_id\"", "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", c.name, i.name iname, quantity, o.\"DATE\" FROM " + tableName4 + " o JOIN " + tableName3 + " c ON o.\"customer_id\" = c.\"customer_id\" JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" ORDER BY \"order_id\"", "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", c.name, i.name iname, quantity, o.\"DATE\" FROM (" + tableName4 + " o, " + tableName3 + " c), " + tableName1 + " i WHERE o.\"item_id\" = i.\"item_id\" AND o.\"customer_id\" = c.\"customer_id\" ORDER BY \"order_id\"", "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", c.name, i.name iname, quantity, o.\"DATE\" FROM " + tableName4 + " o, (" + tableName3 + " c, " + tableName1 + " i) WHERE o.\"item_id\" = i.\"item_id\" AND o.\"customer_id\" = c.\"customer_id\" ORDER BY \"order_id\""};
        try {
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
                Assert.assertEquals((Object)rs.getString("\"order_id\""), (Object)"000000000000001");
                Assert.assertEquals((Object)rs.getString(2), (Object)"C4");
                Assert.assertEquals((Object)rs.getString("C.name"), (Object)"C4");
                Assert.assertEquals((Object)rs.getString(3), (Object)"T1");
                Assert.assertEquals((Object)rs.getString("iName"), (Object)"T1");
                Assert.assertEquals((long)rs.getInt(4), (long)1000L);
                Assert.assertEquals((long)rs.getInt("Quantity"), (long)1000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
                Assert.assertEquals((Object)rs.getString(2), (Object)"C3");
                Assert.assertEquals((Object)rs.getString(3), (Object)"T6");
                Assert.assertEquals((long)rs.getInt(4), (long)2000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
                Assert.assertEquals((Object)rs.getString(2), (Object)"C2");
                Assert.assertEquals((Object)rs.getString(3), (Object)"T2");
                Assert.assertEquals((long)rs.getInt(4), (long)3000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
                Assert.assertEquals((Object)rs.getString(2), (Object)"C4");
                Assert.assertEquals((Object)rs.getString(3), (Object)"T6");
                Assert.assertEquals((long)rs.getInt(4), (long)4000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
                Assert.assertEquals((Object)rs.getString(2), (Object)"C5");
                Assert.assertEquals((Object)rs.getString(3), (Object)"T3");
                Assert.assertEquals((long)rs.getInt(4), (long)5000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertFalse((boolean)rs.next());
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeftJoinWithAggregation() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.name, sum(quantity) FROM " + tableName4 + " o LEFT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" GROUP BY i.name ORDER BY i.name";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.\"item_id\" iid, sum(quantity) q FROM " + tableName4 + " o LEFT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" GROUP BY i.\"item_id\" ORDER BY q DESC";
        String query3 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.\"item_id\" iid, sum(quantity) q FROM " + tableName1 + " i LEFT JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" GROUP BY i.\"item_id\" ORDER BY q DESC NULLS LAST, iid";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T1");
            Assert.assertEquals((long)rs.getInt(2), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T2");
            Assert.assertEquals((long)rs.getInt(2), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T3");
            Assert.assertEquals((long)rs.getInt(2), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(2), (long)6000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt("q"), (long)6000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000003");
            Assert.assertEquals((long)rs.getInt("q"), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000002");
            Assert.assertEquals((long)rs.getInt("q"), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000001");
            Assert.assertEquals((long)rs.getInt("q"), (long)1000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query3);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt("q"), (long)6000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000003");
            Assert.assertEquals((long)rs.getInt("q"), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000002");
            Assert.assertEquals((long)rs.getInt("q"), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000001");
            Assert.assertEquals((long)rs.getInt("q"), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000004");
            Assert.assertEquals((long)rs.getInt("q"), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000005");
            Assert.assertEquals((long)rs.getInt("q"), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"invalid001");
            Assert.assertEquals((long)rs.getInt("q"), (long)0L);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRightJoinWithAggregation() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.name, sum(quantity) FROM " + tableName4 + " o RIGHT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" GROUP BY i.name ORDER BY i.name";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.\"item_id\" iid, sum(quantity) q FROM " + tableName4 + " o RIGHT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" GROUP BY i.\"item_id\" ORDER BY q DESC NULLS LAST, iid";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"INVALID-1");
            Assert.assertEquals((long)rs.getInt(2), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T1");
            Assert.assertEquals((long)rs.getInt(2), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T2");
            Assert.assertEquals((long)rs.getInt(2), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T3");
            Assert.assertEquals((long)rs.getInt(2), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T4");
            Assert.assertEquals((long)rs.getInt(2), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T5");
            Assert.assertEquals((long)rs.getInt(2), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(2), (long)6000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt("q"), (long)6000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000003");
            Assert.assertEquals((long)rs.getInt("q"), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000002");
            Assert.assertEquals((long)rs.getInt("q"), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000001");
            Assert.assertEquals((long)rs.getInt("q"), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000004");
            Assert.assertEquals((long)rs.getInt("q"), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"0000000005");
            Assert.assertEquals((long)rs.getInt("q"), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("iid"), (Object)"invalid001");
            Assert.assertEquals((long)rs.getInt("q"), (long)0L);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeftRightJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName4 + " o LEFT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" RIGHT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\" ORDER BY \"order_id\", s.\"supplier_id\" DESC";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName4 + " o LEFT JOIN (" + tableName1 + " i RIGHT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\") ON o.\"item_id\" = i.\"item_id\" ORDER BY \"order_id\", s.\"supplier_id\" DESC";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S5");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S4");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S3");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)2000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)2000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRightLeftJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName1 + " i RIGHT JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" LEFT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\" ORDER BY \"order_id\"";
        String query2 = "SELECT \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName4 + " o RIGHT JOIN (" + tableName1 + " i LEFT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\") ON o.\"item_id\" = i.\"item_id\" ORDER BY \"order_id\", s.\"supplier_id\" DESC";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)2000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString(2), (Object)"INVALID-1");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S5");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)2000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiLeftJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String[] queries = new String[]{"SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName4 + " o LEFT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" LEFT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\" ORDER BY \"order_id\"", "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName4 + " o LEFT JOIN (" + tableName1 + " i LEFT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\") ON o.\"item_id\" = i.\"item_id\" ORDER BY \"order_id\""};
        try {
            for (String query : queries) {
                PreparedStatement statement = conn.prepareStatement(query);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
                Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
                Assert.assertEquals((long)rs.getInt(4), (long)1000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
                Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
                Assert.assertEquals((long)rs.getInt(4), (long)2000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
                Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
                Assert.assertEquals((long)rs.getInt(4), (long)3000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
                Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
                Assert.assertEquals((long)rs.getInt(4), (long)4000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
                Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
                Assert.assertEquals((long)rs.getInt(4), (long)5000L);
                Assert.assertNotNull((Object)rs.getDate(5));
                Assert.assertFalse((boolean)rs.next());
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiRightJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName4 + " o RIGHT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" RIGHT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\" ORDER BY \"order_id\", s.\"supplier_id\" DESC";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S5");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S4");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S3");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)2000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiRightJoin_SmallChunkSize() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.query.scanResultChunkSize", "1");
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName4 + " o RIGHT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" RIGHT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\" ORDER BY \"order_id\", s.\"supplier_id\" DESC";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S5");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S4");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S3");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)0L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)2000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithWildcard() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ * FROM " + tableName1 + " LEFT JOIN " + tableName2 + " supp ON " + tableName1 + ".\"supplier_id\" = supp.\"supplier_id\" ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".item_id"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".NAME"), (Object)"T1");
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".PRICE"), (long)100L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT1"), (long)5L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT2"), (long)10L);
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".supplier_id"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DESCRIPTION"), (Object)"Item T1");
            Assert.assertEquals((Object)rs.getString("SUPP.supplier_id"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString("supp.name"), (Object)"S1");
            Assert.assertEquals((Object)rs.getString("supp.phone"), (Object)"888-888-1111");
            Assert.assertEquals((Object)rs.getString("supp.address"), (Object)"101 YYY Street");
            Assert.assertEquals((Object)rs.getString("supp.loc_id"), (Object)"10001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".item_id"), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".NAME"), (Object)"T2");
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".PRICE"), (long)200L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT1"), (long)5L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT2"), (long)8L);
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".supplier_id"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DESCRIPTION"), (Object)"Item T2");
            Assert.assertEquals((Object)rs.getString("SUPP.supplier_id"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString("supp.name"), (Object)"S1");
            Assert.assertEquals((Object)rs.getString("supp.phone"), (Object)"888-888-1111");
            Assert.assertEquals((Object)rs.getString("supp.address"), (Object)"101 YYY Street");
            Assert.assertEquals((Object)rs.getString("supp.loc_id"), (Object)"10001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".item_id"), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".NAME"), (Object)"T3");
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".PRICE"), (long)300L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT1"), (long)8L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT2"), (long)12L);
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".supplier_id"), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DESCRIPTION"), (Object)"Item T3");
            Assert.assertEquals((Object)rs.getString("SUPP.supplier_id"), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString("supp.name"), (Object)"S2");
            Assert.assertEquals((Object)rs.getString("supp.phone"), (Object)"888-888-2222");
            Assert.assertEquals((Object)rs.getString("supp.address"), (Object)"202 YYY Street");
            Assert.assertEquals((Object)rs.getString("supp.loc_id"), (Object)"10002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".item_id"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".NAME"), (Object)"T4");
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".PRICE"), (long)400L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT1"), (long)6L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT2"), (long)10L);
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".supplier_id"), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DESCRIPTION"), (Object)"Item T4");
            Assert.assertEquals((Object)rs.getString("SUPP.supplier_id"), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString("supp.name"), (Object)"S2");
            Assert.assertEquals((Object)rs.getString("supp.phone"), (Object)"888-888-2222");
            Assert.assertEquals((Object)rs.getString("supp.address"), (Object)"202 YYY Street");
            Assert.assertEquals((Object)rs.getString("supp.loc_id"), (Object)"10002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".item_id"), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".NAME"), (Object)"T5");
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".PRICE"), (long)500L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT1"), (long)8L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT2"), (long)15L);
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".supplier_id"), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DESCRIPTION"), (Object)"Item T5");
            Assert.assertEquals((Object)rs.getString("SUPP.supplier_id"), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString("supp.name"), (Object)"S5");
            Assert.assertEquals((Object)rs.getString("supp.phone"), (Object)"888-888-5555");
            Assert.assertEquals((Object)rs.getString("supp.address"), (Object)"505 YYY Street");
            Assert.assertEquals((Object)rs.getString("supp.loc_id"), (Object)"10005");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".item_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".NAME"), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".PRICE"), (long)600L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT1"), (long)8L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT2"), (long)15L);
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".supplier_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DESCRIPTION"), (Object)"Item T6");
            Assert.assertEquals((Object)rs.getString("SUPP.supplier_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("supp.name"), (Object)"S6");
            Assert.assertEquals((Object)rs.getString("supp.phone"), (Object)"888-888-6666");
            Assert.assertEquals((Object)rs.getString("supp.address"), (Object)"606 YYY Street");
            Assert.assertEquals((Object)rs.getString("supp.loc_id"), (Object)"10006");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".item_id"), (Object)"invalid001");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".NAME"), (Object)"INVALID-1");
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".PRICE"), (long)0L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT1"), (long)0L);
            Assert.assertEquals((long)rs.getInt(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DISCOUNT2"), (long)0L);
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".supplier_id"), (Object)"0000000000");
            Assert.assertEquals((Object)rs.getString(this.getDisplayTableName(conn, "\"Join\".\"ItemTable\"") + ".DESCRIPTION"), (Object)"Invalid item for join test");
            Assert.assertNull((Object)rs.getString("SUPP.supplier_id"));
            Assert.assertNull((Object)rs.getString("supp.name"));
            Assert.assertNull((Object)rs.getString("supp.phone"));
            Assert.assertNull((Object)rs.getString("supp.address"));
            Assert.assertNull((Object)rs.getString("supp.loc_id"));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithTableWildcard() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ s.*, " + tableName1 + ".*, \"order_id\" FROM " + tableName4 + " o RIGHT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" RIGHT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\" ORDER BY \"order_id\", s.\"supplier_id\" DESC";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            ResultSetMetaData md = rs.getMetaData();
            Assert.assertEquals((long)md.getColumnCount(), (long)13L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-5555");
            Assert.assertEquals((Object)rs.getString(4), (Object)"505 YYY Street");
            Assert.assertEquals((Object)rs.getString(5), (Object)"10005");
            Assert.assertEquals((Object)rs.getString(6), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(7), (Object)"T5");
            Assert.assertEquals((long)rs.getInt(8), (long)500L);
            Assert.assertEquals((long)rs.getInt(9), (long)8L);
            Assert.assertEquals((long)rs.getInt(10), (long)15L);
            Assert.assertEquals((Object)rs.getString(11), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(12), (Object)"Item T5");
            Assert.assertNull((Object)rs.getString(13));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-4444");
            Assert.assertEquals((Object)rs.getString(4), (Object)"404 YYY Street");
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertNull((Object)rs.getString(6));
            Assert.assertNull((Object)rs.getString(7));
            Assert.assertEquals((long)rs.getInt(8), (long)0L);
            Assert.assertEquals((long)rs.getInt(9), (long)0L);
            Assert.assertEquals((long)rs.getInt(10), (long)0L);
            Assert.assertNull((Object)rs.getString(11));
            Assert.assertNull((Object)rs.getString(12));
            Assert.assertNull((Object)rs.getString(13));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-3333");
            Assert.assertEquals((Object)rs.getString(4), (Object)"303 YYY Street");
            Assert.assertNull((Object)rs.getString(5));
            Assert.assertNull((Object)rs.getString(6));
            Assert.assertNull((Object)rs.getString(7));
            Assert.assertEquals((long)rs.getInt(8), (long)0L);
            Assert.assertEquals((long)rs.getInt(9), (long)0L);
            Assert.assertEquals((long)rs.getInt(10), (long)0L);
            Assert.assertNull((Object)rs.getString(11));
            Assert.assertNull((Object)rs.getString(12));
            Assert.assertNull((Object)rs.getString(13));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-2222");
            Assert.assertEquals((Object)rs.getString(4), (Object)"202 YYY Street");
            Assert.assertEquals((Object)rs.getString(5), (Object)"10002");
            Assert.assertEquals((Object)rs.getString(6), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(7), (Object)"T4");
            Assert.assertEquals((long)rs.getInt(8), (long)400L);
            Assert.assertEquals((long)rs.getInt(9), (long)6L);
            Assert.assertEquals((long)rs.getInt(10), (long)10L);
            Assert.assertEquals((Object)rs.getString(11), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(12), (Object)"Item T4");
            Assert.assertNull((Object)rs.getString(13));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-1111");
            Assert.assertEquals((Object)rs.getString(4), (Object)"101 YYY Street");
            Assert.assertEquals((Object)rs.getString(5), (Object)"10001");
            Assert.assertEquals((Object)rs.getString(6), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(7), (Object)"T1");
            Assert.assertEquals((long)rs.getInt(8), (long)100L);
            Assert.assertEquals((long)rs.getInt(9), (long)5L);
            Assert.assertEquals((long)rs.getInt(10), (long)10L);
            Assert.assertEquals((Object)rs.getString(11), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(12), (Object)"Item T1");
            Assert.assertEquals((Object)rs.getString(13), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-6666");
            Assert.assertEquals((Object)rs.getString(4), (Object)"606 YYY Street");
            Assert.assertEquals((Object)rs.getString(5), (Object)"10006");
            Assert.assertEquals((Object)rs.getString(6), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(7), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(8), (long)600L);
            Assert.assertEquals((long)rs.getInt(9), (long)8L);
            Assert.assertEquals((long)rs.getInt(10), (long)15L);
            Assert.assertEquals((Object)rs.getString(11), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(12), (Object)"Item T6");
            Assert.assertEquals((Object)rs.getString(13), (Object)"000000000000002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-1111");
            Assert.assertEquals((Object)rs.getString(4), (Object)"101 YYY Street");
            Assert.assertEquals((Object)rs.getString(5), (Object)"10001");
            Assert.assertEquals((Object)rs.getString(6), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(7), (Object)"T2");
            Assert.assertEquals((long)rs.getInt(8), (long)200L);
            Assert.assertEquals((long)rs.getInt(9), (long)5L);
            Assert.assertEquals((long)rs.getInt(10), (long)8L);
            Assert.assertEquals((Object)rs.getString(11), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(12), (Object)"Item T2");
            Assert.assertEquals((Object)rs.getString(13), (Object)"000000000000003");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-6666");
            Assert.assertEquals((Object)rs.getString(4), (Object)"606 YYY Street");
            Assert.assertEquals((Object)rs.getString(5), (Object)"10006");
            Assert.assertEquals((Object)rs.getString(6), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(7), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(8), (long)600L);
            Assert.assertEquals((long)rs.getInt(9), (long)8L);
            Assert.assertEquals((long)rs.getInt(10), (long)15L);
            Assert.assertEquals((Object)rs.getString(11), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(12), (Object)"Item T6");
            Assert.assertEquals((Object)rs.getString(13), (Object)"000000000000004");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"888-888-2222");
            Assert.assertEquals((Object)rs.getString(4), (Object)"202 YYY Street");
            Assert.assertEquals((Object)rs.getString(5), (Object)"10002");
            Assert.assertEquals((Object)rs.getString(6), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(7), (Object)"T3");
            Assert.assertEquals((long)rs.getInt(8), (long)300L);
            Assert.assertEquals((long)rs.getInt(9), (long)8L);
            Assert.assertEquals((long)rs.getInt(10), (long)12L);
            Assert.assertEquals((Object)rs.getString(11), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(12), (Object)"Item T3");
            Assert.assertEquals((Object)rs.getString(13), (Object)"000000000000005");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinMultiJoinKeys() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName3 = this.getTableName(conn, "\"Join\".\"CustomerTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ c.name, s.name FROM " + tableName3 + " c LEFT JOIN " + tableName2 + " s ON \"customer_id\" = \"supplier_id\" AND c.loc_id = s.loc_id AND substr(s.name, 2, 1) = substr(c.name, 2, 1) ORDER BY \"customer_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C1");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C2");
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C3");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C4");
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C5");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S5");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C6");
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithDifferentNumericJoinKeyTypes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, i.price, discount2, quantity FROM " + tableName4 + " o INNER JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" AND o.price = (i.price * (100 - discount2)) / 100.0 WHERE quantity < 5000";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(3), (long)600L);
            Assert.assertEquals((long)rs.getInt(4), (long)15L);
            Assert.assertEquals((long)rs.getInt(5), (long)4000L);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithDifferentDateJoinKeyTypes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName3 = this.getTableName(conn, "\"Join\".\"CustomerTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", c.name, o.\"DATE\" FROM " + tableName4 + " o INNER JOIN " + tableName3 + " c ON o.\"customer_id\" = c.\"customer_id\" AND o.\"DATE\" = c.\"DATE\" ORDER BY \"order_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"C4");
            Assert.assertEquals((Object)rs.getTimestamp(3), (Object)new Timestamp(this.format.parse("2013-11-22 14:22:56").getTime()));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"C3");
            Assert.assertEquals((Object)rs.getTimestamp(3), (Object)new Timestamp(this.format.parse("2013-11-25 10:06:29").getTime()));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"C2");
            Assert.assertEquals((Object)rs.getTimestamp(3), (Object)new Timestamp(this.format.parse("2013-11-25 16:45:07").getTime()));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"C5");
            Assert.assertEquals((Object)rs.getTimestamp(3), (Object)new Timestamp(this.format.parse("2013-11-27 09:37:50").getTime()));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithIncomparableJoinKeyTypes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, i.price, discount2, quantity FROM " + tableName4 + " o INNER JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" AND o.price / 100 = substr(i.name, 2, 1)";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            statement.executeQuery();
            Assert.fail((String)"Should have got SQLException.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinPlanWithIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item LEFT JOIN " + tableName2 + " supp ON substr(item.name, 2, 1) = substr(supp.name, 2, 1) AND (supp.name BETWEEN 'S1' AND 'S5') WHERE item.name BETWEEN 'T1' AND 'T5' ORDER BY \"item_id\"";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item INNER JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" WHERE (item.name = 'T1' OR item.name = 'T5') AND (supp.name = 'S1' OR supp.name = 'S5') ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithSkipMergeOptimization() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ s.name FROM " + tableName1 + " i JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" AND quantity < 5000 RIGHT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"S3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"S4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"S5");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"S6");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"S6");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            this.assertPlansEqual(this.plans[0], QueryUtil.getExplainPlan((ResultSet)rs));
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i2.\"item_id\", i1.name FROM " + tableName1 + " i1 JOIN " + tableName1 + " i2 ON i1.\"item_id\" = i2.\"item_id\" ORDER BY i1.\"item_id\"";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i1.name, i2.name FROM " + tableName1 + " i1 JOIN " + tableName1 + " i2 ON i1.\"item_id\" = i2.\"supplier_id\" ORDER BY i1.name, i2.name";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"invalid001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"INVALID-1");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query1);
            this.assertPlansEqual(this.plans[2], QueryUtil.getExplainPlan((ResultSet)rs));
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertWithJoin() throws Exception {
        String tempTable = SortMergeJoinIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        conn.setAutoCommit(true);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        try {
            conn.createStatement().execute("CREATE TABLE " + tempTable + "   (\"order_id\" varchar not null,     item_name varchar not null,     supplier_name varchar,     quantity integer,     \"DATE\" timestamp     CONSTRAINT pk PRIMARY KEY (\"order_id\", item_name))");
            conn.createStatement().execute("UPSERT /*+ USE_SORT_MERGE_JOIN*/ INTO " + tempTable + "(\"order_id\", item_name, supplier_name, quantity, \"DATE\") SELECT \"order_id\", i.name, s.name, quantity, \"DATE\" FROM " + tableName4 + " o LEFT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" LEFT JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\"");
            conn.createStatement().execute("UPSERT /*+ USE_SORT_MERGE_JOIN*/ INTO " + tempTable + "(\"order_id\", item_name, quantity) SELECT 'ORDER_SUM', i.name, sum(quantity) FROM " + tableName4 + " o LEFT JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" GROUP BY i.name ORDER BY i.name");
            String query = "SELECT * FROM " + tempTable;
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)2000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertNotNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"ORDER_SUM");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"ORDER_SUM");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"ORDER_SUM");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"ORDER_SUM");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((long)rs.getInt(4), (long)6000L);
            Assert.assertNull((Object)rs.getDate(5));
            Assert.assertFalse((boolean)rs.next());
            String sourceTable = SortMergeJoinIT.generateUniqueName();
            String joinTable = SortMergeJoinIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + sourceTable + "   (TID CHAR(3) NOT NULL,     A UNSIGNED_INT NOT NULL,     B UNSIGNED_INT NOT NULL     CONSTRAINT pk PRIMARY KEY (TID, A, B))");
            conn.createStatement().execute("CREATE TABLE " + joinTable + "   (TID CHAR(3) NOT NULL,     A UNSIGNED_INT NOT NULL,     B UNSIGNED_INT NOT NULL,     COUNT UNSIGNED_INT     CONSTRAINT pk PRIMARY KEY (TID, A, B))");
            PreparedStatement upsertStmt = conn.prepareStatement("upsert into " + sourceTable + "(TID, A, B) values (?, ?, ?)");
            upsertStmt.setString(1, "1");
            upsertStmt.setInt(2, 1);
            upsertStmt.setInt(3, 1);
            upsertStmt.execute();
            upsertStmt.setString(1, "1");
            upsertStmt.setInt(2, 1);
            upsertStmt.setInt(3, 2);
            upsertStmt.execute();
            upsertStmt.setString(1, "1");
            upsertStmt.setInt(2, 1);
            upsertStmt.setInt(3, 3);
            upsertStmt.execute();
            upsertStmt.setString(1, "1");
            upsertStmt.setInt(2, 2);
            upsertStmt.setInt(3, 1);
            upsertStmt.execute();
            upsertStmt.setString(1, "1");
            upsertStmt.setInt(2, 2);
            upsertStmt.setInt(3, 2);
            upsertStmt.execute();
            conn.commit();
            upsertStmt = conn.prepareStatement("upsert /*+ USE_SORT_MERGE_JOIN*/ into " + joinTable + "(TID, A, B, COUNT) SELECT t1.TID, t1.A, t2.A, COUNT(*) FROM " + sourceTable + " t1 INNER JOIN " + sourceTable + " t2 ON t1.B = t2.B WHERE t1.A != t2.A AND t1.TID = '1' AND t2.TID = '1' GROUP BY t1.TID, t1.A, t2.A");
            upsertStmt.execute();
            conn.commit();
            rs = statement.executeQuery("SELECT * FROM " + joinTable);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"1");
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((long)rs.getInt(3), (long)2L);
            Assert.assertEquals((long)rs.getInt(4), (long)2L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"1");
            Assert.assertEquals((long)rs.getInt(2), (long)2L);
            Assert.assertEquals((long)rs.getInt(3), (long)1L);
            Assert.assertEquals((long)rs.getInt(4), (long)2L);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName3 = this.getTableName(conn, "\"Join\".\"CustomerTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.name, count(c.name), min(s.name), max(quantity) FROM " + tableName4 + " o LEFT JOIN (" + tableName2 + " s RIGHT JOIN " + tableName1 + " i ON i.\"supplier_id\" = s.\"supplier_id\") ON o.\"item_id\" = i.\"item_id\" LEFT JOIN " + tableName3 + " c ON c.\"customer_id\" = o.\"customer_id\" GROUP BY i.name ORDER BY i.name";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ * FROM " + tableName3 + " c INNER JOIN (" + tableName4 + " o INNER JOIN (" + tableName2 + " s RIGHT JOIN " + tableName1 + " i ON i.\"supplier_id\" = s.\"supplier_id\") ON o.\"item_id\" = i.\"item_id\") ON c.\"customer_id\" = o.\"customer_id\" WHERE c.\"customer_id\" <= '0000000005' AND \"order_id\" != '000000000000003' AND i.name != 'T3' ORDER BY c.\"customer_id\", i.name";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T1");
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T2");
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T3");
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(2), (long)2L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("C.customer_id"), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString("c.name"), (Object)"C3");
            Assert.assertEquals((Object)rs.getString("c.phone"), (Object)"999-999-3333");
            Assert.assertEquals((Object)rs.getString("c.address"), (Object)"303 XXX Street");
            Assert.assertNull((Object)rs.getString("c.loc_id"));
            Assert.assertEquals((Object)rs.getDate("c.date"), (Object)new Date(this.format.parse("2013-11-25 10:06:29").getTime()));
            Assert.assertEquals((Object)rs.getString("O.order_id"), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString("O.customer_id"), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString("O.item_id"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt("o.price"), (long)552L);
            Assert.assertEquals((long)rs.getInt("o.quantity"), (long)2000L);
            Assert.assertEquals((Object)rs.getTimestamp("o.date"), (Object)new Timestamp(this.format.parse("2013-11-25 10:06:29").getTime()));
            Assert.assertEquals((Object)rs.getString("I.item_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("i.name"), (Object)"T6");
            Assert.assertEquals((long)rs.getInt("i.price"), (long)600L);
            Assert.assertEquals((long)rs.getInt("i.discount1"), (long)8L);
            Assert.assertEquals((long)rs.getInt("i.discount2"), (long)15L);
            Assert.assertEquals((Object)rs.getString("I.supplier_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("i.description"), (Object)"Item T6");
            Assert.assertEquals((Object)rs.getString("S.supplier_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("s.name"), (Object)"S6");
            Assert.assertEquals((Object)rs.getString("s.phone"), (Object)"888-888-6666");
            Assert.assertEquals((Object)rs.getString("s.address"), (Object)"606 YYY Street");
            Assert.assertEquals((Object)rs.getString("s.loc_id"), (Object)"10006");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("C.customer_id"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString("c.name"), (Object)"C4");
            Assert.assertEquals((Object)rs.getString("c.phone"), (Object)"999-999-4444");
            Assert.assertEquals((Object)rs.getString("c.address"), (Object)"404 XXX Street");
            Assert.assertEquals((Object)rs.getString("c.loc_id"), (Object)"10004");
            Assert.assertEquals((Object)rs.getDate("c.date"), (Object)new Date(this.format.parse("2013-11-22 14:22:56").getTime()));
            Assert.assertEquals((Object)rs.getString("O.order_id"), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString("O.customer_id"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString("O.item_id"), (Object)"0000000001");
            Assert.assertEquals((long)rs.getInt("o.price"), (long)100L);
            Assert.assertEquals((long)rs.getInt("o.quantity"), (long)1000L);
            Assert.assertEquals((Object)rs.getTimestamp("o.date"), (Object)new Timestamp(this.format.parse("2013-11-22 14:22:56").getTime()));
            Assert.assertEquals((Object)rs.getString("I.item_id"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString("i.name"), (Object)"T1");
            Assert.assertEquals((long)rs.getInt("i.price"), (long)100L);
            Assert.assertEquals((long)rs.getInt("i.discount1"), (long)5L);
            Assert.assertEquals((long)rs.getInt("i.discount2"), (long)10L);
            Assert.assertEquals((Object)rs.getString("I.supplier_id"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString("i.description"), (Object)"Item T1");
            Assert.assertEquals((Object)rs.getString("S.supplier_id"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString("s.name"), (Object)"S1");
            Assert.assertEquals((Object)rs.getString("s.phone"), (Object)"888-888-1111");
            Assert.assertEquals((Object)rs.getString("s.address"), (Object)"101 YYY Street");
            Assert.assertEquals((Object)rs.getString("s.loc_id"), (Object)"10001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("C.customer_id"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString("c.name"), (Object)"C4");
            Assert.assertEquals((Object)rs.getString("c.phone"), (Object)"999-999-4444");
            Assert.assertEquals((Object)rs.getString("c.address"), (Object)"404 XXX Street");
            Assert.assertEquals((Object)rs.getString("c.loc_id"), (Object)"10004");
            Assert.assertEquals((Object)rs.getDate("c.date"), (Object)new Date(this.format.parse("2013-11-22 14:22:56").getTime()));
            Assert.assertEquals((Object)rs.getString("O.order_id"), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString("O.customer_id"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString("O.item_id"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt("o.price"), (long)510L);
            Assert.assertEquals((long)rs.getInt("o.quantity"), (long)4000L);
            Assert.assertEquals((Object)rs.getTimestamp("o.date"), (Object)new Timestamp(this.format.parse("2013-11-26 13:26:04").getTime()));
            Assert.assertEquals((Object)rs.getString("I.item_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("i.name"), (Object)"T6");
            Assert.assertEquals((long)rs.getInt("i.price"), (long)600L);
            Assert.assertEquals((long)rs.getInt("i.discount1"), (long)8L);
            Assert.assertEquals((long)rs.getInt("i.discount2"), (long)15L);
            Assert.assertEquals((Object)rs.getString("I.supplier_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("i.description"), (Object)"Item T6");
            Assert.assertEquals((Object)rs.getString("S.supplier_id"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("s.name"), (Object)"S6");
            Assert.assertEquals((Object)rs.getString("s.phone"), (Object)"888-888-6666");
            Assert.assertEquals((Object)rs.getString("s.address"), (Object)"606 YYY Street");
            Assert.assertEquals((Object)rs.getString("s.loc_id"), (Object)"10006");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithSubquery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.sid, supp.name FROM " + tableName1 + " item INNER JOIN (SELECT reverse(loc_id), \"supplier_id\" sid, name FROM " + tableName2 + " WHERE name BETWEEN 'S1' AND 'S5') AS supp ON item.\"supplier_id\" = supp.sid ORDER BY \"item_id\"";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item INNER JOIN (SELECT reverse(loc_id), \"supplier_id\", name FROM " + tableName2 + ") AS supp ON item.\"supplier_id\" = supp.\"supplier_id\" AND (supp.name = 'S1' OR supp.name = 'S5') ORDER BY \"item_id\"";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithSubqueryPostFilters() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);){
            String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
            String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
            String query = "SELECT item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item INNER JOIN (SELECT reverse(loc_id), \"supplier_id\", name FROM " + tableName2 + " LIMIT 5) AS supp ON item.\"supplier_id\" = supp.\"supplier_id\" AND (supp.name != 'S1') ORDER BY \"item_id\"";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(4), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithSubqueryAndAggregation() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.name, sum(quantity) FROM " + tableName4 + " o LEFT JOIN (SELECT name, \"item_id\" iid FROM " + tableName1 + ") AS i ON o.\"item_id\" = i.iid GROUP BY i.name ORDER BY i.name";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ o.iid, sum(o.quantity) q FROM (SELECT \"item_id\" iid, quantity FROM " + tableName4 + ") AS o LEFT JOIN (SELECT \"item_id\" FROM " + tableName1 + ") AS i ON o.iid = i.\"item_id\" GROUP BY o.iid ORDER BY q DESC";
        String query3 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.iid, o.q FROM (SELECT \"item_id\" iid FROM " + tableName1 + ") AS i LEFT JOIN (SELECT \"item_id\" iid, sum(quantity) q FROM " + tableName4 + " GROUP BY \"item_id\") AS o ON o.iid = i.iid ORDER BY o.q DESC NULLS LAST, i.iid";
        String query4 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.iid, o.q FROM (SELECT \"item_id\" iid, sum(quantity) q FROM " + tableName4 + " GROUP BY \"item_id\") AS o JOIN (SELECT \"item_id\" iid FROM " + tableName1 + ") AS i ON o.iid = i.iid ORDER BY o.q DESC, i.iid";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T1");
            Assert.assertEquals((long)rs.getInt(2), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T2");
            Assert.assertEquals((long)rs.getInt(2), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T3");
            Assert.assertEquals((long)rs.getInt(2), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(2), (long)6000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("o.iid"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt("q"), (long)6000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("o.iid"), (Object)"0000000003");
            Assert.assertEquals((long)rs.getInt("q"), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("o.iid"), (Object)"0000000002");
            Assert.assertEquals((long)rs.getInt("q"), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("o.iid"), (Object)"0000000001");
            Assert.assertEquals((long)rs.getInt("q"), (long)1000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query3);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)6000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000003");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000002");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000001");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000004");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000005");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"invalid001");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)0L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query4);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)6000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000003");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000002");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("i.iid"), (Object)"0000000001");
            Assert.assertEquals((long)rs.getInt("o.q"), (long)1000L);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedSubqueries() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName3 = this.getTableName(conn, "\"Join\".\"CustomerTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ q.iname, count(c.name), min(q.sname), max(o.quantity) FROM (SELECT \"customer_id\" cid, \"item_id\" iid, quantity FROM " + tableName4 + ") AS o LEFT JOIN (SELECT /*+ USE_SORT_MERGE_JOIN*/ i.iid iid, s.name sname, i.name iname FROM (SELECT \"supplier_id\" sid, name FROM " + tableName2 + ") AS s RIGHT JOIN (SELECT \"item_id\" iid, name, \"supplier_id\" sid FROM " + tableName1 + ") AS i ON i.sid = s.sid) AS q ON o.iid = q.iid LEFT JOIN (SELECT \"customer_id\" cid, name FROM " + tableName3 + ") AS c ON c.cid = o.cid GROUP BY q.iname ORDER BY q.iname";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ * FROM (SELECT \"customer_id\" cid, name, phone, address, loc_id, \"DATE\" FROM " + tableName3 + ") AS c INNER JOIN (SELECT /*+ USE_SORT_MERGE_JOIN*/ o.oid ooid, o.cid ocid, o.iid oiid, o.price * o.quantity, o.\"DATE\" odate, qi.iiid iiid, qi.iname iname, qi.iprice iprice, qi.idiscount1 idiscount1, qi.idiscount2 idiscount2, qi.isid isid, qi.idescription idescription, qi.ssid ssid, qi.sname sname, qi.sphone sphone, qi.saddress saddress, qi.sloc_id sloc_id FROM (SELECT \"item_id\" iid, \"customer_id\" cid, \"order_id\" oid, price, quantity, \"DATE\" FROM " + tableName4 + ") AS o INNER JOIN (SELECT /*+ USE_SORT_MERGE_JOIN*/ i.iid iiid, i.name iname, i.price iprice, i.discount1 idiscount1, i.discount2 idiscount2, i.sid isid, i.description idescription, s.sid ssid, s.name sname, s.phone sphone, s.address saddress, s.loc_id sloc_id FROM (SELECT \"supplier_id\" sid, name, phone, address, loc_id FROM " + tableName2 + ") AS s RIGHT JOIN (SELECT \"item_id\" iid, name, price, discount1, discount2, \"supplier_id\" sid, description FROM " + tableName1 + ") AS i ON i.sid = s.sid) as qi ON o.iid = qi.iiid) as qo ON c.cid = qo.ocid WHERE c.cid <= '0000000005' AND qo.ooid != '000000000000003' AND qo.iname != 'T3' ORDER BY c.cid, qo.iname";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T1");
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T2");
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((long)rs.getInt(4), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T3");
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((long)rs.getInt(4), (long)5000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((long)rs.getInt(2), (long)2L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"S6");
            Assert.assertEquals((long)rs.getInt(4), (long)4000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("c.cid"), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString("c.name"), (Object)"C3");
            Assert.assertEquals((Object)rs.getString("c.phone"), (Object)"999-999-3333");
            Assert.assertEquals((Object)rs.getString("c.address"), (Object)"303 XXX Street");
            Assert.assertNull((Object)rs.getString("c.loc_id"));
            Assert.assertEquals((Object)rs.getDate("c.date"), (Object)new Date(this.format.parse("2013-11-25 10:06:29").getTime()));
            Assert.assertEquals((Object)rs.getString("qo.ooid"), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString("qo.ocid"), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString("qo.oiid"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt(10), (long)1104000L);
            Assert.assertEquals((Object)rs.getTimestamp("qo.odate"), (Object)new Timestamp(this.format.parse("2013-11-25 10:06:29").getTime()));
            Assert.assertEquals((Object)rs.getString("qo.iiid"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("qo.iname"), (Object)"T6");
            Assert.assertEquals((long)rs.getInt("qo.iprice"), (long)600L);
            Assert.assertEquals((long)rs.getInt("qo.idiscount1"), (long)8L);
            Assert.assertEquals((long)rs.getInt("qo.idiscount2"), (long)15L);
            Assert.assertEquals((Object)rs.getString("qo.isid"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("qo.idescription"), (Object)"Item T6");
            Assert.assertEquals((Object)rs.getString("qo.ssid"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("qo.sname"), (Object)"S6");
            Assert.assertEquals((Object)rs.getString("qo.sphone"), (Object)"888-888-6666");
            Assert.assertEquals((Object)rs.getString("qo.saddress"), (Object)"606 YYY Street");
            Assert.assertEquals((Object)rs.getString("qo.sloc_id"), (Object)"10006");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("c.cid"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString("c.name"), (Object)"C4");
            Assert.assertEquals((Object)rs.getString("c.phone"), (Object)"999-999-4444");
            Assert.assertEquals((Object)rs.getString("c.address"), (Object)"404 XXX Street");
            Assert.assertEquals((Object)rs.getString("c.loc_id"), (Object)"10004");
            Assert.assertEquals((Object)rs.getDate("c.date"), (Object)new Date(this.format.parse("2013-11-22 14:22:56").getTime()));
            Assert.assertEquals((Object)rs.getString("qo.ooid"), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString("qo.ocid"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString("qo.oiid"), (Object)"0000000001");
            Assert.assertEquals((long)rs.getInt(10), (long)100000L);
            Assert.assertEquals((Object)rs.getTimestamp("qo.odate"), (Object)new Timestamp(this.format.parse("2013-11-22 14:22:56").getTime()));
            Assert.assertEquals((Object)rs.getString("qo.iiid"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString("qo.iname"), (Object)"T1");
            Assert.assertEquals((long)rs.getInt("qo.iprice"), (long)100L);
            Assert.assertEquals((long)rs.getInt("qo.idiscount1"), (long)5L);
            Assert.assertEquals((long)rs.getInt("qo.idiscount2"), (long)10L);
            Assert.assertEquals((Object)rs.getString("qo.isid"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString("qo.idescription"), (Object)"Item T1");
            Assert.assertEquals((Object)rs.getString("qo.ssid"), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString("qo.sname"), (Object)"S1");
            Assert.assertEquals((Object)rs.getString("qo.sphone"), (Object)"888-888-1111");
            Assert.assertEquals((Object)rs.getString("qo.saddress"), (Object)"101 YYY Street");
            Assert.assertEquals((Object)rs.getString("qo.sloc_id"), (Object)"10001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("c.cid"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString("c.name"), (Object)"C4");
            Assert.assertEquals((Object)rs.getString("c.phone"), (Object)"999-999-4444");
            Assert.assertEquals((Object)rs.getString("c.address"), (Object)"404 XXX Street");
            Assert.assertEquals((Object)rs.getString("c.loc_id"), (Object)"10004");
            Assert.assertEquals((Object)rs.getDate("c.date"), (Object)new Date(this.format.parse("2013-11-22 14:22:56").getTime()));
            Assert.assertEquals((Object)rs.getString("qo.ooid"), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString("qo.ocid"), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString("qo.oiid"), (Object)"0000000006");
            Assert.assertEquals((long)rs.getInt(10), (long)2040000L);
            Assert.assertEquals((Object)rs.getTimestamp("qo.odate"), (Object)new Timestamp(this.format.parse("2013-11-26 13:26:04").getTime()));
            Assert.assertEquals((Object)rs.getString("qo.iiid"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("qo.iname"), (Object)"T6");
            Assert.assertEquals((long)rs.getInt("qo.iprice"), (long)600L);
            Assert.assertEquals((long)rs.getInt("qo.idiscount1"), (long)8L);
            Assert.assertEquals((long)rs.getInt("qo.idiscount2"), (long)15L);
            Assert.assertEquals((Object)rs.getString("qo.isid"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("qo.idescription"), (Object)"Item T6");
            Assert.assertEquals((Object)rs.getString("qo.ssid"), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString("qo.sname"), (Object)"S6");
            Assert.assertEquals((Object)rs.getString("qo.sphone"), (Object)"888-888-6666");
            Assert.assertEquals((Object)rs.getString("qo.saddress"), (Object)"606 YYY Street");
            Assert.assertEquals((Object)rs.getString("qo.sloc_id"), (Object)"10006");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithLimit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, s.address, quantity FROM " + tableName2 + " s LEFT JOIN " + tableName1 + " i ON i.\"supplier_id\" = s.\"supplier_id\" LEFT JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" LIMIT 4";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, s.address, quantity FROM " + tableName2 + " s JOIN " + tableName1 + " i ON i.\"supplier_id\" = s.\"supplier_id\" JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" LIMIT 3";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S3");
            Assert.assertEquals((Object)rs.getString(4), (Object)"303 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S4");
            Assert.assertEquals((Object)rs.getString(4), (Object)"404 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((Object)rs.getString(4), (Object)"101 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((Object)rs.getString(4), (Object)"101 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)3000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((Object)rs.getString(4), (Object)"101 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)1000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((Object)rs.getString(4), (Object)"101 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)3000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((Object)rs.getString(4), (Object)"202 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)5000L);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithOffset() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String query1 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, s.address, quantity FROM " + tableName2 + " s LEFT JOIN " + tableName1 + " i ON i.\"supplier_id\" = s.\"supplier_id\" LEFT JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" LIMIT 2 OFFSET 1";
        String query2 = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, s.name, s.address, quantity FROM " + tableName2 + " s JOIN " + tableName1 + " i ON i.\"supplier_id\" = s.\"supplier_id\" JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" LIMIT 1 OFFSET 2";
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)rs.getString(3), (Object)"S4");
            Assert.assertEquals((Object)rs.getString(4), (Object)"404 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)0L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S1");
            Assert.assertEquals((Object)rs.getString(4), (Object)"101 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)1000L);
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(3), (Object)"S2");
            Assert.assertEquals((Object)rs.getString(4), (Object)"202 YYY Street");
            Assert.assertEquals((long)rs.getInt(5), (long)5000L);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonEquiJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);){
            String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
            String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.name, supp.name FROM " + tableName1 + " item, " + tableName2 + " supp WHERE item.\"supplier_id\" > supp.\"supplier_id\"";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T3");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T5");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S5");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.name, supp.name FROM " + tableName1 + " item JOIN " + tableName2 + " supp ON item.\"supplier_id\" > supp.\"supplier_id\"";
            statement = conn.prepareStatement(query);
            try {
                statement.executeQuery();
                Assert.fail((String)"Should have got SQLException.");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.AMBIGUOUS_JOIN_CONDITION.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithSetMaxRows() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String[] queries = new String[]{"SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", i.name, quantity FROM " + tableName1 + " i JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\"", "SELECT /*+ USE_SORT_MERGE_JOIN*/ o.\"order_id\", i.name, o.quantity FROM " + tableName1 + " i JOIN (SELECT \"order_id\", \"item_id\", quantity FROM " + tableName4 + ") o ON o.\"item_id\" = i.\"item_id\""};
        try {
            for (int i = 0; i < queries.length; ++i) {
                String query = queries[i];
                Statement statement = conn.createStatement();
                statement.setMaxRows(4);
                ResultSet rs = statement.executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
                Assert.assertEquals((long)rs.getInt(3), (long)1000L);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
                Assert.assertEquals((long)rs.getInt(3), (long)3000L);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
                Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
                Assert.assertEquals((long)rs.getInt(3), (long)5000L);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertTrue((rs.getString(1).equals("000000000000002") || rs.getString(1).equals("000000000000004") ? 1 : 0) != 0);
                Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
                Assert.assertTrue((rs.getInt(3) == 2000 || rs.getInt(3) == 4000 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
                rs = statement.executeQuery("EXPLAIN " + query);
                this.assertPlansEqual(i == 0 ? this.plans[1] : this.plans[1].replaceFirst("O\\.item_id", "item_id"), QueryUtil.getExplainPlan((ResultSet)rs));
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinPopulatesParameterMetadata() throws Exception {
        Connection conn = DriverManager.getConnection(SortMergeJoinIT.getUrl());
        String table1 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String table2 = this.getTableName(conn, "\"Join\".\"CustomerTable\"");
        try {
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + table1 + " JOIN " + table2 + " ON " + table1 + ".\"customer_id\" = " + table2 + ".\"customer_id\" WHERE " + table2 + ".loc_id = ?";
            PreparedStatement ps = conn.prepareStatement(query);
            ParameterMetaData pmd = ps.getParameterMetaData();
            Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
            Assert.assertEquals((long)12L, (long)pmd.getParameterType(1));
        }
        finally {
            conn.close();
        }
    }
}

