/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index.txn;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class TxWriteFailureIT
extends BaseTest {
    private String schemaName;
    private String dataTableName;
    private String indexName;
    private String dataTableFullName;
    private String indexFullName;
    private static final String ROW_TO_FAIL = "fail";
    private final boolean localIndex;
    private final String tableDDLOptions;

    public TxWriteFailureIT(boolean localIndex, boolean mutable, String transactionProvider) {
        this.localIndex = localIndex;
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append(" TRANSACTION_PROVIDER='" + transactionProvider + "'");
        if (!mutable) {
            optionBuilder.append(",IMMUTABLE_ROWS=true");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)3);
        serverProps.put("hbase.coprocessor.region.classes", FailingRegionObserver.class.getName());
        serverProps.put("hbase.coprocessor.abortonerror", "false");
        serverProps.put("com.saleforce.hbase.index.checkversion", "false");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)10);
        clientProps.put("phoenix.table.istransactional.default", "true");
        clientProps.put("phoenix.transactions.enabled", "true");
        TxWriteFailureIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Parameterized.Parameters(name="TxWriteFailureIT_localIndex={0},mutable={1},transactionProvider={2}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, false, "OMID"}, {false, true, "OMID"});
    }

    @Before
    public void generateTableNames() throws SQLException {
        this.schemaName = TxWriteFailureIT.generateUniqueName();
        this.dataTableName = TxWriteFailureIT.generateUniqueName();
        this.indexName = TxWriteFailureIT.generateUniqueName();
        this.dataTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.dataTableName);
        this.indexFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.indexName);
    }

    @Test
    public void testIndexTableWriteFailure() throws Exception {
        if (!this.localIndex) {
            this.helpTestWriteFailure(true);
        }
    }

    @Test
    public void testDataTableWriteFailure() throws Exception {
        this.helpTestWriteFailure(false);
    }

    private void helpTestWriteFailure(boolean indexTableWriteFailure) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = driver.connect(url, props);
        conn.setAutoCommit(false);
        conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR)" + this.tableDDLOptions);
        conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL " : "") + "INDEX " + this.indexName + " ON " + this.dataTableFullName + " (v1)");
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.dataTableFullName + " VALUES(?,?)");
        stmt.setString(1, !indexTableWriteFailure ? ROW_TO_FAIL : "k1");
        stmt.setString(2, indexTableWriteFailure ? ROW_TO_FAIL : "k2");
        stmt.execute();
        stmt.setString(1, "k2");
        stmt.setString(2, "v2");
        stmt.execute();
        try {
            conn.commit();
            Assert.fail();
        }
        catch (Exception e) {
            conn.rollback();
        }
        stmt.setString(1, "k3");
        stmt.setString(2, "v3");
        stmt.execute();
        conn.commit();
        String dataSql = "SELECT k, v1 FROM " + this.dataTableFullName + " order by k";
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + dataSql);
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.dataTableFullName), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs = conn.createStatement().executeQuery(dataSql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"k3", (Object)rs.getString(1));
        Assert.assertEquals((Object)"v3", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        String indexSql = "SELECT k, v1 FROM " + this.dataTableFullName + " order by v1";
        rs = conn.createStatement().executeQuery("EXPLAIN " + indexSql);
        if (this.localIndex) {
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.indexFullName + "(" + this.dataTableFullName + ") [1]\n    SERVER FILTER BY EMPTY COLUMN ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        } else {
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + this.indexFullName + "\n    SERVER FILTER BY EMPTY COLUMN ONLY"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        }
        rs = conn.createStatement().executeQuery(indexSql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"k3", (Object)rs.getString(1));
        Assert.assertEquals((Object)"v3", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    public static class FailingRegionObserver
    extends SimpleRegionObserver {
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            if (this.shouldFailUpsert(c, put)) {
                throw new DoNotRetryIOException();
            }
        }

        private boolean shouldFailUpsert(ObserverContext<RegionCoprocessorEnvironment> c, Put put) {
            return Bytes.contains((byte[])put.getRow(), (byte[])Bytes.toBytes((String)TxWriteFailureIT.ROW_TO_FAIL));
        }
    }
}

