/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.GlobalIndexCheckerIT;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class UncoveredGlobalIndexRegionScannerIT
extends BaseTest {
    private final boolean uncovered;
    private final boolean salted;

    public UncoveredGlobalIndexRegionScannerIT(boolean uncovered, boolean salted) {
        this.uncovered = uncovered;
        this.salted = salted;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        UncoveredGlobalIndexRegionScannerIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @After
    public void unsetFailForTesting() throws Exception {
        boolean refCountLeaked = UncoveredGlobalIndexRegionScannerIT.isAnyStoreRefCountLeaked();
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Parameterized.Parameters(name="uncovered={0},salted={1}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    private void populateTable(String tableName) throws Exception {
        Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + (this.salted ? " SALT_BUCKETS=4" : ""));
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
        conn.commit();
        conn.close();
    }

    @Test
    public void testDDL() throws Exception {
        block11: {
            try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
                String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
                String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
                conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + (this.salted ? " SALT_BUCKETS=4" : ""));
                if (this.uncovered) {
                    try {
                        conn.createStatement().execute("CREATE UNCOVERED INDEX " + indexTableName + " on " + dataTableName + " (val1) INCLUDE (val2)");
                        Assert.fail();
                    }
                    catch (PhoenixParserException phoenixParserException) {
                        // empty catch block
                    }
                    try {
                        conn.createStatement().execute("CREATE UNCOVERED LOCAL INDEX " + indexTableName + " on " + dataTableName);
                        Assert.fail();
                    }
                    catch (PhoenixParserException phoenixParserException) {}
                    break block11;
                }
                conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) INCLUDE (val2)");
            }
        }
    }

    @Test
    public void testDDLWithPhoenixRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            if (this.uncovered) {
                conn.createStatement().execute("CREATE UNCOVERED INDEX IDX_" + dataTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP())");
            } else {
                conn.createStatement().execute("CREATE INDEX IDX_" + dataTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP())");
                conn.createStatement().execute("CREATE LOCAL INDEX IDX_LOCAL_" + dataTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP())");
            }
        }
    }

    @Test
    public void testUncoveredQueryWithPhoenixRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            Timestamp initial = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() - 1L);
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10),  val3 varchar(10))" + (this.salted ? " SALT_BUCKETS=4" : ""));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            Timestamp before = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
            Timestamp after = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() + 1L);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1, PHOENIX_ROW_TIMESTAMP()) ");
            String timeZoneID = Calendar.getInstance().getTimeZone().getID();
            String query = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val1, val2, PHOENIX_ROW_TIMESTAMP(), val3 from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + before.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "') AND PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'bc', 'ccc', 'cccc')");
            conn.commit();
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val1, val2, PHOENIX_ROW_TIMESTAMP(), val3 from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertEquals((Object)"cccc", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            String noIndexQuery = "SELECT /*+ NO_INDEX */ val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            rs = conn.createStatement().executeQuery("EXPLAIN " + noIndexQuery);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains("FULL SCAN OVER " + dataTableName));
            rs = conn.createStatement().executeQuery(noIndexQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            after = rs.getTimestamp(3);
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('d', 'de', 'def', 'defg')");
            conn.commit();
            query = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " val1, val2, PHOENIX_ROW_TIMESTAMP()  from " + dataTableName + " WHERE val1 = 'de'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexTableName + " on " + dataTableName);
            conn.commit();
            indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP()) ");
            conn.commit();
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('e', 'ae', 'efg', 'efgh')");
            conn.commit();
            query = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " id, val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ae", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ae", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUncoveredQueryWithPhoenixRowTimestampAndAllPkCols() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            Timestamp initial = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() - 1L);
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10), val1 varchar(10), val2 varchar(10),  val3 varchar(10) constraint pk primary key(id, val1, val2, val3))" + (this.salted ? " SALT_BUCKETS=4" : ""));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            Timestamp before = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
            Timestamp after = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() + 1L);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1, PHOENIX_ROW_TIMESTAMP()) ");
            String timeZoneID = Calendar.getInstance().getTimeZone().getID();
            String query = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + before.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "') AND PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'bc', 'ccc', 'cccc')");
            conn.commit();
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            String noIndexQuery = "SELECT /*+ NO_INDEX */ val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            rs = conn.createStatement().executeQuery("EXPLAIN " + noIndexQuery);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains((CharSequence)(this.salted ? "RANGE" : "FULL SCAN OVER " + dataTableName)));
            rs = conn.createStatement().executeQuery(noIndexQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            after = rs.getTimestamp(3);
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('d', 'de', 'def', 'defg')");
            conn.commit();
            query = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " val1, val2, PHOENIX_ROW_TIMESTAMP()  from " + dataTableName + " WHERE val1 = 'de'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexTableName + " on " + dataTableName);
            conn.commit();
            indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP()) ");
            conn.commit();
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('e', 'ae', 'efg', 'efgh')");
            conn.commit();
            query = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " id, val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ae", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ae", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void assertIndexTableNotSelected(Connection conn, String dataTableName, String indexTableName, String sql) throws Exception {
        try {
            GlobalIndexCheckerIT.assertExplainPlan(conn, sql, dataTableName, indexTableName);
            throw new RuntimeException("The index table should not be selected without an index hint");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void testUncoveredQuery() throws Exception {
        String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String selectSql;
            String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1) " + (this.uncovered ? "" : "INCLUDE (val2)"));
            int limit = 10;
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT val3 from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde') LIMIT 10");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ val2, val3 from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde') LIMIT " + limit;
                GlobalIndexCheckerIT.assertExplainPlanWithLimit(conn, selectSql, dataTableName, indexTableName, limit);
            } else {
                selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde') LIMIT " + limit;
                GlobalIndexCheckerIT.assertExplainPlanWithLimit(conn, selectSql, dataTableName, indexTableName, limit);
            }
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexTableName + " on " + dataTableName);
            conn.commit();
            indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1)");
            conn.commit();
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT id from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde')");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ id from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde')";
            } else {
                selectSql = "SELECT id from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde')";
            }
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c', 'ab','cde', 'cdef')");
            conn.commit();
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT count(val3) from " + dataTableName + " where val1 > '0' GROUP BY val1");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ count(val3) from " + dataTableName + " where val1 > '0' GROUP BY val1";
            } else {
                selectSql = "SELECT count(val3) from " + dataTableName + " where val1 > '0' GROUP BY val1";
            }
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = !this.uncovered ? "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ count(val3) from " + dataTableName + " where val1 > '0'" : "SELECT count(val3) from " + dataTableName + " where val1 > '0'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT val3 from " + dataTableName + " where val1 > '0' ORDER BY val1");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ val3 from " + dataTableName + " where val1 > '0' ORDER BY val1";
            } else {
                selectSql = "SELECT val3 from " + dataTableName + " where val1 > '0' ORDER BY val1";
            }
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"cdef", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testPartialIndexUpdate() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String selectSql;
            String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, val1 varchar, val2 varchar, val3 varchar, val4 varchar)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd', 'bcde', 'bcdef')");
            conn.commit();
            String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1, val2) " + (this.uncovered ? "" : "INCLUDE (val3)"));
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('b', 'bcdd')");
            conn.commit();
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT val4 from " + dataTableName + " WHERE val1 = 'bc' AND val2 = 'bcdd'");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ val4 from " + dataTableName + " WHERE val1 = 'bc' AND val2 = 'bcdd'";
                GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            } else {
                selectSql = "SELECT  val4 from " + dataTableName + " WHERE val1 = 'bc' AND val2 = 'bcdd'";
                GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            }
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcdef", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSkipScanFilter() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + dataTableName + "(k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 INTEGER, v2 INTEGER, v3 INTEGER CONSTRAINT pk PRIMARY KEY (k1,k2))  COLUMN_ENCODED_BYTES = 0, VERSIONS=1" + (this.salted ? ", SALT_BUCKETS=4" : ""));
            TestUtil.addCoprocessor(conn, dataTableName, ScanFilterRegionObserver.class);
            ScanFilterRegionObserver.resetCount();
            String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " ON " + dataTableName + "(v1)" + (this.uncovered ? "" : "include (v2)"));
            int nIndexValues = 97;
            Random RAND = new Random(7L);
            int batchSize = 100;
            for (int i = 0; i < 10000; ++i) {
                conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES (" + i + ", 1, " + RAND.nextInt() % 97 + ", " + RAND.nextInt() + ", 1)");
                if (i % 100 != 0) continue;
                conn.commit();
            }
            conn.commit();
            String selectSql = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "SUM(v3) from " + dataTableName + " GROUP BY v1";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            int sum = 0;
            while (rs.next()) {
                sum += rs.getInt(1);
            }
            Assert.assertEquals((long)10000L, (long)sum);
            Assert.assertEquals((long)10000L, (long)ScanFilterRegionObserver.count.get());
        }
    }

    @Test
    public void testCount() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + dataTableName + "(k1 BIGINT NOT NULL, k2 BIGINT NOT NULL, v1 INTEGER, v2 INTEGER, v3 BIGINT CONSTRAINT pk PRIMARY KEY (k1,k2))  VERSIONS=1, IMMUTABLE_ROWS=TRUE" + (this.salted ? ", SALT_BUCKETS=4" : ""));
            String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " ON " + dataTableName + "(v1)");
            int nIndexValues = 9;
            Random RAND = new Random(7L);
            int batchSize = 1000;
            for (int i = 0; i < 100000; ++i) {
                conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES (" + i + ", 1, " + RAND.nextInt() % 9 + ", " + RAND.nextInt() + ", " + RAND.nextInt() + ")");
                if (i % 1000 != 0) continue;
                conn.commit();
            }
            conn.commit();
            String selectSql = "SELECT /*+ NO INDEX */  Count(v3) from " + dataTableName + " where v1 = 5";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            long count = rs.getLong(1);
            selectSql = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "Count(v3) from " + dataTableName + " where v1 = 5";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)count, (long)rs.getInt(1));
        }
    }

    @Test
    public void testFailDataTableRowUpdate() throws Exception {
        String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1)");
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            try {
                conn.commit();
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('a', 'abcdd')");
            conn.commit();
            String selectSql = "SELECT" + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val2, val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcdd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testFailPostIndexDeleteUpdate() throws Exception {
        String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());){
            String indexTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1)");
            String selectSql = "SELECT id from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            dml = "DELETE from " + dataTableName + " WHERE val1  = 'ab'";
            Assert.assertEquals((long)0L, (long)conn.createStatement().executeUpdate(dml));
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT count(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        }
    }

    @Test
    public void testPointLookup() throws Exception {
        if (this.uncovered || this.salted) {
            return;
        }
        String schemaName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
        String dataTableName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
        String fullDataTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        this.populateTable(fullDataTableName);
        String indexName = UncoveredGlobalIndexRegionScannerIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScannerIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("create index " + indexName + " on " + fullDataTableName + " (val2) include (val1)");
            String sql = "SELECT /*+ INDEX(" + fullDataTableName + " " + fullIndexName + ")*/ val2, val3 from " + fullDataTableName + " WHERE id = 'a'";
            ResultSet rs = stmt.executeQuery("EXPLAIN " + sql);
            String actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualQueryPlan.contains("POINT LOOKUP ON 1 KEY OVER " + fullDataTableName));
            rs = stmt.executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            sql = "SELECT val2, val3 from " + fullDataTableName + " WHERE id = 'a'";
            rs = stmt.executeQuery("EXPLAIN " + sql);
            actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualQueryPlan.contains("POINT LOOKUP ON 1 KEY OVER " + fullDataTableName));
            rs = stmt.executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            sql = "SELECT /*+ INDEX(" + fullDataTableName + " " + indexName + ")*/ val2, val3 from " + fullDataTableName + " WHERE id = 'a'";
            rs = stmt.executeQuery("EXPLAIN " + sql);
            actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualQueryPlan.contains("FULL SCAN OVER " + fullIndexName));
            rs = stmt.executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
        }
    }

    public static class ScanFilterRegionObserver
    extends SimpleRegionObserver {
        public static final AtomicInteger count = new AtomicInteger(0);

        public static void resetCount() {
            count.set(0);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) {
            if (scan.getFilter() instanceof SkipScanFilter) {
                List slots = ((SkipScanFilter)scan.getFilter()).getSlots();
                for (List ranges : slots) {
                    count.addAndGet(ranges.size());
                }
            }
        }
    }
}

