/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class SingleCellIndexIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleCellIndexIT.class);
    private Properties testProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
    private boolean mutable;
    private final String tableDDLOptions;

    @Parameterized.Parameters(name="mutable={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Before
    public void setupBefore() {
        this.testProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.testProps.put("phoenix.default.column.encoded.bytes.attrib", "0");
    }

    public SingleCellIndexIT(boolean mutable) {
        StringBuilder optionBuilder = new StringBuilder();
        this.mutable = mutable;
        optionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN ");
        if (!mutable) {
            optionBuilder.append(", IMMUTABLE_ROWS=true ");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Test
    public void testCreateOneCellTableAndSingleCellIndex() throws Exception {
        try (Connection conn = DriverManager.getConnection(SingleCellIndexIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String tableName = "TBL_" + SingleCellIndexIT.generateUniqueName();
            String idxName = "IND_" + SingleCellIndexIT.generateUniqueName();
            this.createTableAndIndex(conn, tableName, idxName, this.tableDDLOptions, false, 3);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, idxName);
            SingleCellIndexIT.dumpTable(tableName);
            String selectFromData = "SELECT /*+ NO_INDEX */ PK1, INT_PK, V1, V2, V4 FROM " + tableName + " where V2 >= 3 and V4 LIKE 'V4%'";
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectFromData);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualExplainPlan.contains(tableName));
            rs = conn.createStatement().executeQuery(selectFromData);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK2", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"V12", (Object)rs.getString(3));
            Assert.assertEquals((long)3L, (long)rs.getInt(4));
            Assert.assertEquals((Object)"V42", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            String selectFromIndex = "SELECT PK1, INT_PK, V1, V2, V4 FROM " + tableName + " where V2 >= 3 and V4 LIKE 'V4%'";
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectFromIndex);
            actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualExplainPlan.contains(idxName));
            rs = conn.createStatement().executeQuery(selectFromIndex);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK2", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"V12", (Object)rs.getString(3));
            Assert.assertEquals((long)3L, (long)rs.getInt(4));
            Assert.assertEquals((Object)"V42", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK3", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"V13", (Object)rs.getString(3));
            Assert.assertEquals((long)4L, (long)rs.getInt(4));
            Assert.assertEquals((Object)"V43", (Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testAddColumns() throws Exception {
        try (Connection conn = DriverManager.getConnection(SingleCellIndexIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String tableName = "TBL_" + SingleCellIndexIT.generateUniqueName();
            String idxName = "IND_" + SingleCellIndexIT.generateUniqueName();
            this.createTableAndIndex(conn, tableName, idxName, null, false, 3);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, idxName);
            String alterTable = "ALTER TABLE " + tableName + " ADD V_NEW VARCHAR CASCADE INDEX ALL";
            conn.createStatement().execute(alterTable);
            String upsert = "UPSERT INTO " + tableName + " (PK1,INT_PK,V1, V2, V3, V4, V5, V_NEW) VALUES ('PK99',99,'V199',100,101,'V499','V699','V_NEW99')";
            conn.createStatement().executeUpdate(upsert);
            conn.commit();
            String selectFromIndex = "SELECT PK1, INT_PK, V1, V2, V4, V_NEW FROM " + tableName + " where V1='V199' AND V2=100";
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectFromIndex);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualExplainPlan.contains(idxName));
            rs = conn.createStatement().executeQuery(selectFromIndex);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK99", (Object)rs.getString(1));
            Assert.assertEquals((long)99L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"V199", (Object)rs.getString(3));
            Assert.assertEquals((long)100L, (long)rs.getInt(4));
            Assert.assertEquals((Object)"V499", (Object)rs.getString(5));
            Assert.assertEquals((Object)"V_NEW99", (Object)rs.getString(6));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDropColumns() throws Exception {
        try (Connection conn = DriverManager.getConnection(SingleCellIndexIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String tableName = "TBL_" + SingleCellIndexIT.generateUniqueName();
            String idxName = "IND_" + SingleCellIndexIT.generateUniqueName();
            this.createTableAndIndex(conn, tableName, idxName, null, false, 1);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, idxName);
            String alterTable = "ALTER TABLE " + tableName + " DROP COLUMN V2";
            conn.createStatement().execute(alterTable);
            String star = "SELECT * FROM " + idxName;
            ResultSet rs = conn.createStatement().executeQuery(star);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK1", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"V11", (Object)rs.getString(3));
            Assert.assertEquals((Object)"V41", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            String selectFromIndex = "SELECT PK1, INT_PK, V1, V4 FROM " + tableName + " where V1='V11'";
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectFromIndex);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualExplainPlan.contains(idxName));
            rs = conn.createStatement().executeQuery(selectFromIndex);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK1", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"V11", (Object)rs.getString(3));
            Assert.assertEquals((Object)"V41", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testTenantViewIndexes() throws Exception {
        try (Connection conn = DriverManager.getConnection(SingleCellIndexIT.getUrl(), this.testProps);){
            ResultSet rs;
            QueryPlan plan;
            String sql;
            Statement stmt;
            String indexDDL;
            conn.setAutoCommit(true);
            String tableName = "TBL_" + SingleCellIndexIT.generateUniqueName();
            String view1IndexName = "IND_" + SingleCellIndexIT.generateUniqueName();
            String divergedViewIndex = "DIND_" + SingleCellIndexIT.generateUniqueName();
            String view3IndexName = "IND_" + SingleCellIndexIT.generateUniqueName();
            String view1 = "V_" + SingleCellIndexIT.generateUniqueName();
            String divergedView = "V_" + SingleCellIndexIT.generateUniqueName();
            String view3 = "V_" + SingleCellIndexIT.generateUniqueName();
            String baseTableDDL = "CREATE  TABLE " + tableName + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR, V3 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true" + (this.mutable ? "" : ", IMMUTABLE_ROWS=true");
            conn.createStatement().execute(baseTableDDL);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            try (Connection tenant1Conn = this.getTenantConnection("tenant1");){
                String view1DDL = "CREATE VIEW " + view1 + " ( VIEW_COL1 VARCHAR, VIEW_COL2 VARCHAR) AS SELECT * FROM " + tableName;
                tenant1Conn.createStatement().execute(view1DDL);
                indexDDL = "CREATE INDEX " + view1IndexName + " ON " + view1 + " (V1) include (VIEW_COL2, V3) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS,COLUMN_ENCODED_BYTES=2";
                tenant1Conn.createStatement().execute(indexDDL);
                tenant1Conn.commit();
            }
            try (Connection tenant2Conn = this.getTenantConnection("tenant2");){
                String divergedViewDDL = "CREATE VIEW " + divergedView + " ( VIEW_COL1 VARCHAR, VIEW_COL2 VARCHAR) AS SELECT * FROM " + tableName;
                tenant2Conn.createStatement().execute(divergedViewDDL);
                tenant2Conn.createStatement().execute("ALTER VIEW " + divergedView + " DROP COLUMN V2");
                indexDDL = "CREATE INDEX " + divergedViewIndex + " ON " + divergedView + " (V1) include (VIEW_COL1, V3) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS";
                tenant2Conn.createStatement().execute(indexDDL);
                tenant2Conn.commit();
            }
            try (Connection tenant3Conn = this.getTenantConnection("tenant3");){
                String view3DDL = "CREATE VIEW " + view3 + " ( VIEW_COL31 VARCHAR, VIEW_COL32 VARCHAR) AS SELECT * FROM " + tableName;
                tenant3Conn.createStatement().execute(view3DDL);
                indexDDL = "CREATE INDEX " + view3IndexName + " ON " + view3 + " (V1) include (VIEW_COL32, V3)";
                tenant3Conn.createStatement().execute(indexDDL);
                tenant3Conn.commit();
            }
            String upsert = "UPSERT INTO " + view1 + " (PK1, V1, V2, V3, VIEW_COL1, VIEW_COL2) VALUES ('PK1',  'V1', 'V2', 'V3','VIEW_COL1_1','VIEW_COL2_1')";
            try (Connection viewConn = this.getTenantConnection("tenant1");){
                viewConn.createStatement().executeUpdate(upsert);
                viewConn.commit();
                stmt = viewConn.createStatement();
                sql = "SELECT V3, VIEW_COL2 FROM " + view1 + " WHERE V1 = 'V1'";
                plan = stmt.unwrap(PhoenixStatement.class).optimizeQuery(sql);
                Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(SchemaUtil.normalizeIdentifier((String)view1IndexName)));
                rs = viewConn.createStatement().executeQuery(sql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"V3", (Object)rs.getString(1));
                Assert.assertEquals((Object)"VIEW_COL2_1", (Object)rs.getString(2));
            }
            upsert = "UPSERT INTO " + divergedView + " (PK1, V1, V3, VIEW_COL1, VIEW_COL2) VALUES ('PK1', 'V1', 'V3','VIEW_COL21_1','VIEW_COL22_1')";
            viewConn = this.getTenantConnection("tenant2");
            try {
                viewConn.createStatement().executeUpdate(upsert);
                viewConn.commit();
                stmt = viewConn.createStatement();
                sql = "SELECT V3, VIEW_COL1 FROM " + divergedView + " WHERE V1 = 'V1'";
                plan = stmt.unwrap(PhoenixStatement.class).optimizeQuery(sql);
                Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(SchemaUtil.normalizeIdentifier((String)divergedViewIndex)));
                rs = viewConn.createStatement().executeQuery(sql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"V3", (Object)rs.getString(1));
                Assert.assertEquals((Object)"VIEW_COL21_1", (Object)rs.getString(2));
            }
            finally {
                if (viewConn != null) {
                    viewConn.close();
                }
            }
            upsert = "UPSERT INTO " + view3 + " (PK1, V1, V2, V3, VIEW_COL31, VIEW_COL32) VALUES ('PK1',  'V1', 'V2', 'V3','VIEW_COL31_1','VIEW_COL32_1')";
            viewConn = this.getTenantConnection("tenant3");
            try {
                viewConn.createStatement().executeUpdate(upsert);
                viewConn.commit();
                stmt = viewConn.createStatement();
                sql = "SELECT V3, VIEW_COL32 FROM " + view3 + " WHERE V1 = 'V1'";
                plan = stmt.unwrap(PhoenixStatement.class).optimizeQuery(sql);
                Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(SchemaUtil.normalizeIdentifier((String)view3IndexName)));
                rs = viewConn.createStatement().executeQuery(sql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"V3", (Object)rs.getString(1));
                Assert.assertEquals((Object)"VIEW_COL32_1", (Object)rs.getString(2));
            }
            finally {
                if (viewConn != null) {
                    viewConn.close();
                }
            }
            SingleCellIndexIT.dumpTable("_IDX_" + tableName);
        }
    }

    @Test
    public void testUpsertSelect() throws Exception {
        String tableName = SingleCellIndexIT.generateUniqueName();
        String idxName = "IDX_" + SingleCellIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(SingleCellIndexIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            this.createTableAndIndex(conn, tableName, idxName, null, true, 2);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, idxName);
            conn.createStatement().execute("delete from " + tableName + " where pk1 = 'PK1'");
            conn.commit();
            String sql = "UPSERT INTO " + idxName + "(\":PK1\",\":INT_PK\",\"0:V1\",\"0:V2\",\"0:V4\")  SELECT /*+ NO_INDEX */ PK1,INT_PK, V1, V2,V4 FROM " + tableName;
            conn.createStatement().executeUpdate(sql);
            conn.commit();
            String query = "SELECT \":PK1\" from " + idxName + " ORDER BY \":PK1\"";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK2", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testMultipleColumnFamilies() throws Exception {
        String tableName = SingleCellIndexIT.generateUniqueName();
        String idxName = "IDX_" + SingleCellIndexIT.generateUniqueName();
        int numOfRows = 2;
        try (Connection conn = DriverManager.getConnection(SingleCellIndexIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String createTableSql = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, A.V2 INTEGER, B.V3 INTEGER, A.V4 VARCHAR, B.V5 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            String createIndexSql = "CREATE INDEX " + idxName + " ON " + tableName + " (A.V2) include (B.V3, A.V4, B.V5)  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2";
            LOGGER.debug(createIndexSql);
            conn.createStatement().execute(createIndexSql);
            String upsert = "UPSERT INTO " + tableName + " (PK1, INT_PK, V1, A.V2, B.V3, A.V4, B.V5) VALUES (?,?,?,?,?,?,?)";
            PreparedStatement upsertStmt = conn.prepareStatement(upsert);
            for (int i = 1; i <= numOfRows; ++i) {
                upsertStmt.setString(1, "PK" + i);
                upsertStmt.setInt(2, i);
                upsertStmt.setString(3, "V1" + i);
                upsertStmt.setInt(4, i + 1);
                upsertStmt.setInt(5, i + 2);
                upsertStmt.setString(6, "V4" + i);
                upsertStmt.setString(7, "V5" + i);
                upsertStmt.executeUpdate();
            }
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, idxName);
            String query = "SELECT * from " + idxName + " ORDER BY \":PK1\"";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"PK1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"3", (Object)rs.getString(4));
            Assert.assertEquals((Object)"V41", (Object)rs.getString(5));
            Assert.assertEquals((Object)"V51", (Object)rs.getString(6));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"3", (Object)rs.getString(1));
            Assert.assertEquals((Object)"PK2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"2", (Object)rs.getString(3));
            Assert.assertEquals((Object)"4", (Object)rs.getString(4));
            Assert.assertEquals((Object)"V42", (Object)rs.getString(5));
            Assert.assertEquals((Object)"V52", (Object)rs.getString(6));
            String selectFromIndex = "SELECT PK1, INT_PK, A.V2, B.V3, A.V4, B.V5 FROM " + tableName + " where A.V4='V42' and B.V3 >= 3";
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectFromIndex);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualExplainPlan.contains(idxName));
            rs = conn.createStatement().executeQuery(selectFromIndex);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"3", (Object)rs.getString(3));
            Assert.assertEquals((Object)"4", (Object)rs.getString(4));
            Assert.assertEquals((Object)"V42", (Object)rs.getString(5));
            Assert.assertEquals((Object)"V52", (Object)rs.getString(6));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testPartialUpdateSingleCellTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(SingleCellIndexIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String tableName = "TBL_" + SingleCellIndexIT.generateUniqueName();
            String idxName = "IND_" + SingleCellIndexIT.generateUniqueName();
            this.createTableAndIndex(conn, tableName, idxName, this.tableDDLOptions, false, 3);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, idxName);
            String upsert = "UPSERT INTO " + tableName + " (PK1, INT_PK, V4) VALUES ('PK1',1,'UpdatedV4')";
            conn.createStatement().execute(upsert);
            conn.commit();
            String selectFromData = "SELECT /*+ NO_INDEX */ PK1, INT_PK, V1, V2, V4 FROM " + tableName + " where INT_PK = 1 and V4 LIKE 'UpdatedV4'";
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectFromData);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualExplainPlan.contains(tableName));
            rs = conn.createStatement().executeQuery(selectFromData);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK1", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"V11", (Object)rs.getString(3));
            Assert.assertEquals((long)2L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            String selectFromIndex = "SELECT PK1, INT_PK, V1, V2, V4 FROM " + tableName + " where V2 >= 2 and V4 = 'UpdatedV4'";
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectFromIndex);
            actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualExplainPlan.contains(idxName));
            rs = conn.createStatement().executeQuery(selectFromIndex);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK1", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"V11", (Object)rs.getString(3));
            Assert.assertEquals((long)2L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private Connection getTenantConnection(String tenantId) throws Exception {
        Properties tenantProps = PropertiesUtil.deepCopy((Properties)this.testProps);
        tenantProps.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(SingleCellIndexIT.getUrl(), tenantProps);
    }

    private void createTableAndIndex(Connection conn, String tableName, String indexName, String tableDDL, boolean async, int numOfRows) throws SQLException {
        String createTableSql = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER, V3 INTEGER, V4 VARCHAR, V5 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) " + (tableDDL == null ? "" : tableDDL);
        LOGGER.debug(createTableSql);
        conn.createStatement().execute(createTableSql);
        String createIndexSql = "CREATE INDEX " + indexName + " ON " + tableName + " (PK1, INT_PK) include (V1,V2,V4) " + (async ? "ASYNC" : "") + " IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2";
        LOGGER.debug(createIndexSql);
        conn.createStatement().execute(createIndexSql);
        String upsert = "UPSERT INTO " + tableName + " (PK1, INT_PK, V1,  V2, V3, V4, V5) VALUES (?,?,?,?,?,?,?)";
        PreparedStatement upsertStmt = conn.prepareStatement(upsert);
        for (int i = 1; i <= numOfRows; ++i) {
            upsertStmt.setString(1, "PK" + i);
            upsertStmt.setInt(2, i);
            upsertStmt.setString(3, "V1" + i);
            upsertStmt.setInt(4, i + 1);
            upsertStmt.setInt(5, i + 2);
            upsertStmt.setString(6, "V4" + i);
            upsertStmt.setString(7, "V5" + i);
            upsertStmt.executeUpdate();
        }
    }

    public static void dumpTable(String tableName) throws Exception {
        tableName = tableName.replaceAll("\"", "");
        try (Connection conn = DriverManager.getConnection(SingleCellIndexIT.getUrl());){
            Table hTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(tableName.getBytes());
            Scan scan = new Scan();
            scan.setRaw(true);
            scan.readAllVersions();
            LOGGER.info("***** Table Name : " + tableName);
            ResultScanner scanner = hTable.getScanner(scan);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            Result result = scanner.next();
            while (result != null) {
                for (Cell cell : result.rawCells()) {
                    String cellString = cell.toString();
                    LOGGER.info(cellString + " ****** timestamp : " + sdf.format(new Date(cell.getTimestamp())) + " ****** value : " + Bytes.toStringBinary((byte[])CellUtil.cloneValue((Cell)cell)));
                }
                result = scanner.next();
            }
        }
    }
}

