/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SaltedIndexIT
extends ParallelStatsDisabledIT {
    private static final int TABLE_SPLITS = 3;
    private static final int INDEX_SPLITS = 4;

    private static Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.index.mutableBatchSizeThreshold", Integer.toString(1));
        Connection conn = DriverManager.getConnection(SaltedIndexIT.getUrl(), props);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeImmutableAndDeleteData(String tableName, String fullTableName) throws Exception {
        try (Connection conn = SaltedIndexIT.getConnection();){
            conn.setAutoCommit(true);
            conn.createStatement().execute("DELETE FROM " + fullTableName);
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET IMMUTABLE_ROWS=true");
            conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullTableName).next();
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            Assert.assertTrue((boolean)pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName)).isImmutableRows());
        }
    }

    public void testMutableTableIndexMaintanenceSaltedSalted() throws Exception {
        String tableName = "TBL_" + SaltedIndexIT.generateUniqueName();
        String indexName = "IND_" + SaltedIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        this.testMutableTableIndexMaintanence(tableName, fullTableName, indexName, fullIndexName, 3, 4);
        SaltedIndexIT.makeImmutableAndDeleteData(tableName, fullTableName);
        this.testMutableTableIndexMaintanence(tableName, fullTableName, indexName, fullIndexName, 3, 4);
    }

    @Test
    public void testMutableTableIndexMaintanenceSalted() throws Exception {
        String tableName = "TBL_" + SaltedIndexIT.generateUniqueName();
        String indexName = "IND_" + SaltedIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        this.testMutableTableIndexMaintanence(tableName, fullTableName, indexName, fullIndexName, null, 4);
        SaltedIndexIT.makeImmutableAndDeleteData(tableName, fullTableName);
        this.testMutableTableIndexMaintanence(tableName, fullTableName, indexName, fullIndexName, null, 4);
    }

    @Test
    public void testMutableTableIndexMaintanenceUnsalted() throws Exception {
        String tableName = "TBL_" + SaltedIndexIT.generateUniqueName();
        String indexName = "IND_" + SaltedIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        this.testMutableTableIndexMaintanence(tableName, fullTableName, indexName, fullIndexName, null, null);
        SaltedIndexIT.makeImmutableAndDeleteData(tableName, fullTableName);
        this.testMutableTableIndexMaintanence(tableName, fullTableName, indexName, fullIndexName, null, null);
    }

    private void testMutableTableIndexMaintanence(String dataTableName, String dataTableFullName, String indexTableName, String indexTableFullName, Integer tableSaltBuckets, Integer indexSaltBuckets) throws Exception {
        Connection conn = SaltedIndexIT.getConnection();
        conn.setAutoCommit(false);
        conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + dataTableFullName + " (k VARCHAR NOT NULL PRIMARY KEY, v VARCHAR)  " + (String)(tableSaltBuckets == null ? "" : " SALT_BUCKETS=" + tableSaltBuckets));
        String query = "SELECT * FROM " + dataTableFullName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + indexTableName + " ON " + dataTableFullName + " (v DESC)" + (String)(indexSaltBuckets == null ? "" : " SALT_BUCKETS=" + indexSaltBuckets));
        query = "SELECT * FROM " + indexTableFullName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?)");
        stmt.setString(1, "a");
        stmt.setString(2, "x");
        stmt.execute();
        stmt.setString(1, "b");
        stmt.setString(2, "y");
        stmt.execute();
        conn.commit();
        query = "SELECT /*+ SERIAL */ * FROM " + indexTableFullName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"y", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"x", (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        query = "SELECT k,v FROM " + dataTableFullName + " WHERE v = 'y'";
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((Object)"y", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("EXPLAIN " + query);
        String expectedPlan = indexSaltBuckets == null ? "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableFullName + " [~'y']\n    SERVER FILTER BY FIRST KEY ONLY" : "CLIENT PARALLEL 4-WAY RANGE SCAN OVER " + indexTableFullName + " [X'00',~'y'] - [" + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{(byte)(indexSaltBuckets - 1)}) + ",~'y']\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT";
        Assert.assertEquals((Object)expectedPlan, (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        query = "SELECT k,v FROM " + dataTableFullName + " WHERE v >= 'x'";
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((Object)"y", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"x", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("EXPLAIN " + query);
        expectedPlan = indexSaltBuckets == null ? "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableFullName + " [*] - [~'x']\n    SERVER FILTER BY FIRST KEY ONLY" : "CLIENT PARALLEL 4-WAY RANGE SCAN OVER " + indexTableFullName + " [X'00',*] - [" + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{(byte)(indexSaltBuckets - 1)}) + ",~'x']\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT";
        Assert.assertEquals((Object)expectedPlan, (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        query = "SELECT k,v FROM " + dataTableFullName + " WHERE k = 'a' ORDER BY v";
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"x", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("EXPLAIN " + query);
        expectedPlan = tableSaltBuckets == null ? "CLIENT PARALLEL 1-WAY POINT LOOKUP ON 1 KEY OVER " + dataTableFullName + "\n    SERVER SORTED BY [V]\nCLIENT MERGE SORT" : "CLIENT PARALLEL 1-WAY POINT LOOKUP ON 1 KEY OVER " + dataTableFullName + "\n    SERVER SORTED BY [V]\nCLIENT MERGE SORT";
        String explainPlan2 = QueryUtil.getExplainPlan((ResultSet)rs);
        Assert.assertEquals((Object)expectedPlan, (Object)explainPlan2);
        query = "SELECT k,v FROM " + dataTableFullName + " WHERE v >= 'x' ORDER BY k LIMIT 2";
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"x", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((Object)"y", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("EXPLAIN " + query);
        expectedPlan = tableSaltBuckets == null ? "CLIENT PARALLEL 1-WAY FULL SCAN OVER " + dataTableFullName + "\n    SERVER FILTER BY V >= 'x'\n    SERVER 2 ROW LIMIT\nCLIENT 2 ROW LIMIT" : "CLIENT PARALLEL 3-WAY FULL SCAN OVER " + dataTableFullName + "\n    SERVER FILTER BY V >= 'x'\n    SERVER 2 ROW LIMIT\nCLIENT MERGE SORT\nCLIENT 2 ROW LIMIT";
        String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        Assert.assertEquals((Object)expectedPlan, (Object)explainPlan);
        query = "SELECT * FROM " + dataTableFullName + " ORDER BY v DESC LIMIT 1";
        rs = conn.createStatement().executeQuery("EXPLAIN " + query);
        expectedPlan = indexSaltBuckets == null ? "CLIENT SERIAL 1-WAY FULL SCAN OVER " + indexTableFullName + "\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER 1 ROW LIMIT\nCLIENT 1 ROW LIMIT" : "CLIENT PARALLEL 4-WAY FULL SCAN OVER " + indexTableFullName + "\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER 1 ROW LIMIT\nCLIENT MERGE SORT\nCLIENT 1 ROW LIMIT";
        Assert.assertEquals((Object)expectedPlan, (Object)QueryUtil.getExplainPlan((ResultSet)rs));
    }
}

