/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ViewTTLIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.ViewUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PartialSystemCatalogIndexIT
extends ParallelStatsDisabledIT {
    static final Logger LOGGER = LoggerFactory.getLogger(ViewTTLIT.class);
    static final int VIEW_TTL_10_SECS = 10;
    static final int VIEW_TTL_300_SECS = 300;
    static final int VIEW_TTL_120_SECS = 120;
    private static final String SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME = "INDEX_TABLE_LINK_TEST_INDEX";
    private static final String FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME = "SYSTEM.INDEX_TABLE_LINK_TEST_INDEX";
    private static final String SYS_INDEX_HDR_TEST_INDEX_NAME = "INDEX_HDR_TEST_INDEX";
    private static final String FULL_SYS_INDEX_HDR_TEST_INDEX_NAME = "SYSTEM.INDEX_HDR_TEST_INDEX";
    private static final String SYS_VIEW_HDR_TEST_INDEX_NAME = "VIEW_HDR_TEST_INDEX";
    private static final String FULL_SYS_VIEW_HDR_TEST_INDEX_NAME = "SYSTEM.VIEW_HDR_TEST_INDEX";
    private static final String SYS_VIEW_INDEX_HDR_TEST_INDEX_NAME = "VIEW_INDEX_HDR_TEST_INDEX";
    private static final String FULL_SYS_VIEW_INDEX_HDR_TEST_INDEX_NAME = "SYSTEM.VIEW_INDEX_HDR_TEST_INDEX";
    private static final String SYS_ROW_KEY_MATCHER_TEST_INDEX_NAME = "ROW_KEY_MATCHER_TEST_INDEX";
    private static final String FULL_SYS_ROW_KEY_MATCHER_TEST_INDEX_NAME = "SYSTEM.ROW_KEY_MATCHER_TEST_INDEX";
    private static final String SYS_INDEX_TABLE_LINK_TEST_INDEX_SQL = String.format("CREATE INDEX IF NOT EXISTS %s ON SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY) INCLUDE(TABLE_TYPE, LINK_TYPE) WHERE TABLE_TYPE = 'i' AND LINK_TYPE = 1", "INDEX_TABLE_LINK_TEST_INDEX");
    private static final String SYS_INDEX_HDR_TEST_INDEX_SQL = String.format("CREATE INDEX IF NOT EXISTS %s ON SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, INDEX_STATE, DATA_TABLE_NAME) INCLUDE(TABLE_TYPE) WHERE TABLE_TYPE = 'i' AND INDEX_STATE IS NOT NULL", "INDEX_HDR_TEST_INDEX");
    private static final String SYS_VIEW_HDR_TEST_INDEX_SQL = String.format("CREATE INDEX IF NOT EXISTS %s ON SYSTEM.CATALOG(TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY) INCLUDE (TABLE_TYPE, VIEW_STATEMENT, TTL, ROW_KEY_MATCHER) WHERE TABLE_TYPE = 'v'", "VIEW_HDR_TEST_INDEX");
    private static final String SYS_ROW_KEY_MATCHER_TEST_INDEX_SQL = String.format("CREATE INDEX IF NOT EXISTS %s ON SYSTEM.CATALOG(ROW_KEY_MATCHER, TTL, TABLE_TYPE, TENANT_ID, TABLE_SCHEM, TABLE_NAME) INCLUDE (VIEW_STATEMENT) WHERE TABLE_TYPE = 'v' AND ROW_KEY_MATCHER IS NOT NULL", "ROW_KEY_MATCHER_TEST_INDEX");
    private static final String SYS_VIEW_INDEX_HDR_TEST_INDEX_SQL = String.format("CREATE INDEX IF NOT EXISTS %s ON SYSTEM.CATALOG(DECODE_VIEW_INDEX_ID(VIEW_INDEX_ID, VIEW_INDEX_ID_DATA_TYPE), TENANT_ID, TABLE_SCHEM, TABLE_NAME) INCLUDE(TABLE_TYPE, LINK_TYPE, VIEW_INDEX_ID, VIEW_INDEX_ID_DATA_TYPE)  WHERE TABLE_TYPE = 'i' AND LINK_TYPE IS NULL AND VIEW_INDEX_ID IS NOT NULL", "VIEW_INDEX_HDR_TEST_INDEX");
    static final String SYS_CATALOG_ROW_KEY_MATCHER_HEADER_SQL = "SELECT ROW_KEY_MATCHER FROM SYSTEM.CATALOG WHERE %s AND TABLE_SCHEM <> 'SYSTEM' AND TABLE_NAME = '%s' AND ROW_KEY_MATCHER IS NOT NULL";
    static final String SYS_CATALOG_VIEW_TTL_HEADER_SQL = "SELECT TTL FROM SYSTEM.CATALOG WHERE %s AND TABLE_SCHEM = '%s' AND TABLE_NAME = '%s' AND TABLE_TYPE = 'v'";
    static final String SYS_CATALOG_VIEW_INDEX_HEADER_SQL = "SELECT VIEW_INDEX_ID FROM SYSTEM.CATALOG WHERE %s AND TABLE_SCHEM = '%s' AND TABLE_NAME = '%s' AND TABLE_TYPE = 'i' AND LINK_TYPE IS NULL";
    static final String SYS_CATALOG_SYS_INDEX_TABLE_SQL = "SELECT count(*) FROM SYSTEM.CATALOG WHERE TABLE_SCHEM = 'SYSTEM' AND TABLE_NAME = '%s'";
    static final String SYS_CATALOG_INDEX_TABLE_LINK_SQL = "SELECT count(*) FROM SYSTEM.CATALOG WHERE %s AND TABLE_SCHEM = '%s' AND TABLE_NAME = '%s' AND TABLE_TYPE = 'i' AND LINK_TYPE = 1";
    static final String SYS_CATALOG_INDEX_HDR_SQL = "SELECT count(*) FROM SYSTEM.CATALOG WHERE %s AND TABLE_SCHEM = '%s' AND TABLE_NAME = '%s' AND TABLE_TYPE = 'i' AND INDEX_STATE IS NOT NULL";
    static final String SYS_CATALOG_COLUMN_EXISTS_SQL = "SELECT count(*) FROM SYSTEM.CATALOG WHERE TABLE_SCHEM = '%s' AND TABLE_NAME = '%s' AND COLUMN_NAME = '%s'";
    static final String SYS_CATALOG_IDX_INDEX_TABLE_LINK_SQL = "SELECT \":COLUMN_FAMILY\" FROM %s WHERE %s AND \":TABLE_SCHEM\" = '%s' AND \":TABLE_NAME\" = '%s'";
    static final String SYS_CATALOG_IDX_INDEX_HDR_SQL = "SELECT \"0:DATA_TABLE_NAME\", \"0:INDEX_STATE\" FROM %s WHERE %s AND \":TABLE_SCHEM\" = '%s' AND \":TABLE_NAME\" = '%s'";
    static final String SYS_CATALOG_IDX_VIEW_HEADER_SQL = "SELECT \"0:VIEW_STATEMENT\" FROM %s WHERE %s AND \":TABLE_SCHEM\" = '%s' AND \":TABLE_NAME\" = '%s'";
    static final String SYS_CATALOG_IDX_VIEW_INDEX_HEADER_SQL = "SELECT \": DECODE_VIEW_INDEX_ID(VIEW_INDEX_ID,VIEW_INDEX_ID_DATA_TYPE)\" FROM %s WHERE %s AND \":TABLE_SCHEM\" = '%s' AND \":TABLE_NAME\" = '%s'";
    private static RegionCoprocessorEnvironment taskRegionEnvironment;
    private static HBaseTestingUtility hbaseTestUtil;

    @BeforeClass
    public static void doSetup() throws Exception {
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                Configuration conf = HBaseConfiguration.create();
                conf.set("phoenix.system.catalog.indexes.enabled", String.valueOf(true));
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration conf = HBaseConfiguration.create();
                conf.set("phoenix.system.catalog.indexes.enabled", String.valueOf(true));
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        conf.set("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        conf.set("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        hbaseTestUtil = new HBaseTestingUtility(conf);
        PartialSystemCatalogIndexIT.setUpConfigForMiniCluster(conf);
        conf.set("phoenix.jdbc.extra.arguments", "");
        hbaseTestUtil.startMiniCluster();
        HashMap<String, String> DEFAULT_PROPERTIES = new HashMap<String, String>(){
            {
                this.put("phoenix.system.catalog.indexes.enabled", String.valueOf(true));
                this.put("phoenix.max.lookback.age.seconds", Integer.toString(0));
                this.put("phoenix.view.ttl.enabled", Boolean.toString(true));
                this.put("phoenix.view.ttl.tenant_views_per_scan.limit", String.valueOf(1));
                this.put("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
                this.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
            }
        };
        PartialSystemCatalogIndexIT.setUpTestDriver(new ReadOnlyProps(ReadOnlyProps.EMPTY_PROPS, DEFAULT_PROPERTIES.entrySet().iterator()));
        taskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)PartialSystemCatalogIndexIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(TaskRegionObserver.class.getName());
    }

    void assertSystemCatalogHasIndexHdr(String tenantId, String schemaName, String tableName) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "TENANT_ID IS NULL" : String.format("TENANT_ID = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_INDEX_HDR_SQL, tenantClause, schemaName, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            int numRows = rs.next() ? rs.getInt(1) : 0;
            Assert.assertEquals((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (long)1L, (long)numRows);
        }
    }

    void assertAdditionalColumnInMetaIndexTable(String schemaName, String indexName, String newColumnName, boolean exists) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            Statement stmt = connection.createStatement();
            String sql = String.format(SYS_CATALOG_COLUMN_EXISTS_SQL, schemaName, indexName, newColumnName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            int numRows = rs.next() ? rs.getInt(1) : 0;
            Assert.assertEquals((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, indexName), (long)(exists ? 1L : 0L), (long)numRows);
        }
    }

    void assertSystemCatalogHasIndexTableLinks(String tenantId, String schemaName, String tableName) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "TENANT_ID IS NULL" : String.format("TENANT_ID = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_INDEX_TABLE_LINK_SQL, tenantClause, schemaName, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            int numRows = rs.next() ? rs.getInt(1) : 0;
            Assert.assertEquals((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (long)1L, (long)numRows);
        }
    }

    void assertSystemCatalogHasViewIndexHeaderRelatedColumns(String tenantId, String schemaName, String tableName, boolean exists) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            String viewIndexId;
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "TENANT_ID IS NULL" : String.format("TENANT_ID = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_VIEW_INDEX_HEADER_SQL, tenantClause, schemaName, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            String string = viewIndexId = rs.next() ? rs.getString(1) : null;
            if (exists) {
                Assert.assertNotNull((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (Object)viewIndexId);
            } else {
                Assert.assertNull((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (Object)viewIndexId);
            }
        }
    }

    void assertSystemCatalogHasViewHeaderRelatedColumns(String tenantId, String schemaName, String tableName, boolean exists, long ttlValueExpected) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "TENANT_ID IS NULL" : String.format("TENANT_ID = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_VIEW_TTL_HEADER_SQL, tenantClause, schemaName, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            if (exists) {
                String ttlStr = rs.next() ? rs.getString(1) : null;
                long actualTTLValueReturned = ttlStr != null ? (long)Integer.valueOf(ttlStr).intValue() : 0L;
                Assert.assertEquals((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (long)ttlValueExpected, (long)actualTTLValueReturned);
            } else {
                Assert.assertFalse((String)String.format("Rows do exists for schema = %s, table = %s", schemaName, tableName), (boolean)rs.next());
            }
        }
    }

    void assertSystemCatalogHasRowKeyMatcherRelatedColumns(String tenantId, String schemaName, String tableName, boolean exists) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "TENANT_ID IS NULL" : String.format("TENANT_ID = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_ROW_KEY_MATCHER_HEADER_SQL, tenantClause, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            if (exists) {
                byte[] matcherBytes = rs.next() ? rs.getBytes(1) : null;
                Assert.assertNotNull((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (Object)matcherBytes);
            } else {
                Assert.assertFalse((String)String.format("Rows do exists for schema = %s, table = %s", schemaName, tableName), (boolean)rs.next());
            }
        }
    }

    String stripQuotes(String name) {
        return name.replace("\"", "");
    }

    void assertSystemCatalogIndexTable(String systemCatalogIndexName, boolean exists) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            Statement stmt = connection.createStatement();
            String sql = String.format(SYS_CATALOG_SYS_INDEX_TABLE_SQL, systemCatalogIndexName, systemCatalogIndexName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            rs.next();
            Assert.assertTrue((String)String.format("Expected rows do not match for index-table = SYSTEM.%s", systemCatalogIndexName), (boolean)(exists ? rs.getInt(1) > 0 : rs.getInt(1) == 0));
        }
    }

    void assertSystemCatalogIndexHaveIndexHdr(String systemCatalogIndexName, String tenantId, String schemaName, String tableName, boolean exists, String indexName, String expectedIndexState) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            String actualIndexState;
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "\":TENANT_ID\" IS NULL" : String.format("\":TENANT_ID\" = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_IDX_INDEX_HDR_SQL, systemCatalogIndexName, tenantClause, schemaName, indexName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            boolean hasRows = rs.next();
            String actualDataTableName = hasRows ? rs.getString(1) : null;
            String string = actualIndexState = hasRows ? rs.getString(2) : null;
            if (exists) {
                Assert.assertEquals((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, indexName), (Object)tableName, (Object)actualDataTableName);
                Assert.assertEquals((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, indexName), (Object)expectedIndexState, (Object)actualIndexState);
            } else {
                Assert.assertNull((String)String.format("Zero rows expected for schema = %s, table = %s", schemaName, indexName), (Object)actualDataTableName);
                Assert.assertNull((String)String.format("Zero rows expected for schema = %s, table = %s", schemaName, indexName), (Object)actualIndexState);
            }
        }
    }

    void assertSystemCatalogIndexHaveIndexTableLinks(String systemCatalogIndexName, String tenantId, String schemaName, String tableName, boolean exists, String indexName) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            String colFamilyStr;
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "\":TENANT_ID\" IS NULL" : String.format("\":TENANT_ID\" = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_IDX_INDEX_TABLE_LINK_SQL, systemCatalogIndexName, tenantClause, schemaName, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            String string = colFamilyStr = rs.next() ? rs.getString(1) : null;
            if (exists) {
                Assert.assertEquals((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (Object)indexName, (Object)colFamilyStr);
            } else {
                Assert.assertNull((String)String.format("Zero rows expected for schema = %s, table = %s", schemaName, tableName), (Object)colFamilyStr);
            }
        }
    }

    void assertSystemCatalogIndexHaveViewHeaders(String systemCatalogIndexName, String tenantId, String schemaName, String tableName, boolean exists) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            String viewStmt;
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "\":TENANT_ID\" IS NULL" : String.format("\":TENANT_ID\" = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_IDX_VIEW_HEADER_SQL, systemCatalogIndexName, tenantClause, schemaName, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            String string = viewStmt = rs.next() ? rs.getString(1) : null;
            if (exists) {
                Assert.assertNotNull((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (Object)viewStmt);
            } else {
                Assert.assertNull((String)String.format("Zero rows expected for schema = %s, table = %s", schemaName, tableName), (Object)viewStmt);
            }
        }
    }

    void assertSystemCatalogIndexHaveViewIndexHeaders(String systemCatalogIndexName, String tenantId, String schemaName, String tableName, boolean exists) throws SQLException {
        try (Connection connection = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            Integer viewIndexId;
            Statement stmt = connection.createStatement();
            String tenantClause = tenantId == null || tenantId.isEmpty() ? "\":TENANT_ID\" IS NULL" : String.format("\":TENANT_ID\" = '%s'", tenantId);
            String sql = String.format(SYS_CATALOG_IDX_VIEW_INDEX_HEADER_SQL, systemCatalogIndexName, tenantClause, schemaName, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            Integer n = viewIndexId = rs.next() ? Integer.valueOf(rs.getInt(1)) : null;
            if (exists) {
                Assert.assertNotNull((String)String.format("Expected rows do not match for schema = %s, table = %s", schemaName, tableName), (Object)viewIndexId);
            } else {
                Assert.assertNull((String)String.format("Zero rows expected for schema = %s, table = %s", schemaName, tableName), (Object)viewIndexId);
            }
        }
    }

    void dropSystemCatalogIndex(String sysIndexName) throws SQLException {
        try (Connection conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(String.format("drop index %s ON SYSTEM.CATALOG", sysIndexName));
            conn.commit();
        }
    }

    void alterIndexState(String indexName, String tableName, PIndexState newState) throws SQLException {
        try (Connection conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(String.format("alter index %s ON %s %s", indexName, tableName, newState.name()));
            conn.commit();
        }
    }

    void dropTableWithChildViews(String baseTable, int numTaskRuns) throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            conn.setAutoCommit(true);
            conn.createStatement().execute("DELETE  FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME);
            String dropTableSQL = String.format("DROP TABLE IF EXISTS %s CASCADE", baseTable);
            conn.createStatement().execute(dropTableSQL);
            TaskRegionObserver.SelfHealingTask task = new TaskRegionObserver.SelfHealingTask(taskRegionEnvironment, 1800000L);
            for (int i = 0; i < numTaskRuns; ++i) {
                task.run();
            }
            PartialSystemCatalogIndexIT.assertTaskColumns(conn, PTable.TaskStatus.COMPLETED.toString(), PTable.TaskType.DROP_CHILD_VIEWS, null, null, null, null, null);
            TableName linkTable = TableName.valueOf((byte[])PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES);
            TableViewFinderResult childViewsResult = new TableViewFinderResult();
            ViewUtil.findAllRelatives((Table)PartialSystemCatalogIndexIT.getUtility().getConnection().getTable(linkTable), (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])SchemaUtil.getSchemaNameFromFullName((String)baseTable).getBytes(), (byte[])SchemaUtil.getTableNameFromFullName((String)baseTable).getBytes(), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)childViewsResult);
            Assert.assertEquals((long)0L, (long)childViewsResult.getLinks().size());
        }
    }

    static void assertTaskColumns(Connection conn, String expectedStatus, PTable.TaskType taskType, String expectedTableName, String expectedTenantId, String expectedSchema, Timestamp expectedTs, String expectedIndexName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT *  FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " WHERE TASK_TYPE = " + taskType.getSerializedValue());
        Assert.assertTrue((boolean)rs.next());
        String taskStatus = rs.getString("TASK_STATUS");
        Assert.assertEquals((Object)expectedStatus, (Object)taskStatus);
        if (expectedTableName != null) {
            String tableName = rs.getString("TABLE_NAME");
            Assert.assertEquals((Object)expectedTableName, (Object)tableName);
        }
        if (expectedTenantId != null) {
            String tenantId = rs.getString("TENANT_ID");
            Assert.assertEquals((Object)expectedTenantId, (Object)tenantId);
        }
        if (expectedSchema != null) {
            String schema = rs.getString("TABLE_SCHEM");
            Assert.assertEquals((Object)expectedSchema, (Object)schema);
        }
        if (expectedTs != null) {
            Timestamp ts = rs.getTimestamp("TASK_TS");
            Assert.assertEquals((Object)expectedTs, (Object)ts);
        }
        if (expectedIndexName != null) {
            String data = rs.getString("TASK_DATA");
            Assert.assertEquals((Object)true, (Object)data.contains("\"IndexName\":\"" + expectedIndexName));
        }
    }

    private List<String> getExplain(String query, Properties props) throws SQLException {
        ArrayList<String> explainPlan = new ArrayList<String>();
        try (Connection conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement("EXPLAIN " + query);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                String plan = rs.getString(1);
                explainPlan.add(plan);
            }
        }
        return explainPlan;
    }

    protected PhoenixTestBuilder.SchemaBuilder createLevel2TenantViewWithGlobalLevelTTL(int globalTTL, PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions, PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions, boolean allowIndex) throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(PartialSystemCatalogIndexIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true");
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL=%d", globalTTL));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        globalViewIndexOptions.setLocal(false);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewWithOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        if (tenantViewOptions != null) {
            tenantViewWithOverrideOptions = tenantViewOptions;
        }
        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
        if (tenantViewIndexOptions != null) {
            tenantViewIndexOverrideOptions = tenantViewIndexOptions;
        }
        if (allowIndex) {
            schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewWithOverrideOptions).withTenantViewIndexOptions(tenantViewIndexOverrideOptions).buildWithNewTenant();
        } else {
            schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withTenantViewOptions(tenantViewWithOverrideOptions).buildWithNewTenant();
        }
        return schemaBuilder;
    }

    protected PhoenixTestBuilder.SchemaBuilder createLevel1TenantView(PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions, PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions) throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(PartialSystemCatalogIndexIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true");
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        if (tenantViewOptions != null) {
            tenantViewOverrideOptions = tenantViewOptions;
        }
        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
        if (tenantViewIndexOptions != null) {
            tenantViewIndexOverrideOptions = tenantViewIndexOptions;
        }
        schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOverrideOptions).withTenantViewIndexOptions(tenantViewIndexOverrideOptions).buildNewView();
        return schemaBuilder;
    }

    @Test
    public void testIndexesOfIndexTableLinkTypeAndIndexHdrCondition() throws Exception {
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
        tenantViewOptions.setTenantViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel2TenantViewWithGlobalLevelTTL(300, tenantViewOptions, null, true);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String fullBaseTableName = schemaBuilder.getEntityTableName();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewName()));
        String fullGlobalViewName = schemaBuilder.getEntityGlobalViewName();
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalIndexName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewIndexName()));
        String tenantIndexName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewIndexName()));
        this.assertSystemCatalogHasViewHeaderRelatedColumns("", schemaName, globalViewName, true, 300L);
        this.assertSystemCatalogHasViewHeaderRelatedColumns(tenantId, schemaName, tenantViewName, true, 0L);
        this.assertSystemCatalogHasIndexTableLinks(null, schemaName, globalViewName);
        this.assertSystemCatalogHasIndexTableLinks(tenantId, schemaName, tenantViewName);
        this.assertSystemCatalogHasIndexHdr(null, schemaName, globalIndexName);
        this.assertSystemCatalogHasIndexHdr(tenantId, schemaName, tenantIndexName);
        try (Connection conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(SYS_INDEX_TABLE_LINK_TEST_INDEX_SQL);
            stmt.execute(SYS_INDEX_HDR_TEST_INDEX_SQL);
            conn.commit();
        }
        LOGGER.info("Finished creating index: " + SYS_INDEX_TABLE_LINK_TEST_INDEX_SQL);
        LOGGER.info("Finished creating index: " + SYS_INDEX_HDR_TEST_INDEX_SQL);
        this.assertSystemCatalogIndexTable(SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, true);
        this.assertSystemCatalogIndexTable(SYS_INDEX_HDR_TEST_INDEX_NAME, true);
        this.assertSystemCatalogIndexHaveIndexTableLinks(FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, null, schemaName, globalViewName, true, globalIndexName);
        this.assertSystemCatalogIndexHaveIndexTableLinks(FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, true, tenantIndexName);
        this.assertSystemCatalogIndexHaveIndexHdr(FULL_SYS_INDEX_HDR_TEST_INDEX_NAME, null, schemaName, globalViewName, true, globalIndexName, PIndexState.ACTIVE.getSerializedValue());
        this.assertSystemCatalogIndexHaveIndexHdr(FULL_SYS_INDEX_HDR_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, true, tenantIndexName, PIndexState.ACTIVE.getSerializedValue());
        this.alterIndexState(globalIndexName, fullGlobalViewName, PIndexState.UNUSABLE);
        this.assertSystemCatalogIndexHaveIndexHdr(FULL_SYS_INDEX_HDR_TEST_INDEX_NAME, null, schemaName, globalViewName, true, globalIndexName, PIndexState.INACTIVE.getSerializedValue());
        this.alterIndexState(globalIndexName, fullGlobalViewName, PIndexState.REBUILD);
        this.assertSystemCatalogIndexHaveIndexHdr(FULL_SYS_INDEX_HDR_TEST_INDEX_NAME, null, schemaName, globalViewName, true, globalIndexName, PIndexState.ACTIVE.getSerializedValue());
        LOGGER.info("Dropping base table " + fullBaseTableName);
        this.dropTableWithChildViews(fullBaseTableName, 2);
        this.assertSystemCatalogHasViewHeaderRelatedColumns("", schemaName, globalViewName, false, 300L);
        this.assertSystemCatalogHasViewHeaderRelatedColumns(tenantId, schemaName, tenantViewName, false, 0L);
        this.assertSystemCatalogIndexHaveIndexTableLinks(FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, null, schemaName, globalViewName, false, null);
        this.assertSystemCatalogIndexHaveIndexTableLinks(FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, false, null);
        this.assertSystemCatalogIndexHaveIndexHdr(FULL_SYS_INDEX_HDR_TEST_INDEX_NAME, null, schemaName, null, false, globalIndexName, null);
        this.assertSystemCatalogIndexHaveIndexHdr(FULL_SYS_INDEX_HDR_TEST_INDEX_NAME, tenantId, schemaName, null, false, tenantIndexName, null);
        this.dropSystemCatalogIndex(SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME);
        this.dropSystemCatalogIndex(SYS_INDEX_HDR_TEST_INDEX_NAME);
        this.assertSystemCatalogIndexTable(FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, false);
        this.assertSystemCatalogIndexTable(FULL_SYS_INDEX_HDR_TEST_INDEX_NAME, false);
    }

    @Test
    public void testIndexesOfViewAndIndexHeadersCondition() throws Exception {
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        tenantViewOptions.setTableProps(String.format("TTL=%d", 120));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel1TenantView(tenantViewOptions, null);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String fullBaseTableName = schemaBuilder.getEntityTableName();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String indexOnTenantViewName = String.format("IDX_%s", this.stripQuotes(schemaBuilder.getEntityKeyPrefix()));
        this.assertSystemCatalogHasViewHeaderRelatedColumns(tenantId, schemaName, tenantViewName, true, 120L);
        this.assertSystemCatalogHasViewIndexHeaderRelatedColumns(tenantId, schemaName, indexOnTenantViewName, true);
        this.assertSystemCatalogHasRowKeyMatcherRelatedColumns(tenantId, schemaName, tenantViewName, true);
        try (Connection conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(SYS_VIEW_HDR_TEST_INDEX_SQL);
            stmt.execute(SYS_ROW_KEY_MATCHER_TEST_INDEX_SQL);
            stmt.execute(SYS_VIEW_INDEX_HDR_TEST_INDEX_SQL);
            conn.commit();
        }
        LOGGER.info("Finished creating index: " + SYS_VIEW_HDR_TEST_INDEX_SQL);
        LOGGER.info("Finished creating index: " + SYS_ROW_KEY_MATCHER_TEST_INDEX_SQL);
        LOGGER.info("Finished creating index: " + SYS_VIEW_INDEX_HDR_TEST_INDEX_SQL);
        this.assertSystemCatalogIndexTable(SYS_VIEW_HDR_TEST_INDEX_NAME, true);
        this.assertSystemCatalogIndexTable(SYS_VIEW_INDEX_HDR_TEST_INDEX_NAME, true);
        this.assertSystemCatalogIndexTable(SYS_ROW_KEY_MATCHER_TEST_INDEX_NAME, true);
        this.assertSystemCatalogIndexHaveViewHeaders(FULL_SYS_VIEW_HDR_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, true);
        this.assertSystemCatalogIndexHaveViewHeaders(FULL_SYS_ROW_KEY_MATCHER_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, true);
        this.assertSystemCatalogIndexHaveViewIndexHeaders(FULL_SYS_VIEW_INDEX_HDR_TEST_INDEX_NAME, tenantId, schemaName, indexOnTenantViewName, true);
        List<String> plans = this.getExplain("select TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, TABLE_TYPE FROM SYSTEM.CATALOG WHERE TABLE_TYPE = 'v' ", new Properties());
        Assert.assertEquals((Object)String.format("CLIENT PARALLEL 1-WAY FULL SCAN OVER %s", FULL_SYS_VIEW_HDR_TEST_INDEX_NAME), (Object)plans.get(0));
        plans = this.getExplain("select VIEW_INDEX_ID, VIEW_INDEX_ID_DATA_TYPE FROM SYSTEM.CATALOG WHERE TABLE_TYPE = 'i' AND LINK_TYPE IS NULL AND VIEW_INDEX_ID IS NOT NULL", new Properties());
        Assert.assertEquals((Object)String.format("CLIENT PARALLEL 1-WAY FULL SCAN OVER %s", FULL_SYS_VIEW_INDEX_HDR_TEST_INDEX_NAME), (Object)plans.get(0));
        plans = this.getExplain("select ROW_KEY_MATCHER, TTL, TABLE_NAME FROM SYSTEM.CATALOG WHERE TABLE_TYPE = 'v' AND ROW_KEY_MATCHER IS NOT NULL", new Properties());
        Assert.assertEquals((Object)String.format("CLIENT PARALLEL 1-WAY RANGE SCAN OVER %s [not null]", FULL_SYS_ROW_KEY_MATCHER_TEST_INDEX_NAME), (Object)plans.get(0));
        LOGGER.info("Dropping base table " + fullBaseTableName);
        this.dropTableWithChildViews(fullBaseTableName, 2);
        this.assertSystemCatalogHasViewHeaderRelatedColumns(tenantId, schemaName, tenantViewName, false, 120L);
        this.assertSystemCatalogHasRowKeyMatcherRelatedColumns(tenantId, schemaName, tenantViewName, false);
        this.assertSystemCatalogHasViewIndexHeaderRelatedColumns(tenantId, schemaName, tenantViewName, false);
        this.assertSystemCatalogIndexHaveViewHeaders(FULL_SYS_VIEW_HDR_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, false);
        this.assertSystemCatalogIndexHaveViewHeaders(FULL_SYS_ROW_KEY_MATCHER_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, false);
        this.assertSystemCatalogIndexHaveViewIndexHeaders(FULL_SYS_VIEW_INDEX_HDR_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, false);
        this.dropSystemCatalogIndex(SYS_VIEW_HDR_TEST_INDEX_NAME);
        this.dropSystemCatalogIndex(SYS_ROW_KEY_MATCHER_TEST_INDEX_NAME);
        this.dropSystemCatalogIndex(SYS_VIEW_INDEX_HDR_TEST_INDEX_NAME);
        this.assertSystemCatalogIndexTable(FULL_SYS_VIEW_HDR_TEST_INDEX_NAME, false);
        this.assertSystemCatalogIndexTable(FULL_SYS_ROW_KEY_MATCHER_TEST_INDEX_NAME, false);
        this.assertSystemCatalogIndexTable(FULL_SYS_VIEW_INDEX_HDR_TEST_INDEX_NAME, false);
    }

    @Test
    public void testIndexesOnOtherSystemTables() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());
             Statement stmt = conn.createStatement();){
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS SYS_INDEX_LINK_4_IDX ON SYSTEM.CHILD_LINK(TENANT_ID, TABLE_SCHEM, TABLE_NAME, LINK_TYPE) WHERE LINK_TYPE = 4");
                Assert.fail();
            }
            catch (SQLException sqle) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_INDEX_SYSTEM_TABLE.getErrorCode(), (long)sqle.getErrorCode());
            }
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS SYS_INDEX_STATS_IDX ON SYSTEM.STATS(PHYSICAL_NAME, COLUMN_FAMILY, GUIDE_POST_WIDTH, GUIDE_POSTS_ROW_COUNT) WHERE COLUMN_FAMILY = '4'");
                Assert.fail();
            }
            catch (SQLException sqle) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_INDEX_SYSTEM_TABLE.getErrorCode(), (long)sqle.getErrorCode());
            }
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS SYS_INDEX_LOG_IDX ON SYSTEM.LOG(USER, CLIENT_IP, QUERY) WHERE QUERY_ID = '4'");
                Assert.fail();
            }
            catch (SQLException sqle) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_INDEX_SYSTEM_TABLE.getErrorCode(), (long)sqle.getErrorCode());
            }
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS SYS_INDEX_FUNCTION_IDX ON SYSTEM.FUNCTION(CLASS_NAME,JAR_PATH) WHERE FUNCTION_NAME = '4'");
                Assert.fail();
            }
            catch (SQLException sqle) {
                Assert.assertEquals((long)SQLExceptionCode.MISMATCHED_TOKEN.getErrorCode(), (long)sqle.getErrorCode());
            }
        }
    }

    @Test
    @Ignore
    public void testAddColumnWithCascadeOnMetaIndexes() throws Exception {
        Statement stmt;
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
        tenantViewOptions.setTenantViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel2TenantViewWithGlobalLevelTTL(300, tenantViewOptions, null, true);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String fullBaseTableName = schemaBuilder.getEntityTableName();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewName()));
        String fullGlobalViewName = schemaBuilder.getEntityGlobalViewName();
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalIndexName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewIndexName()));
        String tenantIndexName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewIndexName()));
        this.assertSystemCatalogHasViewHeaderRelatedColumns("", schemaName, globalViewName, true, 300L);
        this.assertSystemCatalogHasViewHeaderRelatedColumns(tenantId, schemaName, tenantViewName, true, 0L);
        this.assertSystemCatalogHasIndexTableLinks(null, schemaName, globalViewName);
        this.assertSystemCatalogHasIndexTableLinks(tenantId, schemaName, tenantViewName);
        this.assertSystemCatalogHasIndexHdr(null, schemaName, globalIndexName);
        this.assertSystemCatalogHasIndexHdr(tenantId, schemaName, tenantIndexName);
        try (Connection conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());){
            stmt = conn.createStatement();
            try {
                stmt.execute(SYS_INDEX_TABLE_LINK_TEST_INDEX_SQL);
                stmt.execute(SYS_INDEX_HDR_TEST_INDEX_SQL);
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        LOGGER.info("Finished creating index: " + SYS_INDEX_TABLE_LINK_TEST_INDEX_SQL);
        LOGGER.info("Finished creating index: " + SYS_INDEX_HDR_TEST_INDEX_SQL);
        this.assertSystemCatalogIndexTable(SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, true);
        this.assertSystemCatalogIndexTable(SYS_INDEX_HDR_TEST_INDEX_NAME, true);
        this.assertSystemCatalogIndexHaveIndexTableLinks(FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, null, schemaName, globalViewName, true, globalIndexName);
        this.assertSystemCatalogIndexHaveIndexTableLinks(FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, tenantId, schemaName, tenantViewName, true, tenantIndexName);
        conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());
        try {
            stmt = conn.createStatement();
            try {
                stmt.execute("ALTER TABLE SYSTEM.CATALOG ADD IF NOT EXISTS TEST_COL1 INTEGER DEFAULT 5 CASCADE INDEX ALL");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        this.assertAdditionalColumnInMetaIndexTable("SYSTEM", SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, "0:TEST_COL1", true);
        this.assertAdditionalColumnInMetaIndexTable("SYSTEM", SYS_INDEX_HDR_TEST_INDEX_NAME, "0:TEST_COL1", true);
        conn = DriverManager.getConnection(PartialSystemCatalogIndexIT.getUrl());
        try {
            stmt = conn.createStatement();
            try {
                stmt.execute("ALTER TABLE SYSTEM.CATALOG DROP COLUMN TEST_COL1");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        this.assertAdditionalColumnInMetaIndexTable("SYSTEM", SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, "0:TEST_COL1", false);
        this.assertAdditionalColumnInMetaIndexTable("SYSTEM", SYS_INDEX_HDR_TEST_INDEX_NAME, "0:TEST_COL1", false);
        this.dropSystemCatalogIndex(SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME);
        this.dropSystemCatalogIndex(SYS_INDEX_HDR_TEST_INDEX_NAME);
        this.assertSystemCatalogIndexTable(FULL_SYS_INDEX_TABLE_LINK_TEST_INDEX_NAME, false);
        this.assertSystemCatalogIndexTable(FULL_SYS_INDEX_HDR_TEST_INDEX_NAME, false);
    }
}

