/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.Repeat;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PartialIndexRebuilderIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartialIndexRebuilderIT.class);
    private static final Random RAND = new Random(5L);
    private static final int WAIT_AFTER_DISABLED = 5000;
    private static final long REBUILD_PERIOD = 50000L;
    private static final long REBUILD_INTERVAL = 2000L;
    private static RegionCoprocessorEnvironment indexRebuildTaskRegionEnvironment;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)10);
        serverProps.put("phoenix.index.failure.handling.rebuild", Boolean.TRUE.toString());
        serverProps.put("phoenix.index.failure.handling.rebuild.interval", Long.toString(2000L));
        serverProps.put("phoenix.index.rebuild.disabletimestamp.threshold", "50000000");
        serverProps.put("phoenix.index.failure.handling.rebuild.period", Long.toString(50000L));
        serverProps.put("phoenix.index.failure.handling.rebuild.overlap.forward.time", Long.toString(5000L));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("hbase.client.retries.number", "2");
        clientProps.put("phoenix.index.region.observer.enabled", Boolean.FALSE.toString());
        PartialIndexRebuilderIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        indexRebuildTaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)PartialIndexRebuilderIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(MetaDataRegionObserver.class.getName());
        MetaDataRegionObserver.initRebuildIndexConnectionProps((Configuration)indexRebuildTaskRegionEnvironment.getConfiguration());
    }

    @After
    public void cleanup() {
        EnvironmentEdgeManager.reset();
    }

    private static void runIndexRebuilder(String table) throws InterruptedException, SQLException {
        PartialIndexRebuilderIT.runIndexRebuilder(Collections.singletonList(table));
    }

    private static void runIndexRebuilder(List<String> tables) throws InterruptedException, SQLException {
        MetaDataRegionObserver.BuildIndexScheduleTask task = new MetaDataRegionObserver.BuildIndexScheduleTask(indexRebuildTaskRegionEnvironment, tables);
        task.run();
    }

    private static void runIndexRebuilderAsync(int interval, boolean[] cancel, String table) {
        PartialIndexRebuilderIT.runIndexRebuilderAsync(interval, cancel, Collections.singletonList(table));
    }

    private static void runIndexRebuilderAsync(final int interval, final boolean[] cancel, final List<String> tables) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!cancel[0]) {
                    try {
                        PartialIndexRebuilderIT.runIndexRebuilder(tables);
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        throw new RuntimeException(e);
                    }
                    catch (SQLException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private static void mutateRandomly(final String fullTableName, int nThreads, final int nRows, final int nIndexValues, final int batchSize, final CountDownLatch doneSignal) {
        int i;
        Runnable[] runnables = new Runnable[nThreads];
        for (i = 0; i < nThreads; ++i) {
            runnables[i] = new Runnable(){

                @Override
                public void run() {
                    try {
                        int i;
                        Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());
                        for (i = 0; i < 3000; ++i) {
                            boolean isNull = RAND.nextBoolean();
                            int randInt = RAND.nextInt() % nIndexValues;
                            int pk = Math.abs(RAND.nextInt()) % nRows;
                            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES (" + pk + ", 0, " + (isNull ? null : Integer.valueOf(randInt)) + ")");
                            if (i % batchSize != 0) continue;
                            conn.commit();
                        }
                        conn.commit();
                        for (i = 0; i < 3000; ++i) {
                            int pk = Math.abs(RAND.nextInt()) % nRows;
                            conn.createStatement().execute("DELETE FROM " + fullTableName + " WHERE k1= " + pk + " AND k2=0");
                            if (i % batchSize != 0) continue;
                            conn.commit();
                        }
                        conn.commit();
                        for (i = 0; i < 3000; ++i) {
                            int randInt = RAND.nextInt() % nIndexValues;
                            int pk = Math.abs(RAND.nextInt()) % nRows;
                            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES (" + pk + ", 0, " + randInt + ")");
                            if (i % batchSize != 0) continue;
                            conn.commit();
                        }
                        conn.commit();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
        }
        for (i = 0; i < nThreads; ++i) {
            Thread t = new Thread(runnables[i]);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentUpsertsWithRebuild() throws Throwable {
        int nThreads = 5;
        int batchSize = 200;
        int nRows = 51;
        int nIndexValues = 23;
        String schemaName = "";
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"", (String)indexName);
        Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());
        Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
        conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 INTEGER, CONSTRAINT pk PRIMARY KEY (k1,k2)) STORE_NULLS=true, VERSIONS=1");
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + "(v1)");
        CountDownLatch doneSignal1 = new CountDownLatch(nThreads);
        PartialIndexRebuilderIT.mutateRandomly(fullTableName, nThreads, 51, 23, 200, doneSignal1);
        Assert.assertTrue((String)"Ran out of time", (boolean)doneSignal1.await(120L, TimeUnit.SECONDS));
        IndexUtil.updateIndexState((String)fullIndexName, (long)EnvironmentEdgeManager.currentTimeMillis(), (Table)metaTable, (PIndexState)PIndexState.DISABLE);
        boolean[] cancel = new boolean[1];
        try {
            do {
                CountDownLatch doneSignal2 = new CountDownLatch(nThreads);
                PartialIndexRebuilderIT.runIndexRebuilderAsync(500, cancel, fullTableName);
                PartialIndexRebuilderIT.mutateRandomly(fullTableName, nThreads, 51, 23, 200, doneSignal2);
                Assert.assertTrue((String)"Ran out of time", (boolean)doneSignal2.await(500L, TimeUnit.SECONDS));
            } while (!TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
        }
        finally {
            cancel[0] = true;
        }
        long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        Assert.assertEquals((long)51L, (long)actualRowCount);
    }

    private static boolean mutateRandomly(Connection conn, String fullTableName, int nRows) throws Exception {
        return PartialIndexRebuilderIT.mutateRandomly(conn, fullTableName, nRows, false, null);
    }

    private static boolean hasInactiveIndex(PMetaData metaCache, PTableKey key) throws TableNotFoundException {
        PTable table = metaCache.getTableRef(key).getTable();
        for (PTable index : table.getIndexes()) {
            if (index.getIndexState() != PIndexState.INACTIVE) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDisabledIndex(PMetaData metaCache, PTableKey key) throws TableNotFoundException {
        return PartialIndexRebuilderIT.hasIndexWithState(metaCache, key, PIndexState.DISABLE);
    }

    private static boolean hasIndexWithState(PMetaData metaCache, PTableKey key, PIndexState expectedState) throws TableNotFoundException {
        PTable table = metaCache.getTableRef(key).getTable();
        for (PTable index : table.getIndexes()) {
            if (index.getIndexState() != expectedState) continue;
            return true;
        }
        return false;
    }

    private static boolean mutateRandomly(Connection conn, String fullTableName, int nRows, boolean checkForInactive, String fullIndexName) throws SQLException, InterruptedException {
        int v2;
        int v1;
        int pk;
        int i;
        PTableKey key = new PTableKey(null, fullTableName);
        PMetaData metaCache = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
        boolean hasInactiveIndex = false;
        int batchSize = 200;
        if (checkForInactive) {
            batchSize = 3;
        }
        for (i = 0; i < 10000; ++i) {
            pk = Math.abs(RAND.nextInt()) % nRows;
            v1 = Math.abs(RAND.nextInt()) % nRows;
            v2 = Math.abs(RAND.nextInt()) % nRows;
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES(" + pk + "," + v1 + "," + v2 + ")");
            if (i % batchSize != 0) continue;
            conn.commit();
            if (!checkForInactive || !PartialIndexRebuilderIT.hasInactiveIndex(metaCache, key)) continue;
            checkForInactive = false;
            hasInactiveIndex = true;
            batchSize = 200;
        }
        conn.commit();
        for (i = 0; i < 10000; ++i) {
            pk = Math.abs(RAND.nextInt()) % nRows;
            conn.createStatement().execute("DELETE FROM " + fullTableName + " WHERE k= " + pk);
            if (i % batchSize != 0) continue;
            conn.commit();
            if (!checkForInactive || !PartialIndexRebuilderIT.hasInactiveIndex(metaCache, key)) continue;
            checkForInactive = false;
            hasInactiveIndex = true;
            batchSize = 200;
        }
        conn.commit();
        for (i = 0; i < 10000; ++i) {
            pk = Math.abs(RAND.nextInt()) % nRows;
            v1 = Math.abs(RAND.nextInt()) % nRows;
            v2 = Math.abs(RAND.nextInt()) % nRows;
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES(" + pk + "," + v1 + "," + v2 + ")");
            if (i % batchSize != 0) continue;
            conn.commit();
            if (!checkForInactive || !PartialIndexRebuilderIT.hasInactiveIndex(metaCache, key)) continue;
            checkForInactive = false;
            hasInactiveIndex = true;
            batchSize = 200;
        }
        conn.commit();
        return hasInactiveIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Repeat(value=5)
    public void testDeleteAndUpsertAfterFailure() throws Throwable {
        int nRows = 10;
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k INTEGER PRIMARY KEY, v1 INTEGER, v2 INTEGER) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1) INCLUDE (v2)");
            PartialIndexRebuilderIT.mutateRandomly(conn, fullTableName, 10);
            long disableTS = EnvironmentEdgeManager.currentTimeMillis();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTS, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            boolean[] cancel = new boolean[1];
            try {
                PartialIndexRebuilderIT.runIndexRebuilderAsync(500, cancel, fullTableName);
                PartialIndexRebuilderIT.mutateRandomly(conn, fullTableName, 10);
                TestUtil.waitForIndexRebuild(conn, fullIndexName, PIndexState.ACTIVE);
            }
            finally {
                cancel[0] = true;
            }
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
            Assert.assertEquals((long)10L, (long)actualRowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWhileRebuilding() throws Throwable {
        int nRows = 10;
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        final String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        final String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k INTEGER PRIMARY KEY, v1 INTEGER, v2 INTEGER) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1) INCLUDE (v2)");
            PartialIndexRebuilderIT.mutateRandomly(conn, fullTableName, 10);
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            final boolean[] hasInactiveIndex = new boolean[1];
            final CountDownLatch doneSignal = new CountDownLatch(1);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
                        hasInactiveIndex[0] = PartialIndexRebuilderIT.mutateRandomly(conn, fullTableName, 10, true, fullIndexName);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.start();
            long disableTS = EnvironmentEdgeManager.currentTimeMillis();
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTS, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            boolean[] cancel = new boolean[1];
            try {
                PartialIndexRebuilderIT.runIndexRebuilderAsync(500, cancel, fullTableName);
                TestUtil.waitForIndexRebuild(conn, fullIndexName, PIndexState.ACTIVE);
                doneSignal.await(60L, TimeUnit.SECONDS);
            }
            finally {
                cancel[0] = true;
            }
            Assert.assertTrue((boolean)hasInactiveIndex[0]);
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
            Assert.assertEquals((long)10L, (long)actualRowCount);
        }
    }

    @Test
    public void testMultiVersionsAfterFailure() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','bb')");
            conn.commit();
            long disableTS = EnvironmentEdgeManager.currentTimeMillis();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTS, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc')");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','dddd')");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','eeeee')");
            conn.commit();
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Thread.sleep(5000L);
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
    }

    @Test
    public void testUpsertNullAfterFailure() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a')");
            conn.commit();
            long disableTS = EnvironmentEdgeManager.currentTimeMillis();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTS, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a',null)");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','bb')");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc')");
            conn.commit();
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Thread.sleep(5000L);
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
    }

    @Test
    public void testUpsertNullTwiceAfterFailure() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a',null)");
            conn.commit();
            long disableTS = EnvironmentEdgeManager.currentTimeMillis();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTS, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','bb')");
            conn.commit();
            conn.createStatement().execute("DELETE FROM " + fullTableName);
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a',null)");
            conn.commit();
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Thread.sleep(5000L);
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
    }

    @Test
    public void testDeleteAfterFailure() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a',null)");
            conn.commit();
            long disableTS = EnvironmentEdgeManager.currentTimeMillis();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTS, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','b')");
            conn.commit();
            conn.createStatement().execute("DELETE FROM " + fullTableName);
            conn.commit();
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Thread.sleep(5000L);
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
    }

    @Test
    public void testDeleteBeforeFailure() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a',null)");
            conn.commit();
            conn.createStatement().execute("DELETE FROM " + fullTableName);
            conn.commit();
            long disableTS = EnvironmentEdgeManager.currentTimeMillis();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTS, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','b')");
            conn.commit();
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Thread.sleep(5000L);
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
    }

    private static void waitForIndexState(Connection conn, String fullTableName, String fullIndexName, PIndexState expectedIndexState) throws InterruptedException, SQLException {
        int nRetries = 2;
        PIndexState actualIndexState = null;
        do {
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            actualIndexState = TestUtil.getIndexState(conn, fullIndexName);
            if (actualIndexState == expectedIndexState) {
                return;
            }
            Thread.sleep(1000L);
        } while (--nRetries > 0);
        Assert.fail((String)("Expected index state of " + expectedIndexState + ", but was " + actualIndexState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiValuesAtSameTS() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a')");
            conn.commit();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)clock.currentTime(), (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            clock.setAdvance(false);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','bb')");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc')");
            conn.commit();
            clock.setAdvance(true);
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.INACTIVE);
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.ACTIVE);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeBatchesInCoprocessorRequired() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        PTableKey key = new PTableKey(null, fullTableName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            PMetaData metaCache = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a','0')");
            conn.commit();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)0L, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            long disableTime = clock.currentTime();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('b','bb', '11')");
            conn.commit();
            Assert.assertTrue((boolean)PartialIndexRebuilderIT.hasDisabledIndex(metaCache, key));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullTableName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIndexName));
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc','0')");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a')");
            conn.commit();
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTime, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.INACTIVE);
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchingDuringRebuild() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        PTableKey key = new PTableKey(null, fullTableName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            PMetaData metaCache = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a','0')");
            conn.commit();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            long disableTime = clock.currentTime();
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTime, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('bb','bb', '11')");
            conn.commit();
            clock.time += 50000L;
            Assert.assertTrue((boolean)PartialIndexRebuilderIT.hasDisabledIndex(metaCache, key));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullTableName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIndexName));
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('ccc','ccc','222')");
            conn.commit();
            Assert.assertEquals((long)3L, (long)TestUtil.getRowCount(conn, fullTableName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIndexName));
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.INACTIVE);
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullIndexName));
            clock.time += 50000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpperBoundSetOnRebuild() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        PTableKey key = new PTableKey(null, fullTableName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            PMetaData metaCache = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)0L, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            long disableTime = clock.currentTime();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a', '0')");
            conn.commit();
            clock.time += 10000L;
            Assert.assertTrue((boolean)PartialIndexRebuilderIT.hasDisabledIndex(metaCache, key));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullTableName));
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, fullIndexName));
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('bb','bb','11')");
            conn.commit();
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullTableName));
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, fullIndexName));
            clock.time = disableTime + 100L;
            IndexUtil.updateIndexState((String)fullIndexName, (long)disableTime, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.INACTIVE);
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullTableName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIndexName));
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiValuesWhenDisableAndInactive() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        PTableKey key = new PTableKey(null, fullTableName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            PMetaData metaCache = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1, v2) INCLUDE (v3)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a','0','x')");
            conn.commit();
            try (Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);){
                IndexUtil.updateIndexState((String)fullIndexName, (long)0L, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
                long disableTime = clock.currentTime();
                conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('b','bb', '11','yy')");
                conn.commit();
                Assert.assertTrue((boolean)PartialIndexRebuilderIT.hasDisabledIndex(metaCache, key));
                conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc','222','zzz')");
                conn.commit();
                conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','dddd','3333','zzzz')");
                conn.commit();
                IndexUtil.updateIndexState((String)fullIndexName, (long)disableTime, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            }
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.INACTIVE, null));
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','eeeee','44444','zzzzz')");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','fffff','55555','zzzzzz')");
            conn.commit();
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    @Test
    public void testIndexWriteFailureDisablingIndex() throws Throwable {
        this.testIndexWriteFailureDuringRebuild(PIndexState.DISABLE);
    }

    @Test
    public void testIndexWriteFailureLeavingIndexActive() throws Throwable {
        this.testIndexWriteFailureDuringRebuild(PIndexState.PENDING_ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIndexWriteFailureDuringRebuild(PIndexState indexStateOnFailure) throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        PTableKey key = new PTableKey(null, fullTableName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            PMetaData metaCache = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR) COLUMN_ENCODED_BYTES = 0, DISABLE_INDEX_ON_WRITE_FAILURE = " + (indexStateOnFailure == PIndexState.DISABLE));
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a','0')");
            conn.commit();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            long disableTime = clock.currentTime();
            IndexUtil.updateIndexState((String)fullIndexName, (long)(indexStateOnFailure == PIndexState.DISABLE ? disableTime : -disableTime), (Table)metaTable, (PIndexState)indexStateOnFailure);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('bb','bb', '11')");
            conn.commit();
            clock.time += 100000L;
            Assert.assertTrue((boolean)PartialIndexRebuilderIT.hasIndexWithState(metaCache, key, indexStateOnFailure));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullTableName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIndexName));
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('ccc','ccc','222')");
            conn.commit();
            Assert.assertEquals((long)3L, (long)TestUtil.getRowCount(conn, fullTableName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIndexName));
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, indexStateOnFailure == PIndexState.DISABLE ? PIndexState.INACTIVE : PIndexState.ACTIVE);
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullIndexName));
            TestUtil.addCoprocessor(conn, fullIndexName, WriteFailingRegionObserver.class);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('dddd','dddd','3333')");
            try {
                conn.commit();
                Assert.fail();
            }
            catch (CommitException commitException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, indexStateOnFailure, null));
            PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
            ResultSet rs = stmt.executeQuery("SELECT V2 FROM " + fullTableName + " WHERE V1 = 'a'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0", (Object)rs.getString(1));
            Assert.assertEquals((Object)(indexStateOnFailure == PIndexState.DISABLE ? fullTableName : fullIndexName), (Object)stmt.getQueryPlan().getContext().getCurrentTable().getTable().getName().getString());
            TestUtil.removeCoprocessor(conn, fullIndexName, WriteFailingRegionObserver.class);
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, indexStateOnFailure == PIndexState.DISABLE ? PIndexState.INACTIVE : PIndexState.ACTIVE);
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertEquals((long)3L, (long)TestUtil.getRowCount(conn, fullIndexName));
            clock.time += 100000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            clock.time += 100000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            TestUtil.assertIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L);
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAndUpsertValuesAtSameTS1() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a')");
            conn.commit();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)clock.currentTime(), (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            clock.setAdvance(false);
            conn.createStatement().execute("DELETE FROM " + fullTableName + " WHERE k='a'");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc')");
            conn.commit();
            clock.setAdvance(true);
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.INACTIVE);
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAndUpsertValuesAtSameTS2() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a')");
            conn.commit();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)clock.currentTime(), (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            clock.setAdvance(false);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc')");
            conn.commit();
            conn.createStatement().execute("DELETE FROM " + fullTableName + " WHERE k='a'");
            conn.commit();
            clock.setAdvance(true);
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.INACTIVE);
            clock.time += 5000L;
            PartialIndexRebuilderIT.runIndexRebuilder(fullTableName);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    @Test
    public void testRegionsOnlineCheck() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        PTableKey key = new PTableKey(null, fullTableName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            PMetaData metaCache = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a')");
            conn.commit();
            Configuration conf = conn.unwrap(PhoenixConnection.class).getQueryServices().getConfiguration();
            PTable table = metaCache.getTableRef(key).getTable();
            Assert.assertTrue((boolean)MetaDataRegionObserver.tableRegionsOnline((Configuration)conf, (PTable)table));
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                admin.disableTable(TableName.valueOf((String)fullTableName));
                Assert.assertFalse((boolean)MetaDataRegionObserver.tableRegionsOnline((Configuration)conf, (PTable)table));
                admin.enableTable(TableName.valueOf((String)fullTableName));
            }
            Assert.assertTrue((boolean)MetaDataRegionObserver.tableRegionsOnline((Configuration)conf, (PTable)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPendingDisable() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR) COLUMN_ENCODED_BYTES = 0, DISABLE_INDEX_ON_WRITE_FAILURE = TRUE");
            clock.time += 100L;
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            clock.time += 100L;
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a','0')");
            conn.commit();
            clock.time += 100L;
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)clock.currentTime(), (Table)metaTable, (PIndexState)PIndexState.PENDING_DISABLE);
            Configuration conf = conn.unwrap(PhoenixConnection.class).getQueryServices().getConfiguration();
            PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
            ResultSet rs = stmt.executeQuery("SELECT V2 FROM " + fullTableName + " WHERE V1 = 'a'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0", (Object)rs.getString(1));
            Assert.assertEquals((Object)fullIndexName, (Object)stmt.getQueryPlan().getContext().getCurrentTable().getTable().getName().getString());
            long pendingDisableThreshold = conf.getLong("phoenix.index.pending.disable.threshold", 30000L);
            clock.time += pendingDisableThreshold + 1000L;
            stmt = conn.createStatement().unwrap(PhoenixStatement.class);
            rs = stmt.executeQuery("SELECT V2 FROM " + fullTableName + " WHERE V1 = 'a'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0", (Object)rs.getString(1));
            Assert.assertEquals((Object)fullTableName, (Object)stmt.getQueryPlan().getContext().getCurrentTable().getTable().getName().getString());
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.DISABLE);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexFailureWithinRSDoesnotDisablesIndex() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl());){
            try {
                conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR) DISABLE_INDEX_ON_WRITE_FAILURE = TRUE");
                conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
                conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a','0', 't')");
                conn.commit();
                TestUtil.addCoprocessor(conn, fullIndexName, WriteFailingRegionObserver.class);
                conn.setAutoCommit(true);
                try {
                    conn.createStatement().execute("DELETE FROM " + fullTableName);
                    Assert.fail();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Assert.assertFalse((boolean)TestUtil.checkIndexState(conn, fullIndexName, PIndexState.PENDING_ACTIVE, null));
            }
            finally {
                TestUtil.removeCoprocessor(conn, fullIndexName, WriteFailingRegionObserver.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPendingDisableWithDisableCountTs() throws Throwable {
        String schemaName = PartialIndexRebuilderIT.generateUniqueName();
        String tableName = PartialIndexRebuilderIT.generateUniqueName();
        String indexName = PartialIndexRebuilderIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        MyClock clock = new MyClock(EnvironmentEdgeManager.currentTimeMillis());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PartialIndexRebuilderIT.getUrl(), props);){
            conn.createStatement().execute(String.format("CREATE TABLE %s (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR, v4 VARCHAR) COLUMN_ENCODED_BYTES = 0, DISABLE_INDEX_ON_WRITE_FAILURE = TRUE", fullTableName));
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            clock.addTime(100L);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (v1, v2)", indexName, fullTableName));
            clock.addTime(100L);
            conn.createStatement().execute(String.format("UPSERT INTO %s VALUES('k01', 'v01', 'v02', 'v03', 'v04')", fullTableName));
            conn.commit();
            clock.addTime(100L);
            try (Table systemCatalog = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);){
                IndexUtil.updateIndexState((String)fullIndexName, (long)clock.currentTime(), (Table)systemCatalog, (PIndexState)PIndexState.PENDING_DISABLE);
            }
            Configuration conf = conn.unwrap(PhoenixConnection.class).getQueryServices().getConfiguration();
            PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
            ResultSet rs = stmt.executeQuery(String.format("SELECT V2 FROM %s WHERE V1 = 'v01'", fullTableName));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"v02", (Object)rs.getString(1));
            long pendingDisableThreshold = conf.getLong("phoenix.index.pending.disable.threshold", 30000L);
            long pendingDisableCountLastUpdatedTs = IndexUtil.getIndexPendingDisableCountLastUpdatedTimestamp((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (String)fullIndexName);
            clock.addTime(pendingDisableThreshold + pendingDisableCountLastUpdatedTs);
            stmt = conn.createStatement().unwrap(PhoenixStatement.class);
            rs = stmt.executeQuery(String.format("SELECT V2 FROM %s WHERE V1 = 'v01'", fullTableName));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"v02", (Object)rs.getString(1));
            Thread.sleep(1000L);
            PartialIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.DISABLE);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private static class MyClock
    extends EnvironmentEdge {
        public volatile long time;
        boolean shouldAdvance = true;

        public MyClock(long time) {
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long currentTime() {
            if (this.shouldAdvance) {
                MyClock myClock = this;
                synchronized (myClock) {
                    return this.time++;
                }
            }
            return this.time;
        }

        public void setAdvance(boolean val) {
            this.shouldAdvance = val;
        }

        private synchronized void addTime(long diff) {
            this.time += diff;
        }
    }

    public static class WriteFailingRegionObserver
    extends SimpleRegionObserver {
        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            EnvironmentEdge delegate = EnvironmentEdgeManager.getDelegate();
            if (delegate instanceof MyClock) {
                MyClock myClock = (MyClock)delegate;
                myClock.time += 1000L;
            }
            throw new DoNotRetryIOException("Simulating write failure on " + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().getTable().getNameAsString());
        }
    }
}

