/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class PartialIndexIT
extends BaseTest {
    private final boolean local;
    private final boolean uncovered;
    private final boolean salted;

    public PartialIndexIT(boolean local, boolean uncovered, boolean salted) {
        this.local = local;
        this.uncovered = uncovered;
        this.salted = salted;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        PartialIndexIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @After
    public void unsetFailForTesting() throws Exception {
        boolean refCountLeaked = PartialIndexIT.isAnyStoreRefCountLeaked();
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Parameterized.Parameters(name="local={0}, uncovered={1}, salted={2}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false, true}, {false, false, false}, {false, true, false}, {false, true, true});
    }

    public static void assertPlan(PhoenixResultSet rs, String schemaName, String tableName) {
        PTable table = rs.getContext().getCurrentTable().getTable();
        Assert.assertTrue((table.getSchemaName().getString().equals(schemaName) && table.getTableName().getString().equals(tableName) ? 1 : 0) != 0);
    }

    private static void verifyIndex(String dataTableName, String indexTableName) throws Exception {
        IndexTool indexTool = IndexToolIT.runIndexTool(false, "", dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
        Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).getValue());
        IndexToolIT.runIndexTool(false, "", dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-fi");
        CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(indexTool);
        Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT.name()).getValue());
        Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
        Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
    }

    @Test
    public void testUnsupportedDDLs() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer, C double, D varchar)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            String indexTableName = PartialIndexIT.generateUniqueName();
            try {
                conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE E > 50 ASYNC");
                Assert.fail();
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            try {
                conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE A  < ANY (SELECT B FROM " + dataTableName + ")");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getSQLState().equals("23101"));
            }
            try {
                conn.createStatement().execute("CREATE LOCAL INDEX " + indexTableName + " on " + dataTableName + " (A) WHERE A  > 0");
                Assert.fail();
            }
            catch (PhoenixParserException phoenixParserException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDDLWithAllDataTypes() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            String dataTableName = PartialIndexIT.generateUniqueName();
            String fullTableName = String.format("%s.%s", "S", dataTableName);
            conn.createStatement().execute("create table " + fullTableName + " (id varchar not null, kp varchar not null, A INTEGER, B UNSIGNED_INT, C BIGINT, D UNSIGNED_LONG, E TINYINT, F UNSIGNED_TINYINT, G SMALLINT, H UNSIGNED_SMALLINT, I FLOAT, J UNSIGNED_FLOAT, K DOUBLE, L UNSIGNED_DOUBLE, M DECIMAL, N BOOLEAN, O TIME, P DATE, Q TIMESTAMP, R UNSIGNED_TIME, S UNSIGNED_DATE, T UNSIGNED_TIMESTAMP, U CHAR(10), V BINARY(1024), W VARBINARY, Y INTEGER ARRAY, Z VARCHAR ARRAY[10], AA DATE ARRAY, AB TIMESTAMP ARRAY, AC UNSIGNED_TIME ARRAY, AD UNSIGNED_DATE ARRAY, AE UNSIGNED_TIMESTAMP ARRAY, AF JSON CONSTRAINT pk PRIMARY KEY (id,kp)) MULTI_TENANT=true, COLUMN_ENCODED_BYTES=0");
            String indexTableName = PartialIndexIT.generateUniqueName();
            try {
                conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX IF NOT EXISTS " + indexTableName + " on " + fullTableName + " (kp,A) WHERE (kp  > '5')");
            }
            catch (PhoenixParserException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    @Test
    public void testAtomicUpsert() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer, C double, D varchar)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            String indexTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1', 25, 2, 3.14, 'a')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D) values ('id2', 100, 'b')");
            conn.commit();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE A > 50 ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            String selectSql = "SELECT  D from " + dataTableName + " WHERE A > 60";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(indexTableName));
            selectSql = "SELECT  D from " + dataTableName + " WHERE A = 50";
            rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getString(1).contains(indexTableName));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id3', 50, 2, 9.5, 'c')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id4', 75, 2, 9.5, 'd')");
            conn.commit();
            selectSql = "SELECT * from " + indexTableName;
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)75L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)100L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            String dml = "UPSERT INTO " + dataTableName + " values ('id2', 300, 2, 9.5, 'd') ON DUPLICATE KEY UPDATE A = 0";
            conn.createStatement().execute(dml);
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)75L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT  ID from " + dataTableName + " WHERE A = 0";
            rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"id2", (Object)rs.getString(1));
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getString(1).contains(indexTableName));
            PartialIndexIT.verifyIndex(dataTableName, indexTableName);
            try (PhoenixConnection newConn = (PhoenixConnection)DriverManager.getConnection(PartialIndexIT.getUrl());){
                PTable indexTable = newConn.getTableNoCache(indexTableName);
                Assert.assertTrue((boolean)indexTable.getIndexWhere().equals("A > 50"));
            }
        }
    }

    @Test
    public void testComparisonOfColumns() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer, C double, D varchar) COLUMN_ENCODED_BYTES=0" + (this.salted ? ", SALT_BUCKETS=4" : ""));
            String indexTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1', 25, 2, 3.14, 'a')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, B, D) values ('id2', 100, 200, 'b')");
            conn.commit();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE A > B ASYNC");
            conn.commit();
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            String selectSql = "SELECT D from " + dataTableName + " WHERE A > B and D is not NULL";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(indexTableName));
            selectSql = "SELECT  D from " + dataTableName + " WHERE A > 100";
            rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getString(1).contains(indexTableName));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id3', 50, 300, 9.5, 'c')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id4', 75, 2, 9.5, 'd')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id4', 76, 2, 9.5, 'd')");
            conn.commit();
            selectSql = "SELECT * from " + indexTableName;
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)25L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)76L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("upsert into " + dataTableName + " (ID, B) values ('id1', 100)");
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)76L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            PartialIndexIT.verifyIndex(dataTableName, indexTableName);
            try (PhoenixConnection newConn = (PhoenixConnection)DriverManager.getConnection(PartialIndexIT.getUrl());){
                PTable indexTable = newConn.getTableNoCache(indexTableName);
                Assert.assertTrue((boolean)indexTable.getIndexWhere().equals("A > B"));
            }
        }
    }

    @Test
    public void testIsNull() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer, C double, D varchar)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            String indexTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1', 70, 2, 3.14, 'a')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D) values ('id2', 100, 'b')");
            conn.commit();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE B IS NOT NULL AND C IS NOT NULL ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            String selectSql = "SELECT A, D from " + dataTableName + " WHERE A > 60 AND B IS NOT NULL AND C IS NOT NULL";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)70L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(indexTableName));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id3', 20, 2, 3.14, 'a')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id4', 90, 2, 3.14, 'a')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D) values ('id5', 150, 'b')");
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)70L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)90L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT Count(*) from " + dataTableName);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("EXPLAIN SELECT Count(*) from " + dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getString(1).contains(indexTableName));
            conn.createStatement().execute("upsert into " + dataTableName + " (ID, B) values ('id4', null)");
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)70L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            PartialIndexIT.verifyIndex(dataTableName, indexTableName);
            try (PhoenixConnection newConn = (PhoenixConnection)DriverManager.getConnection(PartialIndexIT.getUrl());){
                PTable indexTable = newConn.getTableNoCache(indexTableName);
                Assert.assertTrue((boolean)indexTable.getIndexWhere().equals("(B IS NOT NULL  AND C IS NOT NULL )"));
            }
        }
    }

    @Test
    public void testLike() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer, C double, D varchar)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            String indexTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1', 70, 2, 3.14, 'abcdef')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D) values ('id2', 100, 'bcdez')");
            conn.commit();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE D like '%cde_' ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            String selectSql = "SELECT D from " + dataTableName + " WHERE B is not NULL AND D like '%cde_'";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcdef", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(indexTableName));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id3', 20, 2, 3.14, 'abcdegg')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id4', 10, 2, 3.14, 'aabecdeh')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D) values ('id5', 150, 'bbbb')");
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aabecdeh", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcdef", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT Count(*) from " + dataTableName;
            rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getString(1).contains(indexTableName));
            conn.createStatement().execute("upsert into " + dataTableName + " (id, D) values ('id4',  'zzz')");
            conn.commit();
            selectSql = "SELECT D from " + dataTableName + " WHERE B is not NULL AND D like '%cde_'";
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcdef", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            PartialIndexIT.verifyIndex(dataTableName, indexTableName);
            try (PhoenixConnection newConn = (PhoenixConnection)DriverManager.getConnection(PartialIndexIT.getUrl());){
                PTable indexTable = newConn.getTableNoCache(indexTableName);
                Assert.assertTrue((boolean)indexTable.getIndexWhere().equals("D LIKE '%cde_'"));
            }
        }
    }

    @Test
    public void testPhoenixRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            String indexTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1', 70, 2)");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id5', 0, 2)");
            conn.commit();
            Thread.sleep(10L);
            Timestamp before = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            String timeZoneID = Calendar.getInstance().getTimeZone().getID();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B)") + " WHERE PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + before + "', 'yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')  ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            String selectSql = "SELECT A from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + before + "', 'yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)70L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(indexTableName));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id2', 20, 3)");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id3', 10, 4)");
            conn.commit();
            rs = conn.createStatement().executeQuery("SELECT Count(*) from " + dataTableName);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("EXPLAIN SELECT Count(*) from " + dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getString(1).contains(indexTableName));
            rs = conn.createStatement().executeQuery("SELECT Count(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1',  70, 2)");
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(indexTableName));
            PartialIndexIT.verifyIndex(dataTableName, indexTableName);
        }
    }

    @Test
    public void testViewIndexes() throws Exception {
        String baseTableName = PartialIndexIT.generateUniqueName();
        String globalViewName = PartialIndexIT.generateUniqueName();
        String globalViewIndexName = PartialIndexIT.generateUniqueName();
        String tenantViewName = PartialIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + baseTableName + " (TENANT_ID CHAR(15) NOT NULL, KP CHAR(3) NOT NULL, PK2 DATE NOT NULL, PK3 INTEGER NOT NULL, KV1 VARCHAR, KV2 VARCHAR, KV3 CHAR(15) CONSTRAINT PK PRIMARY KEY(TENANT_ID, KP, PK2, PK3)) MULTI_TENANT=true" + (this.salted ? ", SALT_BUCKETS=4" : ""));
            conn.createStatement().execute("CREATE VIEW " + globalViewName + " AS SELECT * FROM " + baseTableName + " WHERE  KP = '001'");
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + globalViewIndexName + " on " + globalViewName + " (PK3 DESC, KV3) " + (this.uncovered ? "" : "INCLUDE (KV1)") + " WHERE KV3 IS NOT NULL ASYNC");
            String tenantId = "tenantId";
            Properties tenantProps = new Properties();
            tenantProps.setProperty("TenantId", tenantId);
            try (Connection tenantConn = DriverManager.getConnection(PartialIndexIT.getUrl(), tenantProps);){
                tenantConn.createStatement().execute("CREATE VIEW " + tenantViewName + " AS SELECT * FROM " + globalViewName);
                String tenantViewIndexName = PartialIndexIT.generateUniqueName();
                tenantConn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + tenantViewIndexName + " on " + tenantViewName + " (PK3) " + (this.uncovered ? "" : "INCLUDE (KV1)") + " WHERE PK3 > 4");
                PreparedStatement stmt = tenantConn.prepareStatement("UPSERT INTO  " + tenantViewName + " (PK2, PK3, KV1, KV3) VALUES (?, ?, ?, ?)");
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 1);
                stmt.setString(3, "KV1");
                stmt.setString(4, "KV3");
                stmt.executeUpdate();
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 2);
                stmt.setString(3, "KV4");
                stmt.setString(4, "KV5");
                stmt.executeUpdate();
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 3);
                stmt.setString(3, "KV6");
                stmt.setString(4, "KV7");
                stmt.executeUpdate();
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 4);
                stmt.setString(3, "KV8");
                stmt.setString(4, "KV9");
                stmt.executeUpdate();
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 5);
                stmt.setString(3, "KV10");
                stmt.setString(4, "KV11");
                stmt.executeUpdate();
                tenantConn.commit();
                ResultSet rs = tenantConn.createStatement().executeQuery("SELECT KV1 FROM  " + tenantViewName + " WHERE PK3 = 5");
                PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", tenantViewIndexName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"KV10", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
                rs = tenantConn.createStatement().executeQuery("SELECT KV1 FROM  " + tenantViewName + " WHERE PK3 = 4");
                PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", tenantViewName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"KV8", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
                rs = tenantConn.createStatement().executeQuery("SELECT Count(*) FROM  " + tenantViewIndexName);
                PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", tenantViewIndexName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
            }
            IndexToolIT.runIndexTool(false, "", globalViewName, globalViewIndexName);
            tenantConn = DriverManager.getConnection(PartialIndexIT.getUrl(), tenantProps);
            try {
                ResultSet rs = tenantConn.createStatement().executeQuery("SELECT KV1 FROM  " + tenantViewName + " WHERE PK3 = 1 AND KV3 = 'KV3'");
                PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", tenantViewName + "#" + globalViewIndexName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"KV1", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (tenantConn != null) {
                    tenantConn.close();
                }
            }
            ResultSet rs = conn.createStatement().executeQuery("SELECT KV1 FROM  " + globalViewName + " WHERE PK3 = 1 AND KV3 = 'KV3'");
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", globalViewIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"KV1", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT Count(*) FROM  " + globalViewIndexName);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", globalViewIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testPartialIndexPreferredOverFullIndex() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer, C double, D varchar)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1', 10, 2, 3.14, 'a')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D) values ('id2', 100, 'b')");
            conn.commit();
            String fullIndexTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + fullIndexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, fullIndexTableName);
            String partialIndexTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + partialIndexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE A > 50 ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, partialIndexTableName);
            String selectSql = "SELECT  D from " + dataTableName + " WHERE A > 60";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", partialIndexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(partialIndexTableName));
            selectSql = "SELECT  D from " + dataTableName + " WHERE A < 50";
            rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", fullIndexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(fullIndexTableName));
        }
    }

    @Test
    public void testPartialIndexWithJson() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl(), props);){
            conn.setAutoCommit(true);
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer, C double, D varchar, jsoncol json)");
            String indexTableName = PartialIndexIT.generateUniqueName();
            String json = "{\"info\":{\"age\": %s }}";
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1', 25, 2, 3.14, 'a','" + String.format(json, 25) + "')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D, jsoncol) values ('id2', 100, 'b','" + String.format(json, 100) + "')");
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (CAST(TO_NUMBER(JSON_VALUE(jsoncol, '$.info.age')) AS INTEGER)) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE (CAST(TO_NUMBER(JSON_VALUE(jsoncol, '$.info.age')) AS INTEGER)) > 50 ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            String selectSql = "SELECT  D from " + dataTableName + " WHERE (CAST(TO_NUMBER(JSON_VALUE(jsoncol, '$.info.age')) AS INTEGER)) > 60";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT  D from " + dataTableName + " WHERE (CAST(TO_NUMBER(JSON_VALUE(jsoncol, '$.info.age')) AS INTEGER)) = 50";
            rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id3', 50, 2, 9.5, 'c','" + String.format(json, 50) + "')");
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id4', 75, 2, 9.5, 'd','" + String.format(json, 75) + "')");
            selectSql = "SELECT * from " + indexTableName;
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)75L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)100L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            String dml = "UPSERT INTO " + dataTableName + " values ('id2', 0, 2, 9.5, 'd','" + String.format(json, 0) + "')";
            conn.createStatement().execute(dml);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)75L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT  ID from " + dataTableName + " WHERE (CAST(TO_NUMBER(JSON_VALUE(jsoncol, '$.info.age')) AS INTEGER)) = 0";
            rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"id2", (Object)rs.getString(1));
            PartialIndexIT.verifyIndex(dataTableName, indexTableName);
            try (Connection newConn = DriverManager.getConnection(PartialIndexIT.getUrl());){
                PTable indexTable = PhoenixRuntime.getTableNoCache((Connection)newConn, (String)indexTableName);
                Assert.assertTrue((boolean)StringUtils.deleteWhitespace((String)indexTable.getIndexWhere()).equals("CAST(TO_NUMBER(JSON_VALUE(JSONCOL,'$.info.age'))ASINTEGER)>50"));
            }
        }
    }

    @Test
    public void testPartialIndexWithJsonExists() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl(), props);){
            conn.setAutoCommit(true);
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, A integer, B integer, C double, D varchar, jsoncol json)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            String indexTableName = PartialIndexIT.generateUniqueName();
            String jsonWithPathExists = "{\"info\":{\"address\":{\"exists\":true}}}";
            String jsonWithoutPathExists = "{\"info\":{\"age\": 25 }}";
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id1', 70, 2, 3.14, 'a','" + jsonWithPathExists + "')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D, jsoncol) values ('id2', 100, 'b','" + jsonWithoutPathExists + "')");
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE JSON_EXISTS(JSONCOL, '$.info.address.exists') ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            String selectSql = "SELECT " + (String)(this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " A, D from " + dataTableName + " WHERE A > 60 AND JSON_EXISTS(jsoncol, '$.info.address.exists')";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)70L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id3', 20, 2, 3.14, 'a','" + jsonWithPathExists + "')");
            conn.createStatement().execute("upsert into " + dataTableName + " values ('id4', 90, 2, 3.14, 'a','" + jsonWithPathExists + "')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, A, D, jsoncol) values ('id5', 150, 'b','" + jsonWithoutPathExists + "')");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)70L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)90L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT Count(*) from " + dataTableName);
            PartialIndexIT.assertPlan((PhoenixResultSet)rs, "", dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            conn.createStatement().execute("upsert into " + dataTableName + " (ID, B, jsoncol) values ('id4', null, '" + jsonWithoutPathExists + "')");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)70L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            PartialIndexIT.verifyIndex(dataTableName, indexTableName);
            try (Connection newConn = DriverManager.getConnection(PartialIndexIT.getUrl());){
                PTable indexTable = PhoenixRuntime.getTableNoCache((Connection)newConn, (String)indexTableName);
                Assert.assertTrue((boolean)StringUtils.deleteWhitespace((String)indexTable.getIndexWhere()).equals("JSON_EXISTS(JSONCOL,'$.info.address.exists')"));
            }
        }
    }

    @Test
    public void testPartialIndexWithIndexHint() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());
             Statement stmt = conn.createStatement();){
            String dataTableName = PartialIndexIT.generateUniqueName();
            stmt.execute("create table " + dataTableName + " (id1 varchar not null, id2 integer not null, A integer constraint pk primary key (id1, id2))" + (this.salted ? " SALT_BUCKETS=4" : ""));
            stmt.execute("upsert into " + dataTableName + " values ('id11', 10, 1)");
            conn.commit();
            stmt.execute("upsert into " + dataTableName + " values ('id12', 100, 2)");
            conn.commit();
            String indexTableName = PartialIndexIT.generateUniqueName();
            stmt.execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (id2, id1) " + (this.uncovered ? "" : "INCLUDE (A)") + " WHERE id2 > 50");
            String selectSql = "SELECT  /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ A from " + dataTableName + " WHERE id2 = 100 AND id1 = 'id12'";
            ResultSet rs = stmt.executeQuery("EXPLAIN " + selectSql);
            String actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualQueryPlan.contains("POINT LOOKUP ON 1 KEY OVER " + indexTableName));
            rs = stmt.executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT  /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ A from " + dataTableName + " WHERE id2 = 10 AND id1 = 'id11'";
            rs = stmt.executeQuery("EXPLAIN " + selectSql);
            actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualQueryPlan.contains("POINT LOOKUP ON 1 KEY OVER " + indexTableName));
            rs = stmt.executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT A from " + dataTableName + " WHERE id2 = 10 AND id1 = 'id11'";
            rs = stmt.executeQuery("EXPLAIN " + selectSql);
            actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualQueryPlan.contains("POINT LOOKUP ON 1 KEY OVER " + dataTableName));
            rs = stmt.executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testPartialIndexOnTableWithCaseSensitiveColumns() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());
             PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);){
            String dataTableName = PartialIndexIT.generateUniqueName();
            String indexName1 = PartialIndexIT.generateUniqueName();
            String indexName2 = PartialIndexIT.generateUniqueName();
            String indexName3 = PartialIndexIT.generateUniqueName();
            stmt.execute("CREATE TABLE " + dataTableName + " (\"hashKeY\" VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, \"CoL\" VARCHAR, \"coLUmn3\" VARCHAR)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            stmt.execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexName1 + " on " + dataTableName + " (v1) " + (this.uncovered ? "" : "INCLUDE (\"CoL\", \"coLUmn3\")") + "WHERE v1='b'");
            stmt.execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexName2 + " on " + dataTableName + " (\"CoL\") " + (this.uncovered ? "" : "INCLUDE (v1, \"coLUmn3\")") + " WHERE \"CoL\"='c'");
            stmt.execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexName3 + " on " + dataTableName + " (\"coLUmn3\") " + (this.uncovered ? "" : "INCLUDE (\"CoL\", v1)") + " WHERE \"coLUmn3\"='d'");
            stmt.execute("UPSERT INTO " + dataTableName + " VALUES ('a', 'b', 'c', 'd')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT \"CoL\" FROM " + dataTableName + " WHERE v1='b'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName1, (Object)stmt.getQueryPlan().getTableRef().getTable().getTableName().toString());
            rs = stmt.executeQuery("SELECT v1 FROM " + dataTableName + " WHERE \"CoL\"='c'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName2, (Object)stmt.getQueryPlan().getTableRef().getTable().getTableName().toString());
            rs = stmt.executeQuery("SELECT \"CoL\" FROM " + dataTableName + " WHERE \"coLUmn3\"='d'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName3, (Object)stmt.getQueryPlan().getTableRef().getTable().getTableName().toString());
        }
    }

    @Test
    public void testPartialIndexOnTableWithCaseSensitiveName() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());
             PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);){
            String dataTableName = "\"" + PartialIndexIT.generateUniqueName().toLowerCase() + "\"";
            String indexName1 = PartialIndexIT.generateUniqueName();
            stmt.execute("CREATE TABLE " + dataTableName + " (\"hashKeY\" VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, \"CoL\" VARCHAR, \"coLUmn3\" VARCHAR)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            stmt.execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + indexName1 + " on " + dataTableName + " (\"CoL\") " + (this.uncovered ? "" : "INCLUDE (v1, \"coLUmn3\")") + " WHERE \"CoL\"='c'");
            stmt.execute("UPSERT INTO " + dataTableName + " VALUES ('a', 'b', 'c', 'd')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT v1 FROM " + dataTableName + " WHERE \"CoL\"='c'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName1, (Object)stmt.getQueryPlan().getTableRef().getTable().getTableName().toString());
        }
    }

    @Test
    public void testPartialIndexWithVarbinaryEncoded() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialIndexIT.getUrl());){
            ResultSet rs;
            String dataTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (ID VARCHAR NOT NULL PRIMARY KEY, A VARBINARY_ENCODED, B integer, C double, D varchar)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            try (PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + dataTableName + "(ID, A, B, C, D) VALUES (?, ?, ?, ?, ?)");){
                ps.setString(1, "id1");
                ps.setBytes(2, new byte[]{-2, 0, 2, 3, 1});
                ps.setInt(3, 2);
                ps.setDouble(4, 3.14);
                ps.setString(5, "a");
                ps.executeUpdate();
            }
            conn.commit();
            ps = conn.prepareStatement("UPSERT INTO " + dataTableName + "(ID, A, D) VALUES (?, ?, ?)");
            try {
                ps.setString(1, "id2");
                ps.setBytes(2, new byte[]{-2, 0, 2, 3, 1, 41});
                ps.setString(3, "b");
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            conn.commit();
            String fullIndexTableName = PartialIndexIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + fullIndexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, fullIndexTableName);
            String partialIndexTableName = PartialIndexIT.generateUniqueName();
            String partialIndexVal = PartialIndexIT.toStringLiteral(new byte[]{-2, 0, 2, 3, 1, 35});
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + (this.local ? "LOCAL " : " ") + "INDEX " + partialIndexTableName + " on " + dataTableName + " (A) " + (this.uncovered ? "" : "INCLUDE (B, C, D)") + " WHERE A > " + partialIndexVal + " ASYNC");
            IndexToolIT.runIndexTool(false, null, dataTableName, partialIndexTableName);
            byte[] greaterThanBytesFullIdx = new byte[]{-2, 0, 2, 3, 1, 34};
            byte[] greaterThanBytesPartialIdx = new byte[]{-2, 0, 2, 3, 1, 37};
            byte[] lessThanBytes = new byte[]{-2, 0, 2, 3, 1, 35};
            String selectSql = "SELECT D from " + dataTableName + " WHERE A > ?";
            try (PreparedStatement ps = conn.prepareStatement(selectSql);){
                ps.setBytes(1, greaterThanBytesFullIdx);
                rs = ps.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"b", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
                PartialIndexIT.verifyIndexUsed(ps, fullIndexTableName, this.salted ? 4 : 1);
            }
            ps = conn.prepareStatement(selectSql);
            try {
                ps.setBytes(1, greaterThanBytesPartialIdx);
                rs = ps.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"b", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
                PartialIndexIT.verifyIndexUsed(ps, partialIndexTableName, this.salted ? 4 : 1);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            selectSql = "SELECT D from " + dataTableName + " WHERE A < ?";
            ps = conn.prepareStatement(selectSql);
            try {
                ps.setBytes(1, lessThanBytes);
                rs = ps.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
                PartialIndexIT.verifyIndexUsed(ps, fullIndexTableName, this.salted ? 4 : 1);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private static void verifyIndexUsed(PreparedStatement preparedStatement, String partialIndexTableName, int buckets) throws SQLException {
        ExplainPlan plan = preparedStatement.unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)partialIndexTableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)("PARALLEL " + buckets + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
    }

    private static String toStringLiteral(byte[] b) {
        StringBuilder buf = new StringBuilder();
        buf.append("X'");
        if (b.length > 0) {
            buf.append(Bytes.toHex((byte[])b, (int)0, (int)b.length));
        }
        buf.append("'");
        return buf.toString();
    }
}

