/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.RunUntilFailure;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=RunUntilFailure.class)
public class MutableIndexRebuilderIT
extends BaseTest {
    private static final int WAIT_AFTER_DISABLED = 0;
    private static final long REBUILD_PERIOD = 50000L;
    private static final long REBUILD_INTERVAL = 2000L;
    private static RegionCoprocessorEnvironment indexRebuildTaskRegionEnvironment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRebuildRetriesSuccessful() throws Throwable {
        int numberOfRetries = 5;
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)10);
        serverProps.put("phoenix.index.failure.handling.rebuild", Boolean.TRUE.toString());
        serverProps.put("phoenix.index.failure.handling.rebuild.interval", Long.toString(2000L));
        serverProps.put("phoenix.index.rebuild.disabletimestamp.threshold", "50000000");
        serverProps.put("phoenix.index.failure.handling.rebuild.period", Long.toString(50000L));
        serverProps.put("phoenix.index.failure.handling.rebuild.overlap.forward.time", Long.toString(0L));
        serverProps.put("hbase.client.retries.number", "" + numberOfRetries);
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("phoenix.index.region.observer.enabled", "false");
        MutableIndexRebuilderIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        indexRebuildTaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)MutableIndexRebuilderIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(MetaDataRegionObserver.class.getName());
        MetaDataRegionObserver.initRebuildIndexConnectionProps((Configuration)indexRebuildTaskRegionEnvironment.getConfiguration());
        try (Connection conn = DriverManager.getConnection(MutableIndexRebuilderIT.getUrl());){
            String schemaName = MutableIndexRebuilderIT.generateUniqueName();
            String tableName = MutableIndexRebuilderIT.generateUniqueName();
            String indexName = MutableIndexRebuilderIT.generateUniqueName();
            final String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
            String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR) DISABLE_INDEX_ON_WRITE_FAILURE = TRUE");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)EnvironmentEdgeManager.currentTimeMillis(), (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','a','0')");
            conn.commit();
            TestUtil.addCoprocessor(conn, fullIndexName, WriteFailingRegionObserver.class);
            MutableIndexRebuilderIT.waitForIndexState(conn, fullTableName, fullIndexName, PIndexState.INACTIVE);
            long pendingDisableCount = TestUtil.getPendingDisableCount(conn.unwrap(PhoenixConnection.class), fullIndexName);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                Future<Boolean> future = executor.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        MutableIndexRebuilderIT.runIndexRebuilder(fullTableName);
                        return true;
                    }
                });
                Assert.assertTrue((boolean)future.get(120L, TimeUnit.SECONDS));
                Assert.assertEquals((long)numberOfRetries, (long)WriteFailingRegionObserver.attempts.get());
                Assert.assertEquals((long)pendingDisableCount, (long)TestUtil.getPendingDisableCount(conn.unwrap(PhoenixConnection.class), fullIndexName));
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    public static void waitForIndexState(Connection conn, String fullTableName, String fullIndexName, PIndexState expectedIndexState) throws InterruptedException, SQLException {
        int nRetries = 2;
        PIndexState actualIndexState = null;
        do {
            MutableIndexRebuilderIT.runIndexRebuilder(fullTableName);
            actualIndexState = TestUtil.getIndexState(conn, fullIndexName);
            if (actualIndexState == expectedIndexState) {
                return;
            }
            Thread.sleep(1000L);
        } while (--nRetries > 0);
        Assert.fail((String)("Expected index state of " + expectedIndexState + ", but was " + actualIndexState));
    }

    private static void runIndexRebuilder(String table) throws InterruptedException, SQLException {
        MutableIndexRebuilderIT.runIndexRebuilder(Collections.singletonList(table));
    }

    private static void runIndexRebuilder(List<String> tables) throws InterruptedException, SQLException {
        MetaDataRegionObserver.BuildIndexScheduleTask task = new MetaDataRegionObserver.BuildIndexScheduleTask(indexRebuildTaskRegionEnvironment, tables);
        task.run();
    }

    public static class WriteFailingRegionObserver
    extends SimpleRegionObserver {
        public static volatile AtomicInteger attempts = new AtomicInteger(0);

        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            attempts.incrementAndGet();
            throw new DoNotRetryIOException("Simulating write failure on " + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().getTable().getNameAsString());
        }
    }
}

