/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.PhoenixRegionServerEndpointTestImpl;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class MutableIndexFailureIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableIndexFailureIT.class);
    public static volatile boolean FAIL_WRITE = false;
    public static volatile String fullTableName;
    private String tableName;
    private String indexName;
    private String fullIndexName;
    private final boolean transactional;
    private final PhoenixTransactionProvider transactionProvider;
    private final boolean localIndex;
    private final String tableDDLOptions;
    private final boolean isNamespaceMapped;
    private final boolean leaveIndexActiveOnFailure;
    private final boolean failRebuildTask;
    private final boolean throwIndexWriteFailure;
    private String schema = MutableIndexFailureIT.generateUniqueName();
    private List<CommitException> exceptions = Lists.newArrayList();
    protected static RegionCoprocessorEnvironment indexRebuildTaskRegionEnvironment;
    protected static final int forwardOverlapMs = 1000;
    protected static final int disableTimestampThresholdMs = 10000;
    protected static final int numRpcRetries = 2;

    public MutableIndexFailureIT(String transactionProvider, boolean localIndex, boolean isNamespaceMapped, Boolean disableIndexOnWriteFailure, boolean failRebuildTask, Boolean throwIndexWriteFailure) {
        this.transactional = transactionProvider != null;
        this.transactionProvider = transactionProvider == null ? null : TransactionFactory.getTransactionProvider((TransactionFactory.Provider)TransactionFactory.Provider.valueOf((String)transactionProvider));
        this.localIndex = localIndex;
        this.tableDDLOptions = " SALT_BUCKETS=2, COLUMN_ENCODED_BYTES=NONE" + (String)(this.transactional ? ",TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + transactionProvider + "'" : "") + (String)(disableIndexOnWriteFailure == null ? "" : ", DISABLE_INDEX_ON_WRITE_FAILURE=" + disableIndexOnWriteFailure) + (String)(throwIndexWriteFailure == null ? "" : ", THROW_INDEX_WRITE_FAILURE=" + throwIndexWriteFailure);
        this.tableName = "FAIL_TABLE";
        this.indexName = "A_FAIL_IDX";
        fullTableName = SchemaUtil.getTableName((String)this.schema, (String)this.tableName);
        this.fullIndexName = SchemaUtil.getTableName((String)this.schema, (String)this.indexName);
        this.isNamespaceMapped = isNamespaceMapped;
        this.leaveIndexActiveOnFailure = disableIndexOnWriteFailure != null && disableIndexOnWriteFailure == false;
        this.failRebuildTask = failRebuildTask;
        this.throwIndexWriteFailure = !Boolean.FALSE.equals(throwIndexWriteFailure);
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        Map<String, String> serverProps = MutableIndexFailureIT.getServerProps();
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("hbase.client.retries.number", "2");
        clientProps.put("phoenix.index.region.observer.enabled", Boolean.FALSE.toString());
        NUM_SLAVES_BASE = 4;
        MutableIndexFailureIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        indexRebuildTaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)MutableIndexFailureIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(MetaDataRegionObserver.class.getName());
        MetaDataRegionObserver.initRebuildIndexConnectionProps((Configuration)indexRebuildTaskRegionEnvironment.getConfiguration());
    }

    protected static Map<String, String> getServerProps() {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)10);
        serverProps.put("hbase.coprocessor.region.classes", FailingRegionObserver.class.getName());
        serverProps.put("hbase.rpc.timeout", "10000");
        serverProps.put("phoenix.index.writes.rpc.pause", "5000");
        serverProps.put("data.tx.snapshot.dir", "/tmp");
        serverProps.put("hbase.balancer.period", String.valueOf(Integer.MAX_VALUE));
        serverProps.put("phoenix.index.rebuild.rpc.retries.counter", Long.toString(2L));
        serverProps.put("phoenix.index.failure.handling.rebuild.overlap.forward.time", Long.toString(1000L));
        serverProps.put("phoenix.index.rebuild.disabletimestamp.threshold", Long.toString(10000L));
        serverProps.put("phoenix.index.rebuild.task.initial.delay", Long.toString(Long.MAX_VALUE));
        serverProps.put("hbase.coprocessor.regionserver.classes", PhoenixRegionServerEndpointTestImpl.class.getName());
        return serverProps;
    }

    @Parameterized.Parameters(name="MutableIndexFailureIT_transactionProvider={0},localIndex={1},isNamespaceMapped={2},disableIndexOnWriteFailure={3},failRebuildTask={4},throwIndexWriteFailure={5}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({null, false, false, false, false, false}, {null, false, false, true, false, null}, {"OMID", false, false, true, false, null}, {null, true, false, null, false, null}, {null, false, false, false, false, null}, {null, true, false, false, false, null}, {null, false, false, false, false, null}, {null, false, false, true, false, null}, {null, true, false, true, false, null}, {null, true, false, true, false, null}, {null, false, false, true, true, null}, {null, false, false, false, true, false});
    }

    private void runRebuildTask(Connection conn) throws InterruptedException, SQLException {
        MetaDataRegionObserver.BuildIndexScheduleTask task = new MetaDataRegionObserver.BuildIndexScheduleTask(indexRebuildTaskRegionEnvironment);
        MutableIndexFailureIT.dumpStateOfIndexes(conn, fullTableName, true);
        task.run();
        MutableIndexFailureIT.dumpStateOfIndexes(conn, fullTableName, false);
        Thread.sleep(1100L);
        if (this.failRebuildTask) {
            Thread.sleep(10100L);
        }
        MutableIndexFailureIT.dumpStateOfIndexes(conn, fullTableName, true);
        task.run();
        MutableIndexFailureIT.dumpStateOfIndexes(conn, fullTableName, false);
    }

    private static final void dumpStateOfIndexes(Connection conn, String tableName, boolean beforeRebuildTaskRun) throws SQLException {
        PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
        PTable table = phxConn.getTable(new PTableKey(phxConn.getTenantId(), tableName));
        List indexes = table.getIndexes();
        String s = beforeRebuildTaskRun ? "before rebuild run" : "after rebuild run";
        System.out.println("************Index state in connection " + s + "******************");
        for (PTable idx : indexes) {
            System.out.println("Index Name: " + idx.getName().getString() + " State: " + idx.getIndexState() + " Disable timestamp: " + idx.getIndexDisableTimestamp());
        }
        System.out.println("************Index state from server  " + s + "******************");
        table = phxConn.getTableNoCache(fullTableName);
        for (PTable idx : table.getIndexes()) {
            System.out.println("Index Name: " + idx.getName().getString() + " State: " + idx.getIndexState() + " Disable timestamp: " + idx.getIndexDisableTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexWriteFailure() throws Exception {
        block20: {
            String secondIndexName = "B_FAIL_IDX";
            String thirdIndexName = "C_IDX";
            String thirdFullIndexName = SchemaUtil.getTableName((String)this.schema, (String)thirdIndexName);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            props.put("phoenix.schema.isNamespaceMappingEnabled", String.valueOf(this.isNamespaceMapped));
            try (Connection conn = driver.connect(url, props);){
                conn.setAutoCommit(false);
                if (this.isNamespaceMapped) {
                    conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + this.schema);
                }
                conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) " + this.tableDDLOptions);
                String query = "SELECT * FROM " + fullTableName;
                ResultSet rs = conn.createStatement().executeQuery(query);
                Assert.assertFalse((boolean)rs.next());
                FailingRegionObserver.FAIL_WRITE = false;
                conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL " : "") + " INDEX " + this.indexName + " ON " + fullTableName + " (v1) INCLUDE (v2)");
                conn.createStatement().execute("CREATE " + (!this.localIndex && (this.transactionProvider == null || !this.transactionProvider.isUnsupported(PhoenixTransactionProvider.Feature.ALLOW_LOCAL_INDEX)) ? "LOCAL " : "") + " INDEX " + secondIndexName + " ON " + fullTableName + " (v2) INCLUDE (v1)");
                conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL " : "") + " INDEX " + thirdIndexName + " ON " + fullTableName + " (v1) INCLUDE (v2)");
                query = "SELECT * FROM " + this.fullIndexName;
                rs = conn.createStatement().executeQuery(query);
                Assert.assertFalse((boolean)rs.next());
                this.initializeTable(conn, fullTableName);
                this.addRowsInTableDuringRetry(fullTableName);
                rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)this.schema), null, new String[]{PTableType.INDEX.toString()});
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)this.indexName, (Object)rs.getString(3));
                Assert.assertEquals((Object)PIndexState.ACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)secondIndexName, (Object)rs.getString(3));
                Assert.assertEquals((Object)PIndexState.ACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)thirdIndexName, (Object)rs.getString(3));
                Assert.assertEquals((Object)PIndexState.ACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
                this.addRowToTable(conn, fullTableName);
                query = "SELECT /*+ NO_INDEX */ k,v1 FROM " + fullTableName;
                ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
                Assert.assertEquals((Object)"PARALLEL 2-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)SchemaUtil.getPhysicalTableName((byte[])fullTableName.getBytes(), (boolean)this.isNamespaceMapped).toString(), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                rs = conn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertEquals((Object)"x", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"b", (Object)rs.getString(1));
                Assert.assertEquals((Object)"y", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"c", (Object)rs.getString(1));
                Assert.assertEquals((Object)"z", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
                this.updateTable(conn, true);
                rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)this.schema), StringUtil.escapeLike((String)this.indexName), new String[]{PTableType.INDEX.toString()});
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)this.indexName, (Object)rs.getString(3));
                String indexState = rs.getString("INDEX_STATE");
                if (this.transactional || this.leaveIndexActiveOnFailure || this.localIndex) {
                    Assert.assertTrue((PIndexState.ACTIVE.toString().equalsIgnoreCase(indexState) || PIndexState.PENDING_ACTIVE.toString().equalsIgnoreCase(indexState) ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((PIndexState.DISABLE.toString().equals(indexState) || PIndexState.INACTIVE.toString().equals(indexState) ? 1 : 0) != 0);
                    ResultSet thirdRs = conn.createStatement().executeQuery(this.getSysCatQuery(thirdIndexName));
                    Assert.assertTrue((boolean)thirdRs.next());
                    Assert.assertEquals((Object)PIndexState.ACTIVE.getSerializedValue(), (Object)thirdRs.getString(1));
                }
                Assert.assertFalse((boolean)rs.next());
                if (!this.transactional) {
                    this.updateTableAgain(conn, false);
                    query = "SELECT /*+ NO_INDEX */ k,v1 FROM " + fullTableName;
                    plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                    explainPlanAttributes = plan.getPlanStepsAsAttributes();
                    Assert.assertEquals((Object)"PARALLEL 2-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                    Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                    Assert.assertEquals((Object)SchemaUtil.getPhysicalTableName((byte[])fullTableName.getBytes(), (boolean)this.isNamespaceMapped).toString(), (Object)explainPlanAttributes.getTableName());
                    Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                    rs = conn.createStatement().executeQuery(query);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                    Assert.assertEquals((Object)"x2", (Object)rs.getString(2));
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"a3", (Object)rs.getString(1));
                    Assert.assertEquals((Object)"x3", (Object)rs.getString(2));
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"c", (Object)rs.getString(1));
                    Assert.assertEquals((Object)"z", (Object)rs.getString(2));
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"d", (Object)rs.getString(1));
                    Assert.assertEquals((Object)"d", (Object)rs.getString(2));
                    Assert.assertFalse((boolean)rs.next());
                }
                IndexScrutiny.scrutinizeIndex(conn, fullTableName, thirdFullIndexName);
                if (!this.failRebuildTask) {
                    FailingRegionObserver.FAIL_WRITE = false;
                    this.runRebuildTask(conn);
                    this.checkStateAfterRebuild(conn, this.fullIndexName, PIndexState.ACTIVE);
                    PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
                    stmt.setString(1, "a3");
                    stmt.setString(2, "x4");
                    stmt.setString(3, "4");
                    stmt.execute();
                    conn.commit();
                    this.validateDataWithIndex(conn, fullTableName, this.fullIndexName, this.localIndex);
                    break block20;
                }
                this.runRebuildTask(conn);
                this.checkStateAfterRebuild(conn, this.fullIndexName, PIndexState.DISABLE);
                String q = this.getSysCatQuery(this.indexName);
                try (ResultSet r = conn.createStatement().executeQuery(q);){
                    Assert.assertTrue((boolean)r.next());
                    Assert.assertEquals((Object)PIndexState.DISABLE.getSerializedValue(), (Object)r.getString(1));
                    Assert.assertEquals((long)0L, (long)r.getLong(2));
                    Assert.assertFalse((boolean)r.next());
                }
            }
            finally {
                FAIL_WRITE = false;
            }
        }
    }

    private String getSysCatQuery(String iName) {
        String q = "SELECT INDEX_STATE, INDEX_DISABLE_TIMESTAMP FROM SYSTEM.CATALOG WHERE TABLE_SCHEM = '" + this.schema + "' AND TABLE_NAME = '" + iName + "' AND COLUMN_NAME IS NULL AND COLUMN_FAMILY IS NULL";
        return q;
    }

    private void checkStateAfterRebuild(Connection conn, String fullIndexName, PIndexState expectedIndexState) throws InterruptedException, SQLException {
        if (!this.transactional) {
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, fullIndexName, expectedIndexState, 0L));
        }
    }

    private void initializeTable(Connection conn, String tableName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
        stmt.setString(1, "a");
        stmt.setString(2, "x");
        stmt.setString(3, "1");
        stmt.execute();
        conn.commit();
    }

    private void addRowToTable(Connection conn, String tableName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
        stmt.setString(1, "c");
        stmt.setString(2, "z");
        stmt.setString(3, "3");
        stmt.execute();
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRowsInTableDuringRetry(final String tableName) throws SQLException, InterruptedException, ExecutionException {
        int threads = 10;
        boolean wasFailWrite = FailingRegionObserver.FAIL_WRITE;
        boolean wasToggleFailWriteForRetry = FailingRegionObserver.TOGGLE_FAIL_WRITE_FOR_RETRY;
        try {
            Callable callable = new Callable(){

                public Boolean call() {
                    Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
                    props.put("phoenix.schema.isNamespaceMappingEnabled", String.valueOf(MutableIndexFailureIT.this.isNamespaceMapped));
                    try (Connection conn = driver.connect(url, props);){
                        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
                        stmt.setString(1, "b");
                        stmt.setString(2, "y");
                        stmt.setString(3, "2");
                        stmt.execute();
                        if (!MutableIndexFailureIT.this.leaveIndexActiveOnFailure && !MutableIndexFailureIT.this.transactional) {
                            FailingRegionObserver.FAIL_WRITE = true;
                            FailingRegionObserver.TOGGLE_FAIL_WRITE_FOR_RETRY = true;
                        }
                        conn.commit();
                    }
                    catch (SQLException e) {
                        LOGGER.warn("Error while adding row", (Throwable)e);
                        return false;
                    }
                    return true;
                }
            };
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            ArrayList futures = new ArrayList();
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(callable));
            }
            for (Future future : futures) {
                Boolean isSuccess = (Boolean)future.get();
                if (this.transactional) continue;
                Assert.assertTrue((boolean)isSuccess);
            }
            executor.shutdown();
        }
        finally {
            FailingRegionObserver.FAIL_WRITE = wasFailWrite;
            FailingRegionObserver.TOGGLE_FAIL_WRITE_FOR_RETRY = wasToggleFailWriteForRetry;
        }
    }

    private void validateDataWithIndex(Connection conn, String fullTableName, String fullIndexName, boolean localIndex) throws Exception {
        String query = "SELECT /*+ INDEX(" + fullTableName + " " + SchemaUtil.getTableNameFromFullName((String)fullIndexName) + ")  */ k,v1 FROM " + fullTableName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        String expectedPlan = " OVER " + (String)(localIndex ? fullIndexName + "(" + Bytes.toString((byte[])SchemaUtil.getPhysicalTableName((byte[])fullTableName.getBytes(), (boolean)this.isNamespaceMapped).getName()) + ")" : SchemaUtil.getPhysicalTableName((byte[])fullIndexName.getBytes(), (boolean)this.isNamespaceMapped).getNameAsString());
        String explainPlan = QueryUtil.getExplainPlan((ResultSet)conn.createStatement().executeQuery("EXPLAIN " + query));
        Assert.assertTrue((String)explainPlan, (boolean)explainPlan.contains(expectedPlan));
        if (this.transactional) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a3", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x4", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"z", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        } else {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"d", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x2", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a3", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x4", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"z", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void updateTable(Connection conn, boolean commitShouldFail) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
        stmt.setString(1, "d");
        stmt.setString(2, "d");
        stmt.setString(3, "4");
        stmt.execute();
        stmt.setString(1, "a");
        stmt.setString(2, "x2");
        stmt.setString(3, "2");
        stmt.execute();
        stmt = conn.prepareStatement("DELETE FROM " + fullTableName + " WHERE k=?");
        stmt.setString(1, "b");
        stmt.execute();
        FailingRegionObserver.FAIL_WRITE = true;
        try {
            FailingRegionObserver.FAIL_NEXT_WRITE = this.localIndex && this.transactional;
            conn.commit();
            if (commitShouldFail && (!this.localIndex || this.transactional) && this.throwIndexWriteFailure) {
                Assert.fail();
            }
        }
        catch (CommitException e) {
            if (!commitShouldFail || !this.throwIndexWriteFailure) {
                throw e;
            }
            this.exceptions.add(e);
        }
    }

    private void updateTableAgain(Connection conn, boolean commitShouldFail) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
        stmt.setString(1, "a3");
        stmt.setString(2, "x3");
        stmt.setString(3, "3");
        stmt.execute();
        try {
            conn.commit();
            if (commitShouldFail && !this.localIndex && this.throwIndexWriteFailure) {
                Assert.fail();
            }
        }
        catch (CommitException e) {
            if (!commitShouldFail || !this.throwIndexWriteFailure) {
                throw e;
            }
            this.exceptions.add(e);
        }
    }

    public static class FailingRegionObserver
    extends SimpleRegionObserver {
        public static boolean TOGGLE_FAIL_WRITE_FOR_RETRY = false;
        public static volatile boolean FAIL_WRITE = false;
        public static volatile boolean FAIL_NEXT_WRITE = false;
        public static final String FAIL_INDEX_NAME = "FAIL_IDX";
        public static final String FAIL_TABLE_NAME = "FAIL_TABLE";

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            boolean throwException;
            block5: {
                block6: {
                    block4: {
                        throwException = false;
                        if (!FAIL_NEXT_WRITE) break block4;
                        throwException = true;
                        FAIL_NEXT_WRITE = false;
                        break block5;
                    }
                    if (!((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().getTable().getNameAsString().endsWith("A_FAIL_IDX") || !FAIL_WRITE) break block6;
                    throwException = true;
                    if (!TOGGLE_FAIL_WRITE_FOR_RETRY) break block5;
                    FAIL_WRITE = !FAIL_WRITE;
                    break block5;
                }
                Mutation operation = (Mutation)miniBatchOp.getOperation(0);
                if (FAIL_WRITE) {
                    NavigableMap cellMap = operation.getFamilyCellMap();
                    for (Map.Entry entry : cellMap.entrySet()) {
                        byte[] family = (byte[])entry.getKey();
                        if (!Bytes.toString((byte[])family).startsWith("L#")) continue;
                        int regionStartKeyLen = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().getStartKey().length;
                        Cell firstCell = (Cell)((List)entry.getValue()).get(0);
                        long indexId = MetaDataUtil.getViewIndexIdDataType().getCodec().decodeLong(firstCell.getRowArray(), firstCell.getRowOffset() + regionStartKeyLen, SortOrder.getDefault());
                        if (indexId != -32768L) continue;
                        throwException = true;
                        break;
                    }
                }
            }
            if (throwException) {
                if (!TOGGLE_FAIL_WRITE_FOR_RETRY) {
                    this.dropIndex(c);
                }
                throw new DoNotRetryIOException();
            }
        }

        private void dropIndex(ObserverContext<RegionCoprocessorEnvironment> c) {
            try {
                Connection connection = QueryUtil.getConnection((Configuration)((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration());
                connection.createStatement().execute("DROP INDEX IF EXISTS B_FAIL_IDX ON " + fullTableName);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

