/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class MutableIndexExtendedIT
extends ParallelStatsDisabledIT {
    private static final Logger LOG = LoggerFactory.getLogger(MutableIndexExtendedIT.class);
    protected final boolean localIndex;
    protected final String tableDDLOptions;

    public MutableIndexExtendedIT(Boolean localIndex, String txProvider, Boolean columnEncoded) {
        this.localIndex = localIndex;
        StringBuilder optionBuilder = new StringBuilder();
        if (txProvider != null) {
            optionBuilder.append("TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + txProvider + "'");
        }
        if (!columnEncoded.booleanValue()) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    private static Connection getConnection(Properties props) throws SQLException {
        props.setProperty("phoenix.index.mutableBatchSizeThreshold", Integer.toString(1));
        Connection conn = DriverManager.getConnection(MutableIndexExtendedIT.getUrl(), props);
        return conn;
    }

    protected static Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        return MutableIndexExtendedIT.getConnection(props);
    }

    @Parameterized.Parameters(name="MutableIndexExtendedIT_localIndex={0},transactionProvider={1},columnEncoded={2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({false, null, false}, {false, null, true}, {false, "OMID", false}, {true, null, false}, {true, null, true});
    }

    @Test(timeout=120000L)
    public void testCompactNonPhoenixTable() throws Exception {
        if (this.localIndex || this.tableDDLOptions.contains("TRANSACTIONAL=true")) {
            return;
        }
        try (Connection conn = MutableIndexExtendedIT.getConnection();){
            String randomTable = MutableIndexExtendedIT.generateUniqueName();
            TableName hbaseTN = TableName.valueOf((String)randomTable);
            byte[] famBytes = Bytes.toBytes((String)"fam");
            Table hTable = MutableIndexExtendedIT.getUtility().createTable(hbaseTN, famBytes);
            TestUtil.addCoprocessor(conn, randomTable, UngroupedAggregateRegionObserver.class);
            Put put = new Put(Bytes.toBytes((String)"row"));
            byte[] value = new byte[1];
            Bytes.random((byte[])value);
            put.addColumn(famBytes, Bytes.toBytes((String)"colQ"), value);
            hTable.put(put);
            List regions = MutableIndexExtendedIT.getUtility().getHBaseCluster().getRegions(hbaseTN);
            HRegion hRegion = (HRegion)regions.get(0);
            hRegion.flush(true);
            HStore store = hRegion.getStore(famBytes);
            store.triggerMajorCompaction();
            Optional requestCompaction = store.requestCompaction(1, CompactionLifeCycleTracker.DUMMY, null);
            store.compact((CompactionContext)requestCompaction.get(), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
            Assert.assertEquals((long)1L, (long)store.getStorefiles().size());
            regions = MutableIndexExtendedIT.getUtility().getHBaseCluster().getRegions(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
            hRegion = (HRegion)regions.get(0);
            hRegion.flush(true);
            store = hRegion.getStore(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            store.triggerMajorCompaction();
            requestCompaction = store.requestCompaction(1, CompactionLifeCycleTracker.DUMMY, null);
            store.compact((CompactionContext)requestCompaction.get(), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
            Assert.assertEquals((long)1L, (long)store.getStorefiles().size());
        }
    }

    @Test
    @Ignore
    public void testIndexHalfStoreFileReader() throws Exception {
        if (!this.localIndex) {
            return;
        }
        Connection conn1 = MutableIndexExtendedIT.getConnection();
        ConnectionQueryServices connectionQueryServices = driver.getConnectionQueryServices(MutableIndexExtendedIT.getUrl(), TestUtil.TEST_PROPERTIES);
        Admin admin = connectionQueryServices.getAdmin();
        String tableName = "TBL_" + MutableIndexExtendedIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexExtendedIT.generateUniqueName();
        this.createBaseTable(conn1, tableName, "('e')");
        conn1.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + tableName + "(v1)" + (this.localIndex ? "" : " SPLIT ON ('e')"));
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
        conn1.commit();
        String query = "SELECT count(*) FROM " + tableName + " where v1<='z'";
        ResultSet rs = conn1.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        TableName indexTable = TableName.valueOf((String)(this.localIndex ? tableName : indexName));
        admin.flush(indexTable);
        boolean merged = false;
        long numRegions = 0L;
        while (true) {
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            try {
                List indexRegions = admin.getRegions(indexTable);
                numRegions = indexRegions.size();
                if (numRegions == 1L) break;
                if (!merged) {
                    List regions = admin.getRegions(indexTable);
                    LOG.info("Merging: " + regions.size());
                    admin.mergeRegionsAsync(((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regions.get(1)).getEncodedNameAsBytes(), false);
                    merged = true;
                    Threads.sleep((long)10000L);
                }
            }
            catch (Exception ex) {
                LOG.info("error:", (Throwable)ex);
            }
            long waitStartTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - waitStartTime < 10000L) {
                List regions = admin.getRegions(indexTable);
                LOG.info("Waiting:" + regions.size());
                if ((long)regions.size() < numRegions) break;
                Threads.sleep((long)1000L);
            }
            SnapshotTestingUtils.waitForTableToBeOnline((HBaseTestingUtility)BaseTest.getUtility(), (TableName)indexTable);
            Assert.assertTrue((String)"Index table should be online ", (boolean)admin.isTableAvailable(indexTable));
        }
    }

    protected void createBaseTable(Connection conn, String tableName, String splits) throws SQLException {
        String ddl = "CREATE TABLE " + tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nk3 INTEGER,\nv1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n" + (this.tableDDLOptions != null ? this.tableDDLOptions : "") + (String)(splits != null ? " split on " + splits : "");
        conn.createStatement().execute(ddl);
    }
}

