/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexVerificationResultRepositoryIT
extends ParallelStatsDisabledIT {
    @BeforeClass
    public static synchronized void setupClass() throws Exception {
        Map props = Collections.emptyMap();
        IndexVerificationResultRepositoryIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testReadResultRow() throws Exception {
        String tableName = "T" + IndexVerificationResultRepositoryIT.generateUniqueName();
        String indexName = "I" + IndexVerificationResultRepositoryIT.generateUniqueName();
        byte[] indexNameBytes = Bytes.toBytes((String)indexName);
        try (Connection conn = DriverManager.getConnection(IndexVerificationResultRepositoryIT.getUrl());){
            this.createTableAndIndex(conn, tableName, indexName);
            long scanMaxTs = EnvironmentEdgeManager.currentTimeMillis();
            IndexToolVerificationResult expectedResult = this.getExpectedResult(scanMaxTs);
            IndexVerificationResultRepository resultRepository = this.setupResultRepository(conn, indexNameBytes, expectedResult);
            IndexToolVerificationResult actualResult = resultRepository.getVerificationResult(conn, scanMaxTs, indexNameBytes);
            this.assertVerificationResult(expectedResult, actualResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTTLOnResultTable() throws SQLException, IOException {
        String mockString = "mock_value";
        byte[] mockStringBytes = Bytes.toBytes((String)mockString);
        ManualEnvironmentEdge customClock = new ManualEnvironmentEdge();
        try (Connection conn = DriverManager.getConnection(IndexVerificationResultRepositoryIT.getUrl());
             PhoenixConnection pconn = DriverManager.getConnection(IndexVerificationResultRepositoryIT.getUrl()).unwrap(PhoenixConnection.class);){
            ConnectionQueryServices services = pconn.getQueryServices();
            Table hTable = services.getTable(IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES);
            long scanMaxTs = EnvironmentEdgeManager.currentTimeMillis();
            IndexToolVerificationResult expectedResult = this.getExpectedResult(scanMaxTs);
            this.setupResultRepository(conn, mockStringBytes, expectedResult);
            customClock.setValue(EnvironmentEdgeManager.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)customClock);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(hTable, false));
            customClock.incrementValue(604805000L);
            int count = TestUtil.getRowCount(hTable, false);
            Assert.assertEquals((long)0L, (long)count);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private IndexVerificationResultRepository setupResultRepository(Connection conn, byte[] indexNameBytes, IndexToolVerificationResult expectedResult) throws SQLException, IOException {
        IndexVerificationResultRepository resultRepository = new IndexVerificationResultRepository(conn, indexNameBytes);
        resultRepository.createResultTable(conn);
        TestUtil.assertTTLValue(conn, TableName.valueOf((byte[])IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES), 604800, false);
        byte[] regionOne = Bytes.toBytes((String)"a.1.00000000000000000000");
        byte[] regionTwo = Bytes.toBytes((String)"a.2.00000000000000000000");
        resultRepository.logToIndexToolResultTable(expectedResult, IndexTool.IndexVerifyType.BOTH, regionOne);
        resultRepository.logToIndexToolResultTable(expectedResult, IndexTool.IndexVerifyType.BOTH, regionTwo);
        return resultRepository;
    }

    private void assertVerificationResult(IndexToolVerificationResult expectedResult, IndexToolVerificationResult actualResult) {
        Assert.assertEquals((long)expectedResult.getScanMaxTs(), (long)actualResult.getScanMaxTs());
        Assert.assertArrayEquals((byte[])expectedResult.getStartRow(), (byte[])actualResult.getStartRow());
        Assert.assertArrayEquals((byte[])actualResult.getStopRow(), (byte[])actualResult.getStopRow());
        Assert.assertEquals((long)(2L * expectedResult.getBeforeRebuildExpiredIndexRowCount()), (long)actualResult.getBeforeRebuildExpiredIndexRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getBeforeRebuildInvalidIndexRowCount()), (long)actualResult.getBeforeRebuildInvalidIndexRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getBeforeRebuildMissingIndexRowCount()), (long)actualResult.getBeforeRebuildMissingIndexRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getBeforeRebuildValidIndexRowCount()), (long)actualResult.getBeforeRebuildValidIndexRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getAfterRebuildExpiredIndexRowCount()), (long)actualResult.getAfterRebuildExpiredIndexRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getAfterRebuildInvalidIndexRowCount()), (long)actualResult.getAfterRebuildInvalidIndexRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getAfterRebuildMissingIndexRowCount()), (long)actualResult.getAfterRebuildMissingIndexRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getAfterRebuildValidIndexRowCount()), (long)actualResult.getAfterRebuildValidIndexRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getScannedDataRowCount()), (long)actualResult.getScannedDataRowCount());
        Assert.assertEquals((long)(2L * expectedResult.getRebuiltIndexRowCount()), (long)actualResult.getRebuiltIndexRowCount());
    }

    private IndexToolVerificationResult getExpectedResult(long scanMaxTs) {
        byte[] startRow = Bytes.toBytes((String)"a");
        byte[] stopRow = Bytes.toBytes((String)"b");
        IndexToolVerificationResult result = new IndexToolVerificationResult(startRow, stopRow, scanMaxTs);
        result.setScannedDataRowCount(1L);
        result.setRebuiltIndexRowCount(1L);
        IndexToolVerificationResult.PhaseResult before = new IndexToolVerificationResult.PhaseResult();
        this.populatePhaseResult(before);
        IndexToolVerificationResult.PhaseResult after = new IndexToolVerificationResult.PhaseResult();
        this.populatePhaseResult(after);
        result.setBefore(before);
        result.setAfter(after);
        return result;
    }

    private void populatePhaseResult(IndexToolVerificationResult.PhaseResult result) {
        result.setValidIndexRowCount(1L);
        result.setBeyondMaxLookBackInvalidIndexRowCount(1L);
        result.setBeyondMaxLookBackMissingIndexRowCount(1L);
        result.setExpiredIndexRowCount(1L);
        result.setInvalidIndexRowCount(1L);
        result.setMissingIndexRowCount(1L);
    }

    private void createTable(Connection conn, String tableName) throws Exception {
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))");
    }

    private void createTableAndIndex(Connection conn, String dataTableName, String indexTableName) throws Exception {
        this.createTable(conn, dataTableName);
        conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)");
        conn.commit();
    }

    @After
    public void dropResultTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(IndexVerificationResultRepositoryIT.getUrl());){
            ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
            Admin admin = queryServices.getAdmin();
            TableName outputTableName = TableName.valueOf((byte[])IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES);
            if (admin.tableExists(outputTableName)) {
                admin.disableTable(TableName.valueOf((byte[])IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES));
                admin.deleteTable(TableName.valueOf((byte[])IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES));
            }
        }
        EnvironmentEdgeManager.reset();
    }
}

