/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.transform.TransformToolIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.Transform;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IndexTwoPhaseCreateIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.index.create.default.state", PIndexState.CREATE_DISABLE.toString());
        props.put("phoenix.default.immutable.storage.scheme", "ONE_CELL_PER_COLUMN");
        props.put("phoenix.default.column.encoded.bytes.attrib", "0");
        IndexTwoPhaseCreateIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    @Test
    public void testIndexCreateWithNonDefaultSettings() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTable = IndexTwoPhaseCreateIT.generateUniqueName();
        String indexName = "IDX_" + IndexTwoPhaseCreateIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(IndexTwoPhaseCreateIT.getUrl(), props);){
            String tableDDL = "CREATE TABLE " + dataTable + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ";
            conn.createStatement().execute(tableDDL);
            BaseTest.upsertRows(conn, dataTable, 2);
            String ddl = "CREATE INDEX " + indexName + " ON " + dataTable + " (varchar_col1 ASC, varchar_col2 ASC, int_pk DESC) INCLUDE (int_col1, int_col2) ";
            conn.createStatement().execute(ddl);
            this.assertIndexOrTableState(conn, null, indexName, PTableType.INDEX, PIndexState.CREATE_DISABLE);
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, indexName));
            ddl = "ALTER INDEX " + indexName + " ON " + dataTable + " REBUILD ASYNC";
            conn.createStatement().execute(ddl);
            this.assertIndexOrTableState(conn, null, indexName, PTableType.INDEX, PIndexState.BUILDING);
        }
    }

    @Test
    public void testIndexCreateDisabledBuildAfter() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTable = IndexTwoPhaseCreateIT.generateUniqueName();
        String indexName = "IDX_" + IndexTwoPhaseCreateIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(IndexTwoPhaseCreateIT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableDDL = "CREATE TABLE " + dataTable + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ";
            conn.createStatement().execute(tableDDL);
            BaseTest.upsertRows(conn, dataTable, 1);
            String ddl = "CREATE INDEX " + indexName + " ON " + dataTable + " (varchar_col1 ASC, varchar_col2 ASC, int_pk DESC) INCLUDE (int_col1, int_col2) ";
            conn.createStatement().execute(ddl);
            this.assertIndexOrTableState(conn, null, indexName, PTableType.INDEX, PIndexState.CREATE_DISABLE);
            BaseTest.upsertRows(conn, dataTable, 3);
            long rows = TestUtil.getRowCount(conn, indexName);
            Assert.assertEquals((long)0L, (long)rows);
            IndexToolIT.runIndexTool(false, null, dataTable, indexName);
            rows = TestUtil.getRowCount(conn, indexName);
            Assert.assertEquals((long)3L, (long)rows);
            this.assertIndexOrTableState(conn, null, indexName, PTableType.INDEX, PIndexState.ACTIVE);
        }
    }

    @Test
    public void testTransformingTableAndIndex() throws Exception {
        Properties testProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexTwoPhaseCreateIT.getUrl(), testProps);){
            conn.setAutoCommit(true);
            String tableName = "TBL_" + IndexTwoPhaseCreateIT.generateUniqueName();
            String idxName = "IND_" + IndexTwoPhaseCreateIT.generateUniqueName();
            String createTableSql = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            String upsertStmt = "UPSERT INTO " + tableName + " (PK1, INT_PK, V1, V2) VALUES ('%s', %d, '%s', %d)";
            conn.createStatement().execute(String.format(upsertStmt, "a", 1, "val1", 1));
            String createIndexSql = "CREATE INDEX " + idxName + " ON " + tableName + " (PK1, INT_PK) include (V1)";
            conn.createStatement().execute(createIndexSql);
            IndexTwoPhaseCreateIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            IndexTwoPhaseCreateIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, idxName);
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, idxName));
            IndexToolIT.runIndexTool(false, null, tableName, idxName);
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, idxName));
            conn.createStatement().execute("ALTER INDEX " + idxName + " ON " + tableName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord(null, (String)idxName, (String)tableName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            IndexTwoPhaseCreateIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            String newIndexTable = record.getNewPhysicalTableName();
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, newIndexTable));
            conn.createStatement().execute("ALTER TABLE " + tableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            record = Transform.getTransformRecord(null, (String)tableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            IndexTwoPhaseCreateIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            String newDataTable = record.getNewPhysicalTableName();
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, newDataTable));
            this.assertIndexOrTableState(conn, null, newDataTable, PTableType.TABLE, PIndexState.CREATE_DISABLE);
            conn.createStatement().execute(String.format(upsertStmt, "b", 2, "val2", 2));
            conn.commit();
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, newDataTable));
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, newIndexTable));
            IndexToolIT.runIndexTool(false, null, tableName, newIndexTable);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, newIndexTable));
            this.assertIndexOrTableState(conn, null, newIndexTable, PTableType.INDEX, PIndexState.ACTIVE);
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, newDataTable));
            List<String> args = TransformToolIT.getArgList(null, tableName, null, null, null, null, false, false, true, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            record = Transform.getTransformRecord(null, (String)tableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            TransformToolIT.assertTransformStatusOrPartial(PTable.TransformStatus.PENDING_CUTOVER, record);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, newDataTable));
        }
    }

    @Test
    public void testWithViewIndex() throws Exception {
        Properties testProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexTwoPhaseCreateIT.getUrl(), testProps);){
            conn.setAutoCommit(true);
            String tableName = "TBL_" + IndexTwoPhaseCreateIT.generateUniqueName();
            String viewName = "VW_" + IndexTwoPhaseCreateIT.generateUniqueName();
            String viewIdxName = "VWIDX_" + IndexTwoPhaseCreateIT.generateUniqueName();
            String createTableSql = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            String createViewSql = "CREATE VIEW " + viewName + " ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableName;
            conn.createStatement().execute(createViewSql);
            String createViewIdxSql = "CREATE INDEX " + viewIdxName + " ON " + viewName + " (VIEW_COL1) include (VIEW_COL2) ";
            conn.createStatement().execute(createViewIdxSql);
            this.assertIndexOrTableState(conn, null, viewIdxName, PTableType.INDEX, PIndexState.ACTIVE);
        }
    }

    @Test
    public void testWithLocalIndex() throws Exception {
        Properties testProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTableName = "TBL_" + IndexTwoPhaseCreateIT.generateUniqueName();
        String indexName = "LCLIDX_" + IndexTwoPhaseCreateIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(IndexTwoPhaseCreateIT.getUrl(), testProps);){
            String createTableSql = "CREATE TABLE " + dataTableName + " (k INTEGER PRIMARY KEY, a bigint, b bigint, c bigint) ";
            conn.createStatement().execute(createTableSql);
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + dataTableName + " (b) INCLUDE (c) ");
            this.assertIndexOrTableState(conn, null, indexName, PTableType.INDEX, PIndexState.ACTIVE);
        }
    }

    private void assertIndexOrTableState(Connection conn, String schema, String tblName, PTableType type, PIndexState state) throws SQLException {
        ResultSet rs = conn.getMetaData().getTables("", schema, tblName, new String[]{type.toString()});
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)tblName, (Object)rs.getString(3));
        Assert.assertEquals((Object)state.toString(), (Object)rs.getString("INDEX_STATE"));
        Assert.assertFalse((boolean)rs.next());
    }
}

