/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.MutationBlockedIOException;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HAGroupStoreManager;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.PhoenixHAAdmin;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexRegionObserverMutationBlockingIT
extends BaseTest {
    private static final Long ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS = 1000L;
    private PhoenixHAAdmin haAdmin;
    private HAGroupStoreManager haGroupStoreManager;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.cluster.role.based.mutation.block.enabled", "true");
        props.put("hbase.client.retries.number", "0");
        IndexRegionObserverMutationBlockingIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void setUp() throws Exception {
        this.haAdmin = new PhoenixHAAdmin(config);
        this.haGroupStoreManager = HAGroupStoreManager.getInstance((Configuration)config);
        List crrs = this.haAdmin.listAllClusterRoleRecordsOnZookeeper();
        for (ClusterRoleRecord crr : crrs) {
            this.haAdmin.getCurator().delete().forPath(PhoenixHAAdmin.toPath((String)crr.getHaGroupName()));
        }
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
    }

    @After
    public void tearDown() throws Exception {
        if (this.haAdmin != null) {
            List crrs = this.haAdmin.listAllClusterRoleRecordsOnZookeeper();
            for (ClusterRoleRecord crr : crrs) {
                this.haAdmin.getCurator().delete().forPath(PhoenixHAAdmin.toPath((String)crr.getHaGroupName()));
            }
        }
    }

    @Test
    public void testMutationBlockedOnDataTableWithIndex() throws Exception {
        String dataTableName = IndexRegionObserverMutationBlockingIT.generateUniqueName();
        String indexName = IndexRegionObserverMutationBlockingIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(IndexRegionObserverMutationBlockingIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (id VARCHAR PRIMARY KEY, name VARCHAR, age INTEGER)");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + dataTableName + "(name)");
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES ('1', 'John', 25)");
            conn.commit();
            ClusterRoleRecord blockingCrr = new ClusterRoleRecord("failover_test", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "standby-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
            this.haAdmin.createOrUpdateDataOnZookeeper(blockingCrr);
            Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
            Assert.assertTrue((String)"Mutations should be blocked", (boolean)this.haGroupStoreManager.isMutationBlocked());
            try {
                conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES ('2', 'Jane', 30)");
                conn.commit();
                Assert.fail((String)"Expected MutationBlockedIOException to be thrown");
            }
            catch (CommitException e) {
                Assert.assertTrue((String)"Expected MutationBlockedIOException in exception chain", (boolean)this.containsMutationBlockedException(e));
            }
        }
    }

    @Test
    public void testMutationAllowedWhenNotBlocked() throws Exception {
        String dataTableName = IndexRegionObserverMutationBlockingIT.generateUniqueName();
        String indexName = IndexRegionObserverMutationBlockingIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(IndexRegionObserverMutationBlockingIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (id VARCHAR PRIMARY KEY, name VARCHAR, age INTEGER)");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + dataTableName + "(name)");
            ClusterRoleRecord nonBlockingCrr = new ClusterRoleRecord("active_test", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "standby-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
            this.haAdmin.createOrUpdateDataOnZookeeper(nonBlockingCrr);
            Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES ('1', 'Bob', 35)");
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES ('2', 'Carol', 27)");
            conn.commit();
            try (ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + dataTableName);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)2L, (long)rs.getInt(1));
            }
        }
    }

    @Test
    public void testMutationBlockingTransition() throws Exception {
        String dataTableName = IndexRegionObserverMutationBlockingIT.generateUniqueName();
        String indexName = IndexRegionObserverMutationBlockingIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(IndexRegionObserverMutationBlockingIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (id VARCHAR PRIMARY KEY, name VARCHAR, age INTEGER)");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + dataTableName + "(name)");
            ClusterRoleRecord crr = new ClusterRoleRecord("transition_test", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "standby-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
            this.haAdmin.createOrUpdateDataOnZookeeper(crr);
            Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES ('1', 'David', 40)");
            conn.commit();
            crr = new ClusterRoleRecord("transition_test", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "standby-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
            this.haAdmin.createOrUpdateDataOnZookeeper(crr);
            Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
            try {
                conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES ('2', 'Eve', 33)");
                conn.commit();
                Assert.fail((String)"Expected MutationBlockedIOException after transition to ACTIVE_TO_STANDBY");
            }
            catch (CommitException e) {
                Assert.assertTrue((String)"Expected mutation blocked exception after transition", (boolean)this.containsMutationBlockedException(e));
            }
            crr = new ClusterRoleRecord("transition_test", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "standby-zk-url", ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, 3L);
            this.haAdmin.createOrUpdateDataOnZookeeper(crr);
            Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES ('3', 'Frank', 45)");
            conn.commit();
        }
    }

    private boolean containsMutationBlockedException(CommitException e) {
        Throwable cause = e.getCause();
        if (cause instanceof RetriesExhaustedWithDetailsException) {
            RetriesExhaustedWithDetailsException re = (RetriesExhaustedWithDetailsException)cause;
            return re.getCause(0) instanceof MutationBlockedIOException;
        }
        return false;
    }
}

