/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexRebuildIncrementDisableCountIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexRebuildIncrementDisableCountIT.class);
    private static long pendingDisableCount = 0L;
    private static String ORG_PREFIX = "ORG";
    private static Result pendingDisableCountResult = null;
    private static String indexState = null;
    private static final Random RAND = new Random(5L);
    private static final int WAIT_AFTER_DISABLED = 5000;
    private static final long REBUILD_PERIOD = 50000L;
    private static final long REBUILD_INTERVAL = 2000L;
    private static RegionCoprocessorEnvironment indexRebuildTaskRegionEnvironment;
    private static String schemaName;
    private static String tableName;
    private static String fullTableName;
    private static String indexName;
    private static String fullIndexName;
    private static Connection conn;
    private static PhoenixConnection phoenixConn;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)10);
        serverProps.put("phoenix.index.failure.handling.rebuild", Boolean.TRUE.toString());
        serverProps.put("phoenix.index.failure.handling.rebuild.interval", Long.toString(2000L));
        serverProps.put("phoenix.index.rebuild.disabletimestamp.threshold", "50000000");
        serverProps.put("phoenix.index.failure.handling.rebuild.period", Long.toString(50000L));
        serverProps.put("phoenix.index.failure.handling.rebuild.overlap.forward.time", Long.toString(5000L));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("hbase.client.retries.number", "2");
        IndexRebuildIncrementDisableCountIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        indexRebuildTaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)IndexRebuildIncrementDisableCountIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(MetaDataRegionObserver.class.getName());
        MetaDataRegionObserver.initRebuildIndexConnectionProps((Configuration)indexRebuildTaskRegionEnvironment.getConfiguration());
        schemaName = IndexRebuildIncrementDisableCountIT.generateUniqueName();
        tableName = IndexRebuildIncrementDisableCountIT.generateUniqueName();
        fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        indexName = IndexRebuildIncrementDisableCountIT.generateUniqueName();
        fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        conn = DriverManager.getConnection(IndexRebuildIncrementDisableCountIT.getUrl());
        phoenixConn = conn.unwrap(PhoenixConnection.class);
    }

    static long getPendingDisableCount(PhoenixConnection conn, String indexTableName) {
        byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName((String)indexTableName);
        Get get = new Get(indexTableKey);
        get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PENDING_DISABLE_COUNT_BYTES);
        get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
        try {
            pendingDisableCountResult = conn.getQueryServices().getTable(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, (ReadOnlyProps)conn.getQueryServices().getProps()).getName()).get(get);
            return Bytes.toLong((byte[])pendingDisableCountResult.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PENDING_DISABLE_COUNT_BYTES));
        }
        catch (Exception e) {
            LOGGER.error("Exception in getPendingDisableCount: " + e);
            return 0L;
        }
    }

    private static void checkIndexPendingDisableCount(final PhoenixConnection conn, final String indexTableName) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TestUtil.checkIndexState((Connection)conn, indexTableName, PIndexState.ACTIVE, 0L)) {
                        long count = IndexRebuildIncrementDisableCountIT.getPendingDisableCount(conn, indexTableName);
                        if (count > 0L) {
                            indexState = new String(pendingDisableCountResult.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES));
                            pendingDisableCount = count;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in checkPendingDisableCount : " + e);
                }
            }
        };
        Thread t1 = new Thread(runnable);
        t1.start();
    }

    static String getOrgId(long id) {
        return ORG_PREFIX + "-" + id;
    }

    static String getRandomOrgId(int maxOrgId) {
        return IndexRebuildIncrementDisableCountIT.getOrgId(Math.round(Math.random() * (double)maxOrgId));
    }

    private static void mutateRandomly(Connection conn, String tableName, int maxOrgId) {
        try {
            Statement stmt = conn.createStatement();
            for (int i = 0; i < 10000; ++i) {
                stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('" + IndexRebuildIncrementDisableCountIT.getRandomOrgId(maxOrgId) + "'," + i + "," + (i + 1) + "," + (i + 2) + ")");
            }
            conn.commit();
        }
        catch (Exception e) {
            LOGGER.error("Client side exception:" + e);
        }
    }

    private static MetaDataProtocol.MutationCode updateIndexState(PhoenixConnection phoenixConn, String fullIndexName, PIndexState state) throws Throwable {
        Table metaTable = phoenixConn.getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
        long ts = EnvironmentEdgeManager.currentTimeMillis();
        return IndexUtil.updateIndexState((String)fullIndexName, (long)ts, (Table)metaTable, (PIndexState)state).getMutationCode();
    }

    @Test
    public void testIndexStateTransitions() throws Throwable {
        String createTableSql = "CREATE TABLE " + fullTableName + "(org_id VARCHAR NOT NULL PRIMARY KEY, v1 INTEGER, v2 INTEGER, v3 INTEGER)";
        conn.createStatement().execute(createTableSql);
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + "(v1)");
        conn.commit();
        IndexRebuildIncrementDisableCountIT.updateIndexState(phoenixConn, fullIndexName, PIndexState.DISABLE);
        IndexRebuildIncrementDisableCountIT.mutateRandomly(conn, fullTableName, 20);
        boolean[] cancel = new boolean[1];
        IndexRebuildIncrementDisableCountIT.checkIndexPendingDisableCount(phoenixConn, fullIndexName);
        try {
            do {
                IndexRebuildIncrementDisableCountIT.runIndexRebuilder(Collections.singletonList(fullTableName));
            } while (!TestUtil.checkIndexState(conn, fullIndexName, PIndexState.ACTIVE, 0L));
        }
        finally {
            cancel[0] = true;
        }
        Assert.assertTrue((String)"Index state is inactive ", (boolean)indexState.equals("i"));
        Assert.assertTrue((String)"pendingDisable count is incremented when index is inactive", (pendingDisableCount == 10000L ? 1 : 0) != 0);
        Assert.assertTrue((String)"pending disable count is 0 when index is active: ", (IndexRebuildIncrementDisableCountIT.getPendingDisableCount(phoenixConn, fullIndexName) == 0L ? 1 : 0) != 0);
    }

    @Test
    public void checkIndexPendingDisableResetCounter() throws Throwable {
        IndexUtil.incrementCounterForIndex((PhoenixConnection)phoenixConn, (String)fullIndexName, (long)10000L);
        IndexRebuildIncrementDisableCountIT.updateIndexState(phoenixConn, fullIndexName, PIndexState.PENDING_DISABLE);
        Assert.assertTrue((String)"Pending disable count should reset when index moves from ACTIVE to PENDING_DISABLE ", (IndexRebuildIncrementDisableCountIT.getPendingDisableCount(phoenixConn, fullIndexName) == 0L ? 1 : 0) != 0);
        IndexUtil.incrementCounterForIndex((PhoenixConnection)phoenixConn, (String)fullIndexName, (long)10000L);
        IndexRebuildIncrementDisableCountIT.updateIndexState(phoenixConn, fullIndexName, PIndexState.INACTIVE);
        IndexRebuildIncrementDisableCountIT.updateIndexState(phoenixConn, fullIndexName, PIndexState.PENDING_DISABLE);
        Assert.assertTrue((String)"Pending disable count should reset when index moves from ACTIVE to PENDING_DISABLE ", (IndexRebuildIncrementDisableCountIT.getPendingDisableCount(phoenixConn, fullIndexName) == 10000L ? 1 : 0) != 0);
    }

    private static void runIndexRebuilder(List<String> tables) throws InterruptedException, SQLException {
        MetaDataRegionObserver.BuildIndexScheduleTask task = new MetaDataRegionObserver.BuildIndexScheduleTask(indexRebuildTaskRegionEnvironment, tables);
        task.run();
    }
}

