/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexMaintenanceIT
extends ParallelStatsDisabledIT {
    @Test
    public void testImmutableIndexCreateAndUpdate() throws Exception {
        this.helpTestCreateAndUpdate(false, false);
    }

    @Test
    public void testImmutableLocalIndexCreateAndUpdate() throws Exception {
        this.helpTestCreateAndUpdate(false, true);
    }

    @Test
    public void testMutableIndexCreateAndUpdate() throws Exception {
        this.helpTestCreateAndUpdate(true, false);
    }

    @Test
    public void testMutableLocalIndexCreateAndUpdate() throws Exception {
        this.helpTestCreateAndUpdate(true, true);
    }

    private void insertRow(PreparedStatement stmt, int i) throws SQLException {
        stmt.setString(1, "varchar" + String.valueOf(i));
        stmt.setString(2, "char" + String.valueOf(i));
        stmt.setInt(3, i);
        stmt.setLong(4, i);
        stmt.setBigDecimal(5, new BigDecimal((double)i * 0.5));
        Date date = new Date(DateUtil.parseDate((String)"2015-01-01 00:00:00").getTime() + (long)((i - 1) * 86400000));
        stmt.setDate(6, date);
        stmt.setString(7, "a.varchar" + String.valueOf(i));
        stmt.setString(8, "a.char" + String.valueOf(i));
        stmt.setInt(9, i);
        stmt.setLong(10, i);
        stmt.setBigDecimal(11, new BigDecimal((double)i * 0.5));
        stmt.setDate(12, date);
        stmt.setString(13, "b.varchar" + String.valueOf(i));
        stmt.setString(14, "b.char" + String.valueOf(i));
        stmt.setInt(15, i);
        stmt.setLong(16, i);
        stmt.setBigDecimal(17, new BigDecimal((double)i * 0.5));
        stmt.setDate(18, date);
        stmt.executeUpdate();
    }

    private void verifyResult(ResultSet rs, int i) throws SQLException {
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)("VARCHAR" + String.valueOf(i) + "_" + StringUtils.rightPad((String)("CHAR" + String.valueOf(i)), (int)10, (char)' ') + "_A.VARCHAR" + String.valueOf(i) + "_" + StringUtils.rightPad((String)("B.CHAR" + String.valueOf(i)), (int)10, (char)' ')), (Object)rs.getString(1));
        Assert.assertEquals((long)(i * 3), (long)rs.getInt(2));
        Date date = new Date(DateUtil.parseDate((String)"2015-01-01 00:00:00").getTime() + (long)(i * 86400000));
        Assert.assertEquals((Object)date, (Object)rs.getDate(3));
        Assert.assertEquals((Object)date, (Object)rs.getDate(4));
        Assert.assertEquals((Object)date, (Object)rs.getDate(5));
        Assert.assertEquals((Object)("varchar" + String.valueOf(i)), (Object)rs.getString(6));
        Assert.assertEquals((Object)("char" + String.valueOf(i)), (Object)rs.getString(7));
        Assert.assertEquals((long)i, (long)rs.getInt(8));
        Assert.assertEquals((long)i, (long)rs.getLong(9));
        Assert.assertEquals((double)((double)i * 0.5), (double)rs.getDouble(10), (double)1.0E-6);
        Assert.assertEquals((long)i, (long)rs.getLong(11));
        Assert.assertEquals((long)i, (long)rs.getLong(12));
    }

    private void createDataTable(Connection conn, String dataTableName, String tableProps) throws SQLException {
        String tableDDL = "create table " + dataTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + tableProps;
        conn.createStatement().execute(tableDDL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpTestCreateAndUpdate(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexMaintenanceIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexMaintenanceIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexMaintenanceIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, mutable ? "" : "IMMUTABLE_ROWS=true");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " ((UPPER(varchar_pk) || '_' || UPPER(char_pk) || '_' || UPPER(varchar_col1) || '_' || UPPER(b.char_col2)), (decimal_pk+int_pk+decimal_col2+int_col1), date_pk+1, date1+1, date2+1 ) INCLUDE (long_col1, long_col2)";
            conn.createStatement().execute(ddl);
            String whereSql = "SELECT long_col1, long_col2 from " + fullDataTableName + " WHERE UPPER(varchar_pk) || '_' || UPPER(char_pk) || '_' || UPPER(varchar_col1) || '_' || UPPER(b.char_col2) = ? AND decimal_pk+int_pk+decimal_col2+int_col1=? AND date_pk+1=? AND date1+1=? AND date2+1=?";
            PreparedStatement stmt = conn.prepareStatement(whereSql);
            stmt.setString(1, "VARCHAR1_CHAR1     _A.VARCHAR1_B.CHAR1   ");
            stmt.setInt(2, 3);
            Date date = DateUtil.parseDate((String)"2015-01-02 00:00:00");
            stmt.setDate(3, date);
            stmt.setDate(4, date);
            stmt.setDate(5, date);
            ResultSet rs = stmt.executeQuery("EXPLAIN " + whereSql);
            Assert.assertEquals((Object)(localIndex ? "CLIENT PARALLEL 1-WAY RANGE SCAN OVER INDEX_TEST." + indexName + "(" + fullDataTableName + ") [1,'VARCHAR1_CHAR1     _A.VARCHAR1_B.CHAR1   ',3,'2015-01-02 00:00:00.000',1,420,156,800,000,1,420,156,800,000]\nCLIENT MERGE SORT" : "CLIENT PARALLEL 1-WAY RANGE SCAN OVER INDEX_TEST." + indexName + " ['VARCHAR1_CHAR1     _A.VARCHAR1_B.CHAR1   ',3,'2015-01-02 00:00:00.000',1,420,156,800,000,1,420,156,800,000]"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            String indexSelectSql = "SELECT UPPER(varchar_pk) || '_' || UPPER(char_pk) || '_' || UPPER(varchar_col1) || '_' || UPPER(b.char_col2), decimal_pk+int_pk+decimal_col2+int_col1, date_pk+1, date1+1, date2+1, varchar_pk, char_pk, int_pk, long_pk, decimal_pk, long_col1, long_col2 from " + fullDataTableName;
            rs = conn.createStatement().executeQuery("EXPLAIN " + indexSelectSql);
            Assert.assertEquals((Object)(localIndex ? "CLIENT PARALLEL 1-WAY RANGE SCAN OVER INDEX_TEST." + indexName + "(" + fullDataTableName + ") [1]\nCLIENT MERGE SORT" : "CLIENT PARALLEL 1-WAY FULL SCAN OVER INDEX_TEST." + indexName), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn.createStatement().executeQuery(indexSelectSql);
            this.verifyResult(rs, 1);
            this.verifyResult(rs, 2);
            String upsert = "UPSERT INTO " + fullDataTableName + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            stmt = conn.prepareStatement(upsert);
            this.insertRow(stmt, 3);
            this.insertRow(stmt, 4);
            conn.commit();
            rs = conn.createStatement().executeQuery(indexSelectSql);
            this.verifyResult(rs, 1);
            this.verifyResult(rs, 2);
            this.verifyResult(rs, 3);
            this.verifyResult(rs, 4);
        }
    }

    @Test
    public void testMutableIndexUpdate() throws Exception {
        String dataTableName = IndexMaintenanceIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexMaintenanceIT.generateUniqueName();
        this.helpTestUpdate(fullDataTableName, indexName, false);
    }

    @Test
    public void testMutableLocalIndexUpdate() throws Exception {
        String dataTableName = IndexMaintenanceIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexMaintenanceIT.generateUniqueName();
        this.helpTestUpdate(fullDataTableName, indexName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpTestUpdate(String fullDataTableName, String indexName, boolean localIndex) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexMaintenanceIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, "");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " ((UPPER(varchar_pk) || '_' || UPPER(char_pk) || '_' || UPPER(varchar_col1) || '_' || UPPER(char_col2)), (decimal_pk+int_pk+decimal_col2+int_col1), date_pk+1, date1+1, date2+1 ) INCLUDE (long_col1, long_col2)";
            PreparedStatement stmt = conn.prepareStatement(ddl);
            stmt.execute();
            String upsert = "UPSERT INTO " + fullDataTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk, varchar_col1, long_col1) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
            stmt = conn.prepareStatement(upsert);
            stmt.setString(1, "varchar1");
            stmt.setString(2, "char1");
            stmt.setInt(3, 1);
            stmt.setLong(4, 1L);
            stmt.setBigDecimal(5, new BigDecimal(0.5));
            stmt.setDate(6, DateUtil.parseDate((String)"2015-01-01 00:00:00"));
            stmt.setString(7, "a.varchar_updated");
            stmt.setLong(8, 101L);
            stmt.executeUpdate();
            conn.commit();
            String selectSql = "UPPER(varchar_pk) || '_' || UPPER(char_pk) || '_' || UPPER(varchar_col1) || '_' || UPPER(char_col2), long_col1 from " + fullDataTableName;
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"VARCHAR1_CHAR1     _A.VARCHAR_UPDATED_B.CHAR1   ", (Object)rs.getString(1));
            Assert.assertEquals((long)101L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"VARCHAR2_CHAR2     _A.VARCHAR2_B.CHAR2   ", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT " + selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"VARCHAR1_CHAR1     _A.VARCHAR_UPDATED_B.CHAR1   ", (Object)rs.getString(1));
            Assert.assertEquals((long)101L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"VARCHAR2_CHAR2     _A.VARCHAR2_B.CHAR2   ", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void populateDataTable(Connection conn, String dataTable) throws SQLException {
        String upsert = "UPSERT INTO " + dataTable + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt1 = conn.prepareStatement(upsert);
        this.insertRow(stmt1, 1);
        this.insertRow(stmt1, 2);
        conn.commit();
    }

    @Test
    public void testDeleteIndexedExpressionImmutableIndex() throws Exception {
        this.helpTestDeleteIndexedExpression(false, false);
    }

    @Test
    public void testDeleteIndexedExpressionImmutableLocalIndex() throws Exception {
        this.helpTestDeleteIndexedExpression(false, true);
    }

    @Test
    public void testDeleteIndexedExpressionMutableIndex() throws Exception {
        this.helpTestDeleteIndexedExpression(true, false);
    }

    @Test
    public void testDeleteIndexedExpressionMutableLocalIndex() throws Exception {
        this.helpTestDeleteIndexedExpression(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void helpTestDeleteIndexedExpression(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexMaintenanceIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexMaintenanceIT.generateUniqueName();
        String fullIndexTableName = "INDEX_TEST." + indexName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexMaintenanceIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, mutable ? "" : "IMMUTABLE_ROWS=true");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " (2*long_col2)";
            conn.createStatement().execute(ddl);
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullDataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            conn.setAutoCommit(true);
            conn.createStatement().execute("DELETE from " + fullDataTableName + " WHERE long_col2 = 2");
            if (!mutable) {
                conn.createStatement().execute("DELETE from " + fullDataTableName + " WHERE 2*long_col2 = 4");
            }
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullDataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testDeleteCoveredColImmutableIndex() throws Exception {
        this.helpTestDeleteCoveredCol(false, false);
    }

    @Test
    public void testDeleteCoveredColImmutableLocalIndex() throws Exception {
        this.helpTestDeleteCoveredCol(false, true);
    }

    @Test
    public void testDeleteCoveredColMutableIndex() throws Exception {
        this.helpTestDeleteCoveredCol(true, false);
    }

    @Test
    public void testDeleteCoveredColMutableLocalIndex() throws Exception {
        this.helpTestDeleteCoveredCol(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void helpTestDeleteCoveredCol(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexMaintenanceIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexMaintenanceIT.generateUniqueName();
        String fullIndexTableName = "INDEX_TEST." + indexName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexMaintenanceIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, mutable ? "" : "IMMUTABLE_ROWS=true");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " (long_pk, varchar_pk, 1+long_pk, UPPER(varchar_pk) ) INCLUDE (long_col1, long_col2)";
            conn.createStatement().execute(ddl);
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullDataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            String sql = "SELECT LONG_COL1 from " + fullDataTableName + " WHERE LONG_COL2 = 2";
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            String dml = "DELETE from " + fullDataTableName + " WHERE long_col2 = 2";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            String query = "SELECT /*+ NO_INDEX */ long_pk, varchar_pk, 1+long_pk, UPPER(varchar_pk) FROM " + fullDataTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertEquals((Object)"varchar1", (Object)rs.getString(2));
            Assert.assertEquals((long)2L, (long)rs.getLong(3));
            Assert.assertEquals((Object)"VARCHAR1", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT long_pk, varchar_pk, 1+long_pk, UPPER(varchar_pk) FROM " + fullDataTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertEquals((Object)"varchar1", (Object)rs.getString(2));
            Assert.assertEquals((long)2L, (long)rs.getLong(3));
            Assert.assertEquals((Object)"VARCHAR1", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT * FROM " + fullIndexTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertEquals((Object)"varchar1", (Object)rs.getString(2));
            Assert.assertEquals((long)2L, (long)rs.getLong(3));
            Assert.assertEquals((Object)"VARCHAR1", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

